/*
 * Decompiled with CFR 0.152.
 */
package com.sensetime.mtc;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.sensetime.mtc.IReceiveCallback;
import com.sensetime.mtc.MtcCallback;
import com.sensetime.mtc.MtcCode;
import com.sensetime.mtc.MtcInitParams;
import com.sensetime.mtc.MtcReceiver;
import com.sensetime.mtc.ParamsCheckHelper;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class MClient {
    private static final String TAG = "MClient.java";
    private static volatile MClient mClient;
    private static boolean mtcIsDebug;
    private static final String DEFAULT_DEV = "/dev/ttyACM0";
    public static final int MTC_UPGRADE_SEGMENT_LENGTH = 16300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MClient getInstance() {
        if (mClient != null) return mClient;
        Class<MClient> clazz = MClient.class;
        synchronized (MClient.class) {
            if (mClient != null) return mClient;
            mClient = new MClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mClient;
        }
    }

    private static boolean writeDebug(String funcName, String inputInfo, String outputInfo, String returnInfo) {
        if (mtcIsDebug) {
            String msg = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n|[FUNCTYPE] JNI \n|[FUNCNAME] " + funcName + "\n|[INPUT   ] " + inputInfo + "\n|[OUTPUT  ] " + outputInfo + "\n|[RETURN  ] " + returnInfo + "\n\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n";
            Log.d((String)TAG, (String)msg);
        }
        return mtcIsDebug;
    }

    private static boolean writeDebug(String funcName, String inputInfo, String outputInfo, String returnInfo, String errorInfo) {
        if (mtcIsDebug) {
            if (!errorInfo.isEmpty()) {
                MClient.writeDebug(funcName + "[ERROR   ] " + errorInfo + "\n", inputInfo, outputInfo, returnInfo);
            } else {
                MClient.writeDebug(funcName, inputInfo, outputInfo, returnInfo);
            }
        }
        return mtcIsDebug;
    }

    private MClient() {
    }

    protected static native void mSetIsDebug(boolean var0);

    protected native int mInit(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected native int mPing();

    protected native void mDestroy();

    protected native int mAiAddImage(byte var1, byte[] var2, String var3, ByteBuffer var4);

    protected native int mAiAddImage(byte var1, byte[] var2, String var3, ByteBuffer var4, StringBuffer var5);

    protected native int mAiAddLargeImage(byte[] var1, String var2);

    protected native int mAiAddLargeImage(byte[] var1, String var2, StringBuffer var3);

    protected native int mIdListGet(StringBuffer var1);

    protected native int mAiDelImage(byte var1, String var2);

    protected native int mAiDelAllImage();

    protected native int mAiQueryImage(String var1, StringBuffer var2);

    protected native int mAiStartRecognize(int var1, int var2);

    protected native int mSystemUploadUpgradePackage(int var1, byte[] var2, int var3);

    protected native int mSystemApplyUpgradePackage(String var1, StringBuffer var2);

    protected native int mSystemVersionInfoGet(StringBuffer var1);

    protected native String mHandleAt(String var1);

    protected native int mAiAddFeature(byte[] var1, String var2);

    protected native int mAiRecognitionCountSet(byte var1, byte var2);

    protected native int mAiRecognitionCountGet(StringBuffer var1);

    protected native int mAiQueryFeature(String var1, StringBuffer var2);

    protected native int mAiStaticVerify(byte var1, byte[] var2, StringBuffer var3);

    protected native int mAiStaticVerifyLargeImage(byte[] var1, StringBuffer var2);

    protected native int mAiVerifyOneToOne(int var1, int var2, byte[] var3);

    protected native int mAiVerifyOneToOneFeature(int var1, int var2, byte[] var3);

    protected native int mAiVerifyOneToOneLargeImage(byte var1, byte var2, byte[] var3);

    protected native int mAiResume();

    protected native int mAiPause();

    protected native int mAiControlAutoUploadAiInfo(byte var1, byte var2, byte var3, byte var4);

    protected native int mUploadFrameAiInfo(byte var1);

    protected native int mAiStatus(StringBuffer var1);

    protected native int mAiConfigSet(String var1);

    protected native int mAiConfigGet(StringBuffer var1);

    protected native int mDeviceFpsSet(int var1);

    protected native int mDeviceFpsGet(StringBuffer var1);

    protected native int mDeviceScreenSizeSet(byte var1);

    protected native int mDeviceViewRotate(byte var1);

    protected native String mShellPicSize(int var1);

    protected native int mDeviceScreenModeGet(StringBuffer var1);

    protected native int mDeviceScreenModeSet(byte var1);

    protected native int mAiIDCountGet(StringBuffer var1);

    protected native int mDeviceIRLightnessSet(int var1, int var2);

    protected native int mDeviceIrLightnessGet(StringBuffer var1);

    protected native int mShellSetStatusBrightness(int var1);

    protected native int mSystemReboot(byte var1);

    protected native int mSystemStandby(byte var1);

    protected native int mSystemLowPower(byte var1);

    protected native int mSetQrCodeEnable(byte var1, byte var2);

    protected native int mDeviceCameraStatusGet(byte var1, StringBuffer var2);

    protected native int mDeviceCameraStatusSet(byte var1, byte var2);

    protected native int mDeviceAntiFlickerGet(byte var1, StringBuffer var2);

    protected native int mDeviceAntiFlickerSet(byte var1, byte var2, byte var3);

    protected native int mDeviceCameraSwitch(byte var1, byte var2);

    protected native boolean mRegisterCallback(IReceiveCallback var1);

    protected native int mFactoryReset(byte var1);

    protected native int mDeviceSnGet(byte var1, StringBuffer var2);

    protected native int mDeviceModuleGet(StringBuffer var1);

    protected native int mBootTimeGet(StringBuffer var1);

    protected native int mDeviceBrightnessSensorGet(StringBuffer var1);

    protected native int mDeviceAppVersion(StringBuffer var1);

    protected native int mDeviceSensorCameraModule(int[] var1);

    protected native int mSingleRecognizeGet(StringBuffer var1);

    protected native int mGetCpuTemperature(StringBuffer var1);

    protected native int mTemplateUpdateSet(byte var1);

    protected native int mTemplateUpdateGet(StringBuffer var1);

    protected native int mSetDeviceName(String var1);

    protected native int mGetDeviceName(StringBuffer var1);

    protected native int mUpdateFeature(byte[] var1, String var2);

    @SuppressLint(value={"CheckResult"})
    public void mtcSetDeviceName(String deviceName, MtcCallback mtcCallback) {
        int resultCode = 0;
        String errorMsg = "";
        if (TextUtils.isEmpty((CharSequence)deviceName)) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "deviceName is null or empty";
        }
        if (resultCode != 0) {
            MClient.writeDebug("mSetDeviceName", "mode : 0, deviceName : " + deviceName, "", "retCode : " + resultCode);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg);
            return;
        }
        Observable.create(emitter -> {
            int retCode = this.mSetDeviceName(deviceName);
            MClient.writeDebug("mSetDeviceName", "mode : 0, deviceName : " + deviceName, "", "retCode : " + retCode);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcGetDeviceName(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mGetDeviceName(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcGetDeviceName", "", "deviceName : " + result, "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcUpdateFeature(byte[] featureDatas, String featureId, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (TextUtils.isEmpty((CharSequence)featureId) || featureId.getBytes().length > 32 || featureDatas == null || featureDatas.length <= 0 || featureDatas.length > 0x400000 || featureId.contains("\\") || featureId.contains("/") || featureId.contains("//")) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "TextUtils.isEmpty(Id) || Id.getBytes().length > 32 || featureDatas == null || featureDatas.length <= 0 ||\nfeatureDatas.length > 4 * 1024 * 1024 || Id.contains(\"\\\\\") || Id.contains(\"/\") || Id.contains(\"//\")";
            } else {
                int retCode = this.mUpdateFeature(featureDatas, featureId);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcUpdateFeature", "featureDatas : " + featureDatas + ", Id : " + featureId, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    public boolean setReceiveCallback(IReceiveCallback callback) {
        boolean isOK = this.mRegisterCallback(callback);
        if (callback != null) {
            MClient.writeDebug("setReceiveCallback", "callback : " + callback.toString(), "", "retCode : " + isOK);
        }
        return isOK;
    }

    protected final String mSensorOfCameraModule(int module) {
        String m;
        switch (module) {
            case 8760: {
                m = "SC2315E";
                break;
            }
            case 51988: {
                m = "SC2335";
                break;
            }
            case 9018: {
                m = "SC233A";
                break;
            }
            default: {
                m = "Unknown module";
            }
        }
        return m;
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSetIsDebug(boolean isDebug) {
        MClient.mSetIsDebug(isDebug);
        mtcIsDebug = true;
        MClient.writeDebug("mtcSetIsDebug", "isDebug : " + isDebug, "", "");
        mtcIsDebug = isDebug;
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcInit(int fd, int busNum, int devNum, MtcCallback mtcCallback) {
        MtcInitParams mtcInitParams = new MtcInitParams();
        int vendorId = mtcInitParams.getVendorId();
        int productId = mtcInitParams.getProductId();
        int endPointInAddress = mtcInitParams.getEndPointInAddress();
        int endPointOutAddress = mtcInitParams.getEndPointOutAddress();
        int interfaceNumber = mtcInitParams.getInterfaceNumber();
        Observable.create(emitter -> {
            int retCode = this.mInit(fd, busNum, devNum, vendorId, productId, endPointInAddress, endPointOutAddress, interfaceNumber);
            MClient.writeDebug("mtcInit", "fd : " + fd + ", busNum : " + busNum + ", devNum : " + devNum + ", vendorId : " + vendorId + ", productId : " + productId + ", endPointInAddress : " + endPointInAddress + ", endPointOutAddress : " + endPointOutAddress + ", interfaceNumber : " + interfaceNumber, "", "retCode : " + retCode);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public MtcCode mtcPing() {
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        mtcReceiver.setMtcCode(MtcCode.SUCCESS);
        Observable.create(emitter -> {
            mtcReceiver.setMtcCode(MtcCode.ERR_TIME_OUT);
            int retCode = this.mPing();
            MClient.writeDebug("mtcPing", "", "", "retCode : " + retCode);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(2000L);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)Objects.requireNonNull(e.getMessage()));
            }
        } else {
            Log.w((String)TAG, (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode();
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcPing(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode = this.mPing();
            MClient.writeDebug("mtcPing", "", "", "retCode : " + retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    public void mtcDestroy() {
        this.mDestroy();
        MClient.writeDebug("mtcDestroy", "", "", "");
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceCameraSwitch(int cammraId, int isMirror, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (cammraId != 0 && cammraId != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "cammraId != 0x00 && cammraId != 0x01";
            } else {
                int retCode = this.mDeviceCameraSwitch((byte)cammraId, (byte)isMirror);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceCameraSwitch", "cammraId : " + cammraId + ", isMirror : " + isMirror, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceFpsSet(int fps, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errnoInfo = "";
            if (fps > 25 || fps < 5) {
                mtcCode = MtcCode.PARAM_ERROR;
                errnoInfo = "fps > 25 || fps < 5";
            } else {
                int retCode = this.mDeviceFpsSet(fps);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceFpsSet", "fps : " + fps, "", "retCode : " + mtcCode.getRetCode(), errnoInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceFpsGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceFpsGet(result);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = "fps : " + result;
            } else {
                outputInfo = "invalid output";
                errorInfo = "result is empty";
            }
            MClient.writeDebug("mtcDeviceFpsGet", "", outputInfo, "retCode : " + retCode, errorInfo);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceScreenSizeSet(int screenSize, MtcCallback mtcCallback) {
        int resultCode = 0;
        String errorMsg = "";
        if (screenSize != 0 && screenSize != 1 && screenSize != 2 && screenSize != 3) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "screenSize only support 0x00 or 0x01, current screenSize is=" + screenSize;
        }
        if (resultCode != 0) {
            MClient.writeDebug("mtcDeviceScreenSizeSet", "screenSize : " + screenSize, "", "resultCode : " + resultCode, errorMsg);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg);
            return;
        }
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (screenSize < 0 || screenSize > 4) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "(screenSize < 0x00 || screenSize > 0x04) not support";
            } else {
                int retCode = this.mDeviceScreenSizeSet((byte)screenSize);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceScreenSizeSet", "screenSize : " + screenSize, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceScreenModeSet(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x01 && mode != 0x02 && mode != 0x03 && mode != 0x04";
            } else {
                int retCode = this.mDeviceScreenModeSet((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceScreenModeSet", "mode : " + mode, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceScreenModeGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            String outputInfo;
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceScreenModeGet(result);
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = "mode : " + result;
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcDeviceScreenModeGet", "", outputInfo, "retCode : " + retCode, errorInfo);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceAntiFlickerGet(int cameraId, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            String outputInfo = "";
            String errorInfo = "";
            if (cameraId != 0 && cameraId != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                outputInfo = "invalid output";
                errorInfo = "cameraId != 0x00 && cameraId != 0x01";
            } else {
                int retCode = this.mDeviceAntiFlickerGet((byte)cameraId, result);
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    String[] antiFlickers = result.toString().split(",");
                    if (antiFlickers.length == 2) {
                        outputInfo = "frequency : " + antiFlickers[0] + ", enabled : " + antiFlickers[1];
                    } else {
                        outputInfo = "invalid output";
                        errorInfo = "output result split size != 2";
                    }
                } else {
                    outputInfo = "invalid output";
                    errorInfo = "output result is empty";
                }
                mtcCode = MtcCode.matchRetCode(retCode);
                MClient.writeDebug("mtcDeviceAntiFlickerGet", "cameraId : " + cameraId, outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceAntiFlickerSet(int cameraId, int frequency, int enabled, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (cameraId != 0 && cameraId != 1 || frequency != 0 && frequency != 1 || enabled != 0 && enabled != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "(cameraId != 0x00 && cameraId != 0x01) || (frequency != 0x00 && frequency != 0x01) || (enabled != 0x00 && enabled != 0x01)";
            } else {
                int retCode = this.mDeviceAntiFlickerSet((byte)cameraId, (byte)frequency, (byte)enabled);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceAntiFlickerSet", "cameraId : " + cameraId + ", frequency : " + frequency + ", enabled : " + enabled, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceIRSet(int brightness, int autoCloseTime, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (brightness < 0 || brightness > 200) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "brightness < 0 || brightness > 200";
            } else if (autoCloseTime < 0 || autoCloseTime > 120) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "autoCloseTime < 0 || autoCloseTime > 120";
            } else {
                int retCode = this.mDeviceIRLightnessSet(brightness, autoCloseTime);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceIRSet", "brightness : " + brightness + ", autoCloseTime : " + autoCloseTime, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceIrLedGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceIrLightnessGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "result: " + result + ", ";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                String[] resultArray = result.toString().split(",");
                if (resultArray.length == 2) {
                    outputInfo = outputInfo + "brightness : " + resultArray[0] + ", autoCloseTime : " + resultArray[1];
                } else {
                    outputInfo = outputInfo + "invalid output";
                    errorInfo = "output result split size != 2";
                }
            } else {
                outputInfo = outputInfo + "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcDeviceIrLedGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceCameraStatusGet(int cameraId, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            String outputInfo = "";
            String errorInfo = "";
            if (cameraId != 0 && cameraId != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                outputInfo = "invalid output";
                errorInfo = "cameraId != 0x00 && cameraId != 0x01";
            } else {
                int retCode = this.mDeviceCameraStatusGet((byte)cameraId, result);
                mtcCode = MtcCode.matchRetCode(retCode);
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    outputInfo = "isOpen : " + result;
                } else {
                    outputInfo = "invalid output";
                    errorInfo = "output result is empty";
                }
            }
            MClient.writeDebug("mtcDeviceCameraStatusGet", "cameraId : " + cameraId, outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceCameraStatusSet(int mode, int cameraId, MtcCallback mtcCallback) {
        int resultCode = 0;
        String errorMsg = "";
        if (mode != 0 && mode != 1) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "mode only support 0x00 or 0x01, current mode is=" + mode;
        } else if (cameraId != 0 && cameraId != 1) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "cameraId only support 0x00 or 0x01, current cameraId is=" + cameraId;
        }
        if (resultCode != 0) {
            MClient.writeDebug("mtcDeviceCameraStatusSet", "mode : " + mode + ", cameraId : " + cameraId, "", "resultCode : " + resultCode, errorMsg);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg);
            return;
        }
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x00 && mode != 0x01";
            } else {
                int retCode = this.mDeviceCameraStatusSet((byte)mode, (byte)cameraId);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceCameraStatusSet", "mode : " + mode + ", cameraId : " + cameraId, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceBrightnessSensorGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceBrightnessSensorGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = "brightness : " + result;
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcDeviceBrightnessSensorGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStatusGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiStatus(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result.toString())) {
                outputInfo = "isOpen : " + result;
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcAiStatusGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiConfigSet(String aiConfig, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)aiConfig)) {
                int retCode = this.mAiConfigSet(aiConfig);
                mtcCode = MtcCode.matchRetCode(retCode);
            } else {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "aiConfig is empty";
            }
            MClient.writeDebug("mtcAiConfigSet", "aiConfig : " + aiConfig, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiConfigGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiConfigGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = "aiConfig : " + result.toString();
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcAiConfigGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiIDCountGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiIDCountGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = "idCount : " + result;
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcAiIDCountGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStartRecognize(int reco_mode, int face_mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (reco_mode != 0 && reco_mode != 1 || face_mode != 0 && face_mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "(reco_mode != 0x00 && reco_mode != 0x01) || (face_mode != 0x00 && face_mode != 0x01)";
            } else {
                int retCode = this.mAiStartRecognize(reco_mode, face_mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiStartRecognize", "reco_mode : " + reco_mode + ", face_mode : " + face_mode, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStartVerifyByFeature(int reco_mode, int face_mode, byte[] featureBytes, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (reco_mode != 0 && reco_mode != 1 || face_mode != 0 && face_mode != 1 || featureBytes == null || featureBytes.length <= 0 || featureBytes.length > 0x400000) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "Invalid data or mode";
            } else {
                int retCode = this.mAiVerifyOneToOneFeature(reco_mode, face_mode, featureBytes);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiStartVerifyByFeature", "reco_mode : " + reco_mode + ", face_mode : " + face_mode + ", featureBytes : " + Arrays.toString(featureBytes), "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStartVerify(int reco_mode, int face_mode, byte[] imageBytes, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (reco_mode != 0 && reco_mode != 1 || face_mode != 0 && face_mode != 1 || imageBytes == null || imageBytes.length <= 0 || imageBytes.length > 0x400000) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "Invalid date or mode";
            } else {
                int retCode = 0;
                retCode = imageBytes.length <= 76800 ? this.mAiVerifyOneToOne(reco_mode, face_mode, imageBytes) : this.mAiVerifyOneToOneLargeImage((byte)reco_mode, (byte)face_mode, imageBytes);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiStartVerify", "reco_mode : " + reco_mode + ", face_mode : " + face_mode + ", imageBytes : " + imageBytes, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiResume(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode = this.mAiResume();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcAiResume", "", "", "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiPause(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode = this.mAiPause();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcAiPause", "", "", "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiControlAutoUploadAiInfo(int mode, boolean rgbFaceImg, boolean rgbBgImg, boolean irImg, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x01 && mode != 0x02 && mode != 0x03 && mode != 0x04";
            } else {
                int retCode = this.mAiControlAutoUploadAiInfo((byte)mode, (byte)(rgbFaceImg ? 1 : 0), (byte)(rgbBgImg ? 1 : 0), (byte)(irImg ? 1 : 0));
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiControlAutoUploadAiInfo", "mode : " + mode + ", rgbFaceImg : " + rgbFaceImg + ", rgbBgImg : " + rgbBgImg + ", irImg : " + irImg, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcUploadFrameAiInfo(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x00 && mode != 0x01";
            } else {
                int retCode = this.mUploadFrameAiInfo((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcUploadFrameAiInfo", "mode : " + mode, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public int mtcAiAddImageByCamera(int mode, String id, int type, @NonNull MtcCallback mtcCallback) {
        int resultCode = 0;
        String errorMsg = "";
        if (mode != 0 && mode != 2) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "mode only support 0x00 or 0x02, current mode is=" + mode;
        } else {
            Pair<Integer, String> idResult = ParamsCheckHelper.checkImageId(id);
            if ((Integer)idResult.first != 0) {
                resultCode = (Integer)idResult.first;
                errorMsg = (String)idResult.second;
            }
        }
        if (resultCode != 0) {
            MClient.writeDebug("mtcAiAddImageByCamera", "mode : " + mode + ", id : " + id, "", "resultCode : " + resultCode, errorMsg);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg, null);
            return resultCode;
        }
        Observable.create(emitter -> {
            MtcCode mtcCode;
            MtcReceiver mtcReceiver = new MtcReceiver();
            StringBuffer imageQualityResult = new StringBuffer();
            String outputInfo = "";
            String errorInfo = "";
            if (TextUtils.isEmpty((CharSequence)id) || id.getBytes().length > 32) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "TextUtils.isEmpty(id) || id.getBytes().length > 32";
            } else {
                int retCode;
                if (mode == 2) {
                    ByteBuffer uploadImgByteBuffer = ByteBuffer.allocate(1024000);
                    retCode = type == 21 || type == 20 ? this.mAiAddImage((byte)mode, null, id, uploadImgByteBuffer) : this.mAiAddImage((byte)mode, null, id, uploadImgByteBuffer, imageQualityResult);
                    byte[] data = new byte[uploadImgByteBuffer.limit()];
                    uploadImgByteBuffer.get(data);
                    outputInfo = "uploadImgByteBuffer : " + data;
                    mtcReceiver.setResult(Base64.encodeToString((byte[])data, (int)0));
                } else {
                    retCode = type == 21 || type == 20 ? this.mAiAddImage((byte)mode, null, id, null) : this.mAiAddImage((byte)mode, null, id, null, imageQualityResult);
                }
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiAddImageByCamera", "mode : " + mode + ", id : " + id, outputInfo, "resultCode : " + mtcCode.getRetCode() + ", imageQualityResult : " + imageQualityResult, errorInfo);
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setExtraInfo(imageQualityResult.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            mtcCallback.onResult(s.getMtcCode(), s.getResult());
            mtcCallback.onResult(s.getMtcCode(), s.getResult(), s.getExtraInfo());
        });
        return resultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcAiAddImageFromExternal(byte[] imageBytes, String id) {
        int retCode = 0;
        String errorInfo = "";
        Pair<Integer, String> imageResult = ParamsCheckHelper.checkImageBuffer(imageBytes);
        if ((Integer)imageResult.first == 0) {
            Pair<Integer, String> idResult = ParamsCheckHelper.checkImageId(id);
            if ((Integer)idResult.first != 0) {
                retCode = (Integer)idResult.first;
                errorInfo = (String)idResult.second;
            }
        } else {
            retCode = (Integer)imageResult.first;
            errorInfo = (String)imageResult.second;
        }
        if (retCode != 0) {
            MClient.writeDebug("mtcAiAddImageFromExternal", "imageBytes : " + Arrays.toString(imageBytes) + ", id : " + id, "", "retCode : " + retCode, errorInfo);
            return retCode;
        }
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int resultCode = this.mAiAddImage((byte)1, imageBytes, id, null);
            MtcCode mtcCode = MtcCode.matchRetCode(resultCode);
            MClient.writeDebug("mtcAiAddImageFromExternal", "imageBytes : " + imageBytes + ", id : " + id, "", "resultCode : " + mtcCode.getRetCode());
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(15000L);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)Objects.requireNonNull(e.getMessage()));
            }
        } else {
            Log.w((String)TAG, (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcAiAddImageFromExternal(byte[] imageBytes, String id, int type, MtcCallback mtcCallback) {
        int retCode = 0;
        String errorInfo = "";
        Pair<Integer, String> imageResult = ParamsCheckHelper.checkImageBuffer(imageBytes);
        if ((Integer)imageResult.first == 0) {
            Pair<Integer, String> idResult = ParamsCheckHelper.checkImageId(id);
            if ((Integer)idResult.first != 0) {
                retCode = (Integer)idResult.first;
                errorInfo = (String)idResult.second;
            }
        } else {
            retCode = (Integer)imageResult.first;
            errorInfo = (String)imageResult.second;
        }
        if (retCode != 0) {
            MClient.writeDebug("mtcAiAddImageFromExternal", "imageBytes : " + Arrays.toString(imageBytes) + ", id : " + id, "", "retCode : " + retCode, errorInfo);
            mtcCallback.onResult(MtcCode.matchRetCode(retCode), errorInfo);
            return retCode;
        }
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int resultCode = type == 20 ? this.mAiAddImage((byte)1, imageBytes, id, null) : this.mAiAddImage((byte)1, imageBytes, id, null, result);
            MtcCode mtcCode = MtcCode.matchRetCode(resultCode);
            MClient.writeDebug("mtcAiAddImageFromExternal", "imageBytes : " + imageBytes + ", id : " + id, "", "resultCode : " + mtcCode.getRetCode() + ", result : " + result);
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            mtcCallback.onResult(s.getMtcCode(), s.getResult());
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(15000L);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)Objects.requireNonNull(e.getMessage()));
            }
        } else {
            Log.w((String)TAG, (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcAiAddLargeImageFromExternal(byte[] imageBytes, String id) {
        int retCode = 0;
        String errorInfo = "";
        Pair<Integer, String> imageResult = ParamsCheckHelper.checkImageBuffer(imageBytes);
        if ((Integer)imageResult.first == 0) {
            Pair<Integer, String> idResult = ParamsCheckHelper.checkImageId(id);
            if ((Integer)idResult.first != 0) {
                retCode = (Integer)idResult.first;
                errorInfo = (String)idResult.second;
            }
        } else {
            retCode = (Integer)imageResult.first;
            errorInfo = (String)imageResult.second;
        }
        if (retCode != 0) {
            MClient.writeDebug("mtcAiAddLargeImageFromExternal", "imageBytes : " + (imageBytes != null ? new String(imageBytes) : "null") + ", id : " + id, "", "retCode : " + retCode, errorInfo);
            return retCode;
        }
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int resultCode = this.mAiAddLargeImage(imageBytes, id);
            MtcCode mtcCode = MtcCode.matchRetCode(resultCode);
            MClient.writeDebug("mtcAiAddLargeImageFromExternal", "imageBytes : " + imageBytes + ", id : " + id, "", "resultCode : " + mtcCode.getRetCode());
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(15000L);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)Objects.requireNonNull(e.getMessage()));
            }
        } else {
            Log.w((String)TAG, (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcAiAddLargeImageFromExternal(byte[] imageBytes, String id, int type, MtcCallback mtcCallback) {
        int retCode = 0;
        String errorInfo = "";
        Pair<Integer, String> imageResult = ParamsCheckHelper.checkImageBuffer(imageBytes);
        if ((Integer)imageResult.first == 0) {
            Pair<Integer, String> idResult = ParamsCheckHelper.checkImageId(id);
            if ((Integer)idResult.first != 0) {
                retCode = (Integer)idResult.first;
                errorInfo = (String)idResult.second;
            }
        } else {
            retCode = (Integer)imageResult.first;
            errorInfo = (String)imageResult.second;
        }
        if (retCode != 0) {
            MClient.writeDebug("mtcAiAddLargeImageFromExternal", "imageBytes : " + (imageBytes != null ? new String(imageBytes) : "null") + ", id : " + id, "", "retCode : " + retCode, errorInfo);
            mtcCallback.onResult(MtcCode.matchRetCode(retCode), errorInfo);
            return retCode;
        }
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int resultCode = type == 20 ? this.mAiAddLargeImage(imageBytes, id) : this.mAiAddLargeImage(imageBytes, id, result);
            MtcCode mtcCode = MtcCode.matchRetCode(resultCode);
            MClient.writeDebug("mtcAiAddLargeImageFromExternal", "imageBytes : " + imageBytes + ", id : " + id, "", "resultCode : " + mtcCode.getRetCode() + ", result : " + result);
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            mtcCallback.onResult(s.getMtcCode(), s.getResult());
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(15000L);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)Objects.requireNonNull(e.getMessage()));
            }
        } else {
            Log.w((String)TAG, (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAllIdListGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer idListValues = new StringBuffer();
            int retCode = this.mIdListGet(idListValues);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcAllIdListGet", "", "idListValues : " + idListValues.toString().getBytes(), "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(idListValues.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiDelUserImageById(String id, MtcCallback mtcCallback) {
        int resultCode = 0;
        String errorMsg = "";
        if (TextUtils.isEmpty((CharSequence)id)) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "id is empty";
        }
        if (resultCode != 0) {
            MClient.writeDebug("mtcAiDelUserImageById", "id : " + id, "", "resultCode : " + resultCode, errorMsg);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg);
            return;
        }
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (TextUtils.isEmpty((CharSequence)id) || id.getBytes().length > 32) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "TextUtils.isEmpty(id) || id.getBytes().length > 32";
            } else {
                int retCode = this.mAiDelImage((byte)1, id);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiDelUserImageById", "id : " + id, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiClearAllImage(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode = this.mAiDelAllImage();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcAiClearAllImage", "", "", "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiQueryId(String id, MtcCallback mtcCallback) {
        int resultCode = 0;
        String errorMsg = "";
        if (TextUtils.isEmpty((CharSequence)id)) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "id is empty";
        }
        if (resultCode != 0) {
            MClient.writeDebug("mtcAiQueryId", "id : " + id, "", "resultCode : " + resultCode, errorMsg);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg);
            return;
        }
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            String errorInfo = "";
            if (TextUtils.isEmpty((CharSequence)id) || id.getBytes().length > 32) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "TextUtils.isEmpty(id) || id.getBytes().length > 32";
            } else {
                int retCode = this.mAiQueryImage(id, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiQueryId", "id : " + id, "isIdNotExist : " + result, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiAddFeature(byte[] featureDatas, String Id, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (TextUtils.isEmpty((CharSequence)Id) || Id.getBytes().length > 32 || featureDatas == null || featureDatas.length <= 0 || featureDatas.length > 0x400000 || Id.contains("\\") || Id.contains("/") || Id.contains("//")) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "TextUtils.isEmpty(Id) || Id.getBytes().length > 32 || featureDatas == null || featureDatas.length <= 0 ||\nfeatureDatas.length > 4 * 1024 * 1024 || Id.contains(\"\\\\\") || Id.contains(\"/\") || Id.contains(\"//\")";
            } else {
                int retCode = this.mAiAddFeature(featureDatas, Id);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiAddFeature", "featureDatas : " + featureDatas + ", Id : " + Id, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiRecognitionCountSet(int recognitionTimes, int livingTimes, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (recognitionTimes < 1 || recognitionTimes > 10 || livingTimes < 1 || livingTimes > 10) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "recognitionTimes < 1 || recognitionTimes > 10 || livingTimes < 1 || livingTimes > 10";
            } else {
                int retCode = this.mAiRecognitionCountSet((byte)recognitionTimes, (byte)livingTimes);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiRecognitionCountSet", "recognitionTimes : " + recognitionTimes + ", livingTimes : " + livingTimes, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiRecognitionCountGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiRecognitionCountGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                String[] recogLivingCount = result.toString().split(",");
                if (recogLivingCount.length == 2) {
                    int recognitionCount = Integer.parseInt(recogLivingCount[0], 16);
                    int livingCount = Integer.parseInt(recogLivingCount[1], 16);
                    outputInfo = "recognitionCount : " + recognitionCount + ", livingCount : " + livingCount;
                } else {
                    outputInfo = "invalid output";
                    errorInfo = "output result split size != 2";
                }
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcAiRecognitionCountGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiQueryFeature(String id, MtcCallback mtcCallback) {
        int resultCode = 0;
        String errorMsg = "";
        if (TextUtils.isEmpty((CharSequence)id)) {
            resultCode = MtcCode.PARAM_ERROR.getRetCode();
            errorMsg = "id is empty";
        }
        if (resultCode != 0) {
            MClient.writeDebug("mtcAiQueryFeature", "id : " + id, "", "resultCode : " + resultCode, errorMsg);
            mtcCallback.onResult(MtcCode.matchRetCode(resultCode), errorMsg);
            return;
        }
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            MtcReceiver mtcReceiver = new MtcReceiver();
            String errorInfo = "";
            if (TextUtils.isEmpty((CharSequence)id) || id.getBytes().length > 32 || id.contains("\\") || id.contains("/") || id.contains("//")) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "TextUtils.isEmpty(id) || id.getBytes().length > 32 || id.contains(\"\\\\\") || id.contains(\"/\") || id.contains(\"//\")";
            } else {
                int retCode = this.mAiQueryFeature(id, result);
                mtcCode = MtcCode.matchRetCode(retCode);
                mtcReceiver.setResult(new String(result));
            }
            String outputInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = result.toString().getBytes().toString();
            }
            MClient.writeDebug("mtcAiQueryFeature", "id : " + id, outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStaticVerify(int mode, byte[] imageBytes, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode;
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            String errorInfo = "";
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x00 && mode != 0x01";
            } else if (mode == 0) {
                retCode = this.mAiStaticVerify((byte)mode, imageBytes, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            } else if (imageBytes == null) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "imageBytes can not be null when mode == 0x01";
            } else if (imageBytes.length < 76800) {
                retCode = this.mAiStaticVerify((byte)mode, imageBytes, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            } else {
                retCode = this.mAiStaticVerifyLargeImage(imageBytes, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcAiStaticVerify", "mode : " + mode + ", imageBytes : " + imageBytes, result.toString(), "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcSystemUploadUpgradePackage(int position, byte[] data, int dataLength) {
        if (data == null || dataLength == 0) {
            int nRet = MtcCode.PARAM_ERROR.getRetCode();
            MClient.writeDebug("mtcSystemUploadUpgradePackage", "position : " + position + ", data : " + data + ", dataLength : " + dataLength, "", "retCode : " + nRet);
            return nRet;
        }
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int retCode = this.mSystemUploadUpgradePackage(position, data, dataLength);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcSystemUploadUpgradePackage", "position : " + position + ", data : " + data + ", dataLength : " + dataLength, "", "retCode : " + mtcCode.getRetCode());
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(2000L);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)Objects.requireNonNull(e.getMessage()));
            }
        } else {
            Log.w((String)TAG, (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcSystemApplyUpgradePackage(String fileMD5, StringBuffer result) {
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int retCode = this.mSystemApplyUpgradePackage(fileMD5, result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            Log.d((String)TAG, (String)("mtcSystemApplyUpgradePackage: " + result.toString()));
            MClient.writeDebug("mtcSystemApplyUpgradePackage", "fileMD5 : " + fileMD5, "result : " + result.toString(), "retCode : " + mtcCode.getRetCode());
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(60000L);
                }
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)Objects.requireNonNull(e.getMessage()));
            }
        } else {
            Log.w((String)TAG, (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcHandleAT(String ATCommand, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            String result = this.mHandleAt(ATCommand);
            MClient.writeDebug("mtcHandleAT", "ATCommand : " + ATCommand, "", "result : " + result);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setResult(result);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcFactoryReset(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x00 && mode != 0x01";
            } else {
                int retCode = this.mFactoryReset((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcFactoryReset", "mode : " + mode, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSystemReboot(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            String errorInfo = "";
            int retCode = this.mSystemReboot((byte)0);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcSystemReboot", "mode : 0", "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSystemStandby(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x00 && mode != 0x01";
            } else {
                int retCode = this.mSystemStandby((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcSystemStandby", "mode : " + mode, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSystemLowpower(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x00 && mode != 0x01";
            } else {
                int retCode = this.mSystemLowPower((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcSystemLowpower", "mode : " + mode, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSetQrCodeEnable(int enable, int intervalTime, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (enable != 0 && enable != 1 || intervalTime < 1 || intervalTime > 5) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "(enable != 0x00 && enable != 0x01) || intervalTime < 1 || intervalTime > 5";
            } else {
                int retCode = this.mSetQrCodeEnable((byte)enable, (byte)intervalTime);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcSetQrCodeEnable", "enable : " + enable + ", intervalTime : " + intervalTime, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSystemVersionInfoGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode = MtcCode.ERR_TIME_OUT;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 5; ++i) {
                int retCode = this.mSystemVersionInfoGet(result);
                mtcCode = MtcCode.matchRetCode(retCode);
                String outputInfo = "";
                String errorInfo = "";
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    outputInfo = "SystemVersionInfo : " + result.toString();
                } else {
                    errorInfo = "output result is empty";
                }
                MClient.writeDebug("mtcSystemVersionInfoGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
                if (mtcCode == MtcCode.SUCCESS) break;
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceSnGet(int snType, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            String outputInfo = "";
            String errorInfo = "";
            if (snType != 0 && snType != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                outputInfo = "invalid output";
                errorInfo = "snType != 0x00 && snType != 0x01";
            } else {
                int retCode = this.mDeviceSnGet((byte)snType, result);
                outputInfo = "deviceSn : " + result.toString();
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcDeviceSnGet", "snType : " + snType, outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSingleRecognizeGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mSingleRecognizeGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcSingleRecognizeGet", "", "singleRecognize : " + result.toString(), "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceAppVersion(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceAppVersion(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcDeviceAppVersion", "", "deviceAppVersion : " + result.toString(), "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSensorCameraModule(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int[] result = new int[]{0};
            int retCode = this.mDeviceSensorCameraModule(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MClient.writeDebug("mtcSensorCameraModule", "", "CameraModule : " + Arrays.toString(result) + ", " + this.mSensorOfCameraModule(result[0]), "retCode : " + mtcCode.getRetCode());
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(this.mSensorOfCameraModule(result[0]));
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcCpuTemperatureGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mGetCpuTemperature(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = "CpuTemperature : " + result;
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcCpuTemperatureGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceModuleGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode = MtcCode.ERR_TIME_OUT;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 5; ++i) {
                int retCode = this.mDeviceModuleGet(result);
                mtcCode = MtcCode.matchRetCode(retCode);
                MClient.writeDebug("mtcDeviceModuleGet", "", "deviceModule : " + result.toString(), "retCode : " + mtcCode.getRetCode());
                if (mtcCode == MtcCode.SUCCESS) break;
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcBootTimeGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode = MtcCode.ERR_TIME_OUT;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 5; ++i) {
                int retCode = this.mBootTimeGet(result);
                mtcCode = MtcCode.matchRetCode(retCode);
                String outputInfo = "";
                String errorInfo = "";
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    outputInfo = "bootTime : " + result;
                } else {
                    outputInfo = "invalid output";
                    errorInfo = "output result is empty";
                }
                MClient.writeDebug("mtcBootTimeGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
                if (mtcCode == MtcCode.SUCCESS) break;
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcTemplateUpdateSet(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            String errorInfo = "";
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
                errorInfo = "mode != 0x00 && mode != 0x01";
            } else {
                int retCode = this.mTemplateUpdateSet((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MClient.writeDebug("mtcTemplateUpdateSet", "mode : " + mode, "", "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcTemplateUpdateGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mTemplateUpdateGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            String outputInfo = "";
            String errorInfo = "";
            if (!TextUtils.isEmpty((CharSequence)result)) {
                outputInfo = "isTemplateUpdate : " + result;
            } else {
                outputInfo = "invalid output";
                errorInfo = "output result is empty";
            }
            MClient.writeDebug("mtcTemplateUpdateGet", "", outputInfo, "retCode : " + mtcCode.getRetCode(), errorInfo);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    static {
        System.loadLibrary("mtc");
        mtcIsDebug = false;
    }
}

