/*
 * Decompiled with CFR 0.152.
 */
package com.sensetime.mtc;

import android.app.Application;
import android.util.Log;
import java.lang.reflect.Field;

public class ApplicationUtil {
    static final ApplicationUtil INSTANCE = new ApplicationUtil();

    public static Application getApp() {
        Application app = INSTANCE.getApplicationByReflect();
        Log.d((String)"ApplicationUtil", (String)("tox================> application = " + app));
        return app;
    }

    private Application getApplicationByReflect() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object thread = this.getActivityThread();
            if (thread == null) {
                return null;
            }
            Object app = activityThreadClass.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                return null;
            }
            return (Application)app;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getActivityThread() {
        Object activityThread = this.getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) {
            return activityThread;
        }
        return this.getActivityThreadInActivityThreadStaticMethod();
    }

    private Object getActivityThreadInActivityThreadStaticField() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            return sCurrentActivityThreadField.get(null);
        }
        catch (Exception e) {
            Log.e((String)"UtilsActivityLifecycle", (String)("getActivityThreadInActivityThreadStaticField: " + e.getMessage()));
            return null;
        }
    }

    private Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            return activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)"UtilsActivityLifecycle", (String)("getActivityThreadInActivityThreadStaticMethod: " + e.getMessage()));
            return null;
        }
    }
}

