/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api;

import android.content.Context;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.dialoid.speech.recognition.SpeechRecognizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import net.daum.mf.speech.api.SpeechRecognizeListener;
import net.daum.mf.speech.api.SpeechRecognizerManager;

public final class SpeechRecognizerClient {
    private static final String TAG = "SpeechRecognizerClient";
    public static final int START_SPEECH_POINT_TIMEOUT = 5;
    public static final int GLOBAL_TIMEOUT_DEFAULT = 30;
    public static final String SERVICE_TYPE_DICTATION = "DICTATION";
    public static final String SERVICE_TYPE_WEB = "WEB";
    public static final String SERVICE_TYPE_LOCAL = "LOCAL";
    public static final String SERVICE_TYPE_WORD = "WORD";
    public static final int ERROR_AUDIO_FAIL = 1;
    public static final int ERROR_AUTH_FAIL = 8;
    @Deprecated
    public static final int ERROR_AUTH_TROUBLE = 0;
    public static final int ERROR_CLIENT = 5;
    public static final int ERROR_NETWORK_FAIL = 2;
    public static final int ERROR_NETWORK_TIMEOUT = 3;
    public static final int ERROR_SERVER_FAIL = 6;
    public static final int ERROR_SERVER_TIMEOUT = 7;
    public static final int ERROR_NO_RESULT = 4;
    public static final int ERROR_SERVER_UNSUPPORT_SERVICE = 11;
    public static final int ERROR_SERVER_USERDICT_EMPTY = 12;
    public static final int ERROR_SERVER_ALLOWED_REQUESTS_EXCESS = 13;
    public static final int ERROR_RECOGNITION_TIMEOUT = 99;
    public static final String KEY_RECOGNITION_RESULTS = "recognition_results";
    public static final String KEY_CONFIDENCE_VALUES = "confidence_values";
    public static final String KEY_IS_MARKED_RESULT = "is_marked_result";
    public static final int CONFIDENCE_PASSING_MARKED = 10;
    private SpeechRecognizeListener speechRecognizeListener;
    private boolean mutedStart;
    private boolean alreadyError;
    private boolean inCancelling;
    private boolean isRecording;
    private boolean beforeReady;
    private SpeechRecognizer speechRecognizer;
    private String apiKey;
    private int globalTimeOut;
    private String serviceType;
    private String userDictionary;
    private Timer globalTimer;
    private SpeechRecognizer.Listener listener = new SpeechRecognizer.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReady() {
            SpeechRecognizerClient speechRecognizerClient = SpeechRecognizerClient.this;
            synchronized (speechRecognizerClient) {
                SpeechRecognizerClient.this.beforeReady = false;
            }
            if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                SpeechRecognizerClient.this.speechRecognizeListener.onReady();
            }
        }

        @Override
        public void onPartialResult(String text) {
            if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                SpeechRecognizerClient.this.speechRecognizeListener.onPartialResult(text);
            }
        }

        @Override
        public void onInactive() {
            if (SpeechRecognizerClient.this.inCancelling) {
                return;
            }
            new Thread("running-inactive"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SpeechRecognizerClient speechRecognizerClient = SpeechRecognizerClient.this;
                    synchronized (speechRecognizerClient) {
                        SpeechRecognizerClient.this.beforeReady = false;
                        SpeechRecognizerClient.this.isRecording = false;
                        SpeechRecognizerClient.this.stopGlobalTimeoutTimer();
                        SpeechRecognizerClient.this.speechRecognizer = null;
                    }
                    if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                        SpeechRecognizerClient.this.speechRecognizeListener.onFinished();
                    }
                }
            }.start();
        }

        @Override
        public void onFinalResult(String[] texts) {
            this.onFinalResultConf(texts, null);
        }

        @Override
        public void onFinalResultConf(String[] texts, int[] ints) {
            try {
                if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                    Bundle result = new Bundle();
                    ArrayList<String> resultList = new ArrayList<String>(Arrays.asList(texts));
                    ArrayList<Integer> confList = new ArrayList<Integer>();
                    if (ints != null && ints.length > 0) {
                        for (int conf : ints) {
                            confList.add(conf);
                        }
                        result.putBoolean(SpeechRecognizerClient.KEY_IS_MARKED_RESULT, ints[0] >= 10);
                    }
                    result.putStringArrayList(SpeechRecognizerClient.KEY_RECOGNITION_RESULTS, resultList);
                    result.putIntegerArrayList(SpeechRecognizerClient.KEY_CONFIDENCE_VALUES, confList);
                    SpeechRecognizerClient.this.speechRecognizeListener.onResults(result);
                }
            }
            catch (Exception e) {
                Log.e((String)SpeechRecognizerClient.TAG, (String)"", (Throwable)e);
                this.onError(5, "VOICE_RECO_RESULT_CONTAIN_INVAID_DATA");
            }
        }

        @Override
        public void onError(int code, String msg) {
            Log.d((String)SpeechRecognizerClient.TAG, (String)("[onError] : " + code + " msg : " + msg));
            if (SpeechRecognizerClient.this.alreadyError) {
                return;
            }
            SpeechRecognizerClient.this.alreadyError = true;
            if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                SpeechRecognizerClient.this.speechRecognizeListener.onError(code, msg);
            }
            SpeechRecognizerClient.this.cancelRecording(false);
        }

        @Override
        public void onEnergyChanged(int energy) {
            if (energy >= 0 && energy < 90) {
                energy = 0;
            }
            float level = (float)energy - 90.0f;
            if ((level /= 160.0f) < 0.0f) {
                level = 0.0f;
            } else if (level > 1.0f) {
                level = 1.0f;
            }
            if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                SpeechRecognizerClient.this.speechRecognizeListener.onAudioLevel(level);
            }
        }

        @Override
        public void onEndPointDetect() {
            if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                SpeechRecognizerClient.this.speechRecognizeListener.onEndOfSpeech();
            }
        }

        @Override
        public void onBeginPointDetect() {
            if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                SpeechRecognizerClient.this.speechRecognizeListener.onBeginningOfSpeech();
            }
        }
    };

    SpeechRecognizerClient(Builder builder) {
        this.apiKey = builder.apiKey;
        this.globalTimeOut = builder.globalTimeOut;
        this.serviceType = builder.serviceType;
        this.userDictionary = builder.userDictionary;
    }

    public void setSpeechRecognizeListener(SpeechRecognizeListener speechRecognizeListener) {
        this.speechRecognizeListener = speechRecognizeListener;
    }

    private void startGlobalTimeoutTimer() {
        this.globalTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                int errorCode = 99;
                String errorString = "GLOBAL_TIMEOUT";
                Context context = SpeechRecognizerManager.getInstance().getApplicationContext();
                ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = conn.getActiveNetworkInfo();
                if (networkInfo == null || !networkInfo.isConnected()) {
                    errorCode = 2;
                    errorString = "NETWORK_FAILURE";
                }
                if (SpeechRecognizerClient.this.speechRecognizeListener != null) {
                    SpeechRecognizerClient.this.speechRecognizeListener.onError(errorCode, errorString);
                }
                SpeechRecognizerClient.this.cancelRecording(true);
            }
        };
        this.globalTimer.schedule(timerTask, this.globalTimeOut * 1000);
    }

    private void stopGlobalTimeoutTimer() {
        if (this.globalTimer != null) {
            this.globalTimer.cancel();
            this.globalTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRecording(final boolean mute) {
        SpeechRecognizerClient speechRecognizerClient = this;
        synchronized (speechRecognizerClient) {
            if (this.inCancelling) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        SpeechRecognizerClient.this.startRecording(mute);
                    }
                });
                return true;
            }
            if (this.isRecording) {
                return false;
            }
        }
        this.mutedStart = mute;
        Context context = SpeechRecognizerManager.getInstance().getApplicationContext();
        if (this.mutedStart) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            audioManager.setStreamMute(3, true);
        }
        SpeechRecognizerClient speechRecognizerClient2 = this;
        synchronized (speechRecognizerClient2) {
            this.alreadyError = false;
            this.stopGlobalTimeoutTimer();
            this.speechRecognizer = SpeechRecognizer.getInstance();
            Method m = null;
            try {
                m = SpeechRecognizer.class.getMethod("setAppID", String.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (m != null) {
                String packageName = context.getPackageName();
                try {
                    m.invoke((Object)this.speechRecognizer, packageName);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            this.speechRecognizer.setAPIKey(this.apiKey);
            this.speechRecognizer.setService(this.serviceType);
            this.speechRecognizer.setServer("openapi.voice.search.daum.net", 30000);
            if (!TextUtils.isEmpty((CharSequence)this.userDictionary)) {
                this.speechRecognizer.setUserDict(this.userDictionary);
            }
            this.speechRecognizer.setListener(this.listener);
            this.speechRecognizer.startListening();
            this.startGlobalTimeoutTimer();
            this.isRecording = true;
            this.beforeReady = true;
        }
        return true;
    }

    private void setMuteOff() {
        if (this.mutedStart) {
            Context appContext = SpeechRecognizerManager.getInstance().getApplicationContext();
            AudioManager audioManager = (AudioManager)appContext.getSystemService("audio");
            audioManager.setStreamMute(3, false);
            this.mutedStart = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSpeechRecognizer() {
        SpeechRecognizerClient speechRecognizerClient = this;
        synchronized (speechRecognizerClient) {
            if (this.speechRecognizer != null && this.speechRecognizer.cancel()) {
                this.speechRecognizer.join();
            }
            this.speechRecognizer = null;
            this.inCancelling = false;
            this.isRecording = false;
            this.beforeReady = false;
        }
        this.setMuteOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRecording(boolean sync) {
        SpeechRecognizerClient speechRecognizerClient = this;
        synchronized (speechRecognizerClient) {
            if (this.inCancelling || this.beforeReady) {
                return;
            }
            this.stopGlobalTimeoutTimer();
            this.inCancelling = true;
        }
        if (sync) {
            this.cancelSpeechRecognizer();
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    SpeechRecognizerClient.this.cancelSpeechRecognizer();
                }
            });
        }
    }

    public void cancelRecording() {
        this.cancelRecording(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        SpeechRecognizerClient speechRecognizerClient = this;
        synchronized (speechRecognizerClient) {
            if (this.inCancelling || this.beforeReady) {
                return;
            }
            this.stopGlobalTimeoutTimer();
            if (this.speechRecognizer != null) {
                this.speechRecognizer.stopListening();
            }
        }
        this.setMuteOff();
    }

    public static class Builder {
        private String apiKey;
        private int globalTimeOut = 30;
        private String serviceType = "WEB";
        private String userDictionary;

        public String getApiKey() {
            return this.apiKey;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public int getGlobalTimeOut() {
            return this.globalTimeOut;
        }

        public Builder setGlobalTimeOut(int globalTimeOut) {
            this.globalTimeOut = globalTimeOut;
            return this;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public Builder setServiceType(String serviceType) {
            if (!TextUtils.isEmpty((CharSequence)serviceType)) {
                this.serviceType = serviceType;
            }
            return this;
        }

        public String getUserDictionary() {
            return this.userDictionary;
        }

        public Builder setUserDictionary(String userDictionary) {
            this.userDictionary = userDictionary;
            return this;
        }

        public SpeechRecognizerClient build() throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)this.apiKey)) {
                throw new IllegalArgumentException("API Key is empty. You must set API key!");
            }
            return new SpeechRecognizerClient(this);
        }
    }
}

