/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.daum.mf.speech.api.SpeechRecognizeListener;
import net.daum.mf.speech.api.SpeechRecognizerClient;
import net.daum.mf.speech.api.SpeechRecognizerManager;
import net.daum.mf.speech.api.SpeechRecognizerSurfaceView;
import net.daum.mf.speech.api.impl.util.DeviceUtils;
import net.daum.mf.speech.api.impl.util.PermissionUtils;
import net.daum.mf.speech.api.impl.view.SpecialSearchRenderer;

public class SpeechRecognizerActivity
extends Activity {
    private static final String TAG = "SpeechRecognizerActivity";
    public static final String EXTRA_KEY_API_KEY = "api_key";
    public static final String EXTRA_KEY_SERVICE_TYPE = "service_type";
    public static final String EXTRA_KEY_USER_DICTIONARY = "user_dictionary";
    public static final String EXTRA_KEY_SPEECH_GUIDE = "speech_guide";
    public static final String EXTRA_KEY_HOME_BUTTON = "home_button";
    public static final String EXTRA_KEY_SHOW_SUGGEST_LIST = "show_suggest_list";
    public static final int STARTING_SUCCESS = 0;
    public static final int STARTING_NETWORK_DISCONNECTED = 1;
    public static final int STARTING_ALREADY_STARTED = 2;
    public static final int STARTING_UNINITIALIZED = 3;
    private static final String[] canvasSurfaceViewExceptionVersionList = new String[]{"4.3"};
    private SpeechRecognizerClient recognizer;
    private ProgressBar mProgressBar;
    private TextView mMessageView;
    private TextView mIntermediateMessageView;
    private TextView mTipView;
    private SpeechRecognizerSurfaceView mCanvasSurfaceView;
    private SpecialSearchRenderer mSpecialSearchRenderer;
    private View mTopRetryButton;
    private View mVoiceButton;
    private View mRetryButton;
    private ListView mSuggestListViewPortrait;
    private LinearLayout mSuggestLandScapeLayout;
    private SuggestListAdapter mSuggestListAdapter;
    private List<Float> mVolumes = new ArrayList<Float>();
    private Map<RES_STRINGS, String> stringsMap = new HashMap<RES_STRINGS, String>();
    private Map<RES_VIEWID, Integer> idsMap = new HashMap<RES_VIEWID, Integer>();
    private boolean showSuggestResultsListView = true;
    private SpeechRecognizeListener callback = new SpeechRecognizeListener(){

        @Override
        public void onReady() {
        }

        @Override
        public void onBeginningOfSpeech() {
            SpeechRecognizerActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!SpeechRecognizerActivity.this.isFinishing()) {
                        SpeechRecognizerActivity.this.mVoiceButton.setEnabled(true);
                        SpeechRecognizerActivity.this.mVoiceButton.setSelected(true);
                        SpeechRecognizerActivity.this.mTipView.setText((CharSequence)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.TOUCH_BUTTON_TO_USE_RESULT_INSTANTLY));
                    }
                }
            });
        }

        @Override
        public void onEndOfSpeech() {
            SpeechRecognizerActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!SpeechRecognizerActivity.this.isFinishing()) {
                        SpeechRecognizerActivity.this.mVoiceButton.setVisibility(4);
                        SpeechRecognizerActivity.this.mVoiceButton.setSelected(false);
                        SpeechRecognizerActivity.this.mRetryButton.setVisibility(4);
                        SpeechRecognizerActivity.this.mProgressBar.setVisibility(0);
                    }
                }
            });
        }

        @Override
        public void onError(final int errorCode, final String errorMessage) {
            SpeechRecognizerActivity.this.cancelRecording();
            SpeechRecognizerActivity.this.updateUIOnFail((String)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.SORRY_RECOGNITION_FAILED), (String)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.RETRY_SPEAKING_WITH_TOUCH_BUTTON));
            if (SpeechRecognizerActivity.this.isFinishing()) {
                return;
            }
            SpeechRecognizerActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!SpeechRecognizerActivity.this.isFinishing()) {
                        SpeechRecognizerActivity.this.onRecognitionFailed(errorCode, errorMessage);
                        switch (errorCode) {
                            case 2: {
                                SpeechRecognizerActivity.this.mMessageView.setText((CharSequence)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.NETWORK_IS_UNSTABLE));
                                SpeechRecognizerActivity.this.mTipView.setText((CharSequence)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.RETRY_AFTER_A_WHILE));
                                break;
                            }
                            default: {
                                SpeechRecognizerActivity.this.mMessageView.setText((CharSequence)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.SORRY_RECOGNITION_FAILED));
                            }
                        }
                    }
                }
            });
        }

        @Override
        public void onPartialResult(final String intermediateResultText) {
            SpeechRecognizerActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!SpeechRecognizerActivity.this.isFinishing()) {
                        String ellipsizedString = ((Object)TextUtils.ellipsize((CharSequence)intermediateResultText, (TextPaint)SpeechRecognizerActivity.this.mMessageView.getPaint(), (float)(SpeechRecognizerActivity.this.mMessageView.getWidth() * 2), (TextUtils.TruncateAt)TextUtils.TruncateAt.START)).toString();
                        SpeechRecognizerActivity.this.mMessageView.setVisibility(8);
                        SpeechRecognizerActivity.this.mIntermediateMessageView.setVisibility(0);
                        SpeechRecognizerActivity.this.mIntermediateMessageView.setText((CharSequence)ellipsizedString);
                    }
                }
            });
        }

        @Override
        public void onResults(Bundle result) {
            SpeechRecognizerActivity.this.cancelRecording();
            ArrayList data = result.getStringArrayList("recognition_results");
            if (data == null || data.isEmpty()) {
                SpeechRecognizerActivity.this.processRecognitionFailure();
                return;
            }
            if (result.getBoolean("is_marked_result", false) || !SpeechRecognizerActivity.this.showSuggestResultsListView) {
                SpeechRecognizerActivity.this.processRecognitionSuccess(data);
            } else {
                SpeechRecognizerActivity.this.processRecognitionSuggest(data);
            }
        }

        @Override
        public void onAudioLevel(float level) {
            if ((double)level < 0.2) {
                return;
            }
            if (SpeechRecognizerActivity.this.mVolumes.size() < 3) {
                SpeechRecognizerActivity.this.mVolumes.add(Float.valueOf(level));
                return;
            }
            float size = 0.0f;
            for (Float volume : SpeechRecognizerActivity.this.mVolumes) {
                size += volume.floatValue();
            }
            size /= (float)SpeechRecognizerActivity.this.mVolumes.size();
            SpeechRecognizerActivity.this.mVolumes.clear();
            if (size > 0.8f) {
                size = 0.8f;
            }
            SpeechRecognizerActivity.this.mSpecialSearchRenderer.addIncrementalRandomFlyingImage(false);
            SpeechRecognizerActivity.this.mSpecialSearchRenderer.setBounce(size / 0.8f);
        }

        @Override
        public void onFinished() {
        }
    };

    private static boolean isCanvasSurfaceViewExceptionVersionList() {
        boolean result = false;
        for (String version : canvasSurfaceViewExceptionVersionList) {
            if (!Build.VERSION.RELEASE.contains(version)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected final Map<RES_STRINGS, String> getStringsMap() {
        return this.stringsMap;
    }

    protected final Map<RES_VIEWID, Integer> getIdsMap() {
        return this.idsMap;
    }

    protected final void putString(RES_STRINGS key, String value) {
        this.stringsMap.put(key, value);
    }

    protected final void putViewId(RES_VIEWID key, int viewId) {
        this.idsMap.put(key, viewId);
    }

    private int getViewId(RES_VIEWID key) {
        Integer i = this.idsMap.get((Object)key);
        if (i == null) {
            return 0;
        }
        return i;
    }

    protected final boolean isValidResourceMappings() {
        boolean valid = true;
        for (RES_STRINGS rES_STRINGS : RES_STRINGS.values()) {
            String v = this.stringsMap.get((Object)rES_STRINGS);
            if (!TextUtils.isEmpty((CharSequence)v)) continue;
            Log.w((String)TAG, (String)(rES_STRINGS.name() + " string resource is empty."));
            valid = false;
        }
        for (Enum enum_ : RES_VIEWID.values()) {
            int v = this.getViewId((RES_VIEWID)enum_);
            if (v != 0) continue;
            Log.w((String)TAG, (String)(enum_.name() + " view id doesn't exist."));
            valid = false;
        }
        return valid;
    }

    private void initialize(Intent intent) {
        if (!SpeechRecognizerManager.getInstance().isInitialized()) {
            SpeechRecognizerManager.getInstance().initializeLibrary((Context)this);
        }
        SpeechRecognizerClient.Builder builder = new SpeechRecognizerClient.Builder();
        builder.setApiKey(intent.getStringExtra(EXTRA_KEY_API_KEY)).setUserDictionary(intent.getStringExtra(EXTRA_KEY_USER_DICTIONARY)).setServiceType(intent.getStringExtra(EXTRA_KEY_SERVICE_TYPE));
        this.recognizer = builder.build();
        this.recognizer.setSpeechRecognizeListener(this.callback);
        this.showSuggestResultsListView = intent.getBooleanExtra(EXTRA_KEY_SHOW_SUGGEST_LIST, true);
        Log.d((String)TAG, (String)"initialized.");
    }

    private void processRecognitionFailure() {
        this.updateUIOnFail(this.stringsMap.get((Object)RES_STRINGS.SORRY_RECOGNITION_FAILED), this.stringsMap.get((Object)RES_STRINGS.RETRY_SPEAKING_WITH_TOUCH_BUTTON));
    }

    private void processRecognitionSuccess(final List<String> data) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!SpeechRecognizerActivity.this.isFinishing()) {
                    SpannableString spannableString = new SpannableString((CharSequence)data.get(0));
                    spannableString.setSpan((Object)new ForegroundColorSpan(-16777216), 0, spannableString.length(), 0);
                    SpeechRecognizerActivity.this.mIntermediateMessageView.setText((CharSequence)spannableString);
                    SpeechRecognizerActivity.this.mMessageView.setVisibility(8);
                    SpeechRecognizerActivity.this.mIntermediateMessageView.setVisibility(0);
                    SpeechRecognizerActivity.this.mRetryButton.setVisibility(8);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (!SpeechRecognizerActivity.this.isFinishing()) {
                                SpeechRecognizerActivity.this.onRecognitionSuccess(data, true);
                            }
                        }
                    }, 1000L);
                }
            }
        });
    }

    private void processRecognitionSuggest(final List<String> data) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!SpeechRecognizerActivity.this.isFinishing()) {
                    SpeechRecognizerActivity.this.mProgressBar.setVisibility(8);
                    SpeechRecognizerActivity.this.mRetryButton.setVisibility(0);
                    SpeechRecognizerActivity.this.mIntermediateMessageView.setVisibility(8);
                    SpeechRecognizerActivity.this.mTipView.setText((CharSequence)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.RETRY_SPEAKING_WITH_TOUCH_BUTTON));
                    SpeechRecognizerActivity.this.mMessageView.setVisibility(0);
                    SpeechRecognizerActivity.this.mMessageView.setText((CharSequence)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.SELECT_THAT_YOU_SPEAK_FROM_SUGGEST));
                    if (DeviceUtils.isTablet(SpeechRecognizerActivity.this.getApplicationContext())) {
                        SpeechRecognizerActivity.this.mSuggestListAdapter.setTextGravity(17);
                        SpeechRecognizerActivity.this.mSuggestLandScapeLayout.setVisibility(0);
                    } else {
                        int orientation = SpeechRecognizerActivity.this.getResources().getConfiguration().orientation;
                        switch (orientation) {
                            case 1: {
                                SpeechRecognizerActivity.this.mSuggestListAdapter.setTextGravity(19);
                                SpeechRecognizerActivity.this.mSuggestListViewPortrait.setVisibility(0);
                                SpeechRecognizerActivity.this.mTopRetryButton.setVisibility(8);
                                break;
                            }
                            case 2: {
                                SpeechRecognizerActivity.this.mSuggestListAdapter.setTextGravity(17);
                                SpeechRecognizerActivity.this.mSuggestLandScapeLayout.setVisibility(0);
                            }
                        }
                    }
                    for (String item : data.subList(0, data.size() < 5 ? data.size() : 5)) {
                        SpeechRecognizerActivity.this.mSuggestListAdapter.add(item);
                    }
                }
            }
        });
    }

    protected void onResourcesWillInitialize() {
    }

    private String getSpeechGuideString() {
        String speechGuide = this.stringsMap.get((Object)RES_STRINGS.PLEASE_SPEAK);
        String bundleGuide = this.getIntent().getStringExtra(EXTRA_KEY_SPEECH_GUIDE);
        return TextUtils.isEmpty((CharSequence)bundleGuide) ? speechGuide : bundleGuide;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.onResourcesWillInitialize();
        Window window = this.getWindow();
        window.addFlags(128);
        this.setContentView(this.getViewId(RES_VIEWID.VIEW_VOICE_RECO_ACTIVITY));
        if (!this.setupView()) {
            Log.e((String)TAG, (String)"CANVAS_SURFACE_VIEW is not SpeechRecognizerSurfaceView");
            this.finish();
            return;
        }
        if (!DeviceUtils.isSupportedDevice()) {
            String msg = this.stringsMap.get((Object)RES_STRINGS.THIS_DEVICE_MAY_BE_NOT_SUPPORTED);
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                Toast.makeText((Context)this, (CharSequence)msg, (int)1).show();
            }
            this.finish();
            return;
        }
        this.mMessageView.setText((CharSequence)this.getSpeechGuideString());
        this.initialize(this.getIntent());
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.resizeLayout(newConfig.orientation);
        super.onConfigurationChanged(newConfig);
    }

    private void resizeLayout(int orientation) {
        FrameLayout mainLayout = (FrameLayout)this.findViewById(this.getViewId(RES_VIEWID.LAYOUT_MAIN));
        FrameLayout.LayoutParams mainLayoutParams = (FrameLayout.LayoutParams)mainLayout.getLayoutParams();
        FrameLayout topLayout = (FrameLayout)this.findViewById(this.getViewId(RES_VIEWID.LAYOUT_TOP));
        LinearLayout.LayoutParams topLayoutParams = (LinearLayout.LayoutParams)topLayout.getLayoutParams();
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        if (DeviceUtils.isTablet((Context)this)) {
            FrameLayout.LayoutParams suggestLayoutParams = (FrameLayout.LayoutParams)this.mSuggestLandScapeLayout.getLayoutParams();
            mainLayoutParams.gravity = 80;
            topLayoutParams.height = (int)TypedValue.applyDimension((int)1, (float)275.0f, (DisplayMetrics)displayMetrics);
            suggestLayoutParams.height = (int)TypedValue.applyDimension((int)1, (float)312.5f, (DisplayMetrics)displayMetrics);
            this.mSuggestListAdapter.setTextGravity(17);
            return;
        }
        switch (orientation) {
            case 1: {
                topLayoutParams.height = displayMetrics.widthPixels * 550 / 720;
                mainLayoutParams.height = -2;
                int suggestVisibility = this.mSuggestLandScapeLayout.getVisibility();
                if (suggestVisibility == 0) {
                    this.mSuggestListAdapter.setTextGravity(19);
                    this.mSuggestListViewPortrait.setVisibility(0);
                    this.mSuggestListViewPortrait.invalidate();
                    this.mMessageView.setText((CharSequence)this.stringsMap.get((Object)RES_STRINGS.SELECT_THAT_YOU_SPEAK_FROM_SUGGEST));
                    this.mSuggestLandScapeLayout.setVisibility(8);
                    this.mTopRetryButton.setVisibility(8);
                }
                if (displayMetrics.densityDpi < 320) {
                    this.mMessageView.setTextSize(1, 10.5f);
                    this.mTipView.setTextSize(1, 10.5f);
                    break;
                }
                this.mTipView.setTextSize(1, 12.0f);
                break;
            }
            case 2: {
                topLayoutParams.height = 0;
                topLayoutParams.weight = 1.0f;
                mainLayoutParams.height = -1;
                this.mSuggestListAdapter.setTextGravity(17);
                this.mSuggestLandScapeLayout.setVisibility(this.mSuggestListViewPortrait.getVisibility());
                this.mTopRetryButton.setVisibility(this.mSuggestLandScapeLayout.getVisibility());
                this.mSuggestLandScapeLayout.invalidate();
                this.mSuggestListViewPortrait.setVisibility(8);
                this.mTipView.setTextSize(1, 12.0f);
                break;
            }
        }
    }

    private void clearBitmapList() {
        this.mSpecialSearchRenderer.clearRandomBitmaps();
    }

    protected final void setRendererRandomBitmapIds(int[] bitmapIds) {
        ArrayList<Bitmap> bitmapList = new ArrayList<Bitmap>();
        Resources resource = this.getResources();
        for (int i : bitmapIds) {
            BitmapDrawable drawable = (BitmapDrawable)resource.getDrawable(i);
            if (drawable == null) continue;
            bitmapList.add(drawable.getBitmap());
        }
        this.setRendererRandomBitmaps(bitmapList);
    }

    protected final void setRendererRandomBitmaps(List<Bitmap> bitmaps) {
        this.mSpecialSearchRenderer.setRandomBitmaps(bitmaps);
    }

    private boolean setupView() {
        View closeButton;
        View canvasView = this.findViewById(this.getViewId(RES_VIEWID.CANVAS_SURFACE_VIEW));
        if (!(canvasView instanceof SpeechRecognizerSurfaceView)) {
            return false;
        }
        this.mCanvasSurfaceView = (SpeechRecognizerSurfaceView)canvasView;
        this.mCanvasSurfaceView.setFormat(1);
        this.mSpecialSearchRenderer = new SpecialSearchRenderer((Context)this);
        this.mCanvasSurfaceView.setRenderer(this.mSpecialSearchRenderer);
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View v) {
                if (!v.isEnabled() || v.getVisibility() != 0) {
                    return;
                }
                int viewId = v.getId();
                if (viewId == SpeechRecognizerActivity.this.getViewId(RES_VIEWID.BUTTON_TOP_DAUM)) {
                    SpeechRecognizerActivity.this.onClickDaumButton(v);
                } else if (viewId == SpeechRecognizerActivity.this.getViewId(RES_VIEWID.BUTTON_RETRY)) {
                    SpeechRecognizerActivity.this.cancelRecording();
                    SpeechRecognizerActivity.this.startRecording();
                    SpeechRecognizerActivity.this.onClickRetryButton(v);
                } else if (viewId == SpeechRecognizerActivity.this.getViewId(RES_VIEWID.BUTTON_TOP_RETRY)) {
                    SpeechRecognizerActivity.this.cancelRecording();
                    SpeechRecognizerActivity.this.startRecording();
                    SpeechRecognizerActivity.this.onClickTopRetryButton(v);
                } else if (viewId == SpeechRecognizerActivity.this.getViewId(RES_VIEWID.BUTTON_TOP_CLOSE)) {
                    SpeechRecognizerActivity.this.onClickCloseButton(v);
                    SpeechRecognizerActivity.this.finish();
                } else if (viewId == SpeechRecognizerActivity.this.getViewId(RES_VIEWID.BUTTON_VOICE_START)) {
                    SpeechRecognizerActivity.this.stopRecordingForResult();
                    SpeechRecognizerActivity.this.onClickStartButton(v);
                }
            }
        };
        View homeButton = this.findViewById(this.getViewId(RES_VIEWID.BUTTON_TOP_DAUM));
        if (homeButton != null) {
            if (this.getIntent().getBooleanExtra(EXTRA_KEY_HOME_BUTTON, true)) {
                homeButton.setOnClickListener(listener);
            } else {
                homeButton.setVisibility(8);
            }
        }
        this.mTopRetryButton = this.findViewById(this.getViewId(RES_VIEWID.BUTTON_TOP_RETRY));
        if (this.mTopRetryButton != null) {
            this.mTopRetryButton.setOnClickListener(listener);
        }
        this.mRetryButton = this.findViewById(this.getViewId(RES_VIEWID.BUTTON_RETRY));
        if (this.mRetryButton != null) {
            this.mRetryButton.setOnClickListener(listener);
        }
        this.mVoiceButton = this.findViewById(this.getViewId(RES_VIEWID.BUTTON_VOICE_START));
        if (this.mVoiceButton != null) {
            this.mVoiceButton.setOnClickListener(listener);
        }
        if ((closeButton = this.findViewById(this.getViewId(RES_VIEWID.BUTTON_TOP_CLOSE))) != null) {
            closeButton.setOnClickListener(listener);
        }
        this.mProgressBar = (ProgressBar)this.findViewById(this.getViewId(RES_VIEWID.PROGRESSBAR_ANALYSIS));
        this.mMessageView = (TextView)this.findViewById(this.getViewId(RES_VIEWID.TEXTVIEW_MESSAGE));
        this.mIntermediateMessageView = (TextView)this.findViewById(this.getViewId(RES_VIEWID.TEXTVIEW_INTERMEDIATE_MESSAGE));
        this.mTipView = (TextView)this.findViewById(this.getViewId(RES_VIEWID.TEXTVIEW_TIP));
        this.mSuggestLandScapeLayout = (LinearLayout)this.findViewById(this.getViewId(RES_VIEWID.LAYOUT_SUGGEST_LANDSCAPE));
        this.mSuggestListViewPortrait = (ListView)this.findViewById(this.getViewId(RES_VIEWID.LISTVIEW_SUGGEST_PORTRAIT));
        ListView suggestListViewLandScape = (ListView)this.findViewById(this.getViewId(RES_VIEWID.LISTVIEW_SUGGEST_LANDSCAPE));
        this.mSuggestListAdapter = new SuggestListAdapter((Context)this);
        if (this.mSuggestListViewPortrait != null) {
            this.mSuggestListViewPortrait.setAdapter((ListAdapter)this.mSuggestListAdapter);
        }
        if (suggestListViewLandScape != null) {
            suggestListViewLandScape.setAdapter((ListAdapter)this.mSuggestListAdapter);
        }
        this.checkAnimationStartPosition();
        int orientation = this.getResources().getConfiguration().orientation;
        this.resizeLayout(orientation);
        if (SpeechRecognizerActivity.isCanvasSurfaceViewExceptionVersionList()) {
            switch (orientation) {
                case 1: {
                    this.setRequestedOrientation(1);
                    break;
                }
                case 2: {
                    this.setRequestedOrientation(0);
                }
            }
        }
        return true;
    }

    protected void onClickDaumButton(View v) {
    }

    protected void onClickTopRetryButton(View v) {
    }

    protected void onClickRetryButton(View v) {
    }

    protected void onClickCloseButton(View v) {
    }

    protected void onClickStartButton(View v) {
    }

    private void checkAnimationStartPosition() {
        if (this.mVoiceButton == null || this.mRetryButton == null) {
            return;
        }
        ViewParent voiceParent = this.mVoiceButton.getParent();
        ViewParent retryParent = this.mRetryButton.getParent();
        if (voiceParent == null || !voiceParent.equals(retryParent)) {
            return;
        }
        final ViewGroup frameButton = (ViewGroup)voiceParent;
        if (frameButton.getViewTreeObserver() == null) {
            return;
        }
        frameButton.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (frameButton.getWidth() == 0 || frameButton.getHeight() == 0) {
                    return;
                }
                Rect rootRect = new Rect();
                Rect rect = new Rect();
                SpeechRecognizerActivity.this.mCanvasSurfaceView.getGlobalVisibleRect(rootRect);
                frameButton.getGlobalVisibleRect(rect);
                float xRatio = 0.5f;
                float yRatio = (float)(rect.top - rootRect.top + frameButton.getHeight() / 2) / (float)SpeechRecognizerActivity.this.mCanvasSurfaceView.getHeight();
                SpeechRecognizerActivity.this.mSpecialSearchRenderer.setStartPositionRatio(0.5f, yRatio);
                SpeechRecognizerActivity.this.mCanvasSurfaceView.invalidate();
            }
        });
    }

    private void updateUIOnStart() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!SpeechRecognizerActivity.this.isFinishing()) {
                    SpeechRecognizerActivity.this.mVoiceButton.setEnabled(false);
                    SpeechRecognizerActivity.this.mVoiceButton.setSelected(false);
                    SpeechRecognizerActivity.this.mVoiceButton.setVisibility(0);
                    SpeechRecognizerActivity.this.mTopRetryButton.setVisibility(0);
                    SpeechRecognizerActivity.this.mRetryButton.setVisibility(8);
                    SpeechRecognizerActivity.this.mProgressBar.setVisibility(8);
                    SpeechRecognizerActivity.this.mMessageView.setVisibility(0);
                    SpeechRecognizerActivity.this.mMessageView.setText((CharSequence)SpeechRecognizerActivity.this.getSpeechGuideString());
                    SpeechRecognizerActivity.this.mIntermediateMessageView.setVisibility(8);
                    SpeechRecognizerActivity.this.mTipView.setText((CharSequence)SpeechRecognizerActivity.this.stringsMap.get((Object)RES_STRINGS.PLEASE_SPEAK_NATURAL));
                    SpeechRecognizerActivity.this.mSuggestListAdapter.clear();
                    SpeechRecognizerActivity.this.mSuggestListViewPortrait.setVisibility(8);
                    SpeechRecognizerActivity.this.mSuggestLandScapeLayout.setVisibility(8);
                }
            }
        });
    }

    private void updateUIOnFail(final String message, final String tip) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!SpeechRecognizerActivity.this.isFinishing()) {
                    SpeechRecognizerActivity.this.mVoiceButton.setVisibility(8);
                    SpeechRecognizerActivity.this.mTopRetryButton.setVisibility(8);
                    SpeechRecognizerActivity.this.mRetryButton.setVisibility(0);
                    SpeechRecognizerActivity.this.mProgressBar.setVisibility(8);
                    SpeechRecognizerActivity.this.mMessageView.setVisibility(0);
                    SpeechRecognizerActivity.this.mMessageView.setText((CharSequence)message);
                    SpeechRecognizerActivity.this.mIntermediateMessageView.setVisibility(8);
                    SpeechRecognizerActivity.this.mTipView.setText((CharSequence)tip);
                    SpeechRecognizerActivity.this.mSuggestListAdapter.clear();
                    SpeechRecognizerActivity.this.mSuggestListViewPortrait.setVisibility(8);
                    SpeechRecognizerActivity.this.mSuggestLandScapeLayout.setVisibility(8);
                }
            }
        });
    }

    protected final void stopRecordingForResult() {
        this.recognizer.stopRecording();
    }

    protected void onPause() {
        super.onPause();
        this.mCanvasSurfaceView.onPause();
        this.cancelRecording();
    }

    public void onResume() {
        super.onResume();
        this.mCanvasSurfaceView.onResume();
        this.startRecording();
    }

    public boolean onSearchRequested() {
        return false;
    }

    public void onDestroy() {
        if (SpeechRecognizerManager.getInstance().isInitialized()) {
            SpeechRecognizerManager.getInstance().finalizeLibrary();
        }
        if (this.recognizer != null) {
            this.recognizer.setSpeechRecognizeListener(null);
        }
        this.clearBitmapList();
        super.onDestroy();
    }

    protected void onStartRecording() {
        AudioManager audioManager = (AudioManager)this.getApplication().getSystemService("audio");
        audioManager.setStreamMute(3, true);
    }

    protected final int startRecording() {
        if (PermissionUtils.checkMandatoryPermission((Context)this, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo.DetailedState detailState;
            NetworkInfo networkInfo;
            boolean connected = false;
            ConnectivityManager connManager = (ConnectivityManager)this.getApplication().getSystemService("connectivity");
            if (connManager != null && (networkInfo = connManager.getActiveNetworkInfo()) != null && networkInfo.isConnected() && (detailState = networkInfo.getDetailedState()) == NetworkInfo.DetailedState.CONNECTED) {
                connected = true;
            }
            if (!connected) {
                this.updateUIOnFail(this.stringsMap.get((Object)RES_STRINGS.NETWORK_IS_UNSTABLE), this.stringsMap.get((Object)RES_STRINGS.RETRY_AFTER_A_WHILE));
                return 1;
            }
        }
        if (this.recognizer == null) {
            return 3;
        }
        boolean started = this.recognizer.startRecording(true);
        if (!started) {
            return 2;
        }
        this.updateUIOnStart();
        this.onStartRecording();
        return 0;
    }

    protected void onFinishRecording() {
        AudioManager audioManager = (AudioManager)this.getApplication().getSystemService("audio");
        audioManager.setStreamMute(3, false);
    }

    protected final void cancelRecording() {
        this.mVolumes.clear();
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SpeechRecognizerActivity.this.mSpecialSearchRenderer.setBounce(0.0f);
                if (SpeechRecognizerActivity.this.recognizer != null) {
                    SpeechRecognizerActivity.this.recognizer.cancelRecording();
                }
                SpeechRecognizerActivity.this.onFinishRecording();
            }
        });
    }

    public void onBackPressed() {
        this.cancelRecording();
        if (this.mSuggestListViewPortrait.getVisibility() == 0 || this.mSuggestLandScapeLayout.getVisibility() == 0) {
            this.mSuggestListViewPortrait.setVisibility(8);
            this.mSuggestLandScapeLayout.setVisibility(8);
            this.mMessageView.setText((CharSequence)this.getSpeechGuideString());
            return;
        }
        super.onBackPressed();
    }

    protected void onRecognitionSuccess(List<String> result, boolean marked) {
    }

    protected void onRecognitionFailed(int errorCode, String errorMsg) {
    }

    private class SuggestListAdapter
    extends ArrayAdapter<String>
    implements View.OnClickListener {
        private final LayoutInflater mLayoutInflater;
        private int mTextGravity;

        public SuggestListAdapter(Context context) {
            super(context, 0);
            this.mLayoutInflater = LayoutInflater.from((Context)context);
        }

        public void setTextGravity(int gravity) {
            this.mTextGravity = gravity;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(SpeechRecognizerActivity.this.getViewId(RES_VIEWID.VIEW_SUGGEST_LIST_ITEM), parent, false);
            }
            TextView textView = (TextView)convertView.findViewById(SpeechRecognizerActivity.this.getViewId(RES_VIEWID.TEXTVIEW_SUGGEST));
            textView.setGravity(this.mTextGravity);
            textView.setText((CharSequence)this.getItem(position));
            textView.setOnClickListener((View.OnClickListener)this);
            return convertView;
        }

        public void onClick(View v) {
            if (v.getId() == SpeechRecognizerActivity.this.getViewId(RES_VIEWID.TEXTVIEW_SUGGEST)) {
                TextView view = (TextView)v;
                int size = this.getCount();
                ArrayList<String> data = new ArrayList<String>(size);
                for (int i = 0; i < size; ++i) {
                    String item = (String)this.getItem(i);
                    if (item.equals(view.getText())) {
                        data.add(0, item);
                        continue;
                    }
                    data.add(item);
                }
                SpeechRecognizerActivity.this.onRecognitionSuccess(data, false);
            }
        }
    }

    protected static enum RES_VIEWID {
        VIEW_VOICE_RECO_ACTIVITY,
        VIEW_SUGGEST_LIST_ITEM,
        BUTTON_TOP_DAUM,
        BUTTON_TOP_RETRY,
        BUTTON_TOP_CLOSE,
        BUTTON_RETRY,
        BUTTON_VOICE_START,
        LAYOUT_MAIN,
        LAYOUT_SUGGEST_LANDSCAPE,
        LAYOUT_TOP,
        LISTVIEW_SUGGEST_PORTRAIT,
        LISTVIEW_SUGGEST_LANDSCAPE,
        PROGRESSBAR_ANALYSIS,
        TEXTVIEW_MESSAGE,
        TEXTVIEW_SUGGEST,
        TEXTVIEW_TIP,
        TEXTVIEW_INTERMEDIATE_MESSAGE,
        CANVAS_SURFACE_VIEW;

    }

    protected static enum RES_STRINGS {
        PLEASE_SPEAK,
        THIS_DEVICE_MAY_BE_NOT_SUPPORTED,
        SELECT_THAT_YOU_SPEAK_FROM_SUGGEST,
        RETRY_SPEAKING_WITH_TOUCH_BUTTON,
        PLEASE_SPEAK_NATURAL,
        TOUCH_BUTTON_TO_USE_RESULT_INSTANTLY,
        SORRY_RECOGNITION_FAILED,
        RETRY_AFTER_A_WHILE,
        NETWORK_IS_UNSTABLE;

    }
}

