/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadSmartLightSystem;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.artncore.WallPadDataMgr.WallpadDeviceSet;
import com.artncore.WallPadDataMgr.WallpadStatusData;

public class WallPadSmartLight {
    private static final String TAG = "WallPadSmartLight";
    public static final int ALARM_GENERATED = 0;
    public static final int ALARM_RETURNED = 1;
    public static final int DEVICE_LED_CONVERTER = 0;
    public static final int DEVICE_EM = 1;
    public static final int DEVICE_LED_LIGHT = 2;
    public static final int DEVICE_POWER_CONTROLLER = 3;
    public static final int DEVICE_CONCENT = 4;
    public static final int DEVICE_NULL = 5;
    public static final int CAUSE_VOLT = 0;
    public static final int CAUSE_CURRENT = 1;
    public static final int CAUSE_TEMPERATURE = 2;
    public static final int CAUSE_POWER = 3;
    public static final int CAUSE_ETC = 4;
    public static final String BR_TYPE = "TYPE";
    public static final String BR_DEVICE = "DEVICE";
    public static final String BR_DEVICE_INDEX = "DEVICE_INDEX";
    public static final String BR_CAUSE_TYPE = "CAUSE_TYPE";
    public static final String BR_CAUSE_DETAIL = "CAUSE_DETAIL";
    public static final String NAME_LED_CONVERTER = "led_converter";
    public static final String NAME_EM = "em";
    public static final String NAME_LED_LIGHT = "led_light";
    public static final String NAME_POWER_CONTROLLER = "power_controller";
    public static final String NAME_CONCENT = "concent";
    Context ctx;

    public WallPadSmartLight(Context context) {
        this.ctx = context;
    }

    public AlarmClass GetHeartBeatAlarmStatus() {
        try {
            WallpadStatusData DBMGR = new WallpadStatusData(this.ctx);
            String tempAlarm = DBMGR.GetSmartLightAlarm();
            String tempAlarmDevice = DBMGR.GetSmartLightAlarmDevice();
            DBMGR.closeDB();
            if (tempAlarm == null) {
                tempAlarm = "normal";
            }
            if (tempAlarmDevice == null) {
                tempAlarmDevice = "null";
            }
            AlarmClass alarmClass = new AlarmClass(tempAlarm, tempAlarmDevice);
            return alarmClass;
        }
        catch (Exception e) {
            e.printStackTrace();
            AlarmClass alarmClass = new AlarmClass("normal", "null");
            return alarmClass;
        }
    }

    public boolean SetHeartBeatAlarmStatus(boolean Normal, int Device2) {
        try {
            String TempDevice;
            if (Device2 < 0 || Device2 > 5) {
                Log.e((String)TAG, (String)("HeartBeatAlarmStatusSet - Device is error : " + Device2));
                return false;
            }
            WallpadStatusData DBMGR = new WallpadStatusData(this.ctx);
            boolean bRet1 = DBMGR.SetSmartLightAlarm(Normal);
            switch (Device2) {
                case 0: {
                    TempDevice = NAME_LED_CONVERTER;
                    break;
                }
                case 1: {
                    TempDevice = NAME_EM;
                    break;
                }
                case 2: {
                    TempDevice = NAME_LED_LIGHT;
                    break;
                }
                case 3: {
                    TempDevice = NAME_POWER_CONTROLLER;
                    break;
                }
                case 4: {
                    TempDevice = NAME_CONCENT;
                    break;
                }
                default: {
                    TempDevice = "null";
                }
            }
            if (Normal) {
                TempDevice = "null";
            }
            boolean bRet2 = DBMGR.SetSmartLightAlarmDevice(TempDevice);
            DBMGR.closeDB();
            return bRet1 && bRet2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean BR_SendSmartLightEvent(int AlarmType, int Device2, String DeviceIndex, int CauseType, String CauseDetail) {
        try {
            String TempAlarmCause;
            String TempDevice;
            String TempAlarmType;
            if (AlarmType < 0 || AlarmType > 1) {
                Log.e((String)TAG, (String)("BR_SendSmartLightEvent - AlarmType is error : " + AlarmType));
                return false;
            }
            if (Device2 < 0 || Device2 > 4) {
                Log.e((String)TAG, (String)("BR_SendSmartLightEvent - Device is error : " + Device2));
                return false;
            }
            if (CauseType < 0 || CauseType > 4) {
                Log.e((String)TAG, (String)("BR_SendSmartLightEvent - CauseType is error : " + CauseType));
                return false;
            }
            switch (AlarmType) {
                case 0: {
                    TempAlarmType = "alarm";
                    break;
                }
                case 1: {
                    TempAlarmType = "return";
                    break;
                }
                default: {
                    TempAlarmType = "error";
                }
            }
            switch (Device2) {
                case 0: {
                    TempDevice = NAME_LED_CONVERTER;
                    break;
                }
                case 1: {
                    TempDevice = NAME_EM;
                    break;
                }
                case 2: {
                    TempDevice = NAME_LED_LIGHT;
                    break;
                }
                case 3: {
                    TempDevice = NAME_POWER_CONTROLLER;
                    break;
                }
                case 4: {
                    TempDevice = NAME_CONCENT;
                    break;
                }
                default: {
                    TempDevice = "error";
                }
            }
            switch (CauseType) {
                case 0: {
                    TempAlarmCause = "volt";
                    break;
                }
                case 1: {
                    TempAlarmCause = "current";
                    break;
                }
                case 2: {
                    TempAlarmCause = "temperature";
                    break;
                }
                case 3: {
                    TempAlarmCause = "power";
                    break;
                }
                case 4: {
                    TempAlarmCause = "etc";
                    break;
                }
                default: {
                    TempAlarmCause = "error";
                }
            }
            Intent intent = new Intent();
            intent.setAction("WALLPAD_NOTIFY");
            intent.putExtra("KIND", 1074);
            intent.putExtra(BR_TYPE, TempAlarmType);
            intent.putExtra(BR_DEVICE, TempDevice);
            intent.putExtra(BR_DEVICE_INDEX, DeviceIndex);
            intent.putExtra(BR_CAUSE_TYPE, TempAlarmCause);
            intent.putExtra(BR_CAUSE_DETAIL, CauseDetail);
            this.ctx.sendBroadcast(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public AlarmSettingValue GetAlarmSettingValue() {
        try {
            double tempEmMaxVolt = 3.0;
            double tempEmMinVolt = 5.0;
            int tempEmTemperature = 60;
            double tempLedMaxVolt = 2.0;
            double tempLedMinVolt = 7.0;
            int tempLedTemperature = 80;
            double tempDcApuTotal = 425.0;
            double tempDcApuEach1 = 0.0;
            double tempDcApuEach2 = 0.0;
            WallpadDeviceSet wallpadDeviceSet = new WallpadDeviceSet(this.ctx);
            String[] GetData = wallpadDeviceSet.GetSettingData("\ubd84\uc804\ubc18\uc54c\ub78c\uc124\uc815");
            wallpadDeviceSet.closeDB();
            if (GetData != null && GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                String TempData = GetData[1];
                TempData = TempData.replace('(', '_');
                TempData = TempData.replace(')', '_');
                String[] SettingInfo = TempData.split("_");
                tempEmMaxVolt = Double.parseDouble(SettingInfo[4]);
                tempEmMinVolt = Double.parseDouble(SettingInfo[6]);
                tempEmTemperature = Integer.parseInt(SettingInfo[8]);
                tempLedMaxVolt = Double.parseDouble(SettingInfo[10]);
                tempLedMinVolt = Double.parseDouble(SettingInfo[12]);
                tempLedTemperature = Integer.parseInt(SettingInfo[14]);
                tempDcApuTotal = Double.parseDouble(SettingInfo[16]);
                tempDcApuEach1 = Double.parseDouble(SettingInfo[18]);
                tempDcApuEach2 = Double.parseDouble(SettingInfo[20]);
            }
            AlarmSettingValue alarmSettingValue = new AlarmSettingValue(tempEmMaxVolt, tempEmMinVolt, tempEmTemperature, tempLedMaxVolt, tempLedMinVolt, tempLedTemperature, tempDcApuTotal, tempDcApuEach1, tempDcApuEach2);
            return alarmSettingValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            AlarmSettingValue alarmSettingValue = new AlarmSettingValue(2.0, 5.0, 60, 2.0, 7.0, 80, 425.0, 0.0, 0.0);
            return alarmSettingValue;
        }
    }

    public class AlarmSettingValue {
        public double EM_MaxVolt;
        public double EM_MinVolt;
        public int EM_Temperature;
        public double LED_MaxVolt;
        public double LED_MinVolt;
        public int LED_Temperature;
        public double DC_APU_Total;
        public double DC_APU_Each1;
        public double DC_APU_Each2;

        public AlarmSettingValue(double em_MaxVolt, double em_MinVolt, int em_Temperature, double led_MaxVolt, double led_MinVolt, int led_temperature, double dc_apu_total, double dc_apu_each1, double dc_apu_each2) {
            this.EM_MaxVolt = em_MaxVolt;
            this.EM_MinVolt = em_MinVolt;
            this.EM_Temperature = em_Temperature;
            this.LED_MaxVolt = led_MaxVolt;
            this.LED_MinVolt = led_MinVolt;
            this.LED_Temperature = led_temperature;
            this.DC_APU_Total = dc_apu_total;
            this.DC_APU_Each1 = dc_apu_each1;
            this.DC_APU_Each2 = dc_apu_each2;
        }

        public double GetEM_MaxVolt() {
            return this.EM_MaxVolt;
        }

        public double GetEM_MinVolt() {
            return this.EM_MinVolt;
        }

        public int GetEM_Temperature() {
            return this.EM_Temperature;
        }

        public int GetLED_Temperature() {
            return this.LED_Temperature;
        }

        public double GetLED_MaxVolt() {
            return this.LED_MaxVolt;
        }

        public double GetLED_MinVolt() {
            return this.LED_MinVolt;
        }

        public double GetDCAPU_Total() {
            return this.DC_APU_Total;
        }

        public double GetDCAPU_Each1() {
            return this.DC_APU_Each1;
        }

        public double GetDCAPU_Each2() {
            return this.DC_APU_Each2;
        }
    }

    public class AlarmClass {
        public String Alarm;
        public String AlarmDevice;

        public AlarmClass(String alarmType, String alarmDevice) {
            this.Alarm = alarmType;
            this.AlarmDevice = alarmDevice;
        }

        public String GetAlarm() {
            return this.Alarm;
        }

        public String GetAlarmDevice() {
            return this.AlarmDevice;
        }
    }
}

