/*
 * Copyright (C) 2015 Android WallPad Project
 *
 * FileName  : ApiKey.java
 * Project   : Android WallPad Project
 * Company   : HDC I-CONTROLS ( www.icontrols.co.kr )
 * Author    : Kang Sang Ho  , lairu@icontrols.co.kr
 */

package kr.co.icontrols.sttttsapi;

import android.content.Context;
import android.util.Log;

/**
 * Apikey  Class<br>
 */
public class ApiKey
{
    private String TAG = "ApiKey";
    
    private String mApikey = null;
    
    /**
     * APIKey 
     *  
     * @param context       - θ Context
     */
    public ApiKey(Context context)
    {
        // 1. Param Check
        if(context == null)
        {
            Log.e(TAG, "[Create] Param context is null !!!");
            return;
        }
        
        // 2. getPackageName
        int Target = Common.getTarget(context);
        String Apikey = null;
        
        // 3. get Key
        if(Target == Common.TARGET.WALLPAD)
        {
            Apikey = "be171e2dfa54616129bfd262911258b0";
        }
        else if(Target == Common.TARGET.LOBBY)
        {
            Apikey = "be171e2dfa54616129bfd262911258b0";
        }
        else
        {
            Log.e(TAG, "[Create] Not Support Package... Unable to get an API key.");
        }
        
        // 4. Apikey Copy
        mApikey = Apikey;
    }
    
    /**
     * Apikey  ´.
     * 
     * @return (String) Apikey
     */
    public String getApiKey()
    {
        return mApikey;
    }
    
    /**
     * Apikey  
     * 
     * @return (boolean) true : , false : 
     */
    public boolean Exist()
    {
        if(mApikey == null) return false;
        return true;
    }
}
