/*
 * Decompiled with CFR 0.152.
 */
package milsip.stack.sip;

import java.net.DatagramPacket;
import java.util.Date;
import milsip.stack.sip.SIPStack;

public class RTPCore {
    public int RTP_PORT = 0;
    public int mediaType = SIPStack.SIP_MEDIATYPE_NONE;
    public byte[] buffer = null;
    public byte[] pcmLinearBuffer = null;
    public boolean bRTPlooping = false;
    public boolean bRTPparsing = false;
    public boolean bActive = false;
    public int RTPversion = 0;
    public int RTPpadding = 0;
    public int RTPextension = 0;
    public int RTPcsrc = 0;
    public int RTPmark = 0;
    public int RTPpayload = 0;
    public int RTPsequence = 0;
    public int RTPtimestamp = 0;
    public int RTPssrc = 0;
    public byte[] rtpPacketBuffer = null;
    public byte[] rtpBulkBuffer = null;
    public byte[] fieldBytes = null;
    public byte[] rtpfieldBytes = null;
    public boolean running = false;
    public int remotePayloadType = SIPStack.SIP_CODEC_NONE;
    public String remoteMediaIp = null;
    public int remoteMediaPort = 0;
    public boolean bDtmfDetected = false;
    public int detectedDtmf = 0;
    public Date rtpArrivalTime = null;
    public int packetSize = 0;
    public int PARSEversion = 0;
    public int PARSEpadding = 0;
    public int PARSEextension = 0;
    public int PARSEcsrc = 0;
    public int PARSEmark = 0;
    public int PARSEpayload = 0;
    public int PARSEsequence = 0;
    public int PARSEtimestamp = 0;
    public int PARSEssrc = 0;
    public int PARSERFCdtmf = 0;
    public int PARSERFCedge = 0;
    public int PARSERFCvolume = 0;
    public int PARSERFCduration = 0;

    public RTPCore(int port, int mediaType) {
        if (!SIPStack.bStackLicensed) {
            System.out.println("\ub77c\uc774\uc2a8\uc2a4\ud0a4\ub97c \uc124\uc815\ud558\uc138\uc694.");
        }
        this.RTP_PORT = port;
        this.pcmLinearBuffer = new byte[1024];
        this.rtpPacketBuffer = new byte[512];
        this.rtpBulkBuffer = new byte[512];
        this.fieldBytes = new byte[4];
        this.rtpfieldBytes = new byte[4];
        this.RTPversion = 2;
        this.RTPpadding = 0;
        this.RTPextension = 0;
        this.RTPcsrc = 0;
        this.RTPmark = 0;
        this.RTPpayload = 0;
        this.RTPsequence = 0;
        Date date = new Date();
        this.RTPtimestamp = (int)date.getTime();
        this.RTPssrc = (int)date.getTime();
        this.mediaType = mediaType;
        this.buffer = mediaType == SIPStack.SIP_MEDIATYPE_AUDIO ? new byte[SIPStack.RTP_AUDIO_SIZE] : (mediaType == SIPStack.SIP_MEDIATYPE_VIDEO ? new byte[65507] : new byte[65507]);
        this.bActive = false;
        this.bDtmfDetected = false;
        this.detectedDtmf = 0;
        this.rtpArrivalTime = new Date();
    }

    public boolean encodeRtpHeader(byte[] header, int version, int padding, int extension, int csrc, int mark, int payload, int sequence, int timestamp, int ssrc) {
        if (header == null || header.length < 12) {
            return false;
        }
        int iField = 0;
        int iAppend = 0;
        iField = version << 6 & 0xC0;
        iAppend = padding << 5 & 0x20;
        iField |= iAppend;
        iAppend = extension << 4 & 0x10;
        iField |= iAppend;
        iAppend = csrc & 0xF;
        header[0] = (byte)(iField |= iAppend);
        iField = 0;
        iField = mark << 7 & 0x80;
        iAppend = payload & 0x7F;
        header[1] = (byte)(iField |= iAppend);
        iField = 0;
        header[2] = (byte)(sequence << 16 >> 24);
        header[3] = (byte)(sequence << 24 >> 24);
        header[4] = (byte)(timestamp >> 24);
        header[5] = (byte)(timestamp << 8 >> 24);
        header[6] = (byte)(timestamp << 16 >> 24);
        header[7] = (byte)(timestamp << 24 >> 24);
        header[8] = (byte)(ssrc >> 24);
        header[9] = (byte)(ssrc << 8 >> 24);
        header[10] = (byte)(ssrc << 16 >> 24);
        header[11] = (byte)(ssrc << 24 >> 24);
        return true;
    }

    public boolean encodeRtpHeader(int payload) {
        if (this.rtpPacketBuffer == null || this.rtpPacketBuffer.length < 12) {
            return false;
        }
        int iField = 0;
        int iAppend = 0;
        iField = this.RTPversion << 6 & 0xC0;
        iAppend = this.RTPpadding << 5 & 0x20;
        iField |= iAppend;
        iAppend = this.RTPextension << 4 & 0x10;
        iField |= iAppend;
        iAppend = this.RTPcsrc & 0xF;
        this.rtpPacketBuffer[0] = (byte)(iField |= iAppend);
        iField = 0;
        iField = this.RTPmark << 7 & 0x80;
        iAppend = payload & 0x7F;
        this.rtpPacketBuffer[1] = (byte)(iField |= iAppend);
        iField = 0;
        this.rtpPacketBuffer[2] = (byte)(this.RTPsequence << 16 >> 24);
        this.rtpPacketBuffer[3] = (byte)(this.RTPsequence << 24 >> 24);
        this.rtpPacketBuffer[4] = (byte)(this.RTPtimestamp >> 24);
        this.rtpPacketBuffer[5] = (byte)(this.RTPtimestamp << 8 >> 24);
        this.rtpPacketBuffer[6] = (byte)(this.RTPtimestamp << 16 >> 24);
        this.rtpPacketBuffer[7] = (byte)(this.RTPtimestamp << 24 >> 24);
        this.rtpPacketBuffer[8] = (byte)(this.RTPssrc >> 24);
        this.rtpPacketBuffer[9] = (byte)(this.RTPssrc << 8 >> 24);
        this.rtpPacketBuffer[10] = (byte)(this.RTPssrc << 16 >> 24);
        this.rtpPacketBuffer[11] = (byte)(this.RTPssrc << 24 >> 24);
        return true;
    }

    public int getBytesToInt(byte[] bytes) {
        int newValue = 0;
        newValue |= bytes[0] << 24 & 0xFF000000;
        newValue |= bytes[1] << 16 & 0xFF0000;
        newValue |= bytes[2] << 8 & 0xFF00;
        return newValue |= bytes[3] & 0xFF;
    }

    public byte[] getIntToBytes(int iValue) {
        byte[] newbytes = new byte[]{(byte)(iValue >> 24), (byte)(iValue << 8 >> 24), (byte)(iValue << 16 >> 24), (byte)(iValue << 24 >> 24)};
        return newbytes;
    }

    public boolean setRTPPort(int port) {
        if (port <= 0) {
            return false;
        }
        this.RTP_PORT = port;
        return true;
    }

    public void setRemoteMediaInfo(int payloadtype, String mediaIp, int mediaPort) {
        this.remotePayloadType = payloadtype;
        this.remoteMediaIp = mediaIp;
        this.remoteMediaPort = mediaPort;
    }

    public void parseRtpHeader(byte[] buffer) {
        if (buffer == null || buffer.length < 12) {
            return;
        }
        this.fieldBytes[0] = buffer[0];
        int version = this.fieldBytes[0] >> 6 & 3;
        System.out.println("VERSION:" + version);
        this.fieldBytes[0] = buffer[1];
        int payloadType = this.fieldBytes[0] & 0x7F;
        System.out.println("Payload:" + payloadType);
        this.fieldBytes[0] = 0;
        this.fieldBytes[1] = 0;
        this.fieldBytes[2] = buffer[2];
        this.fieldBytes[3] = buffer[3];
        int sequencNumber = this.getBytesToInt(this.fieldBytes);
        System.out.println("SEQUENCE NUMBER:" + sequencNumber);
        this.fieldBytes[0] = buffer[4];
        this.fieldBytes[1] = buffer[5];
        this.fieldBytes[2] = buffer[6];
        this.fieldBytes[3] = buffer[7];
        int timeStamp = this.getBytesToInt(this.fieldBytes);
        System.out.println("TIMESTAMP:" + timeStamp);
        this.fieldBytes[0] = buffer[8];
        this.fieldBytes[1] = buffer[9];
        this.fieldBytes[2] = buffer[10];
        this.fieldBytes[3] = buffer[11];
        int ssrc = this.getBytesToInt(this.fieldBytes);
        System.out.println("SSRC:" + ssrc);
    }

    public void init() {
        this.RTPversion = 2;
        this.RTPpadding = 0;
        this.RTPextension = 0;
        this.RTPcsrc = 0;
        this.RTPmark = 0;
        this.RTPpayload = 0;
        this.RTPsequence = 0;
        Date date = new Date();
        this.RTPtimestamp = (int)date.getTime();
        this.RTPssrc = (int)date.getTime();
        this.bDtmfDetected = false;
        this.detectedDtmf = 0;
        this.bActive = false;
        this.rtpArrivalTime = new Date();
    }

    public boolean parseRTPHeader() {
        try {
            this.PARSEversion = 0;
            this.PARSEpadding = 0;
            this.PARSEextension = 0;
            this.PARSEcsrc = 0;
            this.PARSEmark = 0;
            this.PARSEpayload = 0;
            this.PARSEsequence = 0;
            this.PARSEtimestamp = 0;
            this.PARSEssrc = 0;
            this.rtpfieldBytes[0] = this.buffer[1];
            this.PARSEmark = this.rtpfieldBytes[0] >> 7 & 1;
            this.PARSEpayload = this.rtpfieldBytes[0] & 0x7F;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getRemotAddress(DatagramPacket dp) {
        String strIp = "0.0.0.0:0";
        try {
            byte[] address = dp.getAddress().getAddress();
            if (address.length == 4) {
                int unsignedByte1 = address[0] < 0 ? address[0] + 256 : address[0];
                int unsignedByte2 = address[1] < 0 ? address[1] + 256 : address[1];
                int unsignedByte3 = address[2] < 0 ? address[2] + 256 : address[2];
                int unsignedByte4 = address[3] < 0 ? address[3] + 256 : address[3];
                strIp = String.valueOf(unsignedByte1) + "." + unsignedByte2 + "." + unsignedByte3 + "." + unsignedByte4 + ":" + dp.getPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strIp;
    }

    public boolean parseRFC2833() {
        this.PARSERFCdtmf = 0;
        this.PARSERFCedge = 0;
        this.PARSERFCvolume = 0;
        this.PARSERFCduration = 0;
        try {
            byte field = 0;
            this.PARSERFCdtmf = this.buffer[12];
            field = this.buffer[13];
            this.PARSERFCedge = (field & 0x80) >> 7;
            this.PARSERFCvolume = field & 0x3F;
            this.PARSERFCduration = this.buffer[14] << 24 >> 16 & 0xFF00;
            this.PARSERFCduration |= this.buffer[15] << 24 >> 24 & 0xFF;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getVideomediadescription() {
        int port = this.RTP_PORT + 2;
        String str = "m=video " + port + " RTP/AVP " + SIPStack.SIP_CODEC_H264 + SIPStack.SIP_LINE_END + "a=rtpmap:" + SIPStack.SIP_CODEC_H264 + " H264/90000" + SIPStack.SIP_LINE_END + "a=fmtp:" + SIPStack.SIP_CODEC_H264 + " packetization-mode=1;profile-level-id=2" + SIPStack.SIP_LINE_END + "a=cliprect:0,0,240,320" + SIPStack.SIP_LINE_END + "a=framesize:" + SIPStack.SIP_CODEC_H264 + " 320-240" + SIPStack.SIP_LINE_END;
        return str;
    }
}

