/*
 * Decompiled with CFR 0.152.
 */
package com.sensetime.mtc;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.sensetime.mtc.IReceiveCallback;
import com.sensetime.mtc.MtcCallback;
import com.sensetime.mtc.MtcCode;
import com.sensetime.mtc.MtcReceiver;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.nio.ByteBuffer;

public class MClient {
    private static volatile MClient mClient;
    private static final String DEFAULT_DEV = "/dev/ttyACM0";
    public static final int MTC_UPGRADE_SEGMENT_LENGTH = 16300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MClient getInstance() {
        if (mClient != null) return mClient;
        Class<MClient> clazz = MClient.class;
        synchronized (MClient.class) {
            if (mClient != null) return mClient;
            mClient = new MClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mClient;
        }
    }

    private MClient() {
    }

    protected native int mInit(String var1);

    protected native int mPing();

    protected native void mDestroy();

    protected native int mAiAddImage(byte var1, byte[] var2, String var3, ByteBuffer var4);

    protected native int mAiAddLargeImage(byte[] var1, String var2);

    protected native int mIdListGet(StringBuffer var1);

    protected native int mAiDelImage(byte var1, String var2);

    protected native int mAiDelAllImage();

    protected native int mAiQueryImage(String var1, StringBuffer var2);

    protected native int mAiStartRecognize(int var1, int var2);

    protected native int mSystemUploadUpgradePackage(int var1, byte[] var2, int var3);

    protected native int mSystemApplyUpgradePackage(String var1);

    protected native int mSystemVersionInfoGet(StringBuffer var1);

    protected native String mHandleAt(String var1);

    protected native int mAiAddFeature(byte[] var1, String var2);

    protected native int mAiRecognitionCountSet(byte var1, byte var2);

    protected native int mAiRecognitionCountGet(StringBuffer var1);

    protected native int mAiQueryFeature(String var1, StringBuffer var2);

    protected native int mAiStaticVerify(byte var1, byte[] var2, StringBuffer var3);

    protected native int mAiStartVerify(int var1, int var2, byte[] var3, String var4);

    protected native int mAiResume();

    protected native int mAiPause();

    protected native int mAiControlAutoUploadAiInfo(byte var1, byte var2, byte var3, byte var4);

    protected native int mUploadFrameAiInfo(byte var1);

    protected native int mAiStatus(StringBuffer var1);

    protected native int mAiConfigSet(String var1);

    protected native int mAiConfigGet(StringBuffer var1);

    protected native int mDeviceFpsSet(int var1);

    protected native int mDeviceFpsGet(StringBuffer var1);

    protected native int mDeviceScreenSizeSet(byte var1);

    protected native int mDeviceViewRotate(byte var1);

    protected native String mShellPicSize(int var1);

    protected native int mDeviceScreenModeGet(StringBuffer var1);

    protected native int mDeviceScreenModeSet(byte var1);

    protected native int mAiIDCountGet(StringBuffer var1);

    protected native int mDeviceIRLightnessSet(int var1, int var2);

    protected native int mDeviceIrLightnessGet(StringBuffer var1);

    protected native int mShellSetStatusBrightness(int var1);

    protected native int mSystemReboot(byte var1);

    protected native int mDeviceCameraStatusGet(byte var1, StringBuffer var2);

    protected native int mDeviceCameraStatusSet(byte var1, byte var2);

    protected native int mDeviceAntiFlickerGet(byte var1, StringBuffer var2);

    protected native int mDeviceAntiFlickerSet(byte var1, byte var2, byte var3);

    protected native int mDeviceCameraSwitch(byte var1);

    protected native void mRegisterCallback(IReceiveCallback var1);

    protected native int mFactoryReset(byte var1);

    protected native int mDeviceSnGet(byte var1, StringBuffer var2);

    protected native int mDeviceModuleGet(StringBuffer var1);

    protected native int mDeviceUvcSet(byte var1);

    protected native int mDeviceBrightnessSensorGet(StringBuffer var1);

    protected native int mDeviceAppVersion(StringBuffer var1);

    protected native int mTemplateUpdateSet(byte var1);

    protected native int mTemplateUpdateGet(StringBuffer var1);

    public void setReceiveCallback(IReceiveCallback callback) {
        this.mRegisterCallback(callback);
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcInit(String dev, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            String devPath = DEFAULT_DEV;
            if (!TextUtils.isEmpty((CharSequence)dev)) {
                devPath = dev;
            }
            Log.d((String)MClient.class.getSimpleName(), (String)("devPath:" + devPath));
            int retCode = this.mInit(devPath);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public MtcCode mtcPing() {
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int retCode = this.mPing();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(2000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            Log.w((String)MClient.class.getSimpleName(), (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode();
    }

    public void mtcDestroy() {
        this.mDestroy();
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceCameraSwitch(int cammraId, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (cammraId != 0 && cammraId != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceCameraSwitch((byte)cammraId);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceFpsSet(int fps, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (fps > 25 || fps < 10) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceFpsSet(fps);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceFpsGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceFpsGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceScreenSizeSet(int screenSize, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (screenSize != 0 && screenSize != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceScreenSizeSet((byte)screenSize);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceScreenModeSet(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceScreenModeSet((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceScreenModeGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceScreenModeGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceAntiFlickerGet(int cameraId, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            if (cameraId != 0 && cameraId != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceAntiFlickerGet((byte)cameraId, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceAntiFlickerSet(int cameraId, int frequency, int enabled, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (cameraId != 0 && cameraId != 1 || frequency != 0 && frequency != 1 || enabled != 0 && enabled != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceAntiFlickerSet((byte)cameraId, (byte)frequency, (byte)enabled);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceUvcSet(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceUvcSet((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceIRSet(int brightness, int autoCloseTime, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (brightness < 0 || brightness > 200) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceIRLightnessSet(brightness, autoCloseTime);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceIrLedGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceIrLightnessGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceCameraStatusGet(int cameraId, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            if (cameraId != 0 && cameraId != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceCameraStatusGet((byte)cameraId, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceCameraStatusSet(int mode, int cameraId, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceCameraStatusSet((byte)mode, (byte)cameraId);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceBrightnessSensorGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceBrightnessSensorGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStatusGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiStatus(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiConfigSet(String aiConfig, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (TextUtils.isEmpty((CharSequence)aiConfig)) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiConfigSet(aiConfig);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiConfigGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiConfigGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiIDCountGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiIDCountGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStartRecognize(int reco_mode, int face_mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (reco_mode != 0 && reco_mode != 1 || face_mode != 0 && face_mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiStartRecognize(reco_mode, face_mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStartVerify(int reco_mode, int face_mode, byte[] imageBytes, String Id, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (reco_mode != 0 && reco_mode != 1 || face_mode != 0 && face_mode != 1 || TextUtils.isEmpty((CharSequence)Id) || Id.getBytes().length > 32 || imageBytes == null || imageBytes.length <= 0 || imageBytes.length > 0x400000 || Id.contains("\"") || Id.contains("\\")) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiStartVerify(reco_mode, face_mode, imageBytes, Id);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiResume(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode = this.mAiResume();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiPause(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode = this.mAiPause();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiControlAutoUploadAiInfo(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 1 && mode != 2 && mode != 4) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiControlAutoUploadAiInfo((byte)mode, (byte)0, (byte)0, (byte)0);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiControlAutoUploadAiInfo(int mode, boolean rgbFaceImg, boolean rgbBgImg, boolean irImg, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 1 && mode != 2 && mode != 4) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiControlAutoUploadAiInfo((byte)mode, (byte)(rgbFaceImg ? 1 : 0), (byte)(rgbBgImg ? 1 : 0), (byte)(irImg ? 1 : 0));
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcUploadFrameAiInfo(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mUploadFrameAiInfo((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiAddImageByCamera(int mode, String Id, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            MtcReceiver mtcReceiver = new MtcReceiver();
            if (TextUtils.isEmpty((CharSequence)Id) || Id.getBytes().length > 32) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode;
                if (mode == 2) {
                    ByteBuffer uploadImgByteBuffer = ByteBuffer.allocate(102400);
                    retCode = this.mAiAddImage((byte)mode, null, Id, uploadImgByteBuffer);
                    byte[] data = new byte[uploadImgByteBuffer.limit()];
                    uploadImgByteBuffer.get(data);
                    mtcReceiver.setResult(Base64.encodeToString((byte[])data, (int)0));
                } else {
                    retCode = this.mAiAddImage((byte)mode, null, Id, null);
                }
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcAiAddImageFromExternal(byte[] imageBytes, String Id) {
        if (TextUtils.isEmpty((CharSequence)Id)) {
            return -1001;
        }
        if (Id.getBytes().length > 32) {
            return -1002;
        }
        if (imageBytes == null || imageBytes.length <= 0) {
            return -1003;
        }
        if (imageBytes.length > 0x400000) {
            return -1004;
        }
        if (Id.contains("\"") || Id.contains("\\")) {
            return -1005;
        }
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int retCode = this.mAiAddImage((byte)1, imageBytes, Id, null);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(15000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            Log.w((String)MClient.class.getSimpleName(), (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcAiAddLargeImageFromExternal(final byte[] imageBytes, final String Id) {
        if (TextUtils.isEmpty((CharSequence)Id)) {
            return -1001;
        }
        if (Id.getBytes().length > 32) {
            return -1002;
        }
        if (imageBytes == null || imageBytes.length <= 0) {
            return -1003;
        }
        if (imageBytes.length > 0x400000) {
            return -1004;
        }
        if (Id.contains("\"") || Id.contains("\\")) {
            return -1005;
        }
        final Object lock = new Object();
        final MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<MtcReceiver>(){

            public void subscribe(ObservableEmitter<MtcReceiver> emitter) throws Exception {
                int retCode = MClient.this.mAiAddLargeImage(imageBytes, Id);
                MtcCode mtcCode = MtcCode.matchRetCode(retCode);
                mtcReceiver.setMtcCode(mtcCode);
                emitter.onNext((Object)mtcReceiver);
            }
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MtcReceiver>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(MtcReceiver s) throws Exception {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
                s.setResult("complete");
            }
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(15000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            Log.w((String)MClient.class.getSimpleName(), (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAllIdListGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer idListValues = new StringBuffer();
            int retCode = this.mIdListGet(idListValues);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(idListValues.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiDelUserImageById(String Id, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (TextUtils.isEmpty((CharSequence)Id) || Id.getBytes().length > 32) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiDelImage((byte)1, Id);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiClearAllImage(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode = this.mAiDelAllImage();
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiQueryId(String Id, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            if (TextUtils.isEmpty((CharSequence)Id) || Id.getBytes().length > 32) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiQueryImage(Id, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiAddFeature(byte[] featureDatas, String Id, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (TextUtils.isEmpty((CharSequence)Id) || Id.getBytes().length > 32 || featureDatas == null || featureDatas.length <= 0 || featureDatas.length > 0x400000 || Id.contains("\"") || Id.contains("\\")) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiAddFeature(featureDatas, Id);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiRecognitionCountSet(int recognitionTimes, int livingTimes, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (recognitionTimes < 1 || recognitionTimes > 10 || livingTimes < 1 || livingTimes > 10) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiRecognitionCountSet((byte)recognitionTimes, (byte)livingTimes);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiRecognitionCountGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mAiRecognitionCountGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiQueryFeature(String Id, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            MtcReceiver mtcReceiver = new MtcReceiver();
            if (TextUtils.isEmpty((CharSequence)Id) || Id.getBytes().length > 32 || Id.contains("\"") || Id.contains("\\")) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiQueryFeature(Id, result);
                mtcCode = MtcCode.matchRetCode(retCode);
                mtcReceiver.setResult(new String(result));
            }
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcAiStaticVerify(int mode, byte[] imageBytes, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mAiStaticVerify((byte)mode, imageBytes, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcSystemUploadUpgradePackage(int position, byte[] data, int dataLength) {
        if (data == null || dataLength == 0) {
            return -2;
        }
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int retCode = this.mSystemUploadUpgradePackage(position, data, dataLength);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(2000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            Log.w((String)MClient.class.getSimpleName(), (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CheckResult"})
    public int mtcSystemApplyUpgradePackage(String fileMD5) {
        Object lock = new Object();
        MtcReceiver mtcReceiver = new MtcReceiver();
        Observable.create(emitter -> {
            int retCode = this.mSystemApplyUpgradePackage(fileMD5);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            s.setResult("complete");
        });
        if (TextUtils.isEmpty((CharSequence)mtcReceiver.getResult())) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(5000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            Log.w((String)MClient.class.getSimpleName(), (String)"received result is faster than wait");
        }
        return mtcReceiver.getMtcCode().getRetCode();
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcHandleAT(String ATCommand, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            String result = this.mHandleAt(ATCommand);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setResult(result);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcFactoryReset(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mFactoryReset((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSystemReboot(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 0 && mode != 1 && mode != 2 && mode != 3 && mode != 4) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mSystemReboot((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcSystemVersionInfoGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode;
            MtcCode mtcCode = MtcCode.ERR_TIME_OUT;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 5 && (mtcCode = MtcCode.matchRetCode(retCode = this.mSystemVersionInfoGet(result))) != MtcCode.SUCCESS; ++i) {
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceSnGet(int snType, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            StringBuffer result = new StringBuffer();
            if (snType != 0 && snType != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mDeviceSnGet((byte)snType, result);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceAppVersion(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mDeviceAppVersion(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcDeviceModuleGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            int retCode;
            MtcCode mtcCode = MtcCode.ERR_TIME_OUT;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 5 && (mtcCode = MtcCode.matchRetCode(retCode = this.mDeviceModuleGet(result))) != MtcCode.SUCCESS; ++i) {
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcTemplateUpdateSet(int mode, MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            MtcCode mtcCode;
            if (mode != 0 && mode != 1) {
                mtcCode = MtcCode.PARAM_ERROR;
            } else {
                int retCode = this.mTemplateUpdateSet((byte)mode);
                mtcCode = MtcCode.matchRetCode(retCode);
            }
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    @SuppressLint(value={"CheckResult"})
    public void mtcTemplateUpdateGet(MtcCallback mtcCallback) {
        Observable.create(emitter -> {
            StringBuffer result = new StringBuffer();
            int retCode = this.mTemplateUpdateGet(result);
            MtcCode mtcCode = MtcCode.matchRetCode(retCode);
            MtcReceiver mtcReceiver = new MtcReceiver();
            mtcReceiver.setMtcCode(mtcCode);
            mtcReceiver.setResult(result.toString());
            emitter.onNext((Object)mtcReceiver);
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> mtcCallback.onResult(s.getMtcCode(), s.getResult()));
    }

    static {
        System.loadLibrary("mtc");
    }
}

