/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class SpeechRecognizerSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private boolean mSizeChanged = true;
    private SurfaceHolder mHolder;
    private CanvasThread mCanvasThread;
    private long mFrameInterval = 16L;

    public SpeechRecognizerSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public SpeechRecognizerSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SpeechRecognizerSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mHolder = this.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
    }

    public SurfaceHolder getSurfaceHolder() {
        return this.mHolder;
    }

    void setRenderer(Renderer renderer) {
        this.mCanvasThread = new CanvasThread(this.mHolder, renderer);
        this.mCanvasThread.start();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mCanvasThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        this.mCanvasThread.onWindowResize(w, h);
    }

    public void onPause() {
        this.mCanvasThread.onPause();
    }

    public void onResume() {
        this.mCanvasThread.onResume();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.mCanvasThread.onWindowFocusChanged(hasFocus);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCanvasThread.requestExitAndWait();
    }

    public void setFormat(int format) {
        this.mHolder.setFormat(format);
    }

    public void setMaxFramePerSec(int framePerSec) {
        this.mFrameInterval = 1000 / framePerSec;
    }

    private class CanvasThread
    extends Thread {
        private boolean mDone = false;
        private boolean mPaused;
        private boolean mHasFocus;
        private boolean mHasSurface;
        private boolean mContextLost;
        private int mWidth = 0;
        private int mHeight = 0;
        private final Renderer mRenderer;
        private final SurfaceHolder mSurfaceHolder;

        CanvasThread(SurfaceHolder holder, Renderer renderer) {
            this.mRenderer = renderer;
            this.mSurfaceHolder = holder;
            this.setName("CanvasThread");
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long beforeDrawingTime = 0L;
            while (!this.mDone) {
                Canvas canvas;
                long time;
                int h;
                int w;
                boolean tellRendererSurfaceChanged;
                CanvasThread canvasThread = this;
                synchronized (canvasThread) {
                    if (this.needToWait()) {
                        while (this.needToWait()) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (this.mDone) {
                        break;
                    }
                    tellRendererSurfaceChanged = SpeechRecognizerSurfaceView.this.mSizeChanged;
                    w = this.mWidth;
                    h = this.mHeight;
                    SpeechRecognizerSurfaceView.this.mSizeChanged = false;
                }
                if (tellRendererSurfaceChanged) {
                    this.mRenderer.sizeChanged(w, h);
                }
                if ((time = System.currentTimeMillis()) - beforeDrawingTime <= SpeechRecognizerSurfaceView.this.mFrameInterval) continue;
                beforeDrawingTime = time;
                if (w <= 0 || h <= 0 || (canvas = this.mSurfaceHolder.lockCanvas()) == null) continue;
                this.mRenderer.drawFrame(canvas);
                this.mSurfaceHolder.unlockCanvasAndPost(canvas);
            }
        }

        private boolean needToWait() {
            return (this.mPaused || !this.mHasFocus || !this.mHasSurface || this.mContextLost) && !this.mDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            CanvasThread canvasThread = this;
            synchronized (canvasThread) {
                this.mHasSurface = true;
                this.mContextLost = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            CanvasThread canvasThread = this;
            synchronized (canvasThread) {
                this.mHasSurface = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            CanvasThread canvasThread = this;
            synchronized (canvasThread) {
                this.mPaused = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            CanvasThread canvasThread = this;
            synchronized (canvasThread) {
                this.mPaused = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowFocusChanged(boolean hasFocus) {
            CanvasThread canvasThread = this;
            synchronized (canvasThread) {
                this.mHasFocus = hasFocus;
                if (this.mHasFocus) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int w, int h) {
            CanvasThread canvasThread = this;
            synchronized (canvasThread) {
                this.mWidth = w;
                this.mHeight = h;
                SpeechRecognizerSurfaceView.this.mSizeChanged = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            CanvasThread canvasThread = this;
            synchronized (canvasThread) {
                this.mDone = true;
                this.notify();
            }
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface Renderer {
        public void sizeChanged(int var1, int var2);

        public void drawFrame(Canvas var1);
    }
}

