/*
 * 
 * SIP PARTY HEADER PROCESSING
 * Copyright 2011-2012 KWANGHAESOFT LTD.
 * Creator: JGK
 * PUBLISH DATE: Dec. 2011
 * 
 * ............................................
 * Compact Type :Checked - adopted.
 * Date:2012 04 27
 * ............................................
 * 
 */
package bssoft.stack.sip;

public class SIPHeaderParty {
	public String header		= null;
	public String headerValue	= null;
	//
	public String display		= null;
	public String username		= null;
	public String sipuri		= null;
	public String uriusertag	= null;//< ;user=phone>
	public String ip			= null;
	public int port			= 0;
	
	public String tag			= null;
	//
	public int headerType=SIPStack.SIP_HEADERTYPE_NONE;
	public boolean flag=false;
	
	public SIPHeaderParty(String message,int headerType)
	{
		String keyWord;
		String compactKeyWord=null;
		
		if(message!=null)
		{			
			if(headerType == SIPStack.SIP_HEADERTYPE_FROM) {
				keyWord = "From: ";
				compactKeyWord = "f: ";
			}
			else if(headerType == SIPStack.SIP_HEADERTYPE_TO) {
				keyWord = "To: ";
				compactKeyWord = "t: ";
			}
			else keyWord=null;
			if(keyWord != null)
			{
				int iS=message.indexOf(keyWord);
				int iE=0;
				if(iS>=0) 
				{//2012 03 22
					iE=message.indexOf(SIPStack.SIP_LINE_END,iS);
					if(iE>0) {
						header=message.substring(iS,iE);
						headerValue=message.substring(iS+keyWord.length(),iE);
						this.headerType=headerType;
						//DISPLAY
						iE=headerValue.indexOf("<sip:");
						if(iE>0)
						{
							String str=null;
							str=headerValue.substring(0,iE).trim();
							if(str != null && str.length()>1 
									&& str.startsWith("\"")==true 
									&& str.endsWith("\"")==true
									)
							{
								this.display=str.substring(1,str.length()-1);
							}
							else if(str != null && str.length()>0) this.display=str;
						}
						//URI
						iS=headerValue.indexOf("sip:");
						if(iS>0)
						{
							String str=null;
							iE=headerValue.indexOf(">",iS+4);
							if(iE<0) iE=headerValue.indexOf(";",iS+4);
							if(iE>0) str=headerValue.substring(iS,iE);
							else str=headerValue.substring(iS);
							if(str != null && str.length()>0) this.sipuri=str.trim();
						}
						//USERNAME
						if(this.sipuri != null && this.sipuri.length()>0)
						{
							iS=this.sipuri.indexOf("@",4);
							if(iS>0)
							{
								this.username=this.sipuri.substring(4,iS).trim();
							}
						}
						//HOST
						if(this.sipuri != null && this.sipuri.length()>0)
						{
							iS=this.sipuri.indexOf("@",4);
							String str=null;
							if(iS>=0)
							{
								str=this.sipuri.substring(iS+1).trim();
							}
							else {
								str=this.sipuri.substring(4).trim();
							}
							//PORT
							this.port=5060;
							if(str != null && str.length()>0)
							{
								iS=str.indexOf(":");
								if(iS>0) {
									this.port=Integer.parseInt(str.substring(iS+1).trim());
									this.ip=str.substring(0,iS);
								}
								else {
									this.ip=str;
								}
							}
						}					
						//TAG
						iS=headerValue.indexOf(";tag=");
						if(iS>0)
						{
							String str=null;
							iE=headerValue.indexOf(";",iS+5);
							if(iE>=0) {
								if(iE>iS+5) str=headerValue.substring(iS+5,iE);
								else str="";
							}
							else str=headerValue.substring(iS+5);
							if(str != null && str.length()>0) this.tag=str.trim();
						}
						else this.tag="";
						//URIUSERTAG
						iS=headerValue.indexOf("sip:");
						if(iS>0)
						{
							String str=null;
							iE=headerValue.indexOf(">",iS+4);
							if(iE>0) str=headerValue.substring(iS,iE);
							if(str != null && str.length()>0)
							{
								iS=str.indexOf(";user=",iS+4);
								if(iS>0) {
									this.uriusertag=str.substring(iS+6);
									if(this.uriusertag != null && this.uriusertag.length()>0 && this.uriusertag.indexOf(";")>=0)
									{
										if(this.uriusertag.indexOf(";")==0) this.uriusertag=null;
										else this.uriusertag=this.uriusertag.substring(0,this.uriusertag.indexOf(";")).trim();
									}
								}
							}
						}

						//
						flag=true;
					}

				}
			}//if
			else if(compactKeyWord != null) //2012 04 27
			{
				int iS=message.indexOf(compactKeyWord);
				int iE=0;
				if(iS>=0) 
				{//2012 03 22
					iE=message.indexOf(SIPStack.SIP_LINE_END,iS);
					if(iE>0) {
						header=message.substring(iS,iE);
						headerValue=message.substring(iS+compactKeyWord.length(),iE);
						this.headerType=headerType;
						//DISPLAY
						iE=headerValue.indexOf("<sip:");
						if(iE>0)
						{
							String str=null;
							str=headerValue.substring(0,iE).trim();
							if(str != null && str.length()>1 
									&& str.startsWith("\"")==true 
									&& str.endsWith("\"")==true
									)
							{
								this.display=str.substring(1,str.length()-1);
							}
							else if(str != null && str.length()>0) this.display=str;
						}
						//URI
						iS=headerValue.indexOf("sip:");
						if(iS>0)
						{
							String str=null;
							iE=headerValue.indexOf(">",iS+4);
							if(iE<0) iE=headerValue.indexOf(";",iS+4);
							if(iE>0) str=headerValue.substring(iS,iE);
							else str=headerValue.substring(iS);
							if(str != null && str.length()>0) this.sipuri=str.trim();
						}
						//USERNAME
						if(this.sipuri != null && this.sipuri.length()>0)
						{
							iS=this.sipuri.indexOf("@",4);
							if(iS>0)
							{
								this.username=this.sipuri.substring(4,iS).trim();
							}
						}
						//HOST
						if(this.sipuri != null && this.sipuri.length()>0)
						{
							iS=this.sipuri.indexOf("@",4);
							String str=null;
							if(iS>=0)
							{
								str=this.sipuri.substring(iS+1).trim();
							}
							else {
								str=this.sipuri.substring(4).trim();
							}
							//PORT
							this.port=5060;
							if(str != null && str.length()>0)
							{
								iS=str.indexOf(":");
								if(iS>0) {
									this.port=Integer.parseInt(str.substring(iS+1).trim());
									this.ip=str.substring(0,iS);
								}
								else {
									this.ip=str;
								}
							}
						}					
						//TAG
						iS=headerValue.indexOf(";tag=");
						if(iS>0)
						{
							String str=null;
							iE=headerValue.indexOf(";",iS+5);
							if(iE>=0) {
								if(iE>iS+5) str=headerValue.substring(iS+5,iE);
								else str="";
							}
							else str=headerValue.substring(iS+5);
							if(str != null && str.length()>0) this.tag=str.trim();
						}
						else this.tag="";
						//URIUSERTAG
						iS=headerValue.indexOf("sip:");
						if(iS>0)
						{
							String str=null;
							iE=headerValue.indexOf(">",iS+4);
							if(iE>0) str=headerValue.substring(iS,iE);
							if(str != null && str.length()>0)
							{
								iS=str.indexOf(";user=",iS+4);
								if(iS>0) {
									this.uriusertag=str.substring(iS+6);
									if(this.uriusertag != null && this.uriusertag.length()>0 && this.uriusertag.indexOf(";")>=0)
									{
										if(this.uriusertag.indexOf(";")==0) this.uriusertag=null;
										else this.uriusertag=this.uriusertag.substring(0,this.uriusertag.indexOf(";")).trim();
									}
								}
							}
						}

						//
						flag=true;
					}

				}
			}//if
			
		}
	}
	public String getDisplay()
	{		
		return display;
	}
	public String getUsername()
	{		
		return username;
	}
	public String getSipuri()
	{
		return sipuri;
	}
	public String getSipuriusertag()
	{
		return uriusertag;
	}
	public String getIp()
	{
		return ip;
	}
	public int getPort()
	{
		return port;
	}
	public String getTag()
	{
		return tag;
		
	}
}//class SIPHeaderParty