/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadimap;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.artncore.WallPadDataMgr.WallpadDeviceSet;
import com.artncore.WallPadDataMgr.WallpadStatusData;
import com.artncore.WallPadDataMgr.WallpadVistorPicData;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadimap.RetProci;
import com.artncore.wallpadimap.WallPadFTPUploader;
import com.artncore.wallpadimap.WallPadiMAPClient;
import java.util.Calendar;
import java.util.GregorianCalendar;
import kr.co.icontrols.wallpadsupport.WpadSound;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WallPadiMAPNotifyAPI
extends WallPadiMAPClient {
    final int NOTIFY_ELEVATOR_UP = 8;
    final int NOTIFY_ELEVATOR_DN = 9;
    final int NOTIFY_DEVICE_BOOTUP = 13;
    final int OPEN_LOBBY_DOOR = 14;
    final int UPLOAD_VISTOR_PICTURE = 15;
    final int UPLOAD_VISTOR_COMPLITE = 16;
    final int REQ_GET_SET_SYNC = 17;
    final int NOTIFY_DEVICE_MODECHANGED = 18;
    final int NOTIFY_GET_METERING = 19;
    final int NOTIFY_GET_METERING_MONTH = 20;
    public APIErrorCode ErrorCode;
    String[] eventString = new String[]{"\"news_arrival\"", "\"box_arrival\"", "\"box_delivered\"", "\"car_arrival\"", "\"epic_completed\"", "\"epic_down_fail\"", "\"elevator_arrived\"", "\"elevator_arrived_up\"", "\"elevator_up\"", "\"elevator_dn\"", "\"elevator_cancel\"", "\"elevator_move_info_set\"", "\"elevator_move_info_clear\""};
    String myIP = "NONE";
    String myDong = "NONE";
    String myHo = "NONE";
    Context ctx;
    RetProci ElevatorProc;
    String XMLHeader;
    int DoWork = -1;
    String ArgStr1;
    String ArgStr2;
    public iMAP_RET_DATA imapSync;
    public static final int DEST_LOBBY = 0;
    public static final int DEST_DOOR = 1;

    public void SetServerIPcfg(String IPa, int port) {
        this.ServerIP = IPa;
        this.SvrPort = port;
    }

    public WallPadiMAPNotifyAPI(Context ctx) {
        super.setContext(ctx);
        WallpadStatusData DBMGR = new WallpadStatusData(ctx);
        this.ErrorCode = new APIErrorCode();
        wallpaddbmgr.AddressSet addc = DBMGR.getAddressMGR();
        this.myDong = addc.Dong;
        this.myIP = addc.IPAddress;
        this.myHo = addc.Ho;
        this.SetServerIPConfig(DBMGR.GetServerIP(), DBMGR.GetServerPort());
        DBMGR.closeDB();
        this.XMLHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<imap ver = \"1.0\" address = \"" + this.myIP + "\" sender = \"" + this.myDong + "\ub3d9 " + this.myHo + "\ud638\">\r\n";
        this.ctx = ctx;
        this.imapSync = new iMAP_RET_DATA();
    }

    public void SetElevatorRetCtr(RetProci electr) {
        this.ElevatorProc = electr;
    }

    private String GetXML(int event) {
        String retXML = this.XMLHeader + "<service type = \"request\" name= \"event_notify\">\r\n<event> " + this.eventString[event] + " </event>\r\n</service>\r\n </imap>";
        return retXML;
    }

    protected void FreeElevatorCall(int Dowork) {
        WallpadStatusData wdb = new WallpadStatusData(this.ctx);
        int elestatus = wdb.GetElevatorStatus();
        wdb.closeDB();
        if (Dowork != 8 && Dowork != 9) {
            return;
        }
    }

    @Override
    protected void ProcComplite() {
        block81: {
            if ((this.DoWork == 8 || this.DoWork == 9) && this.ElevatorProc != null) {
                try {
                    if (this.doc == null) break block81;
                    this.SetItem("service");
                    String result = this.GetAttributeVal(0, "result");
                    if (result != null) {
                        if (result.equalsIgnoreCase("ok")) {
                            WallpadStatusData wdb = new WallpadStatusData(this.ctx);
                            int elestatus = wdb.GetElevatorStatus();
                            wdb.SetElevatorStatus(elestatus |= this.DoWork == 8 ? 1 : 2);
                            if (this.DoWork == 8) {
                                wdb.SetElevatorCallUpTime();
                            } else {
                                wdb.SetElevatorCallDnTime();
                            }
                            wdb.closeDB();
                            this.ElevatorProc.ProcSuccess();
                        } else {
                            this.ElevatorProc.ProcError();
                        }
                        break block81;
                    }
                    this.ElevatorProc.ProcError();
                }
                catch (Exception e) {
                    Log.d((String)"WApi", (String)("Exception e " + e));
                    e.printStackTrace();
                }
            } else if (this.DoWork == 13) {
                try {
                    String[] WeatherVer;
                    String[] weatherdate;
                    if (this.doc == null) break block81;
                    boolean SendHeartBeat = false;
                    this.SetItem("date");
                    int year = Integer.parseInt(this.GetAttributeVal(0, "year"));
                    int month = Integer.parseInt(this.GetAttributeVal(0, "month"));
                    int date = Integer.parseInt(this.GetAttributeVal(0, "date"));
                    this.SetItem("time");
                    int hour = Integer.parseInt(this.GetAttributeVal(0, "hour"));
                    int min = Integer.parseInt(this.GetAttributeVal(0, "min"));
                    int sec = Integer.parseInt(this.GetAttributeVal(0, "sec"));
                    GregorianCalendar bootupal = new GregorianCalendar();
                    long settedtime = bootupal.getTimeInMillis();
                    bootupal.set(1, year);
                    bootupal.set(2, month);
                    bootupal.set(5, date);
                    bootupal.set(11, hour);
                    bootupal.set(12, min);
                    bootupal.set(13, sec);
                    long bootupmil = bootupal.getTimeInMillis();
                    WallpadStatusData DBMGR = new WallpadStatusData(this.ctx);
                    if (Math.abs(bootupmil - settedtime) > 5000L) {
                        DBMGR.setSystemTime(year, month, date, hour, min, sec);
                        SendHeartBeat = true;
                        Intent Iintent = new Intent();
                        Iintent.setAction("WALLPAD_NOTIFY");
                        Iintent.putExtra("KIND", 1025);
                        this.ctx.sendBroadcast(Iintent);
                    }
                    if ((weatherdate = (WeatherVer = DBMGR.GetWeatherVer().split(":"))[0].split("[.]")).length < 4 || WeatherVer.length < 3) {
                        return;
                    }
                    if (Integer.parseInt(weatherdate[1]) == month && Integer.parseInt(weatherdate[2]) == date) {
                        try {
                            Intent intent = new Intent();
                            intent.setAction("WALLPAD_NOTIFY");
                            intent.putExtra("KIND", 1015);
                            intent.putExtra("NOTICONTENT", WeatherVer[3] + ":" + WeatherVer[6] + ":" + WeatherVer[7]);
                            this.ctx.sendBroadcast(intent);
                        }
                        catch (Exception we) {
                            we.printStackTrace();
                        }
                    } else {
                        WallpadStatusData.WeatherTable WeatherTBL = DBMGR.GetWeatherTableController();
                        if (WeatherTBL.GetWeatherList().size() > 0) {
                            String Curdate = String.format("%02d%02d", month, date);
                            for (int i = 0; i < WeatherTBL.GetWeatherList().size(); ++i) {
                                if (!WeatherTBL.GetWeatherList().get((int)i).date.equals(Curdate)) continue;
                                Intent intent = new Intent();
                                intent.setAction("WALLPAD_NOTIFY");
                                intent.putExtra("KIND", 1015);
                                intent.putExtra("NOTICONTENT", WeatherTBL.GetWeatherList().get((int)i).code + ":" + WeatherTBL.GetWeatherList().get((int)i).low + ":" + WeatherTBL.GetWeatherList().get((int)i).high);
                                this.ctx.sendBroadcast(intent);
                            }
                        }
                    }
                    DBMGR.closeDB();
                    try {
                        Element ele = this.doc.getDocumentElement();
                        NodeList items = ele.getElementsByTagName("ver_server");
                        if (items != null) {
                            Node item = items.item(0);
                            Node text = item.getFirstChild();
                            String versionInfo = this.trimquotation(text.getNodeValue());
                            Log.d((String)"bootup", (String)("Bootup replay versionInfo : " + versionInfo));
                            WallpadStatusData DBcc = new WallpadStatusData(this.ctx);
                            DBcc.SetServerVer(versionInfo);
                            DBcc.closeDB();
                            WallpadDeviceSet wallpadDeviceSet = new WallpadDeviceSet(this.ctx);
                            boolean mNewDanjiServer = wallpadDeviceSet.GetNewDanjiServer();
                            wallpadDeviceSet.closeDB();
                            if (mNewDanjiServer && versionInfo.equalsIgnoreCase("1.0") || !mNewDanjiServer && versionInfo.indexOf("2.") >= 0) {
                                Intent intent = new Intent();
                                intent.setAction("WALLPAD_NOTIFY");
                                intent.putExtra("KIND", 1301);
                                this.ctx.sendBroadcast(intent);
                            } else if (SendHeartBeat) {
                                Intent intent = new Intent();
                                intent.setAction("WALLPAD_NOTIFY");
                                intent.putExtra("KIND", 1021);
                                this.ctx.sendBroadcast(intent);
                            }
                        }
                    }
                    catch (Exception ele) {
                    }
                }
                catch (Exception e) {
                    Log.d((String)"WApi", (String)("Exception e " + e));
                    e.printStackTrace();
                }
            } else if (this.DoWork == 14) {
                try {
                    this.SetItem("service");
                    String userinfo = this.GetAttributeVal(0, "result");
                    Intent intent = new Intent();
                    intent.setAction("WALLPAD_NOTIFY");
                    if (userinfo.equalsIgnoreCase("ok")) {
                        intent.putExtra("KIND", 1044);
                        WpadSound SNDMGR = new WpadSound(this.ctx);
                        SNDMGR.Play(14);
                    } else {
                        intent.putExtra("KIND", 1043);
                    }
                    this.ctx.sendBroadcast(intent);
                }
                catch (Exception e) {
                    Log.d((String)"WApi", (String)("Exception e " + e));
                    e.printStackTrace();
                }
            } else if (this.DoWork == 15) {
                try {
                    this.SetItem("ftp_info");
                    String userinfo = this.GetAttributeVal(0, "user");
                    String userPasswd = this.GetAttributeVal(0, "passwd");
                    String path = this.GetAttributeVal(0, "path");
                    WallpadVistorPicData Vistor = new WallpadVistorPicData(this.ctx);
                    Vistor.UpdateFTPInfo(this.ArgStr1, this.ArgStr2, userinfo, userPasswd, path);
                    Vistor.closeDB();
                    VistorUploader Vistoruploader = new VistorUploader(this.ctx, path, userinfo, userPasswd, this.ArgStr1);
                    Vistoruploader.start();
                }
                catch (Exception e) {
                    Log.d((String)"WApi", (String)("Exception e " + e));
                    e.printStackTrace();
                }
            } else if (this.DoWork == 17) {
                try {
                    this.SetItem("setting");
                    String dateData = this.GetAttributeVal(0, "value");
                    int year = Integer.parseInt(dateData.substring(0, 4));
                    int month = Integer.parseInt(dateData.substring(4, 6));
                    int day = Integer.parseInt(dateData.substring(6, 8));
                    int hour = Integer.parseInt(dateData.substring(8, 10));
                    int min = Integer.parseInt(dateData.substring(10, 12));
                    int sec = Integer.parseInt(dateData.substring(12, 14));
                    GregorianCalendar nowdate = new GregorianCalendar();
                    long settedtime = nowdate.getTimeInMillis();
                    nowdate.set(1, year);
                    nowdate.set(2, month);
                    nowdate.set(5, day);
                    nowdate.set(11, hour);
                    nowdate.set(12, min);
                    nowdate.set(13, sec);
                    long bootupmil = nowdate.getTimeInMillis();
                    if (Math.abs(bootupmil - settedtime) > 5000L) {
                        WallpadStatusData DBMGR = new WallpadStatusData(this.ctx);
                        DBMGR.setSystemTime(year, month, day, hour, min, sec);
                        DBMGR.closeDB();
                        Intent intent = new Intent();
                        intent.setAction("WALLPAD_NOTIFY");
                        intent.putExtra("KIND", 1021);
                        this.ctx.sendBroadcast(intent);
                        Intent Iintent = new Intent();
                        Iintent.setAction("WALLPAD_NOTIFY");
                        Iintent.putExtra("KIND", 1025);
                        this.ctx.sendBroadcast(Iintent);
                    }
                }
                catch (Exception e) {
                    Log.d((String)"WApi", (String)("Exception e " + e));
                    e.printStackTrace();
                }
            } else if (this.DoWork != 18) {
                if (this.DoWork == 19) {
                    try {
                        if (this.doc == null) break block81;
                        NodeList items = this.doc.getElementsByTagName("valuelist");
                        String Sdate = "0";
                        String electused = "0";
                        String gasused = "0";
                        String waterused = "0";
                        String hwaterused = "0";
                        String energyused = "0";
                        String carbonused = "0";
                        String electread = "0";
                        String gasread = "0";
                        String waterread = "0";
                        String hwaterread = "0";
                        String energyread = "0";
                        String carbonread = "0";
                        String FSdate = "0";
                        String Felectused = "0";
                        String Fgasused = "0";
                        String Fwaterused = "0";
                        String Fhwaterused = "0";
                        String Fenergyused = "0";
                        String Fcarbonused = "0";
                        String Felectread = "0";
                        String Fgasread = "0";
                        String Fwaterread = "0";
                        String Fhwaterread = "0";
                        String Fenergyread = "0";
                        String Fcarbonread = "0";
                        try {
                            for (int i = 0; i < items.getLength(); ++i) {
                                Node item = items.item(i);
                                NamedNodeMap attrs = item.getAttributes();
                                for (int j = 0; j < attrs.getLength(); ++j) {
                                    Node attr = attrs.item(j);
                                    if (attr.getNodeName().equalsIgnoreCase("day")) {
                                        Sdate = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("elect_read")) {
                                        electread = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("gas_read")) {
                                        gasread = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("water_read")) {
                                        waterread = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("hotwater_read")) {
                                        hwaterread = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("energy_read")) {
                                        energyread = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("carbon_read")) {
                                        carbonread = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("elect_used")) {
                                        electused = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("gas_used")) {
                                        gasused = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("water_used")) {
                                        waterused = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("hotwater_used")) {
                                        hwaterused = attr.getNodeValue();
                                        continue;
                                    }
                                    if (attr.getNodeName().equalsIgnoreCase("energy_used")) {
                                        energyused = attr.getNodeValue();
                                        continue;
                                    }
                                    if (!attr.getNodeName().equalsIgnoreCase("carbon_used")) continue;
                                    carbonused = attr.getNodeValue();
                                }
                                if (Integer.parseInt(FSdate) >= Integer.parseInt(Sdate)) continue;
                                FSdate = Sdate;
                                Felectused = electused;
                                Fgasused = gasused;
                                Fwaterused = waterused;
                                Fhwaterused = hwaterused;
                                Fenergyused = energyused;
                                Fcarbonused = carbonused;
                                Felectread = electread;
                                Fgasread = gasread;
                                Fwaterread = waterread;
                                Fhwaterread = hwaterread;
                                Fenergyread = energyread;
                                Fcarbonread = carbonread;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Intent intent = new Intent();
                        intent.setAction("WALLPAD_NOTIFY");
                        intent.putExtra("KIND", 1030);
                        String contData = FSdate + ";" + Felectused + ";" + Fwaterused + ";" + Fgasused + ";" + Fhwaterused + ";" + Fenergyused + ";" + Fcarbonused + ";" + Felectread + ";" + Fgasread + ";" + Fwaterread + ";" + Fhwaterread + ";" + Fenergyread + ";" + Fcarbonread;
                        intent.putExtra("NOTICONTENT", contData);
                        this.ctx.sendBroadcast(intent);
                    }
                    catch (Exception e) {
                        Log.d((String)"WApi", (String)("Exception e " + e));
                        e.printStackTrace();
                    }
                } else if (this.DoWork == 20) {
                    try {
                        if (this.doc == null) break block81;
                        NodeList items = this.doc.getElementsByTagName("valuelist");
                        String Sdate = "0";
                        String electused = "0";
                        String gasused = "0";
                        String waterused = "0";
                        String hwaterused = "0";
                        String energyused = "0";
                        String carbonused = "0";
                        String electread = "0";
                        String gasread = "0";
                        String waterread = "0";
                        String hwaterread = "0";
                        String energyread = "0";
                        String carbonread = "0";
                        try {
                            Node item = items.item(0);
                            NamedNodeMap attrs = item.getAttributes();
                            for (int j = 0; j < attrs.getLength(); ++j) {
                                Node attr = attrs.item(j);
                                if (attr.getNodeName().equalsIgnoreCase("month")) {
                                    Sdate = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("elect_read")) {
                                    electread = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("gas_read")) {
                                    gasread = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("water_read")) {
                                    waterread = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("hotwater_read")) {
                                    hwaterread = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("energy_read")) {
                                    energyread = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("carbon_read")) {
                                    carbonread = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("elect_used")) {
                                    electused = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("gas_used")) {
                                    gasused = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("water_used")) {
                                    waterused = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("hotwater_used")) {
                                    hwaterused = attr.getNodeValue();
                                    continue;
                                }
                                if (attr.getNodeName().equalsIgnoreCase("energy_used")) {
                                    energyused = attr.getNodeValue();
                                    continue;
                                }
                                if (!attr.getNodeName().equalsIgnoreCase("carbon_used")) continue;
                                carbonused = attr.getNodeValue();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        String deli = ";";
                        String contData = Sdate + deli + electused + deli + waterused + deli + gasused + deli + hwaterused + deli + energyused + deli + carbonused + deli + electread + deli + gasread + deli + waterread + deli + hwaterread + deli + energyread + deli + carbonread;
                        WallpadStatusData energyData = new WallpadStatusData(this.ctx);
                        energyData.SetEnergyMonData(contData);
                        energyData.closeDB();
                    }
                    catch (Exception e) {
                        Log.d((String)"WApi", (String)("Exception e " + e));
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    protected void ProcError() {
        if (this.DoWork == 8 || this.DoWork == 9) {
            if (this.ElevatorProc != null) {
                this.ElevatorProc.ProcError();
            }
        } else if (this.DoWork == 13) {
            Intent intent = new Intent();
            intent.setAction("WALLPAD_NOTIFY");
            intent.putExtra("KIND", 1010);
            this.ctx.sendBroadcast(intent);
        } else if (this.DoWork == 14) {
            Intent intent = new Intent();
            intent.setAction("WALLPAD_NOTIFY");
            intent.putExtra("KIND", 1043);
            this.ctx.sendBroadcast(intent);
        } else if (this.DoWork == 17 || this.DoWork == 18) {
            // empty if block
        }
    }

    public void CallElevator(byte updown) {
        this.DoWork = updown == 0 ? 9 : 8;
        this.SetServerIPConfig(this.ServerIP, this.SvrPort);
        this.SendXMLDoc(this.GetXML(this.DoWork), true);
        Intent iIntent = new Intent();
        iIntent.setAction("WALLPAD_NOTIFY");
        iIntent.putExtra("KIND", 1048);
        this.ctx.sendBroadcast(iIntent);
    }

    public void UploadVistorPic(int dest, String filepath, String TimeData, boolean retry) {
        String[] destStr = new String[]{"lobby", "home"};
        try {
            String[] FileName = filepath.split("/");
            String XMLCMD = this.XMLHeader + "<service type = \"request\" name= \"visitor_access_info\">\r\n    <visitor_info dong= \"" + this.myDong + "\" ho= \"" + this.myHo + "\" distinct= \"" + destStr[dest] + "\"  time= \"" + TimeData + "\" filename = \"" + FileName[FileName.length - 1] + "\" message= \"null\"/>\r\n</service>\r\n</imap>";
            this.DoWork = 15;
            WallpadVistorPicData Vistor = new WallpadVistorPicData(this.ctx);
            if (!retry) {
                Vistor.InsertPicInfo(TimeData, "NONE", "NONE", "NONE", filepath, destStr[dest]);
                Vistor.StatusUpdate(1, filepath, TimeData);
            } else {
                Vistor.StatusUpdate(1, filepath, TimeData);
            }
            Vistor.closeDB();
            this.ArgStr1 = filepath;
            this.ArgStr2 = TimeData;
            this.SendXMLDoc(XMLCMD, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void OpenLobbyDoor() {
        String XMLCMD = this.XMLHeader + "<service type=\"request\" name=\"lobby_open\"/> \r\n</imap>";
        this.DoWork = 14;
        String[] IPa = this.myIP.split("[.]");
        String LobbyIP = IPa[0] + "." + IPa[1] + ".0.99";
        this.SetServerIPConfig(LobbyIP, this.SvrPort);
        this.SendXMLDoc(XMLCMD, true);
    }

    public void OpenLobbyDoor(String IP) {
        String XMLCMD = this.XMLHeader + "<service type=\"request\" name=\"lobby_open\"/> \r\n</imap>";
        this.DoWork = 14;
        this.SetServerIPConfig(IP, this.SvrPort);
        this.SendXMLDoc(XMLCMD, true);
    }

    public void ReqGetSet() {
        String XMLCMD = this.XMLHeader + "<service type=\"request\" name=\"get_setup_info\"> \r\n   <guidemap devtype=\"homedev\" count=\"1\">\r\n       <variable>\"datetime\"</variable>\r\n   </guidemap>\r\n</service>\r\n</imap>";
        this.DoWork = 17;
        this.SendXMLDoc(XMLCMD, true);
    }

    private String Make_Device_Bootup_XML(String MainApp_Version, String Setting_Version, String svr_Version) {
        String XMLDoc = this.XMLHeader + "<service type=\"request\" name=\"device_bootup\" dev_type=\"homedev\">\r\n<ver_bsp>  \"" + Build.DISPLAY + "\" </ver_bsp>\r\n<ver_app>  \"" + MainApp_Version + "\" </ver_app>\r\n<ver_setting>  \"" + Setting_Version + "\" </ver_setting>\r\n<ver_server>" + svr_Version + "</ver_server>\r\n</service>\r\n</imap>";
        return XMLDoc;
    }

    public void Send_Device_BootUP(String MainApp_Version, String Setting_Version, String svr_Version) {
        this.DoWork = 13;
        this.SetServerIPConfig(this.ServerIP, this.SvrPort);
        if (MainApp_Version == null || MainApp_Version.equalsIgnoreCase("")) {
            MainApp_Version = "0000.00.00";
        }
        if (Setting_Version == null || Setting_Version.equalsIgnoreCase("")) {
            Setting_Version = "0000.00.00";
        }
        if (svr_Version == null || svr_Version.equalsIgnoreCase("")) {
            svr_Version = "1.0";
        }
        this.SendXMLDoc(this.Make_Device_Bootup_XML(MainApp_Version, Setting_Version, svr_Version), true);
    }

    public void ModeChanged(String mode) {
        String XMLDoc = this.XMLHeader + "<service type = \"request\" name= \"mode_changed\">\r\n    <new_mode> \"" + mode + "\" </new_mode>\r\n</service>\r\n</imap>\r\n";
        this.DoWork = 18;
        WallpadStatusData wd = new WallpadStatusData(this.ctx);
        this.SetServerIPConfig(wd.GetManagePCIP(), wd.GetManagePCPort());
        wd.closeDB();
        this.SendXMLDoc(XMLDoc, true);
    }

    public void GetEnergyUsage() {
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(5, -1);
        String XMLDoc = this.XMLHeader + "<service type = \"request\" name= \"get_ems_metering\">\r\n    <guidemap distinguish = \"month\" elect = \"yes\" gas = \"yes\" water = \"yes\" hotwater = \"yes\" energy = \"yes\" carbon=\"yes\" support_ems=\"no\">\r\n    <datelist year = \"" + now.get(1) + "\" month = \"" + (now.get(2) + 1) + "\" />\r\n</guidemap>\r\n</service>\r\n</imap>\r\n";
        this.DoWork = 19;
        this.SetServerIPConfig(this.ServerIP, this.SvrPort);
        this.SendXMLDoc(XMLDoc, true);
    }

    public void GetEnergyUsageMonth() {
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(2, -1);
        String XMLDoc = this.XMLHeader + "<service type = \"request\" name= \"get_ems_metering\">\r\n    <guidemap distinguish = \"year\" elect = \"yes\" gas = \"yes\" water = \"yes\" hotwater = \"yes\" energy = \"yes\" carbon=\"yes\" support_ems=\"no\">\r\n    <datelist year = \"" + now.get(1) + "\" month = \"0\" />\r\n</guidemap>\r\n</service>\r\n</imap>\r\n";
        this.DoWork = 20;
        this.SetServerIPConfig(this.ServerIP, this.SvrPort);
        this.SendXMLDoc(XMLDoc, true);
    }

    public static class iMAP_RET_DATA {
        public String TargetIP;
        public String XML;
        public String RETVAL;
    }

    class VistorUploader
    extends WallPadFTPUploader {
        public VistorUploader(Context ctx, String ftpPath, String User, String Passwd, String LocalFile) {
            super(ctx, ftpPath, User, Passwd, LocalFile);
        }

        @Override
        protected void ProcUploadFail() {
            WallpadVistorPicData Vistor = new WallpadVistorPicData(WallPadiMAPNotifyAPI.this.ctx);
            Vistor.StatusUpdate(2, WallPadiMAPNotifyAPI.this.ArgStr1, WallPadiMAPNotifyAPI.this.ArgStr2);
            Vistor.closeDB();
        }

        @Override
        protected void ProcUploadSuccess() {
            try {
                WallpadVistorPicData Vistor = new WallpadVistorPicData(WallPadiMAPNotifyAPI.this.ctx);
                String[] VistorPicData = Vistor.GetVistorPicData(WallPadiMAPNotifyAPI.this.ArgStr1, WallPadiMAPNotifyAPI.this.ArgStr2);
                String[] filename = WallPadiMAPNotifyAPI.this.ArgStr1.split("/");
                String retXML = WallPadiMAPNotifyAPI.this.XMLHeader + "    <service type = \"notice\" name= \"visitor_upload_complete\">\r\n    < upload_info status=\"success\" dong=\"" + WallPadiMAPNotifyAPI.this.myDong + "\" ho=\"" + WallPadiMAPNotifyAPI.this.myHo + "\" distinct= \"" + VistorPicData[3] + "\"  time= \"" + WallPadiMAPNotifyAPI.this.ArgStr2 + "\" filename = \"" + filename[filename.length - 1] + "\"  message = \"null\" />\r\n</service>\r\n </imap>";
                Vistor.DeletePic(WallPadiMAPNotifyAPI.this.ArgStr1, WallPadiMAPNotifyAPI.this.ArgStr2);
                Vistor.closeDB();
                WallPadiMAPNotifyAPI.this.DoWork = 16;
                WallPadiMAPNotifyAPI.this.SendXMLDoc(retXML, false);
            }
            catch (Exception e) {
                Log.e((String)"WallPadiMAPNotifyAPI", (String)"[ProcUploadSuccess] Exception Error");
                e.printStackTrace();
            }
        }
    }
}

