/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class RealTimeMeterAPI
extends WallPadDevAPI {
    private final String TAG = "RealTimeMeterAPI";
    private final boolean DEBUG_LOG_ON = true;
    public DataClasses.RealTimeMeter data;

    private void DebugLogOutput(String s) {
        Log.d((String)"RealTimeMeterAPI", (String)s);
    }

    public RealTimeMeterAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("RealTimeMeterAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "REALTIMEMETER";
        this.data = new DataClasses.RealTimeMeter();
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 16) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.Elec.Support = Boolean.parseBoolean(retlist[index++]);
                this.data.Elec.Acc = Double.parseDouble(retlist[index++]);
                this.data.Elec.Now = Double.parseDouble(retlist[index++]);
                this.data.Water.Support = Boolean.parseBoolean(retlist[index++]);
                this.data.Water.Acc = Double.parseDouble(retlist[index++]);
                this.data.Water.Now = Double.parseDouble(retlist[index++]);
                this.data.HotWater.Support = Boolean.parseBoolean(retlist[index++]);
                this.data.HotWater.Acc = Double.parseDouble(retlist[index++]);
                this.data.HotWater.Now = Double.parseDouble(retlist[index++]);
                this.data.Gas.Support = Boolean.parseBoolean(retlist[index++]);
                this.data.Gas.Acc = Double.parseDouble(retlist[index++]);
                this.data.Gas.Now = Double.parseDouble(retlist[index++]);
                this.data.Calorie.Support = Boolean.parseBoolean(retlist[index++]);
                this.data.Calorie.Acc = Double.parseDouble(retlist[index++]);
                this.data.Calorie.Now = Double.parseDouble(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"RealTimeMeterAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }
}

