/*
 * Copyright (C) 2015 Android WallPad Project
 *
 * FileName  : ApiKey.java
 * Project   : Android WallPad Project
 * Company   : HDC I-CONTROLS ( www.icontrols.co.kr )
 * Author    : Kang Sang Ho  , lairu@icontrols.co.kr
 */

package kr.co.icontrols.sttttsapi;

import android.content.Context;
import android.media.AudioManager;
import android.util.Log;

/**
 * define  Class<br>
 */
public class Common
{
	private static final String TAG = "Common";
	
	/** е ȭ Ű  */
    public static String WALLPAD_PACKAGENAME = "com.artncore.apps.ic_wallpad";
    /** κ  Ű  */
    public static String LOBBY_PACKAGENAME   = "kr.co.icontrols.ilp731t";
	
	public static final class TARGET
	{
        /** ǵʴ 𵨸 */
        public final static int OTHER   = -1;
		/** е */
		public final static int WALLPAD = 0;
		/** κ */
		public final static int LOBBY   = 1;
	}
	
	public static int getTarget(Context context)
	{
		String PackageName = context.getPackageName();
        if(PackageName.equals(Common.WALLPAD_PACKAGENAME))
        {
            return TARGET.WALLPAD;
        }
        else if(PackageName.equals(Common.LOBBY_PACKAGENAME))
        {
        	return TARGET.LOBBY;
        }
		
		return TARGET.OTHER;
	}
    
    /** н */
    public static final class AUDIO_PATH
    {
    	public final static int NORMAL   = AudioManager.MODE_NORMAL;
    	/** е  TTS  н */
    	public final static int DOOR_TTS = 10;
    	/** е  STT  н */
    	public final static int DOOR_STT = 11;
    }
    
    /**
     * 
     * @param context
     * @param ChangeMode
     * @return
     */
    public static boolean setAudioMode(Context context, int ChangeMode)
    {
        Log.i(TAG, "[setAudioMode] ChangeMode : " + ChangeMode);
        
        if(context == null)
        {
        	Log.e(TAG, "[setAudioMode] Param : context is Null !!!");
        	return false;
        }
        
        try
        {
            AudioManager audioManager= (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
            audioManager.setMode(ChangeMode);
            return true;
        }
        catch( Exception e )
        {
            Log.e(TAG, "[Exception Error] setAudioMode");
            e.printStackTrace();
        }
        return false;
    }
    
    /**
     * sleep
     * 
     * @param time - sleep  ð (milliseconds  ð )
     */
    public static void Sleep(long time)
    {
        try{Thread.sleep(time);}
        catch(Exception e)
        {
            Log.e(TAG, "[Exception Error] Sleep ");
            e.printStackTrace();
        }
    }
    
    public Common(Context context)
    {
    }
}
