/*
 * Copyright (C) 2014 Android LobbyPhone(TCC8935) Project
 *
 * FileName : CardReaderSerialPort.java
 * Project : Android LobbyPhone(TCC8935) Project
 * Company : HDC I-CONTROLS ( www.icontrols.co.kr )
 * Author : Jeffrey Nam
 * E-mail : jeffnam0524@gmail.com, cwnam@icontrols.co.kr
 * Date : 2014.05.28
 */

package kr.co.icontrols.iencryptor.aesfp;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import android.util.Base64;
import android.util.Log;

public class AES_FingerPrint {
    static final String TAG = "AES_FingerPrint";
    
    static String strKey_HEAD = "HDCFPA";
    static String strKey_TAIL = "0101100101";   // κ +   +   (⺻ Է)
    int nLobbyDong = 102;
    int nLobbyID = 10;
    /*
    Key = "HDCFINGERPRINTACCESS" + κ +  + 
    κ  : κ (4ڸ) + κ ID(2ڸ)
      : (2ڸ)
      : (2ڸ)
     : 102 10 κ(010210), 6 21(0621)
               -> HDCFINGERPRINTACCESS0102100621
     */
    
    public static String encryptFPData(int nDong, int nID, String strFPData) {
    	try {
    		Log.i(TAG, "[encryptFPData] ========== START ==========");
    		String strEncryptedData = encryptMessage(makeEncryptionKey(strKey_HEAD, nDong, nID), strFPData);
            return strEncryptedData;
		} catch (Exception e) {
			Log.e(TAG, "[Exception] encryptFPData(int nDong, int nID, String strFPData)");
            e.printStackTrace();
            return null;
		}
    }
    
    public static String decryptFPData(int nDong, int nID, String strFPData) {
    	try {
    		Log.i(TAG, "[decryptFPData] ========== START ==========");
    		String strDecryptedData = decryptMessage(makeEncryptionKey(strKey_HEAD, nDong, nID), strFPData);
            return strDecryptedData;
		} catch (Exception e) {
			Log.e(TAG, "[Exception] decryptFPData(int nDong, int nID, String strFPData)");
            e.printStackTrace();
            return null;
		}
    }
    
    private static String encryptMessage(String strKey, String strMessage) {
        try {
//            Log.i(TAG, "[encryptMessage] strKey [" + strKey + "]");
//            Log.i(TAG, "[encryptMessage] strMessage [" + strMessage + "]");
            Cipher mCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] haKeyBytes = new byte[16];
            byte[] haSrcKeyBytes = strKey.getBytes("UTF-8");
            int nLength= haSrcKeyBytes.length;
            if (nLength > haKeyBytes.length) nLength = haKeyBytes.length;
            System.arraycopy(haSrcKeyBytes, 0, haKeyBytes, 0, nLength);
            SecretKeySpec mSecretKeySpec = new SecretKeySpec(haKeyBytes, "AES");
            IvParameterSpec mIvParameterSpec = new IvParameterSpec(haKeyBytes);
            mCipher.init(Cipher.ENCRYPT_MODE, mSecretKeySpec, mIvParameterSpec);
            byte[] haResults = mCipher.doFinal(strMessage.getBytes("UTF-8"));
            return Base64.encodeToString(haResults, 0);
        } catch (Exception e) {
            Log.e(TAG, "[Exception] encryptMessage(String strKey, String strRawMessage)");
            e.printStackTrace();
            return null;
        }
    }

    private static String decryptMessage(String strKey, String strMessage) {
        try {
//            Log.i(TAG, "[decryptMessage] strKey [" + strKey + "]");
//            Log.i(TAG, "[decryptMessage] strMessage [" + strMessage + "]");
            Cipher mCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] haKeyBytes= new byte[16];
            byte[] haSrcKeyBytes= strKey.getBytes("UTF-8");
            int nLength= haSrcKeyBytes.length;
            if (nLength > haKeyBytes.length) nLength = haKeyBytes.length;
            System.arraycopy(haSrcKeyBytes, 0, haKeyBytes, 0, nLength);
            SecretKeySpec mSecretKeySpec = new SecretKeySpec(haKeyBytes, "AES");
            IvParameterSpec mIvParameterSpec = new IvParameterSpec(haKeyBytes);
            mCipher.init(Cipher.DECRYPT_MODE, mSecretKeySpec, mIvParameterSpec);
            byte [] haResults = mCipher.doFinal(Base64.decode(strMessage, 0));
            return new String(haResults,"UTF-8");
        } catch (Exception e) {
            Log.e(TAG, "[Exception] decryptMessage(String strKey, String strRawMessage)");
            e.printStackTrace();
            return null;
        }
    }

    private static String makeEncryptionKey(String strKeyHead, int nDong, int nID) {
        try {
            String strResult = "null";
            Date mDate = new Date(System.currentTimeMillis());
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("MMdd");
            strKey_TAIL = ZeroPadding_Head(4, Integer.toString(nDong)) + ZeroPadding_Head(2, Integer.toString(nID)) + mSimpleDateFormat.format(mDate);
            strResult = strKey_HEAD + strKey_TAIL;
//            Log.i(TAG, "[makeEncryptionKey] strResult [" + strResult + "]");
            return strResult;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] makeEncryptionKey(String strKeyHead, int nDong, int nID)");
            e.printStackTrace();
            return null;
        }
    }

    private static String ZeroPadding_Head(int nOutLength, String strOriginalString) {
        String strResult = strOriginalString;
//        Log.d(TAG, "[ZeroPadding_Head] (Length) strOriginalString [" + strOriginalString.length() + "], nOutLength [" + nOutLength + "]");
        try {
            if (strOriginalString.length() < nOutLength) {
                for (int i = strOriginalString.length(); i < nOutLength; i++) {
                    strResult = "0" + strResult;
                }
//                Log.d(TAG, "[ZeroPadding_Head] strResult : " + strResult);
            } else if (strOriginalString.length() == nOutLength) {
//                Log.d(TAG, "[ZeroPadding_Head] same length!");
            } else {
//                Log.d(TAG, "[ZeroPadding_Head] strOriginalString(" + strOriginalString.length() + ") is longer than nOutLength(" + nOutLength + ")");
            }
            return strResult;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] ZeroPadding_Head(int nOutLength, String strOriginalString)");
            e.printStackTrace();
            return strResult;
        }
    }
    
    
    
    
}