/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api.impl.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.concurrent.atomic.AtomicInteger;

public class CircleProgressLayer {
    private float mStartXRatio = 0.5f;
    private float mStartYRatio = 0.5f;
    private float mRadius;
    private int mCircleWidth;
    private AtomicInteger mProgress = new AtomicInteger(0);
    private Paint paint = new Paint();
    private RectF arcRegion = new RectF();

    public CircleProgressLayer() {
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    public void setCenterPositionRatio(float x, float y) {
        this.mStartXRatio = x;
        this.mStartYRatio = y;
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
    }

    public void setCircleWidth(int circleWidth) {
        this.mCircleWidth = circleWidth;
    }

    public void setProgress(int progress) {
        this.mProgress.set(progress);
    }

    public void draw(Canvas canvas) {
        if (canvas == null || this.mRadius <= 0.0f) {
            return;
        }
        this.paint.setColor(-1315861);
        this.paint.setStrokeWidth((float)this.mCircleWidth);
        int startXPos = (int)((float)canvas.getWidth() * this.mStartXRatio);
        int startYPos = (int)((float)canvas.getHeight() * this.mStartYRatio);
        canvas.drawCircle((float)startXPos, (float)startYPos, this.mRadius, this.paint);
        int currentProgress = this.mProgress.get();
        if (currentProgress == 0) {
            return;
        }
        this.paint.setColor(-12352272);
        this.arcRegion.set((float)startXPos - this.mRadius, (float)startYPos - this.mRadius, (float)startXPos + this.mRadius, (float)startYPos + this.mRadius);
        canvas.drawArc(this.arcRegion, 270.0f, (float)(270 * currentProgress) / 100.0f, false, this.paint);
    }
}

