/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api;

import android.text.TextUtils;
import com.dialoid.speech.tts.TextToSpeech;
import java.util.Arrays;
import net.daum.mf.speech.api.TextToSpeechListener;

public class TextToSpeechClient {
    public static final String VOICE_WOMAN_READ_CALM = "WOMAN_READ_CALM";
    public static final String VOICE_MAN_READ_CALM = "MAN_READ_CALM";
    public static final String VOICE_WOMAN_DIALOG_BRIGHT = "WOMAN_DIALOG_BRIGHT";
    public static final String VOICE_MAN_DIALOG_BRIGHT = "MAN_DIALOG_BRIGHT";
    public static final int ERROR_NETWORK = 2;
    public static final int ERROR_NETWORK_TIMEOUT = 3;
    public static final int ERROR_CLIENT_INETRNAL = 5;
    public static final int ERROR_SERVER_INTERNAL = 6;
    public static final int ERROR_SERVER_TIMEOUT = 7;
    public static final int ERROR_SERVER_AUTHENTICATION = 8;
    public static final int ERROR_SERVER_SPEECH_TEXT_BAD = 9;
    public static final int ERROR_SERVER_SPEECH_TEXT_EXCESS = 10;
    public static final int ERROR_SERVER_ALLOWED_REQUESTS_EXCESS = 13;
    public static final int ERROR_SERVER_SPEECH_TEXT_FORBIDDEN = 14;
    public static final int ERROR_UNKNOWN = 99;
    private String apiKey;
    private double speechSpeed;
    private String speechVoice;
    private String speechText;
    private TextToSpeech ttsClient;
    private TextToSpeechListener listener;
    private int receivedSize;
    private int sentSize;
    private TextToSpeech.Listener internalListener = new TextToSpeech.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInactive() {
            1 var1_1 = this;
            synchronized (var1_1) {
                if (TextToSpeechClient.this.ttsClient != null) {
                    TextToSpeechClient.this.receivedSize = TextToSpeechClient.this.ttsClient.getRecvDataSizeSession();
                    TextToSpeechClient.this.sentSize = TextToSpeechClient.this.ttsClient.getSentDataSizeSession();
                }
                TextToSpeechClient.this.ttsClient = null;
            }
            if (TextToSpeechClient.this.listener != null) {
                TextToSpeechClient.this.listener.onFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int code, String message) {
            1 var3_3 = this;
            synchronized (var3_3) {
                TextToSpeechClient.this.ttsClient = null;
            }
            if (TextToSpeechClient.this.listener != null) {
                int[] errorCodes;
                int checkedCode = 0;
                for (int errorCode : errorCodes = new int[]{2, 3, 5, 6, 7, 8, 9, 10, 13, 14}) {
                    if (code != errorCode) continue;
                    checkedCode = code;
                    break;
                }
                if (checkedCode == 0) {
                    checkedCode = 99;
                }
                TextToSpeechClient.this.listener.onError(checkedCode, message);
            }
        }
    };

    public String getApiKey() {
        return this.apiKey;
    }

    public double getSpeechSpeed() {
        return this.speechSpeed;
    }

    public String getSpeechVoice() {
        return this.speechVoice;
    }

    public String getSpeechText() {
        return this.speechText;
    }

    public void setSpeechText(String text) {
        this.speechText = text;
    }

    public void setListener(TextToSpeechListener listener) {
        this.listener = listener;
    }

    TextToSpeechClient(Builder builder) {
        this.apiKey = builder.getApiKey();
        this.speechSpeed = builder.getSpeechSpeed();
        this.speechVoice = builder.getSpeechVoice();
        this.listener = builder.getListener();
    }

    public int getReceivedDataSize() {
        return this.receivedSize;
    }

    public int getSentDataSize() {
        return this.sentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaying() {
        TextToSpeechClient textToSpeechClient = this;
        synchronized (textToSpeechClient) {
            return this.ttsClient != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play() {
        if (this.isPlaying()) {
            return false;
        }
        this.receivedSize = 0;
        this.sentSize = 0;
        TextToSpeech client = TextToSpeech.getInstance();
        client.setListener(this.internalListener);
        client.setService("TTS");
        client.setServer("openapi.voice.search.daum.net", 30000);
        client.setTimeout(5000);
        client.setAPIKey(this.getApiKey());
        client.setSpeechText(this.getSpeechText());
        client.setSpeechVoice(this.getSpeechVoice());
        client.setSpeechSpeed(this.getSpeechSpeed());
        if (!client.playTTS()) {
            return false;
        }
        TextToSpeechClient textToSpeechClient = this;
        synchronized (textToSpeechClient) {
            this.ttsClient = client;
        }
        return true;
    }

    public boolean play(String speechText) {
        this.setSpeechText(speechText);
        return this.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TextToSpeechClient textToSpeechClient = this;
        synchronized (textToSpeechClient) {
            if (this.ttsClient != null) {
                this.ttsClient.cancel();
                this.ttsClient = null;
            }
        }
    }

    public static class Builder {
        private String apiKey;
        private double speechSpeed = 1.0;
        private String speechVoice = "WOMAN_READ_CALM";
        private TextToSpeechListener listener;

        public String getApiKey() {
            return this.apiKey;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public double getSpeechSpeed() {
            return this.speechSpeed;
        }

        public Builder setSpeechSpeed(double speed) {
            this.speechSpeed = speed;
            return this;
        }

        public String getSpeechVoice() {
            return this.speechVoice;
        }

        public Builder setSpeechVoice(String voice) {
            String[] voices = new String[]{TextToSpeechClient.VOICE_WOMAN_READ_CALM, TextToSpeechClient.VOICE_MAN_READ_CALM, TextToSpeechClient.VOICE_WOMAN_DIALOG_BRIGHT, TextToSpeechClient.VOICE_MAN_DIALOG_BRIGHT};
            if (Arrays.asList(voices).contains(voice)) {
                this.speechVoice = voice;
            }
            return this;
        }

        public TextToSpeechListener getListener() {
            return this.listener;
        }

        public Builder setListener(TextToSpeechListener listener) {
            this.listener = listener;
            return this;
        }

        public TextToSpeechClient build() throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)this.apiKey)) {
                throw new IllegalArgumentException("API Key is empty. You must set API key!");
            }
            return new TextToSpeechClient(this);
        }
    }
}

