/*
 * Decompiled with CFR 0.152.
 */
package com.dialoid.speech.tts;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioTrack;
import android.os.Build;
import android.util.Log;
import com.dialoid.speech.util.NativeHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TextToSpeech {
    private static final String TAG = "TextToSpeech";
    private static final int SAMPLE_RATE = 16000;
    private static final int TTS_DEFAULT_ONCE_TIME = 3200;
    private static final int TEN_MILLI_SEC_SIZE = 160;
    private MyAudioTrack audioTrack = null;
    private int receivedSpeechSize = 0;
    private String mHost = "";
    private int mPort = 0;
    private int mTimeout = 5000;
    private String mApiKey = "unknown";
    private String mAppID = "unknown";
    private String mLanguage = "ko_KR";
    private String mEncoding = "SPEEX";
    private String mService = "TTS";
    private String mUUID = "unknown";
    private String mModel = Build.HARDWARE;
    private String mOS = "Android-" + Build.VERSION.RELEASE;
    private String mSpeechText = "";
    private String mSpeechVoice = "WOMAN_READ_CALM";
    private double mSpeechSpeed = 1.0;
    private double mSpeechVolume = -1.0;
    private String mSpeechStyle = "READ";
    private String mReserve1 = "";
    private String mReserve2 = "";
    private String mReserve3 = "";
    private String mReserve4 = "";
    private String mReserve5 = "";
    private String mReserve6 = "";
    private String mReserve7 = "";
    private String mReserve8 = "";
    private String mReserve9 = "";
    private String mReserve10 = "";
    private int mEncryptTextFlag = 0;
    private int mPronMethod = 0;
    private static boolean isLoadLibrary = false;
    private static TextToSpeech mSavedTextToSpeech = null;
    private Listener mListener = null;
    private static Context mContextGet;

    public static boolean initializeLibrary(Context context) {
        if (context != null) {
            mContextGet = context;
        }
        if (isLoadLibrary) {
            return true;
        }
        String libName = "dialoid-apklib";
        String preLoadLibname = "Daumdialoid-apklib";
        try {
            System.loadLibrary(libName);
            isLoadLibrary = true;
            return true;
        }
        catch (UnsatisfiedLinkError ex1) {
            try {
                System.loadLibrary(libName);
                isLoadLibrary = true;
                return true;
            }
            catch (UnsatisfiedLinkError ex2) {
                String libraryPath = context.getCacheDir().getAbsolutePath() + "/libdialoid-apklib.so";
                String libraryPathInJar = TextToSpeech.findLibPath();
                try {
                    NativeHelper.installLibrary(libraryPathInJar, libraryPath);
                }
                catch (IOException e) {
                    return false;
                }
                try {
                    System.load(libraryPath);
                }
                catch (Exception e) {
                    return false;
                }
                isLoadLibrary = true;
                return true;
            }
        }
    }

    public static String findLibPath() {
        String strCheck = "/libs/armeabi/libdialoid-apklib";
        if (TextToSpeech.existLib(strCheck)) {
            return strCheck;
        }
        strCheck = "/lib/armeabi/libdialoid-apklib";
        if (TextToSpeech.existLib(strCheck)) {
            return strCheck;
        }
        strCheck = "/libs/armeabi-v7a/libdialoid-apklib";
        if (TextToSpeech.existLib(strCheck)) {
            return strCheck;
        }
        strCheck = "/lib/armeabi-v7a/libdialoid-apklib";
        if (TextToSpeech.existLib(strCheck)) {
            return strCheck;
        }
        return "";
    }

    public static boolean existLib(String src) {
        InputStream is = NativeHelper.class.getResourceAsStream(src);
        return is != null;
    }

    public static void finalizeLibrary() {
    }

    public static native String getVersion();

    public static native String getSessionID();

    public static TextToSpeech getInstance() {
        if (mSavedTextToSpeech == null) {
            mSavedTextToSpeech = new TextToSpeech();
        }
        return mSavedTextToSpeech;
    }

    public void setServer(String server, int port) {
        this.mHost = server;
        this.mPort = port;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void setService(String service) {
        this.mService = service;
    }

    public void setLanguage(String language) {
        this.mLanguage = language;
    }

    public void setUUID(String uuid) {
        this.mUUID = uuid;
    }

    public void setAPIKey(String apiKey) {
        this.mApiKey = apiKey;
    }

    public void setTimeout(int msec) {
        this.mTimeout = msec;
    }

    public void setSpeechText(String text) {
        this.mSpeechText = text;
    }

    public void setSpeechVoice(String voiceID) {
        this.mSpeechVoice = voiceID;
    }

    public void setSpeechSpeed(double speed) {
        this.mSpeechSpeed = speed;
    }

    public void setSpeechVolume(double volume) {
    }

    public void setSpeechStyle(String style) {
    }

    public void setReserve1(String reserve) {
        this.mReserve1 = reserve;
    }

    public void setReserve2(String reserve) {
        this.mReserve2 = reserve;
    }

    public void setReserve3(String reserve) {
        this.mReserve3 = reserve;
    }

    public void setReserve4(String reserve) {
        this.mReserve4 = reserve;
    }

    public void setReserve5(String reserve) {
        this.mReserve5 = reserve;
    }

    public void setReserve6(String reserve) {
        this.mReserve6 = reserve;
    }

    public void setReserve7(String reserve) {
        this.mReserve7 = reserve;
    }

    public void setReserve8(String reserve) {
        this.mReserve8 = reserve;
    }

    public void setReserve9(String reserve) {
        this.mReserve9 = reserve;
    }

    public void setReserve10(String reserve) {
        this.mReserve10 = reserve;
    }

    public void setEncryptTextFlag(int encryptTextFlag) {
        this.mEncryptTextFlag = encryptTextFlag;
    }

    public void setPronMethod(int prontMethod) {
        this.mPronMethod = prontMethod;
    }

    public boolean playTTS() {
        if (this.isRunning()) {
            return false;
        }
        Log.d((String)TAG, (String)" in makeTTSData()");
        try {
            PackageInfo packInfo;
            if (mContextGet.getPackageManager().getPackageInfo(mContextGet.getPackageName(), 0) != null) {
                Log.d((String)TAG, (String)"playTTS() - mContextGet.getPackageManager().getPackageInfo(mContextGet.getPackageName()) ");
            }
            if (this.makeTTSDataJNI(packInfo = mContextGet.getPackageManager().getPackageInfo(mContextGet.getPackageName(), 0))) {
                Log.d((String)TAG, (String)" makeTTSDataJNI() true");
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)"playTTS() - NameNotFoundException");
        }
        Log.d((String)TAG, (String)" makeTTSDataJNI() false");
        return false;
    }

    public boolean cancel() {
        Log.d((String)TAG, (String)"TextToSpeech.cancel()");
        if (this.audioTrack != null) {
            this.audioTrack.stop();
        }
        return this.cancelJNI();
    }

    public void join() {
        if (this.audioTrack != null) {
            this.audioTrack.join();
        }
        this.joinJNI();
    }

    public boolean isRunning() {
        if (this.audioTrack != null) {
            return this.isRunningJNI() || this.audioTrack.isRunning();
        }
        return this.isRunningJNI();
    }

    public int getSentDataSizeSession() {
        return this.getSentDataSizeSessionJNI();
    }

    public int getRecvDataSizeSession() {
        return this.getRecvDataSizeSessionJNI();
    }

    private void handleOnInactive() {
        if (this.audioTrack != null) {
            this.audioTrack.join();
        }
        this.audioTrack = null;
        if (this.mListener != null) {
            this.mListener.onInactive();
        }
    }

    private void handleOnReady() {
        this.audioTrack = new MyAudioTrack();
        this.audioTrack.play();
        if (this.mListener != null) {
            // empty if block
        }
    }

    private void handleOnSpeech(short[] data, int intDataSize) {
        if (this.audioTrack != null) {
            this.audioTrack.addSpeech(data);
        }
        if (this.mListener != null) {
            // empty if block
        }
    }

    private void handleOnSpeechEnd() {
        if (this.audioTrack != null) {
            this.audioTrack.setIsSpeechEnd(true);
        }
        if (this.mListener != null) {
            // empty if block
        }
    }

    private void handleOnTTSFileLocation(String datalocation) {
        if (this.mListener != null) {
            // empty if block
        }
    }

    private void handleOnError(int code, String message) {
        if (this.audioTrack != null) {
            this.audioTrack.stop();
            this.audioTrack.join();
        }
        this.audioTrack = null;
        if (this.mListener != null) {
            this.mListener.onError(code, message);
        }
    }

    private native boolean makeTTSDataJNI(PackageInfo var1);

    private native boolean cancelJNI();

    private native void joinJNI();

    private native boolean isRunningJNI();

    private native int getSentDataSizeSessionJNI();

    private native int getRecvDataSizeSessionJNI();

    public static class MyAudioTrack {
        private AudioTrack audioTrack = null;
        private LinkedList<short[]> queue = new LinkedList();
        private Thread thread = null;
        private boolean runFlag = false;
        private boolean isSpeechEnd = false;
        private Lock speechLock = new ReentrantLock();

        public void setIsSpeechEnd(boolean flag) {
            this.isSpeechEnd = flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSpeech(short[] speech) {
            Log.d((String)TextToSpeech.TAG, (String)("addSpeech() - size: " + speech.length));
            this.speechLock.lock();
            try {
                this.queue.add(speech);
            }
            finally {
                this.speechLock.unlock();
            }
        }

        public void play() {
            Log.d((String)TextToSpeech.TAG, (String)"MyAudioTrack.start()");
            if (this.thread != null) {
                Log.w((String)TextToSpeech.TAG, (String)"MyAudioTrack.run() - already running");
                return;
            }
            this.runFlag = true;
            this.isSpeechEnd = false;
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MyAudioTrack.this.audioTrack = new AudioTrack(3, 16000, 4, 2, 10240, 1);
                    MyAudioTrack.this.audioTrack.play();
                    int intNeedMuteTime = 0;
                    while (true) {
                        Log.d((String)TextToSpeech.TAG, (String)("Play TTS - " + this.getId() + ", runFlag: " + MyAudioTrack.this.runFlag + ", isSpeechEnd: " + MyAudioTrack.this.isSpeechEnd + ", queue size: " + MyAudioTrack.this.queue.size()));
                        if (!MyAudioTrack.this.runFlag || MyAudioTrack.this.queue.isEmpty() && MyAudioTrack.this.isSpeechEnd) break;
                        if (MyAudioTrack.this.queue.isEmpty()) {
                            try {
                                Thread.sleep(20L, 0);
                            }
                            catch (InterruptedException e) {}
                            continue;
                        }
                        short[] speech = null;
                        try {
                            MyAudioTrack.this.speechLock.lock();
                            speech = (short[])MyAudioTrack.this.queue.getFirst();
                            MyAudioTrack.this.speechLock.unlock();
                            if (speech != null && speech.length > 0) {
                                MyAudioTrack.this.audioTrack.write(speech, 0, speech.length);
                                intNeedMuteTime = 3200 - speech.length;
                            }
                            MyAudioTrack.this.speechLock.lock();
                            MyAudioTrack.this.queue.removeFirst();
                            MyAudioTrack.this.speechLock.unlock();
                        }
                        catch (NoSuchElementException e) {
                            Log.e((String)TextToSpeech.TAG, (String)"Raised NoSuchElementException in queue.getFirst()");
                            break;
                        }
                    }
                    short[] emptySpeech = new short[160];
                    for (int i = 0; i < 30; ++i) {
                        MyAudioTrack.this.audioTrack.write(emptySpeech, 0, emptySpeech.length);
                    }
                    emptySpeech = null;
                    MyAudioTrack.this.audioTrack.stop();
                    MyAudioTrack.this.audioTrack.release();
                    MyAudioTrack.this.audioTrack = null;
                    MyAudioTrack.this.queue.clear();
                }
            };
            this.thread.start();
        }

        public void stop() {
            this.runFlag = false;
            try {
                if (this.thread != null) {
                    this.thread.join();
                    this.thread = null;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void join() {
            if (this.thread != null) {
                try {
                    this.thread.join();
                    this.thread = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public boolean isRunning() {
            return this.runFlag;
        }
    }

    public static interface Listener {
        public void onInactive();

        public void onError(int var1, String var2);
    }

    public class SpeechVoice {
        public static final String WOMAN_READ_CALM = "WOMAN_READ_CALM";
        public static final String MAN_READ_CALM = "MAN_READ_CALM";
        public static final String WOMAN_DIALOG_BRIGHT = "WOMAN_DIALOG_BRIGHT";
        public static final String MAN_DIALOG_BRIGHT = "MAN_DIALOG_BRIGHT";
    }

    public class ErrorCode {
        public static final int ERROR_NONE = 0;
        public static final int ERROR_AUDIO = 1;
        public static final int ERROR_NETWORK = 2;
        public static final int ERROR_NETWORK_TIMEOUT = 3;
        public static final int ERROR_NO_RESULT = 4;
        public static final int ERROR_CLIENT_INETRNAL = 5;
        public static final int ERROR_SERVER_INTERNAL = 6;
        public static final int ERROR_SERVER_TIMEOUT = 7;
        public static final int ERROR_SERVER_AUTHENTICATION = 8;
        public static final int ERROR_SERVER_SPEECH_TEXT_BAD = 9;
        public static final int ERROR_SERVER_SPEECH_TEXT_EXCESS = 10;
        public static final int ERROR_SERVER_UNSUPPORT_SERVICE = 11;
        public static final int ERROR_SERVER_USERDICT_EMPTY = 12;
        public static final int ERROR_SERVER_ALLOWED_REQUESTS_EXCESS = 13;
        public static final int ERROR_SERVER_SPEECH_TEXT_FORBIDDEN = 14;
    }

    public class Encoding {
        public static final String SPEECH_VORBIS = "VORBIS";
        public static final String SPEECH_SPEEX = "SPEEX";
    }

    public class Language {
        public static final String LANGUAGE_KO = "ko_KR";
    }
}

