/*
 * Copyright (C) 2015 Android WallPad Project
 *
 * FileName  : TTsApi.java
 * Project   : Android WallPad Project
 * Company   : HDC I-CONTROLS ( www.icontrols.co.kr )
 * Author    : Kang Sang Ho  , lairu@icontrols.co.kr
 */

package kr.co.icontrols.sttttsapi;

import net.daum.mf.speech.api.TextToSpeechClient;
import net.daum.mf.speech.api.TextToSpeechListener;
import net.daum.mf.speech.api.TextToSpeechManager;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

/**
 * @description
 * TTS (Text To Speech ) ؽƮ  ռϿ ϱ Ͽ ϴ api ̴.
 * 
 * @import
 * kr.co.icontrols.sttttsapi.TTsApi
 */
@SuppressLint("HandlerLeak")
public class TTsApi
{
    private String TAG = "TTsAPI";
    
    private Context mContext;
    public Context getContext() { return mContext; }
    
    /** TTs  interface */
    private TTsResult Result;
    
    /** Target */
    private int mTarget = Common.TARGET.OTHER;
    
    /** ApiKey Class*/
    private ApiKey mApiKey = null;
    
    /** ռ ӵ  */
    private double mSpeechSpeed = 0.8;
    
    /**  ռ Ҹ Ÿ */
    private int mVoiceType = VOICE_TYPE.WOMAN_READ_CALM;
    
    /** ռ  ̿ϱ  Class  */
    private TextToSpeechClient mTTsClient;
    
    /**
     *  ռ Ҹ Ÿ 
     */
    public static final class VOICE_TYPE
    {
        /**  ü */
        public final static int  MAN_READ_CALM       = 0;
        /**  ü */
        public final static int  WOMAN_READ_CALM     = 1;
        /**  ȭü */
        public final static int  MAN_DIALOG_BRIGHT   = 2;
        /**  ȭü */
        public final static int  WOMAN_DIALOG_BRIGHT = 3;
        
        /**
         * Ҹ Ÿ String  ޽ ȯѴ.
         * 
         * @param Type - (int) Ҹ Ÿ
         * 
         * @return (String) ȯ ޽
         */
        public static String ToString(int Type)
        {
            String retStr;
            if(Type == MAN_READ_CALM)            retStr = TextToSpeechClient.VOICE_MAN_READ_CALM;
            else if(Type == WOMAN_READ_CALM)     retStr = TextToSpeechClient.VOICE_WOMAN_READ_CALM;
            else if(Type == MAN_DIALOG_BRIGHT)   retStr = TextToSpeechClient.VOICE_MAN_DIALOG_BRIGHT;
            else if(Type == WOMAN_DIALOG_BRIGHT) retStr = TextToSpeechClient.VOICE_WOMAN_DIALOG_BRIGHT;
            else retStr = null;
            return retStr;
        }
        
        /**
         * Ҹ Ÿ   üũѴ.
         * 
         * @param Type - (int) üũ Ҹ Ÿ
         * 
         * @return (boolean) true : , false : Ż
         */
        public static boolean Check(int Type)
        {
            if(Type == MAN_READ_CALM)            return true;
            else if(Type == WOMAN_READ_CALM)     return true;
            else if(Type == MAN_DIALOG_BRIGHT)   return true;
            else if(Type == WOMAN_DIALOG_BRIGHT) return true;
            return false;
        }
    }
    
    /**
     * @description
     * ռ   Ͼ event ó  callback interface  óϴ Ŭ̴.
     * 
     * @implements
     * net.daum.mf.speech.api.TextToSpeechListener
     */
    private class TextToSpeechListenerClass implements TextToSpeechListener
    {
        private TextToSpeechListenerClass(Context context)
        {
            Log.d(TAG, "[TextToSpeechListenerClass] - Create");
            // ռ library ʱȭ
            try
            {
                TextToSpeechManager.getInstance().initializeLibrary(context);
            }
            catch (Exception e)
            {
                Log.e(TAG, "[Exception Error] TextToSpeechListenerClass - Create");
                e.printStackTrace();
            }
        }
        
        /**
         * ҽ ʱȭ Ų.<br>
         *  ޼ҵ ݵ Activity - onDestroy ο Ѵ.<br>
         */
        public void Release()
        {
            Log.d(TAG, "[TextToSpeechListenerClass] - Release");
            // API ̻    finalizeLibrary() ȣѴ.
            try
            {
                TextToSpeechManager.getInstance().finalizeLibrary();
            }
            catch (Exception e)
            {
                Log.e(TAG, "[Exception Error] TextToSpeechListenerClass - Release");
                e.printStackTrace();
            }
        }
        
        /**  ߻  ȣȴ. */
        @Override
        public void onError(int errorCode, String errorMsg)
        {
            Log.d(TAG, "[onError]");
            
            Log.e(TAG, "[onResult] - RESULT_ERROR");
            Log.e(TAG, "             errorCode   : " + errorCode);
            Log.e(TAG, "             errorMsg    : " + errorMsg);
            Log.e(TAG, "             ErrorString : " + getErrorString(errorCode));
            
            Stop();
            mTTsClient = null;
            
            Message msg = new Message();
            msg.what = TTsResult.Error;
            msg.arg1 = errorCode;
            msg.obj = (String) errorMsg;
            mCallBackHandler.sendMessage(msg);
        }
        
        /** ռ   Ǿ  ȣȴ. */
        @Override
        public void onFinished()
        {
            Stop();
            mTTsClient = null;
            
            mCallBackHandler.sendEmptyMessage(TTsResult.Finished);
        }
        
    }
    /** ռ   Ͼ event callback infate class   */
    private TextToSpeechListenerClass mTextToSpeechListenerClass;
    
    /** CallBack ޼ҵ ó Handler */
    private Handler mCallBackHandler;
    
    /**
     * TTsApi 
     *  
     * @param context   - θ Context
     * @param result    - TTs    interface
     */
    public TTsApi(Context context, TTsResult result)
    {
        Log.i(TAG, "[Create] !!!");
        
        // 1. Input Param Check
        if(context == null)
        {
            Log.w(TAG, "[Create] 1. Input Param Check : 'context' is null");
            return;
        }
        mContext = context;
        
        if(result == null)
        {
            Log.w(TAG, "[Create] 1. Input Param Check : 'result' is null");
            return;
        }
        Result = result;
        Log.d(TAG, "[Create] 1. Input Param Check : OK");
        
        
        // 2. APIKEY initialize
        mApiKey = new ApiKey(context);
        if(mApiKey.Exist())
        {
            Log.d(TAG, "[Create] 2. APIKEY initialize : Exist true - Key : " + mApiKey.getApiKey());
        }
        else
        {
            Log.w(TAG, "[Create] 2. APIKEY initialize : Exist Fail ...");
            return;
        }
        
        // 3. getTarget
        mTarget = Common.getTarget(context);
        
        // 4. Make TextToSpeechListenerClass
        mTextToSpeechListenerClass = new TextToSpeechListenerClass(context);
        
        // 5. mCallBackHandler 
        mCallBackHandler = new Handler()
        {
            @SuppressLint("HandlerLeak")
            @Override
            public void handleMessage(Message msg)
            {
                if(msg.what == TTsResult.Finished)
                {
                    if(Result != null)
                    {
                        try
                        {
                            Result.onFinished();
                        }
                        catch (Exception e)
                        {
                            Log.e(TAG, "[Exception Error] Result.onFinished()");
                            e.printStackTrace();
                        }
                    }
                }
                else if(msg.what == TTsResult.Error)
                {
                    if(Result != null)
                    {
                        try
                        {
                            Result.onError(msg.arg1, (String)msg.obj);
                        }
                        catch (Exception e)
                        {
                            Log.e(TAG, "[Exception Error] Result.onError()");
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
    }
    
    /**
     * ҽ ʱȭ Ų.<br>
     *  ޼ҵ ݵ Activity - onDestroy ο Ѵ.<br>
     */
    public void Release()
    {
        Stop();
        try
        {
            if(mTextToSpeechListenerClass != null)
                mTextToSpeechListenerClass.Release();
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Release");
            e.printStackTrace();
        }
    }
    
    /**
     * ռ  ȮѴ.
     * 
     * @return (boolean) true:, false:߾ƴ
     */
    public boolean isPlaying()
    {
        try
        {
            if(mTTsClient == null) return false;
            return mTTsClient.isPlaying();
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] isPlaying");
            e.printStackTrace();
            return false;
        }
    }
    
    /**
     * ռ   Ѵ.
     */
    public void Stop()
    {
        try
        {
            if(mTTsClient != null) mTTsClient.stop();
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Stop");
            e.printStackTrace();
        }
        
        if(mTarget == Common.TARGET.WALLPAD)
        {
        	Common.setAudioMode(getContext(), Common.AUDIO_PATH.NORMAL);
        }
    }
    
    /**
     * ռ ӵ  Ѵ.
     * 
     * @param SpeechSpeed - (double)  ӵ ( : 0.5 ~ 4.0 , ⺻ : 1.0)
     * 
     * @return (boolean) Է Ķ üũ (true:, false: [Log.e Ȯ])
     */
    public boolean setSpeechSpeed(double SpeechSpeed)
    {
        if( !(SpeechSpeed >= 0.5 && SpeechSpeed <= 4.0) )
        {
            Log.e(TAG, "[setSpeechSpeed] Input Param : SpeechSpeed Out Of Range !!! Range : 0.5 ~ 4.0 (input:" + SpeechSpeed + ")");
            return false;            
        }
        mSpeechSpeed = SpeechSpeed;
        return true;
    }
    
    /**
     * ռ ӵ  ȮѴ.
     * 
     * @return (double) ռ ӵ 
     */
    public double getSpeechSpeed()
    {
        return mSpeechSpeed;
    }
    
    /**
     * ռ Ҹ Ÿ Ѵ.
     * 
     * @param VoiceType - (int)  ռ Ҹ Ÿ ({@link #VOICE_TYPE}  )
     * 
     * @return (boolean) Է Ķ üũ (true:, false: [Log.e Ȯ])
     */
    public boolean setVoiceType(int VoiceType)
    {
        if(!VOICE_TYPE.Check(VoiceType))
        {
            Log.e(TAG, "[setVoiceType] Input Param : VoiceType Out Of Range !!! Range : 0 ~ 3 (input:" + VoiceType + ")");
            return false;            
        }
        mVoiceType = VoiceType;
        return true;
    }
    
    /**
     * ռ Ҹ Ÿ ȮѴ.
     * 
     * @return (int) ռ Ҹ Ÿ
     */
    public int getVoiceType()
    {
        return mVoiceType;
    }
    
    /**
     * Ķͷ ־ ڿ ռϿ Ѵ.
     * 
     * @param TTsString - (String) ռ ڿ
     * 
     * @return (boolean)  (true:,  false:)
     */
    public boolean Play(String TTsString)
    {
        return Play(TTsString, mSpeechSpeed, mVoiceType);
    }
    
    /**
     * Ķͷ ־ ڿ ռϿ Ѵ.
     * 
     * @param TTsString   - (String) ռ ڿ
     * @param SpeechSpeed - (double) ռ ӵ 
     * @param VoiceType   - (int)    ռ Ҹ Ÿ ({@link #VOICE_TYPE}  )
     * 
     * @return (boolean) ռ  (true: , false:)
     */
    public boolean Play(String TTsString, double SpeechSpeed, int VoiceType)
    {
        Log.d(TAG, "[Play] " + TTsString + ", " + SpeechSpeed + ", " + VOICE_TYPE.ToString(VoiceType) );
        
        // 1. Param Check
        if(TTsString == null)
        {
            Log.e(TAG, "[Play] Input Param : TTsString is null");
            return false;
        }
        if( !(SpeechSpeed >= 0.5 && SpeechSpeed <= 4.0) )
        {
            Log.e(TAG, "[Play] Input Param : SpeechSpeed Out Of Range !!! Range : 0.5 ~ 4.0 (input:" + SpeechSpeed + ")");
            return false;            
        }
        if(!VOICE_TYPE.Check(VoiceType))
        {
            Log.e(TAG, "[Play] Input Param : VoiceType Out Of Range !!! Range : 0 ~ 3 (input:" + VoiceType + ")");
            return false;            
        }
        
        // 2. APIKey Check
        if(!mApiKey.Exist())
        {
            Log.e(TAG, "[Play] Exist Fail !!! (The package does not support)");
            return false;
        }
        
        // 3. Check isPlaying
        if (isPlaying())
        {
            Stop();
            try{Thread.sleep(100);}
            catch(Exception e) { e.printStackTrace(); }
            return false;
        }
        
        if(mTarget == Common.TARGET.WALLPAD)
        {
        	Common.setAudioMode(getContext(), Common.AUDIO_PATH.DOOR_TTS);
        	Common.Sleep(100);
        }
        
        // 4. Make mTTsClient
        try
        {
            mTTsClient = new TextToSpeechClient.Builder()
                             .setApiKey(mApiKey.getApiKey())
                             .setSpeechSpeed(SpeechSpeed)
                             .setSpeechVoice(VOICE_TYPE.ToString(VoiceType))
                             .setListener(mTextToSpeechListenerClass)
                             .build();
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Play - Make mTTsClient");
            e.printStackTrace();
            return false;
        }
        
        // 5. play
        boolean bRet = false;
        try
        {
            bRet = mTTsClient.play(TTsString);
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Play - play");
            e.printStackTrace();
            return false;
        }
        
        Log.d(TAG, "[Play] mTTsClient.play - bRet = " + bRet);
        
        return bRet;
    }
    
    /**
     * {@link SpeechRecognizerClient}  ǵ ڵ带<br>
     * ѱۿ  ȯѴ.
     * 
     * @param errorCode - (int)  
     * 
     * @return (String) ѱۿ
     */
    private String getErrorString(int errorCode)
    {
        String ErrorStr = null;
        switch(errorCode)
        {
            case TextToSpeechClient.ERROR_NETWORK:
                ErrorStr = "Ʈũ ";
                break;
            case TextToSpeechClient.ERROR_NETWORK_TIMEOUT:
                ErrorStr = "Ʈũ ";
                break;
            case TextToSpeechClient.ERROR_CLIENT_INETRNAL:
                ErrorStr = "ռ Ŭ̾Ʈ  ";
                break;
            case TextToSpeechClient.ERROR_SERVER_INTERNAL:
                ErrorStr = "ռ   ";
                break;
            case TextToSpeechClient.ERROR_SERVER_TIMEOUT:
                ErrorStr = "ռ  ִ ӽð ʰ";
                break;
            case TextToSpeechClient.ERROR_SERVER_AUTHENTICATION:
                ErrorStr = " ռ  ";
                break;
            case TextToSpeechClient.ERROR_SERVER_SPEECH_TEXT_BAD:
                ErrorStr = " ռ ؽƮ ";
                break;
            case TextToSpeechClient.ERROR_SERVER_SPEECH_TEXT_EXCESS:
                ErrorStr = " ռ ؽƮ   ʰ";
                break;
            case TextToSpeechClient.ERROR_SERVER_ALLOWED_REQUESTS_EXCESS:
                ErrorStr = " Ƚ ʰ";
                break;
            default:
                ErrorStr = "   (errorCode:" + errorCode + ")";
                break;
        }
        return ErrorStr;
    }
}
