/*
 * Decompiled with CFR 0.152.
 */
package com.sensetime.mtc;

import android.text.TextUtils;
import android.util.Pair;

public class ParamsCheckHelper {
    public static Pair<Integer, String> checkImageBuffer(byte[] imageBytes) {
        int retCode = 0;
        String errorInfo = "";
        if (imageBytes == null || imageBytes.length <= 0) {
            errorInfo = "imageBytes == null || imageBytes.length <= 0";
            retCode = -1003;
        } else if (imageBytes.length > 0x400000) {
            errorInfo = "imageBytes.length > 4 * 1024 * 1024";
            retCode = -1004;
        }
        return new Pair((Object)retCode, (Object)errorInfo);
    }

    public static Pair<Integer, String> checkImageId(String id) {
        int retCode = 0;
        String errorInfo = "";
        if (TextUtils.isEmpty((CharSequence)id)) {
            errorInfo = "id is empty";
            retCode = -1001;
        } else if (id.length() > 32) {
            errorInfo = "id bytes length > 32";
            retCode = -1002;
        } else if (id.contains("\\") || id.contains("/") || id.contains("//")) {
            errorInfo = "id.contains(\"\\\\\") || id.contains(\"/\") || id.contains(\"//\")";
            retCode = -1005;
        }
        return new Pair((Object)retCode, (Object)errorInfo);
    }
}

