/*
 * Decompiled with CFR 0.152.
 */
package com.sensetime.mtc;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.util.Log;
import com.sensetime.mtc.ApplicationUtil;
import java.util.Collections;
import java.util.HashMap;

public class MtcInitParams {
    public static final String TAG = "MtcInitParams";
    public static final int DEVICE_PRODUCT_VID_4817 = 4817;
    public static final int DEVICE_PRODUCT_PID_17185 = 17185;
    public static final int DEVICE_PRODUCT_VID_8711 = 8711;
    public static final int DEVICE_PRODUCT_PID_22 = 22;
    private final UsbManager mUsbManager = (UsbManager)ApplicationUtil.getApp().getSystemService("usb");
    private UsbDevice mUsbDevice;
    private UsbInterface mUsbInterface;
    private UsbEndpoint mEndpointOut;
    private UsbEndpoint mEndpointIn;
    private int interfaceNumber = -1;

    public int getVendorId() {
        if (this.mUsbDevice != null) {
            return this.mUsbDevice.getVendorId();
        }
        return -1;
    }

    public int getProductId() {
        if (this.mUsbDevice != null) {
            return this.mUsbDevice.getProductId();
        }
        return -1;
    }

    public int getEndPointInAddress() {
        if (this.mEndpointIn != null) {
            return this.mEndpointIn.getAddress();
        }
        return -1;
    }

    public int getEndPointOutAddress() {
        if (this.mEndpointOut != null) {
            return this.mEndpointOut.getAddress();
        }
        return -1;
    }

    public int getInterfaceNumber() {
        return this.interfaceNumber;
    }

    public MtcInitParams() {
        this.getDeviceInfo();
    }

    private void getDeviceInfo() {
        HashMap deviceList = this.mUsbManager.getDeviceList();
        if (!deviceList.isEmpty()) {
            Log.d((String)TAG, (String)("getUsbDevice deviceList=" + Collections.singletonList(deviceList)));
            for (UsbDevice device : deviceList.values()) {
                if ((device.getVendorId() != 4817 || device.getProductId() != 17185) && (device.getVendorId() != 8711 || device.getProductId() != 22)) continue;
                this.mUsbDevice = device;
                break;
            }
        }
        if (this.mUsbDevice != null) {
            for (int i = 0; i < this.mUsbDevice.getInterfaceCount(); ++i) {
                UsbInterface itemInterface = this.mUsbDevice.getInterface(i);
                if (Build.VERSION.SDK_INT >= 21 && itemInterface.getInterfaceClass() == 10 && itemInterface.getEndpointCount() == 2) {
                    this.mUsbInterface = this.mUsbDevice.getInterface(i);
                }
                if (itemInterface.getInterfaceClass() != 2) continue;
                this.interfaceNumber = i;
            }
            this.mEndpointIn = this.mUsbInterface.getEndpoint(0);
            this.mEndpointOut = this.mUsbInterface.getEndpoint(1);
        }
    }
}

