/*
 * Decompiled with CFR 0.152.
 */
package com.sensetime.mtc;

import com.google.gson.annotations.SerializedName;
import com.sensetime.mtc.DbQuality;
import com.sensetime.mtc.RecoginzeQuality;
import com.sensetime.mtc.TemperStrategy;
import java.io.Serializable;
import java.util.List;

public class AiConfig
implements Serializable {
    private static volatile AiConfig instance;
    @SerializedName(value="work_mode")
    private final int workMode = 0;
    @SerializedName(value="recognize_mode")
    private int recognizeMode = 1;
    @SerializedName(value="face_mode")
    private int faceMode = 1;
    @SerializedName(value="enable_qr_code")
    private boolean enableQrCode = false;
    @SerializedName(value="enable_track_box")
    private boolean enableTrackBox = true;
    @SerializedName(value="enable_extra_attribute")
    private boolean enableExtraAttribute = false;
    @SerializedName(value="liveness_thresh")
    private float livenessThresh = 0.995f;
    @SerializedName(value="recognition_thresh")
    private float recognitionThresh = 0.905f;
    @SerializedName(value="verify_thresh")
    private float verifyThresh = 0.6f;
    @SerializedName(value="recognition_interval")
    private int recognitionInterval = 5;
    @SerializedName(value="report_interval")
    private int reportInterval = 5;
    @SerializedName(value="max_face_cnt")
    private int maxFaceCnt = 4;
    @SerializedName(value="face_size")
    private int faceSize = 30;
    @SerializedName(value="face_size_max")
    private int faceSize_max = 800;
    @SerializedName(value="enable_feature_export")
    private boolean enableFeatureExport = false;
    @SerializedName(value="enable_image_export")
    private boolean enableImageExport = true;
    @SerializedName(value="ae_mode")
    private int aeMode = 1;
    @SerializedName(value="enable_mask_sign")
    private boolean enableMaskSign = false;
    @SerializedName(value="enable_safety_hat")
    private boolean enableSafetyHat = false;
    @SerializedName(value="track_fps")
    private int trackFps = 25;
    @SerializedName(value="temper_strategy")
    private List<TemperStrategy> temperStrategy;
    @SerializedName(value="recognize_quality_param")
    private RecoginzeQuality recoginzeQuality;
    @SerializedName(value="db_quality_param")
    private DbQuality dbQuality;
    @SerializedName(value="enable_db_mask_sign")
    private boolean enableDbMaskSign = false;
    @SerializedName(value="enable_enhanced_safety_mode")
    private int enableEnhancedSafetyMode = 0;
    @SerializedName(value="ae_flicker_freq")
    private int aeFlickerFreq = 0;

    private AiConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AiConfig getInstance() {
        if (instance != null) return instance;
        Class<AiConfig> clazz = AiConfig.class;
        synchronized (AiConfig.class) {
            if (instance != null) return instance;
            instance = new AiConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void setInstance(AiConfig aiConfig) {
        instance = aiConfig;
    }

    public boolean isValueValid() {
        if (this.recognizeMode != 0 && this.recognizeMode != 1 && this.recognizeMode != 2) {
            return false;
        }
        if (this.faceMode != 0 && this.faceMode != 1) {
            return false;
        }
        if (this.livenessThresh <= 0.0f || this.livenessThresh >= 1.0f) {
            return false;
        }
        if (this.verifyThresh <= 0.0f || this.verifyThresh >= 1.0f) {
            return false;
        }
        if (this.recognitionThresh <= 0.0f || this.recognitionThresh >= 1.0f) {
            return false;
        }
        if (this.maxFaceCnt <= 0) {
            return false;
        }
        if (this.faceSize < 10 || this.faceSize > 1000) {
            return false;
        }
        if (this.faceSize_max < 10 || this.faceSize_max > 1000) {
            return false;
        }
        if (this.reportInterval < 0 || this.reportInterval > 9) {
            return false;
        }
        if (this.aeMode != 0 && this.aeMode != 1 && this.aeMode != 2) {
            return false;
        }
        if (this.aeFlickerFreq != 0 && this.aeFlickerFreq != 50 && this.aeFlickerFreq != 60) {
            return false;
        }
        if (this.recognitionInterval < 0 || this.recognitionInterval > 9) {
            return false;
        }
        return this.enableEnhancedSafetyMode == 0 && this.enableEnhancedSafetyMode == 1;
    }

    public int getWorkMode() {
        return 0;
    }

    public int getRecognizeMode() {
        return this.recognizeMode;
    }

    public void setRecognizeMode(int recognizeMode) {
        this.recognizeMode = recognizeMode;
    }

    public int getFaceMode() {
        return this.faceMode;
    }

    public void setFaceMode(int faceMode) {
        this.faceMode = faceMode;
    }

    public boolean getEnableQrCode() {
        return this.enableQrCode;
    }

    public float getLivenessThresh() {
        return this.livenessThresh;
    }

    public void setLivenessThresh(float livenessThresh) {
        this.livenessThresh = livenessThresh;
    }

    public float getRecognitionThresh() {
        return this.recognitionThresh;
    }

    public void setRecognitionThresh(float recognitionThresh) {
        this.recognitionThresh = recognitionThresh;
    }

    public float getVerifyThresh() {
        return this.verifyThresh;
    }

    public void setVerifyThresh(float verifyThresh) {
        this.verifyThresh = verifyThresh;
    }

    public int getRecognitionInterval() {
        return this.recognitionInterval;
    }

    public void setRecognitionInterval(int recognitionInterval) {
        this.recognitionInterval = recognitionInterval;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public void setReportInterval(int reportInterval) {
        this.reportInterval = reportInterval;
    }

    public int getMaxFaceCnt() {
        return this.maxFaceCnt;
    }

    public void setMaxFaceCnt(int maxFaceCnt) {
        this.maxFaceCnt = maxFaceCnt;
    }

    public int getFaceSize() {
        return this.faceSize;
    }

    public void setFaceSize(int faceSize) {
        this.faceSize = faceSize;
    }

    public int getFaceSizeMax() {
        return this.faceSize_max;
    }

    public void setFaceSizeMax(int faceSize) {
        this.faceSize_max = faceSize;
    }

    public int getTrackFps() {
        return this.trackFps;
    }

    public void setTrackFps(int trackFps) {
        this.trackFps = trackFps;
    }

    public List<TemperStrategy> getTemperStrategy() {
        return this.temperStrategy;
    }

    public void setTemperStrategy(List<TemperStrategy> temperStrategy) {
        this.temperStrategy = temperStrategy;
    }

    public RecoginzeQuality getRecoginzeQuality() {
        return this.recoginzeQuality;
    }

    public void setRecoginzeQuality(RecoginzeQuality recoginzeQuality) {
        this.recoginzeQuality = recoginzeQuality;
    }

    public DbQuality getDbQuality() {
        return this.dbQuality;
    }

    public void setDbQuality(DbQuality dbQuality) {
        this.dbQuality = dbQuality;
    }

    public boolean isEnableQrCode() {
        return this.enableQrCode;
    }

    public void setEnableQrCode(boolean enableQrCode) {
        this.enableQrCode = enableQrCode;
    }

    public boolean isEnableTrackBox() {
        return this.enableTrackBox;
    }

    public void setEnableTrackBox(boolean enableTrackBox) {
        this.enableTrackBox = enableTrackBox;
    }

    public boolean isEnableFeatureExport() {
        return this.enableFeatureExport;
    }

    public void setEnableFeatureExport(boolean enableFeatureExport) {
        this.enableFeatureExport = enableFeatureExport;
    }

    public boolean isEnableImageExport() {
        return this.enableImageExport;
    }

    public void setEnableImageExport(boolean enableImageExport) {
        this.enableImageExport = enableImageExport;
    }

    public void setAeMode(int aeMode) {
        this.aeMode = aeMode;
    }

    public void setAeFlickerFreq(int aeFlickerFreq) {
        this.aeFlickerFreq = aeFlickerFreq;
    }

    public int getAeFlickerFreq() {
        return this.aeFlickerFreq;
    }

    public void setEnableMaskSign(boolean enableMaskSign) {
        this.enableMaskSign = enableMaskSign;
    }

    public boolean getEnableMaskSign() {
        return this.enableMaskSign;
    }

    public void setEnableSafetyHat(boolean enableSafetyHat) {
        this.enableSafetyHat = enableSafetyHat;
    }

    public boolean getEnableSafetyHat() {
        return this.enableSafetyHat;
    }

    public void setEnableDbMaskSign(boolean enableDbMaskSign) {
        this.enableDbMaskSign = enableDbMaskSign;
    }

    public boolean getEnableDbMaskSign() {
        return this.enableDbMaskSign;
    }

    public void setEnableEnhancedSafetyMode(int enableEnhancedSafetyMode) {
        this.enableEnhancedSafetyMode = enableEnhancedSafetyMode;
    }

    public int getEnableEnhancedSafetyMode() {
        return this.enableEnhancedSafetyMode;
    }
}

