/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api.impl.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.concurrent.atomic.AtomicInteger;

public class BounceLayer {
    private AtomicInteger mBounceWidth = new AtomicInteger(0);
    private float mStartXRatio = 0.5f;
    private float mStartYRatio = 0.5f;
    private float mRadius;
    private final int mBounceDecrement;
    private Paint paint = new Paint();

    public BounceLayer(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mBounceDecrement = (int)TypedValue.applyDimension((int)1, (float)1.5f, (DisplayMetrics)displayMetrics);
        this.paint.setColor(-855310);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setAntiAlias(true);
    }

    public void setCenterPositionRatio(float x, float y) {
        this.mStartXRatio = x;
        this.mStartYRatio = y;
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
    }

    public void setBounceWidth(int bounceWidth) {
        int previousBounce = this.mBounceWidth.get();
        if (previousBounce < bounceWidth) {
            this.mBounceWidth.set(bounceWidth);
        }
    }

    public void draw(Canvas canvas) {
        if (canvas == null || this.mRadius <= 0.0f) {
            return;
        }
        int currentBounceWidth = this.mBounceWidth.get();
        if (currentBounceWidth <= 0) {
            return;
        }
        this.mBounceWidth.set(currentBounceWidth - this.mBounceDecrement);
        this.paint.setStrokeWidth((float)currentBounceWidth);
        int startXPos = (int)((float)canvas.getWidth() * this.mStartXRatio);
        int startYPos = (int)((float)canvas.getHeight() * this.mStartYRatio);
        canvas.drawCircle((float)startXPos, (float)startYPos, this.mRadius + (float)(currentBounceWidth / 2), this.paint);
    }

    public void clearBounceWidth() {
        this.mBounceWidth.set(0);
    }
}

