/*
 * Decompiled with CFR 0.152.
 */
package com.dialoid.speech.recognition;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.dialoid.speech.recognition.AudioCapture;
import com.dialoid.speech.recognition.AudioCaptureFromAndroid;
import com.dialoid.speech.util.NativeHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class SpeechRecognizer {
    private static final String TAG = "SpeechRecognizer";
    private String mHost = "";
    private int mPort = 0;
    private int mTimeout = 5000;
    private int mRecordSpeechInterval = 20;
    private int mSendSpeechInterval = 100;
    private int mRecognitionInterval = 200;
    private String mApiKey = "unknown";
    private String mAppID = "unknown";
    private String mLanguage = "ko_KR";
    private String mEncoding = "ADPCM";
    private String mService = "DICTATION";
    private String mUUID = "unknown";
    private String mModel = Build.HARDWARE;
    private String mOS = "Android-" + Build.VERSION.RELEASE;
    private String mUserDict = "";
    private String mPingpongDictPath = "";
    private String mPingpongConfPath = "";
    private int mPingpongConfFlag = 0;
    private String mReserve1 = "";
    private String mReserve2 = "";
    private String mReserve3 = "";
    private String mReserve4 = "";
    private String mReserve5 = "";
    private String mReserve6 = "";
    private String mReserve7 = "";
    private String mReserve8 = "";
    private String mReserve9 = "";
    private String mReserve10 = "";
    private int mRecordingFlag = 0;
    private String mRecordingPath = "";
    private int mEncryptTextFlag = 0;
    private String mNBest = "nbest";
    private int mSampleRate = 16000;
    private static boolean isLoadLibrary = false;
    private Listener mListener = null;
    private AudioCapture mAudioCapture = null;
    private static Context mContextGet;
    private static SpeechRecognizer mSavedSpeechRecognizer;

    public static boolean initializeLibrary(Context context) {
        if (context != null) {
            mContextGet = context;
        }
        if (isLoadLibrary) {
            return true;
        }
        String libName = "dialoid-apklib";
        String preLoadLibname = "Daumdialoid-apklib";
        try {
            System.loadLibrary(libName);
            isLoadLibrary = true;
            Log.d((String)TAG, (String)("initializeLibrary() - libName:" + libName));
            return true;
        }
        catch (UnsatisfiedLinkError ex1) {
            try {
                System.loadLibrary(preLoadLibname);
                isLoadLibrary = true;
                Log.d((String)TAG, (String)("initializeLibrary() - preLoadLibname:" + preLoadLibname));
                return true;
            }
            catch (UnsatisfiedLinkError ex2) {
                String libraryPath = context.getCacheDir().getAbsolutePath() + "/libdialoid-apklib.so";
                String libraryPathInJar = SpeechRecognizer.findLibPath();
                Log.d((String)TAG, (String)("initializeLibrary() - libraryPathInJar:" + libraryPathInJar));
                try {
                    NativeHelper.installLibrary(libraryPathInJar, libraryPath);
                }
                catch (IOException e) {
                    Log.d((String)TAG, (String)("initializeLibrary() - libraryPathInJar:" + libraryPathInJar + " libraryPath:" + libraryPath));
                    Log.d((String)TAG, (String)("initializeLibrary() - e:" + e.getMessage()));
                    return false;
                }
                try {
                    System.load(libraryPath);
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)("initializeLibrary() - libraryPath:" + libraryPath));
                    Log.d((String)TAG, (String)("initializeLibrary() - e:" + e.getMessage()));
                    return false;
                }
                isLoadLibrary = true;
                return true;
            }
        }
    }

    public static String findLibPath() {
        String strCheck = "/libs/armeabi/libdialoid-apklib";
        if (SpeechRecognizer.existLib(strCheck)) {
            return strCheck;
        }
        strCheck = "/lib/armeabi/libdialoid-apklib";
        if (SpeechRecognizer.existLib(strCheck)) {
            return strCheck;
        }
        strCheck = "/libs/armeabi-v7a/libdialoid-apklib";
        if (SpeechRecognizer.existLib(strCheck)) {
            return strCheck;
        }
        strCheck = "/lib/armeabi-v7a/libdialoid-apklib";
        if (SpeechRecognizer.existLib(strCheck)) {
            return strCheck;
        }
        return "";
    }

    public static boolean existLib(String src) {
        InputStream is = NativeHelper.class.getResourceAsStream(src);
        return is != null;
    }

    public static void finalizeLibrary() {
    }

    public static native String getVersion();

    public static native String getSessionID();

    public static SpeechRecognizer getInstance() {
        if (mSavedSpeechRecognizer == null) {
            mSavedSpeechRecognizer = new SpeechRecognizer();
        }
        return mSavedSpeechRecognizer;
    }

    public static SpeechRecognizer getInstance(AudioCapture audioCapture) {
        if (mSavedSpeechRecognizer == null) {
            mSavedSpeechRecognizer = new SpeechRecognizer(audioCapture);
        }
        return mSavedSpeechRecognizer;
    }

    public SpeechRecognizer() {
        this.mAudioCapture = new AudioCaptureFromAndroid();
        this.mAudioCapture.setListener(new AudioCapture.Listener(){

            @Override
            public void onStart() {
                if (SpeechRecognizer.this.mListener != null) {
                    SpeechRecognizer.this.mListener.onReady();
                }
            }

            @Override
            public void onStop() {
            }

            @Override
            public void onRecord(short[] speech) {
                int energy = SpeechRecognizer.this.addSpeech(speech);
                SpeechRecognizer.this.handleOnEnergyChanged(energy);
            }

            @Override
            public void onError(int errorCode) {
                SpeechRecognizer.this.handleOnError(errorCode, "failed AudioRecorder");
                SpeechRecognizer.this.cancel();
            }
        });
    }

    public SpeechRecognizer(AudioCapture audioCapture) {
        this.mAudioCapture = audioCapture;
        this.mAudioCapture.setListener(new AudioCapture.Listener(){

            @Override
            public void onStart() {
                if (SpeechRecognizer.this.mListener != null) {
                    SpeechRecognizer.this.mListener.onReady();
                }
            }

            @Override
            public void onStop() {
            }

            @Override
            public void onRecord(short[] speech) {
                int energy = SpeechRecognizer.this.addSpeech(speech);
                SpeechRecognizer.this.handleOnEnergyChanged(energy);
            }

            @Override
            public void onError(int errorCode) {
                SpeechRecognizer.this.handleOnError(errorCode, "failed AudioRecorder");
                SpeechRecognizer.this.cancel();
            }
        });
    }

    public void setServer(String server, int port) {
        this.mHost = server;
        this.mPort = port;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void setService(String service) {
        if (service.equals("SERVICE_WAKEUP") || service.equals("WAKEUP")) {
            this.mService = "WAKEUP";
        } else if (service.equals("SERVICE_EIWR") || service.equals("EIWR") || service.equals("EWORD")) {
            this.mService = "EWORD";
        } else if (service.equals("SERVICE_IWR") || service.equals("WORD")) {
            this.mService = "WORD";
        } else if (service.equals("SERVICE_DICTATION") || service.equals("DICTATION")) {
            this.mService = "DICTATION";
        } else if (service.equals("SERVICE_WEB") || service.equals("WEB") || service.equals("SEARCH")) {
            this.mService = "WEB";
        } else if (service.equals("SERVICE_LOCAL") || service.equals("LOCAL")) {
            this.mService = "LOCAL";
        } else if (service.equals("SERVICE_KIDSAPP") || service.equals("KIDSAPP")) {
            this.mService = "KIDSAPP";
        } else if (service.equals("SERVICE_TEST") || service.equals("TEST")) {
            this.mService = "TEST";
        } else if (service.equals("LGUP_DICTATION")) {
            this.mService = "LGUP_DICTATION";
        } else if (service.equals("LGUP_WORD")) {
            this.mService = "LGUP_WORD";
        } else if (service.equals("LGUP_PHNNUM")) {
            this.mService = "LGUP_PHNNUM";
        }
    }

    public void setLanguage(String language) {
        this.mLanguage = language;
    }

    public void setUserDict(String userDict) {
        this.mUserDict = userDict;
    }

    public void setUUID(String uuid) {
        this.mUUID = uuid;
    }

    public void setAPIKey(String apiKey) {
        this.mApiKey = apiKey;
    }

    public void setTimeout(int msec) {
        this.mTimeout = msec;
    }

    public void setPingpongDictPath(String pingpongDictPath) {
        this.mPingpongDictPath = pingpongDictPath;
    }

    public void setReserve1(String reserve) {
        this.mReserve1 = reserve;
    }

    public void setReserve2(String reserve) {
        this.mReserve2 = reserve;
    }

    public void setReserve3(String reserve) {
        this.mReserve3 = reserve;
    }

    public void setReserve4(String reserve) {
        this.mReserve4 = reserve;
    }

    public void setReserve5(String reserve) {
        this.mReserve5 = reserve;
    }

    public void setReserve6(String reserve) {
        this.mReserve6 = reserve;
    }

    public void setReserve7(String reserve) {
        this.mReserve7 = reserve;
    }

    public void setReserve8(String reserve) {
        this.mReserve8 = reserve;
    }

    public void setReserve9(String reserve) {
        this.mReserve9 = reserve;
    }

    public void setReserve10(String reserve) {
        this.mReserve10 = reserve;
    }

    public void setPingpongConfPath(String pingpongConfPath) {
        this.mPingpongConfPath = pingpongConfPath;
    }

    public void setPingpongConfFlag(int pingpongConfFlag) {
        this.mPingpongConfFlag = pingpongConfFlag;
    }

    public void setRecordingPath(String recordingPath) {
        Log.d((String)TAG, (String)("setRecordingPath() - recordingPath : " + recordingPath));
        File path = new File(recordingPath);
        if (!path.exists() && !path.mkdirs()) {
            Log.d((String)TAG, (String)"setRecordingPath() - create directory failed");
        }
        this.mRecordingPath = recordingPath;
    }

    public void setRecordingFlag(int recordingFlag) {
        this.mRecordingFlag = recordingFlag;
    }

    public void setEncryptTextFlag(int encryptTextFlag) {
        this.mEncryptTextFlag = encryptTextFlag;
    }

    public void setNBest(String nBest) {
        this.mNBest = nBest;
    }

    public void setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
        this.mAudioCapture.initConstants(this.mSampleRate);
    }

    public boolean startListening() {
        Log.d((String)TAG, (String)"startListening()");
        try {
            PackageInfo packInfo;
            Log.d((String)TAG, (String)("startListening()" + mContextGet.getPackageName()));
            if (mContextGet.getPackageManager().getPackageInfo(mContextGet.getPackageName(), 0) != null) {
                Log.d((String)TAG, (String)"startListening() - mContextGet.getPackageManager().getPackageInfo(mContextGet.getPackageName()) ");
            }
            if (this.startListeningJNI(packInfo = mContextGet.getPackageManager().getPackageInfo(mContextGet.getPackageName(), 0))) {
                this.mAudioCapture.start();
                return true;
            }
            Log.d((String)TAG, (String)"startListening() - startListeningJNI: false");
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)"startListening() - NameNotFoundException");
        }
        return false;
    }

    public boolean stopListening() {
        return this.stopListeningJNI();
    }

    public boolean cancel() {
        this.mAudioCapture.stop();
        return this.cancelJNI();
    }

    public void join() {
        this.mAudioCapture.join();
        this.joinJNI();
    }

    public boolean isRunning() {
        return this.isRunningJNI();
    }

    public int getSentDataSizeSession() {
        return this.getSentDataSizeSessionJNI();
    }

    public int getRecvDataSizeSession() {
        return this.getRecvDataSizeSessionJNI();
    }

    private void handleOnInactive() {
        this.mAudioCapture.stop();
        this.mAudioCapture.join();
        if (this.mListener != null) {
            this.mListener.onInactive();
        }
    }

    private void handleOnReady() {
    }

    private void handleOnBeginPointDetect() {
        if (this.mListener != null) {
            this.mListener.onBeginPointDetect();
        }
    }

    private void handleOnEnergyChanged(int energy) {
        if (this.mListener != null) {
            this.mListener.onEnergyChanged(energy);
        }
    }

    private void handleOnPartialResult(String text) {
        if (this.mListener != null) {
            this.mListener.onPartialResult(text);
        }
    }

    private void handleOnEndPointDetect() {
        this.mAudioCapture.stop();
        if (this.mListener != null) {
            this.mListener.onEndPointDetect();
        }
    }

    private void handleOnFinalResult(String[] texts) {
        if (this.mListener != null) {
            this.mListener.onFinalResult(texts);
        }
    }

    private void handleOnFinalResultConf(String[] texts, int[] intAryConf) {
        if (this.mListener != null) {
            this.mListener.onFinalResultConf(texts, intAryConf);
        }
    }

    private void handleOnError(int code, String message) {
        this.mAudioCapture.stop();
        this.mAudioCapture.join();
        if (this.mListener != null) {
            this.mListener.onError(code, message);
        }
    }

    private native boolean startListeningJNI(PackageInfo var1);

    private native boolean stopListeningJNI();

    private native boolean cancelJNI();

    private native void joinJNI();

    private native boolean isRunningJNI();

    private native int addSpeech(short[] var1);

    private native int getSentDataSizeSessionJNI();

    private native int getRecvDataSizeSessionJNI();

    static {
        mSavedSpeechRecognizer = null;
    }

    public static interface Listener {
        public void onInactive();

        public void onReady();

        public void onBeginPointDetect();

        public void onPartialResult(String var1);

        public void onEndPointDetect();

        public void onFinalResult(String[] var1);

        public void onFinalResultConf(String[] var1, int[] var2);

        public void onError(int var1, String var2);

        public void onEnergyChanged(int var1);
    }

    public class ErrorCode {
        public static final int ERROR_NONE = 0;
        public static final int ERROR_AUDIO = 1;
        public static final int ERROR_NETWORK = 2;
        public static final int ERROR_NETWORK_TIMEOUT = 3;
        public static final int ERROR_NO_RESULT = 4;
        public static final int ERROR_CLIENT_INETRNAL = 5;
        public static final int ERROR_SERVER_INTERNAL = 6;
        public static final int ERROR_SERVER_TIMEOUT = 7;
        public static final int ERROR_SERVER_AUTHENTICATION = 8;
        public static final int ERROR_SERVER_SPEECH_TEXT_BAD = 9;
        public static final int ERROR_SERVER_SPEECH_TEXT_EXCESS = 10;
        public static final int ERROR_SERVER_UNSUPPORT_SERVICE = 11;
        public static final int ERROR_SERVER_USERDICT_EMPTY = 12;
        public static final int ERROR_SERVER_ALLOWED_REQUESTS_EXCESS = 13;
        public static final int ERROR_SERVER_SPEECH_TEXT_FORBIDDEN = 14;
    }

    public class Encoding {
        public static final String SPEECH_ADPCM = "ADPCM";
        public static final String SPEECH_SPEEX = "SPEEX";
    }

    public class Language {
        public static final String LANGUAGE_KO = "ko_KR";
        public static final String LANGUAGE_EN = "en_US";
        public static final String LANGUAGE_JA = "ja_JP";
    }
}

