/*
 * Decompiled with CFR 0.152.
 */
package com.dialoid.speech.recognition;

import android.media.AudioRecord;
import android.util.Log;
import com.dialoid.speech.recognition.AudioCapture;

public class AudioCaptureFromAndroid
extends AudioCapture {
    @Override
    public void start() {
        if (this.thread != null) {
            if (this.listener != null) {
                this.listener.onError(1);
            }
            return;
        }
        this.thread = new Thread(this);
        this.thread.setName("AudioCapture");
        this.thread.start();
    }

    @Override
    public void stop() {
        if (this.thread == null) {
            return;
        }
        this.runFlag = false;
    }

    @Override
    public void join() {
        if (this.thread == null) {
            return;
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Log.d((String)"AudioCapture", (String)("AudioCapture started mSamplingRate:" + this.mSamplingRate + " mSamplingBufferSize:" + this.mSamplingBufferSize));
        this.runFlag = true;
        try {
            this.audioRecord = new AudioRecord(6, this.mSamplingRate, 16, 2, this.mSamplingBufferSize);
            this.audioRecord.startRecording();
            if (this.listener != null) {
                this.listener.onStart();
            }
            while (this.runFlag) {
                this.audioRecord.read(this.speech, 0, this.mFrameSize);
                if (this.listener == null) continue;
                this.listener.onRecord(this.speech);
            }
        }
        catch (Exception e) {
            if (this.listener != null) {
                this.listener.onError(1);
            }
        }
        finally {
            if (this.audioRecord != null) {
                if (this.audioRecord.getRecordingState() == 3) {
                    this.audioRecord.stop();
                }
                if (this.audioRecord.getState() == 1) {
                    this.audioRecord.release();
                }
            }
        }
        this.thread = null;
        if (this.listener != null) {
            this.listener.onStop();
        }
        Log.d((String)"AudioCapture", (String)"AudioCapture stopped");
    }
}

