/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.os.RemoteException;
import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class WallPadDevAPI {
    String TitleStr;
    DevCtrCMD DevctrCMD;
    public TransactionMonitor TRInfo;
    public APIErrorCode ErrorCode = new APIErrorCode();

    public WallPadDevAPI() {
        this.TRInfo = new TransactionMonitor();
    }

    public void regChangedBR(String actionname) {
        String CmdStr = this.TitleStr + ";" + "REGBRAC" + ";" + actionname;
        this.SendCMD(CmdStr);
    }

    public void unregChangedBR(String actionname) {
        String param = actionname == null ? "null" : actionname;
        String CmdStr = this.TitleStr + ";" + "UNREGBRAC" + ";" + param;
        this.SendCMD(CmdStr);
    }

    public void SetLogOnOff(boolean onoff) {
        String CmdStr = this.TitleStr + ";" + "SETLOGONOFF" + ";" + onoff;
        this.SendCMD(CmdStr);
    }

    public boolean GetLogOnOff() {
        String CmdStr = this.TitleStr + ";" + "GETLOGONOFF" + ";0";
        try {
            String ret = this.SendCMD(CmdStr);
            if (ret == null) {
                return false;
            }
            String[] retlist = ret.split(";");
            if (retlist == null) {
                return false;
            }
            if (retlist.length != 2) {
                return false;
            }
            if (retlist[0].equals("SUCCESS")) {
                boolean bRet = Boolean.parseBoolean(retlist[1]);
                return bRet;
            }
            return false;
        }
        catch (Exception e) {
            Log.e((String)this.TitleStr, (String)"[Exception Error] GetLogOnOff");
            e.printStackTrace();
            return false;
        }
    }

    protected String SendCMD(String CMD) {
        String ret;
        try {
            if (this.DevctrCMD == null) {
                return "FAIL;-1000";
            }
            ret = this.DevctrCMD.Control_Device(CMD);
        }
        catch (RemoteException e) {
            Log.e((String)this.TitleStr, (String)"[RemoteException Error] SendCMD");
            e.printStackTrace();
            Object ret2 = null;
            return "EXCEPTION";
        }
        return ret;
    }

    protected int SendNReadCMD_int(String MainCMD, String SubCMD, int param1, int param2, int param3, int param4, int param5) {
        if (MainCMD == null) {
            return -1;
        }
        if (SubCMD == null) {
            return -2;
        }
        String CmdStr = String.format("%s;%s;%s:%d:%d:%d:%d:%d", this.TitleStr, MainCMD, SubCMD, param1, param2, param3, param4, param5);
        try {
            String ret = this.SendCMD(CmdStr);
            String[] retlist = ret.split(";");
            if (retlist == null) {
                return -101;
            }
            if (retlist[0].equals("SUCCESS")) {
                if (retlist.length == 1) {
                    return 0;
                }
                return Integer.parseInt(retlist[1]);
            }
            if (retlist.length >= 2) {
                this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
                return Integer.parseInt(retlist[1]);
            }
            Log.e((String)"WallPadDevAPI", (String)("[SendNReadCMD_int] Error : " + retlist[0]));
            return -101;
        }
        catch (Exception e) {
            Log.e((String)"WallPadDevAPI", (String)("[SendNReadCMD_int] Exception Error - (" + CmdStr + ")"));
            e.printStackTrace();
            return -1;
        }
    }

    protected int SendNReadCMD_int(String MainCMD, String SubCMD, byte[] param) {
        if (MainCMD == null) {
            return -1;
        }
        if (SubCMD == null) {
            return -2;
        }
        if (param == null) {
            Log.w((String)this.TitleStr, (String)"[SendNReadCMD_int] Param - param is null !!!");
            return -1;
        }
        String CmdStr = String.format("%s;%s;%s:", this.TitleStr, MainCMD, SubCMD);
        for (int i = 0; i < param.length; ++i) {
            CmdStr = CmdStr + param[i] + ":";
        }
        try {
            String ret = this.SendCMD(CmdStr);
            String[] retlist = ret.split(";");
            if (retlist == null) {
                return -101;
            }
            if (retlist[0].equals("SUCCESS")) {
                if (retlist.length == 1) {
                    return 0;
                }
                return Integer.parseInt(retlist[1]);
            }
            if (retlist.length >= 2) {
                this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
                return Integer.parseInt(retlist[1]);
            }
            Log.e((String)"WallPadDevAPI", (String)("[SendNReadCMD_int] Error : " + retlist[0]));
            return -101;
        }
        catch (Exception e) {
            Log.e((String)this.TitleStr, (String)("[SendNReadCMD_int] Exception Error - (" + CmdStr + ")"));
            e.printStackTrace();
            return -1;
        }
    }

    protected String SendNReadCMD_str(String MainCMD, String SubCMD, int param1, int param2, int param3, int param4, int param5) {
        String CmdStr = String.format("%s;%s;%s:%d:%d:%d:%d:%d", this.TitleStr, MainCMD, SubCMD, param1, param2, param3, param4, param5);
        try {
            String[] splitData;
            String ret = this.SendCMD(CmdStr);
            if (ret != null && (splitData = ret.split(";")) != null && !splitData[0].equals("SUCCESS") && splitData.length >= 2) {
                this.ErrorCode.Set_Error_Code(Integer.parseInt(splitData[1]));
            }
            return ret;
        }
        catch (Exception e) {
            Log.e((String)"WallPadDevAPI", (String)("[SendNReadCMD_str] Exception Error - (" + CmdStr + ")"));
            e.printStackTrace();
            return null;
        }
    }

    public class TransactionMonitor {
        public byte[] recentList = null;
        public int totalSuccess = 0;
        public int totalFail = 0;
        public int RecentSuccess = 0;
        public int RecentFail = 0;

        public double GetSuccessRate(boolean Total) {
            if (Total) {
                return (double)this.totalSuccess / (double)(this.totalSuccess + this.totalFail) * 100.0;
            }
            return (double)this.RecentSuccess / (double)(this.RecentSuccess + this.RecentFail) * 100.0;
        }

        public int GetTransactionList(int devID) {
            String CmdStr = WallPadDevAPI.this.TitleStr + ";" + "TRDATA" + ";" + devID;
            String ret = WallPadDevAPI.this.SendCMD(CmdStr);
            if (ret.split(";")[0].equals("SUCCESS")) {
                String[] Trdata = ret.split(";");
                try {
                    this.totalSuccess = Integer.parseInt(Trdata[1]);
                    this.totalFail = Integer.parseInt(Trdata[2]);
                    this.RecentSuccess = Integer.parseInt(Trdata[3]);
                    this.RecentFail = Integer.parseInt(Trdata[4]);
                    int totaldata = Integer.parseInt(Trdata[5]);
                    this.recentList = new byte[totaldata];
                    for (int i = 0; i < totaldata; ++i) {
                        this.recentList[i] = Byte.parseByte(Trdata[6 + i]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }
}

