/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class VentiAPI
extends WallPadDevAPI {
    private final String TAG = "VentiAPI";
    private final boolean DEBUG_LOG_ON = true;
    public DataClasses.Venti data;

    private void DebugLogOutput(String s) {
        Log.d((String)"VentiAPI", (String)s);
    }

    public VentiAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("VentiAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "VENTILATION";
        this.data = new DataClasses.Venti();
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 17) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.OnOff = Boolean.parseBoolean(retlist[index++]);
                this.data.Reservation = Boolean.parseBoolean(retlist[index++]);
                this.data.Wind = Byte.parseByte(retlist[index++]);
                this.data.Timer = Integer.parseInt(retlist[index++]);
                this.data.Fault = new DataClasses.Venti.FAULT(Byte.parseByte(retlist[index++]));
                this.data.Support = new DataClasses.Venti.SUPPORT(Byte.parseByte(retlist[index++]));
                this.data.Support2 = new DataClasses.Venti.SUPPORT2(Byte.parseByte(retlist[index++]));
                this.data.HeaterStatus = Byte.parseByte(retlist[index++]);
                this.data.HeaterTimeRemaining = Byte.parseByte(retlist[index++]);
                this.data.ByPass = Boolean.parseBoolean(retlist[index++]);
                this.data.AutoDriving = Boolean.parseBoolean(retlist[index++]);
                this.data.BathRoom = Boolean.parseBoolean(retlist[index++]);
                this.data.InnerCycle = Boolean.parseBoolean(retlist[index++]);
                this.data.OutAirClean = Boolean.parseBoolean(retlist[index++]);
                this.data.AirCleanAuto = Boolean.parseBoolean(retlist[index++]);
                this.data.Sleep = Byte.parseByte(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"VentiAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetOnOff(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetOnOff", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetWind(byte ChangeWind) {
        if (!DataClasses.Venti.WIND.CheckRange(ChangeWind)) {
            Log.w((String)"VentiAPI", (String)("[SetWind] Param : ChangeWind  Out Of Range !!!" + String.format("0x%02X", ChangeWind)));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetWind", ChangeWind, 0, 0, 0, 0);
    }

    public int SetTimer(int ChangeTimer) {
        return this.SendNReadCMD_int("SINKCTRL", "SetTimer", (byte)ChangeTimer, 0, 0, 0, 0);
    }

    public int SetReservationOnOff(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetReservationOnOff", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetReservationSchedule(byte[] ScheduleData2) {
        if (ScheduleData2 == null) {
            return -1;
        }
        if (ScheduleData2.length != 24) {
            return -2;
        }
        byte range = WIND.HI;
        if (this.data.Support2.WindowVenti) {
            range = WIND.BYPASS;
        }
        for (int i = 0; i < ScheduleData2.length; ++i) {
            if (ScheduleData2[i] <= range) continue;
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetReservationSchedule", ScheduleData2);
    }

    public byte[] GetReservationSchedule() {
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "GetReservationSchedule";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        Log.d((String)"WALLPADAPI", (String)("GetReservationSchedule cmd ret : " + ret));
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist.length != 25) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte[] Schedule = new byte[24];
                for (int i = 0; i < 24; ++i) {
                    Schedule[i] = Byte.parseByte(retlist[index++]);
                }
                return Schedule;
            }
            catch (Exception e) {
                Log.e((String)"VentiAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    public int SetHeater(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetHeater", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetByPass(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetByPass", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetFilterReset() {
        return this.SendNReadCMD_int("SINKCTRL", "SetFilterReset", 0, 0, 0, 0, 0);
    }

    public int SetAutoDriving(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAutoDriving", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetInnerCycle(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetInnerCycle", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetOutAirClean(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetOutAirClean", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetAirCleanAuto(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAirCleanAuto", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetSleepMode(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetSleepMode", ByteOnOff, 0, 0, 0, 0);
    }

    public static class WIND {
        public static byte LOW = DataClasses.Venti.WIND.LOW;
        public static byte MID = DataClasses.Venti.WIND.MID;
        public static byte HI = DataClasses.Venti.WIND.HI;
        public static byte AUTO = DataClasses.Venti.WIND.AUTO;
        public static byte BYPASS = DataClasses.Venti.WIND.BYPASS;
    }
}

