/*
* Copyright (C) 2015 Android WallPad Project
 *
 * FileName  : SttApi.java
 * Project   : Android WallPad Project
 * Company   : HDC I-CONTROLS ( www.icontrols.co.kr )
 * Author    : Kang Sang Ho  , lairu@icontrols.co.kr
 */

package kr.co.icontrols.sttttsapi;

import java.util.ArrayList;

import net.daum.mf.speech.api.SpeechRecognizeListener;
import net.daum.mf.speech.api.SpeechRecognizerClient;
import net.daum.mf.speech.api.SpeechRecognizerManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.annotation.SuppressLint;
import android.content.Context;

/**
 * @description
 * STT(Speech To Text )  ؽƮ ȯ. ν  ϴ api ̴.
 * 
 * @import
 * kr.co.icontrols.sttttsapi.SttApi
 */
@SuppressLint("HandlerLeak")
public class SttApi
{
    private String TAG = "SttApi";
    
    private Context mContext;
    public Context getContext() { return mContext; }
    
    /** STT  interface */
    private SttResult Result;
    
    /** Target */
    private int mTarget = Common.TARGET.OTHER;
    
    /** ApiKey Class*/
    private ApiKey mApiKey = null;
    
    /** ν  հ   */
    private float mAudioLevelSum   = 0.0f;
    /**
     *       հ ´.<br>
     *  ޼ҵ ν Ϸ ϵ Ѵ.
     * 
     * @return (float) AudioLevelAvg
     */
    public float getAudioLevelAvg() { return mAudioLevelSum/mAudioLevelCount; }
    
    /**     ī */
    private float mAudioLevelCount = 0;
    
    /**
     *       Ƚ(īƮ) ´.
     *  ޼ҵ ν Ϸ ϵ Ѵ.
     *  
     * @return (float) AudioLevelCount
     */
    public float getAudioLevelCount() { return mAudioLevelCount; }
    
    /**
     * ν ڵ ¸ Ѵ. 
     */
    public static final class STATUS
    {
        /**  */
        public final static int  IDLE     = 0;
        /** ν غϷ */
        public final static int  READY    = 1;
        /** ν  */
        public final static int  ING      = 2;
        
        /**
         * ¸ String  ޽ ȯѴ.
         * 
         * @param status - (int) 
         * 
         * @return (String) ȯ ޽
         */
        public static String ToDebugString(int status)
        {
            String retStr;
            if(status == IDLE)         retStr = "IDLE";
            else if(status == READY)   retStr = "READY";
            else if(status == ING)     retStr = "ING";
            else retStr = "UnDefined";
            return retStr;
        }
    }
    /** ν ڵ   */
    private int mStatus = STATUS.IDLE;
    /**
     * ν ڵ ¸ ȯѴ.
     * 
     * @return (int) ν  ({@link STATUS} Ѵ.)
     */
    public int getStatus() { return mStatus; }
    
    /**
     * ν ڵ ¸ Ѵ.
     * 
     * @param set - (int)  
     */
    private void setStatus(int set) { mStatus = set; }
    
    /**
     * @description
     * ν   Ͼ event ó  callback interface  óϴ Ŭ̴.
     * 
     * @implements
     * net.daum.mf.speech.api.SpeechRecognizeListener
     */
    private class SpeechRecognizeListenerClass implements SpeechRecognizeListener
    {
        /**
         * 
         * @param context         - θ Context
         */
        private SpeechRecognizeListenerClass(Context context)
        {
            Log.d(TAG, "[SpeechRecognizeListenerClass] - Create");
            // ν library ʱȭ
            try
            {
                SpeechRecognizerManager.getInstance().initializeLibrary(context);
            }
            catch (Exception e)
            {
                Log.e(TAG, "[Exception Error] SpeechRecognizeListenerClass - Create");
                e.printStackTrace();
            }
        }
        
        /**
         * ҽ ʱȭ Ų.<br>
         *  ޼ҵ ݵ Activity - onDestroy ο Ѵ.<br>
         */
        public void Release()
        {
            Log.d(TAG, "[SpeechRecognizeListenerClass] - Release");
            // API ̻    finalizeLibrary() ȣѴ.
            try
            {
                SpeechRecognizerManager.getInstance().finalizeLibrary();
            }
            catch (Exception e)
            {
                Log.e(TAG, "[Exception Error] SpeechRecognizeListenerClass - Release");
                e.printStackTrace();
            }
        }
        
        /**         ȣȴ. */
        @Override
        public void onAudioLevel(float v)
        {
            AddSttVol(v);
        }
        
        /** Է ۵  Ǵܵ  ȣȴ. */
        @Override
        public void onBeginningOfSpeech()
        {
        }
        
        /** Է   Ǵܵ  ȣȴ. */
        @Override
        public void onEndOfSpeech()
        {
        }
        
        /**  Ǵ ν   ִ  ȣȴ. */
        @Override
        public void onError(int errorCode, String errorMsg)
        {
            Log.d(TAG, "[onError]");
            
            Log.e(TAG, "[onResult] - RESULT_ERROR");
            Log.e(TAG, "             errorCode   : " + errorCode);
            Log.e(TAG, "             errorMsg    : " + errorMsg);
            Log.e(TAG, "             ErrorString : " + getErrorString(errorCode));
            
            ClientCancelRecordingNnull();
            
            Message msg = new Message();
            msg.what = SttResult.Error;
            msg.arg1 = errorCode;
            msg.obj = (String) errorMsg;
            mCallBackHandler.sendMessage(msg);
        }
        
        /** ν Ϸ  audio ϵ õ  ҽ  Ŀ ȣȴ. */
        @Override
        public void onFinished()
        {
            Log.d(TAG, "[onFinished]");
            ClientCancelRecordingNnull();
        }
        
        /** ν Ǵ ߿ ߰  text ִ  ޵ȴ. */
        @Override
        public void onPartialResult(String text)
        {
            if(text == null)
            {
                Log.d(TAG, "[onPartialResult] text : null....");
            }
            else
            {
                if(getStatus() != STATUS.ING) setStatus(STATUS.ING);
                
                int length = text.length();
                
                if(length <= 0)
                {
                    Log.d(TAG, "[onPartialResult] text : length 0");
                }
                else
                {
                    Log.d(TAG, "[onPartialResult] text : " + text);
                }
            }
        }
        
        /** ν  ʱȭ ϷǾ  ȣȴ. */
        @Override
        public void onReady()
        {
            Log.d(TAG, "[onReady]");
            setStatus(STATUS.READY);
            mCallBackHandler.sendEmptyMessage(SttResult.Ready);
            
            if(mTarget == Common.TARGET.WALLPAD)
            {
            	Common.setAudioMode(getContext(), Common.AUDIO_PATH.DOOR_STT);
            }
        }
        
        /** ν Ϸ 쿡 ȣȴ. */
        @Override
        public void onResults(Bundle results)
        {
            Log.d(TAG, "[onResults] Start");
            
            if(mClient == null)
            {
            	Log.d(TAG, "[onResults] mClient is null !!!");
            	return;
            }
            if(results == null)
            {
            	Log.e(TAG, "[onResults] results is null !!!");
            	return;            	
            }
            
            final StringBuilder builder = new StringBuilder();
            ArrayList<String> texts = results.getStringArrayList(SpeechRecognizerClient.KEY_RECOGNITION_RESULTS);
            ArrayList<Integer> confs = results.getIntegerArrayList(SpeechRecognizerClient.KEY_CONFIDENCE_VALUES);
            
            for (int i = 0; i < texts.size(); i++)
            {
                builder.append(texts.get(i));
                builder.append(" (");
                builder.append(confs.get(i).intValue());
                builder.append(")\n");
            }
            
            Log.i(TAG, "[onResults] builder");
            Log.i(TAG, "[onResults] " + builder.toString());
            
            if(texts.size() > 0)
            {
                String result = texts.get(0);
                Log.d(TAG, "[onResult] - RESULT_OK");
                Log.d(TAG, "             result : " + result);
                Log.d(TAG, "             AudioLevelAvg : " + getAudioLevelAvg() + ", Count : " + getAudioLevelCount());
                
                Message msg = new Message();
                msg.what = SttResult.Success;
                msg.obj = (String) result;
                mCallBackHandler.sendMessage(msg);
            }
            
            ClientCancelRecordingNnull();
        }
    }
    /** ν   Ͼ event callback interface class   */
    private SpeechRecognizeListenerClass mSpeechRecognizeListenerClass;
    
    /** CallBack ޼ҵ ó Handler */
    private Handler mCallBackHandler;
    
    /**
     * SttApi 
     *  
     * @param context   - θ Context
     * @param result    - Stt    interface
     */
    public SttApi(Context context, SttResult result)
    {
        Log.i(TAG, "[Create] !!!");
        
        // 1. Input Param Check
        if(context == null)
        {
            Log.w(TAG, "[Create] 1. Input Param Check : 'context' is null");
            return;
        }
        mContext = context;
        
        if(result == null)
        {
            Log.w(TAG, "[Create] 1. Input Param Check : 'result' is null");
            return;
        }
        Result = result;
        Log.d(TAG, "[Create] 1. Input Param Check : OK");
        
        // 2. APIKEY initialize
        mApiKey = new ApiKey(context);
        if(mApiKey.Exist())
        {
            Log.d(TAG, "[Create] 2. APIKEY initialize : Exist true - Key : " + mApiKey.getApiKey());
        }
        else
        {
            Log.w(TAG, "[Create] 2. APIKEY initialize : Exist Fail ...");
            return;
        }
        
        // 3. getTarget
        mTarget = Common.getTarget(context);
        
        // 4. Make SpeechRecognizeListenerClass
        mSpeechRecognizeListenerClass = new SpeechRecognizeListenerClass(context);
        Log.d(TAG, "[Create] 3. Make mSpeechRecognizeListenerClass : OK");
        
        // 5. Status Init
        setStatus(STATUS.IDLE);
        
        // 6. mCallBackHandler 
        mCallBackHandler = new Handler()
        {
            @SuppressLint("HandlerLeak")
            @Override
            public void handleMessage(Message msg)
            {
                if(msg.what == SttResult.Ready)
                {
                    if(Result != null)
                    {
                        try
                        {
                            Result.onReady();
                        }
                        catch (Exception e)
                        {
                            Log.e(TAG, "[Exception Error] Result.onReady()");
                            e.printStackTrace();
                        }
                    }
                }
                else if(msg.what == SttResult.Success)
                {
                    if(Result != null)
                    {
                        try
                        {
                            Result.onSuccess((String)msg.obj);
                        }
                        catch (Exception e)
                        {
                            Log.e(TAG, "[Exception Error] Result.onSuccess()");
                            e.printStackTrace();
                        }
                    }
                }
                else if(msg.what == SttResult.Error)
                {
                    if(Result != null)
                    {
                        try
                        {
                            Result.onError(msg.arg1, (String)msg.obj);
                        }
                        catch (Exception e)
                        {
                            Log.e(TAG, "[Exception Error] Result.onError()");
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
    }
    
    /**
     * ҽ ʱȭ Ų.<br>
     *  ޼ҵ ݵ Activity - onDestroy ο Ѵ.<br>
     */
    public void Release()
    {
        Cancel();
        if(mSpeechRecognizeListenerClass != null)
            mSpeechRecognizeListenerClass.Release();
    }
    
    /**
     * ν </br>
     * νĿ   {@link #Result}  Ͽ ޴´.
     * 
     * @return (boolean) true : ν  ,  false : ν  
     */
    public boolean Start()
    {
        Log.d(TAG, "Start()");
        
        // 1. Status Check
        int Status = getStatus();
        if(Status != STATUS.IDLE)
        {
            Log.w(TAG, "[Start] The Status is not IDLE. !!! (Status : " + STATUS.ToDebugString(Status) + ")");
            return false;
        }
        
        // 2. APIKey Check
        if(!mApiKey.Exist())
        {
            Log.e(TAG, "[Start] Exist Fail !!! (The package does not support)");
            return false;
        }
        
        // 3.  AudioLevel ʱȭ
        InitAudioLevel();
        
        // 4.   : 񽺴 SERVICE_TYPE_DICTATION  .
        String serviceType = SpeechRecognizerClient.SERVICE_TYPE_DICTATION;
        
        // 5. SpeechRecognizerClient.Builder 
        try
        {
            // 5.1. 
            SpeechRecognizerClient.Builder builder = new SpeechRecognizerClient.Builder()
                         .setApiKey(mApiKey.getApiKey())
                         .setServiceType(serviceType);
            
            // 5.2. GlobalTimeOut 
            builder.setGlobalTimeOut(10);
            
            // 5.3. Client  
            mClient = builder.build();
            mClient.setSpeechRecognizeListener(mSpeechRecognizeListenerClass);
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Start - SpeechRecognizerClient.Builder");
            e.printStackTrace();
            return false;
        }
        
        try
        {
            // 8. cancelRecording
            mClient.cancelRecording();
            
            // 9. startRecording
            mClient.startRecording(true);
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Start - cancelRecording & startRecording");
            e.printStackTrace();
            return false;
        }
        
        return true;
    }
    
    /**
     * ν  ϰ,  Էµ   ν Ѵ.
     */
    public void Stop()
    {
        Log.d(TAG, "Stop()");
        
        try
        {
            if(mClient != null)
            {
                mClient.stopRecording();
                setStatus(STATUS.IDLE);
            }
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Stop");
            e.printStackTrace();
        }
        
        if(mTarget == Common.TARGET.WALLPAD)
        {
        	Common.setAudioMode(getContext(), Common.AUDIO_PATH.NORMAL);
        }
    }
    
    /**
     * ν  Ѵ.
     */
    public void Cancel()
    {
        Log.d(TAG, "Cancel()");
        
        try
        {
            if(mClient != null)
            {
                mClient.cancelRecording();
                setStatus(STATUS.IDLE);
            }
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] Cancel");
            e.printStackTrace();
        }
        
        if(mTarget == Common.TARGET.WALLPAD)
        {
        	Common.setAudioMode(getContext(), Common.AUDIO_PATH.NORMAL);
        }
    }
    
    /**
     * ν  հ ϱ   ʱȭ Ѵ.
     */
    private void InitAudioLevel()
    {
        mAudioLevelSum = 0.0f;
        mAudioLevelCount = 0;
    }
    /**
     *      ޵ɶ  ȣϿ  Ѵ.
     * 
     * @param v - (float) audioLevel
     */
    private void AddSttVol(float v)
    {
        mAudioLevelSum += v;
        mAudioLevelCount++;
    }
    
    /** ν  ϱ  Ŭ  */
    private SpeechRecognizerClient mClient;
    
    /** ν ϰ null  ȯѴ.<br>
     *  ¸ IDLE  ʱȭ Ѵ. */
    private void ClientCancelRecordingNnull()
    {
        try
        {
            if (mClient != null)
            {
                mClient.cancelRecording();
                mClient = null;
            }
            setStatus(STATUS.IDLE);
        }
        catch (Exception e)
        {
            Log.e(TAG, "[Exception Error] ClientCancelRecordingNnull");
            e.printStackTrace();
        }
        
        if(mTarget == Common.TARGET.WALLPAD)
        {
        	Common.setAudioMode(getContext(), Common.AUDIO_PATH.NORMAL);
        }
    }
    
    /**
     * {@link SpeechRecognizerClient}  ǵ ڵ带<br>
     * ѱۿ  ȯѴ.
     * 
     * @param errorCode - (int)  
     * 
     * @return (String) ѱۿ
     */
    @SuppressWarnings("deprecation")
    private String getErrorString(int errorCode)
    {
        String ErrorStr = null;
        switch(errorCode)
        {
            case SpeechRecognizerClient.GLOBAL_TIMEOUT_DEFAULT:
                ErrorStr = "ü ν ð  default timeout.";
                break;
                
            case SpeechRecognizerClient.ERROR_AUDIO_FAIL:
                ErrorStr = "Է Ұϰų ũ   ʾ ";
                break;
                
            case SpeechRecognizerClient.ERROR_AUTH_FAIL:
                ErrorStr = "apikey   ";
                break;
        
            case SpeechRecognizerClient.ERROR_AUTH_TROUBLE:
                ErrorStr = "apikey      ߻ ";
                break;
                
            case SpeechRecognizerClient.ERROR_CLIENT:
                ErrorStr = "Ŭ̾Ʈ    ߻ ";
                break;
            
            case SpeechRecognizerClient.ERROR_NETWORK_FAIL:
                ErrorStr = "Ʈũ  ߻ ";
                break;
                
            case SpeechRecognizerClient.ERROR_SERVER_FAIL:
                ErrorStr = "  ߻ ";
                break;
                
            case SpeechRecognizerClient.ERROR_SERVER_TIMEOUT:
                ErrorStr = " ŸӾƿ ߻ ";
                break; 
                
            case SpeechRecognizerClient.ERROR_NO_RESULT:
                ErrorStr = "νĵ    ";
                break; 
                
            case SpeechRecognizerClient.ERROR_SERVER_UNSUPPORT_SERVICE:
                ErrorStr = " ʴ  Ÿ  ";
                break;
                
            case SpeechRecognizerClient.ERROR_SERVER_USERDICT_EMPTY:
                ErrorStr = "Էµ     ";
                break;
                
            case SpeechRecognizerClient.ERROR_SERVER_ALLOWED_REQUESTS_EXCESS:
                ErrorStr = "û  Ƚ ʰ";
                break;                
                
            case SpeechRecognizerClient.ERROR_RECOGNITION_TIMEOUT:
                ErrorStr = "ü ҿð  ŸӾƿ ߻ ";
                break;
                
            default:
                ErrorStr = "ǵ  (errorCode:" + errorCode + ")";
                break;
        }
        return ErrorStr;
    }
}
