/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api.impl.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.List;
import net.daum.mf.speech.api.SpeechRecognizerSurfaceView;
import net.daum.mf.speech.api.impl.view.BounceLayer;
import net.daum.mf.speech.api.impl.view.CircleProgressLayer;
import net.daum.mf.speech.api.impl.view.FlyingImageLayer;

public class SpecialSearchRenderer
implements SpeechRecognizerSurfaceView.Renderer {
    private int mBackgroundColor = -1;
    private final BounceLayer mBounceLayer;
    private FlyingImageLayer mFlyingImageLayer;
    private final CircleProgressLayer mCircleProgressLayer;
    private final int mRadius;
    private final int mCircleWidth;
    private final int mMaxBounceWidth;

    public SpecialSearchRenderer(Context context) {
        this.mBounceLayer = new BounceLayer(context);
        this.mFlyingImageLayer = new FlyingImageLayer(context);
        this.mCircleProgressLayer = new CircleProgressLayer();
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mRadius = (int)TypedValue.applyDimension((int)1, (float)41.0f, (DisplayMetrics)displayMetrics);
        this.mBounceLayer.setRadius(this.mRadius);
        this.mCircleProgressLayer.setRadius(this.mRadius);
        this.mCircleWidth = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
        this.mCircleProgressLayer.setCircleWidth(this.mCircleWidth);
        this.mMaxBounceWidth = (int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)displayMetrics);
    }

    @Override
    public void sizeChanged(int width, int height) {
    }

    @Override
    public void drawFrame(Canvas canvas) {
        canvas.drawColor(this.mBackgroundColor);
        this.mBounceLayer.draw(canvas);
        this.mFlyingImageLayer.draw(canvas);
        this.mCircleProgressLayer.draw(canvas);
    }

    public void setBackgroundColor(int color) {
        this.mBackgroundColor = color;
    }

    public void setStartPositionRatio(float xRatio, float yRatio) {
        this.mBounceLayer.setCenterPositionRatio(xRatio, yRatio);
        this.mFlyingImageLayer.setCenterPositionRatio(xRatio, yRatio);
        this.mCircleProgressLayer.setCenterPositionRatio(xRatio, yRatio);
    }

    public void setRandomBitmaps(List<Bitmap> bitmaps) {
        this.mFlyingImageLayer.setRandomBitmaps(bitmaps);
    }

    public void addIncrementalRandomFlyingImage(boolean randomRotation) {
        this.mFlyingImageLayer.addIncrementalRandomFlyingImage(randomRotation);
    }

    public void setBounce(float bounce) {
        this.mBounceLayer.setBounceWidth((int)((float)this.mMaxBounceWidth * bounce));
    }

    public void setProgress(int progress) {
        this.mCircleProgressLayer.setProgress(progress);
    }

    public void clearRendering() {
        this.mBounceLayer.clearBounceWidth();
        this.mCircleProgressLayer.setProgress(0);
        this.mFlyingImageLayer.clearFlyingImage();
    }

    public void clearRandomBitmaps() {
        this.mFlyingImageLayer.clearBitmaps();
    }
}

