/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api.impl.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FlyingImageLayer {
    private static final String TAG = "FlyingImageLayer";
    private ConcurrentLinkedQueue<FlyingImageItem> mFlyingImageItems = new ConcurrentLinkedQueue();
    private List<Bitmap> mRandomBitmaps;
    private final int mMoveSize;
    private final int mFadeRange;
    private float mStartXRatio = 0.5f;
    private float mStartYRatio = 0.5f;
    private final Matrix mMatrix;
    private final Paint mPaint;

    public FlyingImageLayer(Context context) {
        this.mMoveSize = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mFadeRange = this.mMoveSize * 10;
        this.mMatrix = new Matrix();
        this.mPaint = new Paint();
    }

    public void setCenterPositionRatio(float x, float y) {
        this.mStartXRatio = x;
        this.mStartYRatio = y;
    }

    public void draw(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        for (FlyingImageItem item : this.mFlyingImageItems) {
            this.drawFlyingImage(canvas, item);
        }
    }

    private void drawFlyingImage(Canvas canvas, FlyingImageItem item) {
        if (item.createdTime == 0L) {
            item.x = (int)((float)canvas.getWidth() * this.mStartXRatio);
            item.y = (int)((float)canvas.getHeight() * this.mStartYRatio);
            item.createdTime = System.currentTimeMillis();
        } else {
            item.x = (float)((double)item.x + Math.cos(item.angle) * (double)this.mMoveSize);
            item.y = (float)((double)item.y + Math.sin(item.angle) * (double)this.mMoveSize);
        }
        float xMargin = Math.min(item.x, Math.abs(item.x - (float)canvas.getWidth()));
        float yMargin = Math.min(item.y, Math.abs(item.y - (float)canvas.getHeight()));
        float minMargin = Math.min(xMargin, yMargin);
        if ((float)this.mMoveSize > minMargin) {
            this.mFlyingImageItems.remove(item);
            return;
        }
        this.mMatrix.reset();
        this.mMatrix.preTranslate(item.x - (float)item.bitmap.getWidth() * item.size / 2.0f, item.y - (float)item.bitmap.getHeight() * item.size / 2.0f);
        this.mMatrix.preScale(item.size, item.size);
        if (item.rotation > 0) {
            this.mMatrix.postRotate((float)item.rotation, item.x, item.y);
        }
        this.mPaint.reset();
        if (item.incremental) {
            int alpha;
            item.size += 0.01f;
            if (item.size > 1.0f) {
                item.size = 1.0f;
            }
            if ((alpha = (int)(200.0f * (1.0f - item.size))) < 50) {
                alpha = 50;
            }
            this.mPaint.setAlpha(alpha);
        } else {
            this.mPaint.setAlpha((int)(minMargin > (float)this.mFadeRange ? 255.0f : 255.0f * minMargin / (float)this.mFadeRange));
        }
        canvas.drawBitmap(item.bitmap, this.mMatrix, this.mPaint);
    }

    public void setRandomBitmaps(List<Bitmap> bitmaps) {
        this.mRandomBitmaps = bitmaps;
    }

    public void addIncrementalRandomFlyingImage(boolean randomRotation) {
        if (this.mRandomBitmaps == null) {
            Log.e((String)TAG, (String)"random bitmaps is null");
            return;
        }
        FlyingImageItem item = new FlyingImageItem();
        item.size = 0.2f;
        item.incremental = true;
        item.angle = new Random().nextInt(360);
        if (randomRotation) {
            item.rotation = new Random().nextInt(360);
        }
        item.bitmap = this.mRandomBitmaps.get(new Random().nextInt(this.mRandomBitmaps.size()));
        this.mFlyingImageItems.add(item);
    }

    public void clearFlyingImage() {
        this.mFlyingImageItems.clear();
    }

    public void clearBitmaps() {
        if (this.mRandomBitmaps != null) {
            this.mRandomBitmaps.clear();
            this.mRandomBitmaps = null;
        }
    }

    private static class FlyingImageItem {
        private float x;
        private float y;
        private float size;
        private boolean incremental;
        private Bitmap bitmap;
        private int rotation;
        private long createdTime;
        private int angle;

        private FlyingImageItem() {
        }
    }
}

