/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.speech.api;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.dialoid.speech.tts.TextToSpeech;
import net.daum.mf.speech.api.gen.DaumSpeechOpenApiMeta;
import net.daum.mf.speech.api.impl.util.PermissionUtils;

public final class TextToSpeechManager {
    private static volatile TextToSpeechManager instance;
    private static final String TAG = "TextToSpeechManager";
    private Context appContext;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextToSpeechManager getInstance() {
        if (instance != null) return instance;
        Class<TextToSpeechManager> clazz = TextToSpeechManager.class;
        synchronized (TextToSpeechManager.class) {
            TextToSpeechManager temp;
            if (instance != null) return instance;
            instance = temp = new TextToSpeechManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean initializeLibrary(Context context) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null!");
        }
        if (this.initialized) {
            Log.d((String)TAG, (String)"already initialized the library.");
            return true;
        }
        this.appContext = context instanceof Application ? context : context.getApplicationContext();
        TextToSpeech.initializeLibrary(context);
        if (!PermissionUtils.checkMandatoryPermission(context, "android.permission.INTERNET")) {
            return false;
        }
        if (!PermissionUtils.checkMandatoryPermission(context, "android.permission.RECORD_AUDIO")) {
            return false;
        }
        if (!PermissionUtils.checkMandatoryPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            return false;
        }
        Log.d((String)TAG, (String)("[textToSpeech] version : " + this.getVersion()));
        this.initialized = true;
        return true;
    }

    public void finalizeLibrary() {
        TextToSpeech.finalizeLibrary();
        this.initialized = false;
    }

    Context getApplicationContext() {
        return this.appContext;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getVersion() {
        return DaumSpeechOpenApiMeta.getVersion();
    }
}

