/*
 * 
 * SIP STACK FRAME CLASS
 * Copyright 2011-2012 KWANGHAESOFT LTD.
 * Creator: JGK
 * PUBLISH DATE: Dec. 2011
 * 
 */
package bssoft.stack.sip;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.*;
import java.util.Date;
import java.util.StringTokenizer;


public class SIPStack {
	//SIP STACK LOCAL PORT
	public static int SIP_LOCAL_PORT						= 5060;
	public static int SIP_SIGNAL_PORT						= 5060;
	public static int MAX_SIGNAL_PORTS						= 100; 
	//METHOD TYPE DEFINE
	public static int SIP_METHODTYPE_NONE 					= 0;
	public static int SIP_METHODTYPE_REGISTER 				= 1;
	public static int SIP_METHODTYPE_INVITE 				= 2;
	public static int SIP_METHODTYPE_CANCEL 				= 3;
	public static int SIP_METHODTYPE_BYE 					= 4;
	public static int SIP_METHODTYPE_INFO 					= 5;
	public static int SIP_METHODTYPE_OPTIONS 				= 6;
	public static int SIP_METHODTYPE_ACK 					= 7;
	public static int SIP_METHODTYPE_REFER 					= 8;
	public static int SIP_METHODTYPE_NOTIFY 				= 9;
	public static int SIP_METHODTYPE_MESSAGE 				= 10;
	public static int SIP_METHODTYPE_SUBSCRIBE 				= 11;
	public static int SIP_METHODTYPE_PRACK 					= 12;
	public static int SIP_METHODTYPE_PUBLISH				= 13;
	public static int SIP_METHODTYPE_RESPONSE				= 14;
	//HEADER TYPE DEFINE
	public static int SIP_HEADERTYPE_NONE					= 0;
	public static int SIP_HEADERTYPE_ACCEPT					= 1;
	public static int SIP_HEADERTYPE_ACCEPTENCODING			= 2;
	public static int SIP_HEADERTYPE_ACCEPTLANGUAGE			= 3;
	public static int SIP_HEADERTYPE_ALERTINFO				= 4;
	public static int SIP_HEADERTYPE_ALLOW					= 5;
	public static int SIP_HEADERTYPE_ALLOWEVENTS			= 6;
	public static int SIP_HEADERTYPE_AUTHENTICATIONINFO		= 7;
	public static int SIP_HEADERTYPE_AUTHORIZATION			= 8;
	public static int SIP_HEADERTYPE_CALLID					= 9;
	public static int SIP_HEADERTYPE_CALLINFO				= 10;
	public static int SIP_HEADERTYPE_CONTACT				= 11;
	public static int SIP_HEADERTYPE_CONTENTDISPOSITION		= 12;
	public static int SIP_HEADERTYPE_CONTENTENCODING		= 13;
	public static int SIP_HEADERTYPE_CONTENTLANGUAGE		= 14;
	public static int SIP_HEADERTYPE_CONTENTLENGTH			= 15;
	public static int SIP_HEADERTYPE_CONTENTTYPE			= 16;
	public static int SIP_HEADERTYPE_CSEQ					= 17;
	public static int SIP_HEADERTYPE_DATE					= 18;
	public static int SIP_HEADERTYPE_EVENT					= 19;
	public static int SIP_HEADERTYPE_ERRORINFO				= 20;
	public static int SIP_HEADERTYPE_EXPIRES				= 21;
	public static int SIP_HEADERTYPE_FROM					= 22;
	public static int SIP_HEADERTYPE_INREPLYTO				= 23;
	public static int SIP_HEADERTYPE_MAXFORWARDS			= 24;
	public static int SIP_HEADERTYPE_MINEXPIRES				= 25;
	public static int SIP_HEADERTYPE_MIMEVERSION			= 26;
	public static int SIP_HEADERTYPE_ORGANIZATION			= 27;
	public static int SIP_HEADERTYPE_PRIORITY				= 28;
	public static int SIP_HEADERTYPE_PROXYAUTHENTICATE		= 29;
	public static int SIP_HEADERTYPE_PROXYAUTHORIZATION		= 30;
	public static int SIP_HEADERTYPE_PROXYREQUIRE			= 31;
	public static int SIP_HEADERTYPE_PASSERTEDIDENTITY		= 32;
	public static int SIP_HEADERTYPE_RECORDROUTE			= 33;
	public static int SIP_HEADERTYPE_REPLYTO				= 34;
	public static int SIP_HEADERTYPE_REQUIRE				= 35;
	public static int SIP_HEADERTYPE_RETRYAFTER				= 36;
	public static int SIP_HEADERTYPE_ROUTE					= 37;
	public static int SIP_HEADERTYPE_SERVER					= 38;
	public static int SIP_HEADERTYPE_SUBJECT				= 39;
	public static int SIP_HEADERTYPE_SUPPORTED				= 40;
	public static int SIP_HEADERTYPE_TIMESTAMP				= 41;
	public static int SIP_HEADERTYPE_TO						= 42;
	public static int SIP_HEADERTYPE_UNSUPPORTED			= 43;
	public static int SIP_HEADERTYPE_USERAGENT				= 44;
	public static int SIP_HEADERTYPE_VIA					= 45;
	public static int SIP_HEADERTYPE_WARNING				= 46;
	public static int SIP_HEADERTYPE_WWWAUTHENTICATE		= 47;
	public static int SIP_HEADERTYPE_WwwAUTHENTICATE		= 48;
	public static String SIP_LINE_END						= "\r\n";
	public static String SIP_LINE_DOUBLEEND			    	= "\r\n\r\n";
	public static String SIP_LINE_END_SINGLE				= "\n";
	public static String USER_AGENT							= "BSSHns release 0100o";
	//MESSAGETYPE
	public static int SIP_MSGTYPE_NONE						= 0;
	public static int SIP_MSGTYPE_REQUEST					= 1;
	public static int SIP_MSGTYPE_RESPONSE					= 2;
	//REGISTER STATE DEFINE
	public static int SIP_REGSTATE_IDLE						= 0;
	public static int SIP_REGSTATE_REGISTERING				= 1;
	public static int SIP_REGSTATE_REGISTERED				= 2;
	public static int SIP_REGSTATE_UNREGISTERING			= 3;
	public static int SIP_REGSTATE_AUTHORIZING				= 4;
	public static int SIP_REGSTATE_UNAUTHORIZED				= 5;
	public static int SIP_REGSTATE_UNAVAILABLE				= 6;
	//CALL STATE DEFINE
	public static final int SIP_CALLSTATE_IDLE					= 0;
	public static final int SIP_CALLSTATE_INVITING				= 1;
	public static final int SIP_CALLSTATE_OFFERRED				= 2;
	public static final int SIP_CALLSTATE_PROCEEDING			= 3;
	public static final int SIP_CALLSTATE_PROGRESSING			= 4;
	public static final int SIP_CALLSTATE_ACCEPTED				= 5;
	public static final int SIP_CALLSTATE_REMOTEACCEPTED		= 6;
	public static final int SIP_CALLSTATE_CONNECTED				= 7;
	public static final int SIP_CALLSTATE_DISCONNECTING			= 8;
	public static final int SIP_CALLSTATE_TERMINATING			= 9;
	public static final int SIP_CALLSTATE_UNAUTHORIZED			= 10;
	public static final int SIP_CALLSTATE_CANCELLING			= 11;
	public static final int SIP_CALLSTATE_CANCELLED				= 12;
	public static final int SIP_CALLSTATE_RECANCELLING			= 13;
	public static final int SIP_CALLSTATE_CANCELREMOTEACCEPTED	= 14;
	public static final int SIP_CALLSTATE_REJECTED				= 15;
	public static final int SIP_CALLSTATE_REDIRECTED			= 16;
	public static final int SIP_CALLSTATE_UPDATING				= 20;
	public static final int SIP_CALLSTATE_UPDATEPROCEEDING		= 21;
	public static final int SIP_CALLSTATE_UPDATEPROGRESSING		= 22;
	public static final int SIP_CALLSTATE_UPDATEOFFERRED		= 23;
	public static final int SIP_CALLSTATE_UPDATEACCEPTED		= 24;
	public static final int SIP_CALLSTATE_UPDATEREJECTED		= 25;
	public static final int SIP_CALLSTATE_UPDATEREMOTEACCEPTED	= 26;
	public static final int SIP_CALLSTATE_UPDATEREMOTEREJECTED	= 27;
	public static final int SIP_CALLSTATE_UPDATEUNAUTHORIZED	= 28;
	public static final int SIP_CALLSTATE_UPDATEREDIRECTED		= 29;
	//CALL MODE DEFINE
	public static int SIP_CALLMODE_NONE						= 0;
	public static int SIP_CALLMODE_BASIC					= 1;
	public static int SIP_CALLMODE_HOLD						= 2;
	//2012 02 09
	public static int SIP_SERVICEMODE_BASIC					= 0;
	public static int SIP_SERVICEMODE_CONFERENCE			= 1;
	//CALL DIRECTION DEFINE
	public static int SIP_CALLDIRECTION_NONE				= 0;
	public static int SIP_CALLDIRECTION_IN					= 1;
	public static int SIP_CALLDIRECTION_OUT					= 2;
	//MEDIA TYPE DEFINE
	public static int SIP_MEDIATYPE_NONE					= 0;
	public static int SIP_MEDIATYPE_AUDIO					= 1;
	public static int SIP_MEDIATYPE_VIDEO					= 2;
	//CODE DEFINE
	public static int SIP_CODEC_NONE						= -1;
	public static int SIP_CODEC_G711U						= 0;
	public static int SIP_CODEC_G711A						= 8;
	public static int SIP_CODEC_G7231						= 4;
	public static int SIP_CODEC_G729						= 18;
	public static int SIP_CODEC_H263						= 34;
	public static int SIP_CODEC_H264						= 98;
	public static int PRIMARY_CODEC_AUDIO					= SIP_CODEC_G711U;//SIP_CODEC_G711U; 
	public static int PRIMARY_CODEC_VIDEO					= SIP_CODEC_H264;
	//INFO DTMF TYPE
	public static int SIP_DTMFINFO_DTMFRELAY				= 0;
	public static int SIP_DTMFINFO_DTMF					= 1;
	//
	public static int SIP_SEQUENCE_INVITE					= 1;
	public static int SIP_SEQUENCE_REGISTER				= 1;
	//MEDIA START PORT
	public static int SIP_MEDIA_INITPORT					= 3000;
	public static int SIP_MEDIA_PORTS						= 5;
	//MEDIA FLOW
	public static int SIP_MEDIAFLOW_NONE					= 0;
	public static int SIP_MEDIAFLOW_SENDRECV				= 1;
	public static int SIP_MEDIAFLOW_SENDONLY				= 2;
	public static int SIP_MEDIAFLOW_RECVONLY				= 3;
	
	public static int RTP_AUDIO_SIZE						= 1024;
	public static int RTP_VIDEO_SIZE 						= 30000;
	//
	public static boolean[] SIP_MEDIA_PORTFLAG				= new boolean[SIP_MEDIA_PORTS];
	//CALL STATE TIMEOUT DEFINE
	public static int CS_TIMEOUT_TI							= 3; //IDLE TIMEOUT
	public static int CS_TIMEOUT_T0							= 15; //INVITING TIMEOUT 
	public static int CS_TIMEOUT_T00						= 10;//1; //INVITING REPEAT TIMEOUT 2012 03 22 1->5 2012 11 29 5->10
	public static int CS_TIMEOUT_T000						= 5;//1; //Homenet INVITING TIMEOUT
	public static int CS_TIMEOUT_T1							= 30; //PROCEEDING TIMEOUT 2012 11 29 15->30
	public static int CS_TIMEOUT_T2							= 120; //PROGRESSING TIMEOUT
	public static int CS_TIMEOUT_T3							= 7; //ACCEPTED TIMEOUT
	public static int CS_TIMEOUT_T4							= 7200; //CONNECTED TIMEOUT
	public static int CS_TIMEOUT_T5							= 7; //DISCONNECTING TIMEOUT
	public static int CS_TIMEOUT_T6							= 0; //TERMINATING TIMEOUT
	public static int CS_TIMEOUT_T7							= 30; //OFFERRED TIMEOUT
	public static int CS_TIMEOUT_T8							= 7; //CANCELLING TIMEOUT
	public static int CS_TIMEOUT_T80						= 2; //RECANCELLING TIMEOUT
	
	public static int CS_TIMEOUT_RESPONSE					= 1; //MESSAGE RESPONSE TIMEOUT
	public static int NETWORKIF_CHECK_TIME					= 5;//NETWORK INTERFACE CHANGE CHECK seconds
	//2012 06 08
	public static int TEARDOWN_CODE_NORMAL					= 0;
	public static int TEARDOWN_CODE_EEREJECT				= 1;
	public static int TEARDOWN_CODE_ERREJECT				= 2;
	public static int TEARDOWN_CODE_NOTFOUND				= 3;
	public static int TEARDOWN_CODE_ERROR					= 4;
	//2012 08 10
	public static int SIP_NETIF_UNAVAILABLE					= 0;
	public static int SIP_NETIF_AVAILABLE					= 1;
	public static int SIP_NETIF_UNREACHABLE					= 2;
	//2012 07 16
	public static int REPEAT_SENDCOUNT						= 3;
	
	//
	public static int SIP_MAXMESSAGE_SIZE					= 2500;//65507;
	
	//DEVELOPEMENT CONTROL
	public static boolean SIP_MESSAGE_DEBUG					= false; 
	public static boolean SIP_CALLHANDLE_DEBUG				= false;
	
	public static Date bootTime								= new Date();
	public static int exceptionCountAtCurrentCall			= 0;
	
	//2012 04 27
	public static boolean ventureCall						= true;
	public static boolean bLimitedUse						= false;
	
	//2012 06 05
	
	//2012 08 08
	public static int BACKGROUNDIDLE_MAX_SECONDS			= 28800; // 2hours //600;//10 minutes
	//2012 08 10
	public static int networkStatus							= SIP_NETIF_UNAVAILABLE;
	//2012 08 31
	public static String generalPhoneNumber					= "";
	public static String hwModelName						= "";
	public static String hwId								= "";
	public static String firmVersion						= "";
	public static String hwImsi								= "";
	public static String hwImei								= "";
	//2013 02 19
	public static String gcmRegistId						= "";
	public static boolean bGCMRegistSend					= false;
	public static String ANDROID_API_KEY 					= "AIzaSyDZcNyOPs5iTQ9kGZaF56Ngf4eCQDzMEl0";
	//2013 02 14
	public static boolean isInternetWiMax 					= false;
	public static boolean isInternetWiFi 					= false;
	public static boolean isInternetMobile 					= false;
	public static String  localSdpIp						= "0.0.0.0";
	public static boolean usePrivateWiMax					= true;
	//2013 02 27
	public static boolean bShutdownApplication				= false;
	//2013 04 10
	public static boolean bOuttraffic						= false;
	public static boolean bIntraffic						= false;
	//2013 09 22
	public static String macAddress							= "";
	public static boolean bTtsservice						= false;
	public static boolean bSupportTts						= false;
	//
	public static int WIFI_CALL_SIGNAL_MIN					= 3;
	public static Date networkInfoCheckTime					= new Date();
	public static int	WIFI_SIGNAL_VALUE					= 0;//0-5
	public static String mobileLanguage						= "ko";
	public static boolean bActive 							= false;
	public static boolean bVibrator							= true;
	public static boolean bVibrating 						= false;
	public static int iVibrator 							= 0;//0:  1:1ȸ 2..ȸ
	public static GetIpDns	ipdns							= new GetIpDns();
	public static boolean bNetworkActive					= false;
	public static int	antenaOnStep						= 0;
	public static boolean bProximityOn						= false;
	public static int localPort								= SIP_LOCAL_PORT;
	public static String strLocalip							= null;
	public static boolean bBackgroundRunning				= false;
	public static boolean bGeneralPhoneDetected				= false;
	public static stackKey stackkey 						= new stackKey();
	public static Date 	backgroundEnteredTime				= new Date();
	public static boolean bdialContextActive				= false;
	public static UserDial userDial 						= new UserDial();
	public static int SIPCTRL_INTERVAL						= 40;
	public static boolean bVideocommunication 				= true;
	public static boolean bDirectCall 						= true;
	protected static boolean bStackLicensed 				= false;
	public static boolean bUseSendTimer						= false;
	public static boolean bUseCtrlTimer						= false;

	
	//
	
	public SIPStack() {
	}
	public static int getCSeqMethod(String s)
	{
		int iMethodType=SIP_METHODTYPE_NONE;
		int iS=s.indexOf("CSeq: ");
		int iE=0;
		if(iS>=0) iE=s.indexOf(SIPStack.SIP_LINE_END,iS);
		if(iE>0) {
		}
		else return iMethodType;
		
		String strCSEQ=s.substring(iS,iE);
		
		StringTokenizer tokenArray= new StringTokenizer(strCSEQ," ",true);
		int tokenCount=0;
		while(tokenArray.hasMoreTokens())
		{
			String token=tokenArray.nextToken();
			
			if(token.length()>0 && token.compareTo(" ")!=0)
			{
				tokenCount++;
				if(tokenCount==3)
				{
					if(token.compareTo("REGISTER")==0) 		iMethodType=SIPStack.SIP_METHODTYPE_REGISTER;
					else if(token.compareTo("INVITE")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_INVITE;
					else if(token.compareTo("CANCEL")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_CANCEL;
					else if(token.compareTo("BYE")==0) 		iMethodType=SIPStack.SIP_METHODTYPE_BYE;
					else if(token.compareTo("INFO")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_INFO;
					else if(token.compareTo("OPTIONS")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_OPTIONS;
					else if(token.compareTo("ACK")==0) 		iMethodType=SIPStack.SIP_METHODTYPE_ACK;
					else if(token.compareTo("REFER")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_REFER;
					else if(token.compareTo("NOTIFY")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_NOTIFY;
					else if(token.compareTo("MESSAGE")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_MESSAGE;
					else if(token.compareTo("SUBSCRIBE")==0) iMethodType=SIPStack.SIP_METHODTYPE_SUBSCRIBE;
					else if(token.compareTo("PRACK")==0) 	iMethodType=SIPStack.SIP_METHODTYPE_PRACK;
					break;
				}
			}
		}
		return iMethodType;
		//
	}
	public static int getRequestlineMethod(String str)
	{
		int iMethodType=SIP_METHODTYPE_NONE;
		//if(str.endsWith("\r\n")==false)
		//{
		//	return iMethodType;
		//	
		//}
		//INVITE
		if(str.startsWith("INVITE") && str.endsWith("SIP/2.0\r"))
		{

			iMethodType=SIPStack.SIP_METHODTYPE_INVITE;
		}
		//BYE
		else if(str.startsWith("BYE") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_BYE;
		}
		//ACK
		else if(str.startsWith("ACK") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_ACK;
		}
		//CANCEL
		else if(str.startsWith("CANCEL") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_CANCEL;
		}
		//OPTIONS
		else if(str.startsWith("OPTIONS") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_OPTIONS;
		}
		//INFO
		else if(str.startsWith("INFO") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_INFO;
		}
		//PRACK
		else if(str.startsWith("PRACK") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_PRACK;
		}
		//MESSAGE
		else if(str.startsWith("MESSAGE") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_MESSAGE;
		}
		//SUBSCRIBE
		else if(str.startsWith("SUBSCRIBE") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_SUBSCRIBE;
		}
		//REFER
		else if(str.startsWith("REFER") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_REFER;
		}
		//NOTIFY
		else if(str.startsWith("NOTIFY") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_NOTIFY;
		}
		//REGISTER
		else if(str.startsWith("REGISTER") && str.endsWith("SIP/2.0\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_REGISTER;
		}
		else if(str.startsWith("SIP/2.0") && str.endsWith("\r"))
		{
			iMethodType=SIPStack.SIP_METHODTYPE_RESPONSE;
		}
		return iMethodType;
	}
	public static void setLicense(String strLicense)
	{
		if(SIPStack.bLimitedUse==true)
		{
			Date currentDate	= new Date();
			int month=currentDate.getMonth()+1;
			int day=currentDate.getDate();
			int year=currentDate.getYear()+1900;
			if(year<=2016 && month<=12)
			{
				System.out.println("Ⱓ "+2016+" "+12+" Ǿ ֽϴ.");
			}
			else {
				System.out.println("Ⱓ Ǿϴ.");
				bStackLicensed=false;
				System.exit(0);
			}
		}
		String license="ֽȸƮѽ 200701243005451";
		if(strLicense.compareTo(license)==0) bStackLicensed=true;
		else {
			System.out.println("SIP ̽  ʽϴ.");
			bStackLicensed=false;
		}
		System.out.println(
				"  Ʈѽ ȨƮũԴϴ.");

	}
	//2012 08 31
	public static String getResponseDescription(int code)
	{
		switch(code)
		{
		case 100: 
			return "Trying";
		case 180:
			return "Ringing";
		case 181:
			return "Call Is Being Forwarded";
		case 182:
			return "Call Queued";
		case 183:
			return "Session Progress";
		case 200:
			return "OK";
		case 300:
			return "Multiple Choices";
		case 301:
			return "Moved Permanently";
		case 302:
			return "Moved Temporarily";
		case 305:
			return "Use Proxy";
		case 380:
			return "Alternative Service";
		case 400:
			return "Bad Request";
		case 401:
			return "Unauthorized";
		case 402:
			return "Payment Required";
		case 403:
			return "Forbidden";
		case 404:
			return "Not Found";
		case 405:
			return "Method Not Allowed";
		case 406:
			return "Not Acceptable";
		case 407:
			return "Proxy Authentication Required";
		case 408:
			return "Request Timeout";
		case 409:
			return "Conflict";
		case 410:
			return "Gone";
		case 411:
			return "Length Required";
		case 413:
			return "Request Entity Too Large";
		case 414:
			return "Request-URI Too Long";
		case 415:
			return "Unsupported Media Type";
		case 420:
			return "Bad Extension";
		case 421:
			return "Extension Required";
		case 423:
			return "Interval Too Brief";
		case 480:
			return "Temporarily Unavailable";
		case 481:
			return "Call Leg Does Not Exist";
		case 482:
			return "Loop Detected";
		case 483:
			return "Two Many Hops";
		case 484:
			return "Address Incomplete";
		case 485:
			return "Ambiguous";
		case 486:
			return "Busy Here";
		case 487:
			return "Request Canceled";
		case 488:
			return "Not Acceptable Here";
		case 500:
			return "Server Internal Error";
		case 501:
			return "Not Implemented";
		case 502:
			return "Bad Gateway";
		case 503:
			return "Service Unavailable";
		case 504:
			return "Gateway Timeout";
		case 505:
			return "Version Not Supported";
		case 600:
			return "Busy Everywhere";
		case 603:
			return "Decline";
		case 604:
			return "Does Not Exist Anywhere";
		case 606:
			return "Not Acceptable";
		default:
			break;
		}
		return "";
	}
	public static String BSSMD5Get(String data)
	{

		if(data==null||data.length()<=0) return null;//2012 03 23
		
		try 
	    { 
	    
	       SIPmd5 md = SIPmd5.getInstance(); 
	       return md.hashData(data.getBytes());
	    } 
	    catch(NoSuchAlgorithmException e) 
	    { 
	    	e.printStackTrace(System.out); 
	    	SIPStack.exceptionCountAtCurrentCall++;//2012 03 23
	    } 
		
		return null;

	}
	public static String getViaBranch()
	{

		Date today=new Date();
		return "z9hG4bK-"+today.getTime()+"-"+((int)today.getTime() % 7);
	}
	public static String newTag(String prefix)
	{

		Date today=new Date();
		return prefix+today.getTime()+"-"+today.hashCode();
	}
	public static String newTag()
	{

		Date today=new Date();
		return today.getTime()+"."+today.hashCode();
	}
	

    //
    public static int getFreeAudioRtpPort()
    {

    	//System.out.println(">>>getFreeAudioRtpPort");
    	for(int i=0;i<SIP_MEDIA_PORTS;i++)
    	{
    		if(SIP_MEDIA_PORTFLAG[i]==false) {
    			SIP_MEDIA_PORTFLAG[i]=true;
    			//System.out.println("Audio Rtp Port Allocated:"+(SIP_MEDIA_INITPORT+i*2));
    			return SIP_MEDIA_INITPORT+i*2;
    		}
    	}
    	return 0;
    }
    public static boolean freeAudioRtpPort(int port)
    {

    	//System.out.println(">>>freeAudioRtpPort");
    	int index=(port-SIP_MEDIA_INITPORT)/2;
    	if(index>=0 && index<SIP_MEDIA_PORTS) 
    	{
    		SIP_MEDIA_PORTFLAG[index]=false;
    		//System.out.println("Audio Rtp Port Freed:"+port);
    		return true;
    	}
    	return false;
    }
    public static void printAudioRtpPortInfo()
    {

    	System.out.print(">>>> RTP PORT STATUS  ");
    	for(int i=0;i<SIP_MEDIA_PORTS;i++)
    	{
    		System.out.print("  "+SIP_MEDIA_PORTFLAG[i]);
     	}
    	System.out.println("  ");
    	return;
    }
	public static String getIPV4(String host)
	{

		if(host==null || host.length()==0) return null;
		String ip=null;
		try {
			InetAddress ia=InetAddress.getByName(host);
			byte[] address = ia.getAddress();
			if(address.length==4)
			{
				int unsignedByte1 = address[0]<0 ? address[0]+256 : address[0];
				int unsignedByte2 = address[1]<0 ? address[1]+256 : address[1];
				int unsignedByte3 = address[2]<0 ? address[2]+256 : address[2];
				int unsignedByte4 = address[3]<0 ? address[3]+256 : address[3];
				ip=unsignedByte1+"."+unsignedByte2+"."+unsignedByte3+"."+unsignedByte4;
			}
			
		} catch(UnknownHostException uhe) {
			System.err.println(uhe);
			SIPStack.exceptionCountAtCurrentCall++;//2012 03 23
		} catch(Exception e)
		{
			System.err.println(e);
		}
		//System.out.println("Host:"+host+", ip:"+ip);
		return ip;
	}

	//2013 02 14
	public static boolean isPrivateIp(String ip)
	{

		if(ip==null || ip.length()<7) return false;
		
		boolean bPrivate=false;
		//private ip prefix
		//10.0.0.0 - 10.255.255.255 (10/8 prefix) 
		//172.16.0.0 - 172.31.255.255 (172.16/12 prefix) 
		//192.168.0.0 - 192.168.255.255 (192.168/16 prefix)
		StringTokenizer st= new StringTokenizer(ip,".",true);
		int tokenCount=0;
		String token=null;
		//System.out.println(">>> "+headerValue);
		int ipdigit_0=0;
		int ipdigit_1=0;
		//int ipdigit_2=0;
		//int ipdigit_3=0;
		while(st.hasMoreTokens())
		{
			token=st.nextToken().trim();
			if(token!=null && token.length()>0 
					&& token.length()<=3
					&& token.compareTo(".")!=0)
			{
				if(tokenCount==0)
				{
					ipdigit_0=Integer.parseInt(token.trim());
				}
				else if(tokenCount==1)
				{
					ipdigit_1=Integer.parseInt(token.trim());
				}
				/*
				else if(tokenCount==2)
				{
					ipdigit_2=Integer.parseInt(token.trim());
				}
				else if(tokenCount==3)
				{
					ipdigit_3=Integer.parseInt(token.trim());
				}
				*/
				tokenCount++;
			}
		}
		if(tokenCount==4)
		{
			bPrivate= ipdigit_0==10 || 
					(ipdigit_0==172 && ipdigit_1>=16 && ipdigit_1<=31) ||
					(ipdigit_0==192 && ipdigit_1==168);
		}

		return bPrivate;
	}
	//
	public static boolean getLicensed(){
		return bStackLicensed;
	}
    //


}//class SIPStack