/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kr.co.icontrols.wallpadsupport.Version;

public class WallpadDeviceSet
extends wallpaddbmgr {
    private final String TAG = "WallpadDeviceSet";
    public static final String DEV_ID_THERMO = "thermostat";
    public static final String DEV_ID_LIGHT = "light";
    public static final String DEV_ID_GAS = "gas";
    public static final String DEV_ID_BATCHLIGHT = "batchlight";
    public static final String DEV_ID_CURTAIN = "curtain";
    public static final String DEV_ID_VENTIL = "ventil";
    public static final String DEV_ID_DOORLOCK = "doorlock";
    public static final String DEV_ID_AIRCON = "aircon";
    public static final String DEV_ID_REMOTEMETER = "RemoteMeter";
    public static final String DEV_ID_RFDOORCAM = "RfDoorCam";
    public static final String DEV_ID_REMOTECON = "Remotecon";
    public static final String DEV_ID_SUBPHONE = "subphone";
    public static final String DEV_ID_SMARTSW = "SmartSwitch";
    public static final String DEV_ENABLE = "enable";
    public static final String DEV_DISABLE = "disable";
    private static String[][] SubDevInitData = new String[][]{{"thermostat", "\uc628\ub3c4\uc870\uc808\uae30", "1", "0", "\uac01\ubc29", "enable", "enable"}, {"light", "\uc870\uba85\uc81c\uc5b4\uae30", "1", "0", "\uac70\uc2e4", "enable", "enable"}, {"gas", "\uac00\uc2a4\ubc38\ube0c", "1", "0", "\uc8fc\ubc29", "enable", "enable"}, {"batchlight", "\uc77c\uad04\uc18c\ub4f1", "1", "0", "none", "enable", "enable"}, {"curtain", "\uc804\ub3d9\ucee4\ud2bc", "1", "0", "none", "disable", "enable"}, {"ventil", "\ud658\uae30\uc2dc\uc2a4\ud15c", "1", "0", "none", "enable", "enable"}, {"doorlock", "\ub514\uc9c0\ud138\ub3c4\uc5b4\ub77d", "1", "0", "none", "disable", "enable"}, {"aircon", "\uc2dc\uc2a4\ud15c\uc5d0\uc5b4\ucee8", "1", "0", "none", "disable", "enable"}, {"RemoteMeter", "\uc6d0\uaca9\uac80\uce68", "1", "0", "none", "disable", "enable"}, {"RfDoorCam", "RF\ub3c4\uc5b4\ucea0", "1", "0", "none", "disable", "enable"}, {"Remotecon", "\ub9ac\ubaa8\ucf58", "1", "0", "none", "disable", "enable"}, {"subphone", "\uc11c\ube0c\ud3f0", "1", "0", "none", "enable", "enable"}, {"SmartSwitch", "\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58", "1", "0", "none", "disable", "enable"}};
    public static final int DO_NOT_USE = 0;
    public static final int DO_USE = 1;
    public static final int LIGHT_TYPE_LIVING = 11;
    public static final int LIGHT_TYPE_ROOM = 12;
    public static final int LIGHT_TYPE_HDC_INTLIGHT_NORMAL = 15;
    public static final int LIGHT_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT = 16;
    public static final int LIGHT_TYPE_ZEROENERGY_ENERGYMETER = 17;
    public static final int LIGHT_TYPE_SMART_DISTRIBUTION = 18;
    public int mModelType = Version.getModelType();
    public static final int BATCH_TYPE_GENERAL = 21;
    public static final int BATCH_TYPE_SMART = 22;
    public static final int BATCH_TYPE_HDC_OLD_SMART = 25;
    public static final int BATCH_TYPE_HDC_LCD_SMART = 26;
    public static final int DOORLOCK_TYPE_NORMAL = 31;
    public static final int DOORLOCK_TYPE_RF = 32;
    public static final int DOORLOCK_TYPE_FINGERPRINT = 33;
    public static final int VENTIL_TYPE_NORMAL = 31;
    public static final int VENTIL_TYPE_LH = 32;
    public static final int VENTIL_TYPE_HOOD = 33;
    public static final int ELEVATOR_NONE = 51;
    public static final int ELEVATOR_SIMPLE = 52;
    public static final int ELEVATOR_FLOOR = 53;
    public static final String MAIN_GUI_TYPE_DEFAULT = "\uae30\ubcf8";
    public static final String MAIN_GUI_TYPE_METRO = "\uba54\ud2b8\ub85c";
    public static final String MAIN_GUI_TYPE_HYOSUNG_CTR_ON = "\ud6a8\uc131-\uc81c\uc5b4\uc788\uc74c";
    public static final String MAIN_GUI_TYPE_HYOSUNG_CTR_OFF = "\ud6a8\uc131-\uc81c\uc5b4\uc5c6\uc74c";
    public static final String MAIN_GUI_TYPE_HIMCHAN = "\ud798\ucc2c";
    public static final int DOORTYPE_BASIC = 51;
    public static final int DOORTYPE_RFCAM = 52;
    public static final int DOORTYPE_SMARTKEY = 53;
    public static final int DOORTYPE_UKS = 54;
    public static final int DOORTYPE_ETC = 55;
    public static final int DOORTYPE_IOT_SMART = 56;
    public static final int DOORTYPE_HYOSUNG_SMART = 57;
    public static final int DOORTYPE_DAEWOO_SMART = 58;
    public static final int CURTAIN_TYPE_ROOM = 41;
    public static final int CURTAIN_TYPE_LIVING = 42;
    public static final int CURTAIN_TYPE_ALL = 43;
    public static final int SET_IN_MOTION = 1;
    public static final int SET_OUT_MOTION = 2;
    public static final int SET_OUT_TO_IN_MOTION = 4;
    int[] volindextbl = new int[]{-1, 19, 26, 31, 35, 40, 43, 46, 48, 52, 56};
    public static final int HANDICAPPED_MODE_NORMAL = 0;
    public static final int HANDICAPPED_MODE_HEARING = 1;
    public static final int HANDICAPPED_MODE_BLIND = 2;
    public static final int HANDICAPPED_DO_NOT_USE = 0;
    public static final int HANDICAPPED_USE = 1;
    public static final int BLACK_TYPE = 0;
    public static final int COLOR_TYPE = 1;
    public static final int BLESMARTKEY_NONUSE = 61;
    public static final int BLESMARTKEY_KEY = 62;
    public static final int BLESMARTKEY_BAND = 63;
    public static final int DEV_DATA_NONE = 0;
    public static final int DEV_DATA_DISABLE = 1;
    public static final int DEV_DATA_ENABLE = 2;
    public static final int DEV_DATA_ERROR = 3;
    public static final int SUBWPD_CTR_NONUSE = 71;
    public static final int SUBWPD_CTR_MAINREQ = 72;
    public static final int SUBWPD_CTR_DIRECT = 73;
    private static Pattern mPattern = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public WallpadDeviceSet(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("SettingDB")) {
            try {
                this.wdb.execSQL("create table SettingDB (type  text, name text unique, cnt INTEGER, value text);");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.CheckTableExist("SubDeviceDB")) {
            try {
                this.wdb.execSQL("create table SubDeviceDB (id text unique, name  text, devcnt text, cnt text, loc text, enable text, lononoff text);");
                this.initSubDeviceTBL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int[] Get_Light_info() {
        String[] GetData = this.GetSettingData("\uc870\uba85\uc81c\uc5b4\uae30");
        int[] returnData = new int[]{1, 11, 6};
        if (this.mModelType == 11100) {
            returnData[1] = 16;
            returnData[2] = 5;
        }
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (this.mModelType == 11100) {
                returnData[1] = GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc77c\uccb4\ud615\uc870\uba85\uae30\ubcf8\ud615") > 0 ? 15 : (GetData[1].indexOf("\uc2a4\ub9c8\ud2b8\ubd84\uc804\ubc18\uc870\uba85") > 0 ? 18 : 16);
            } else if (this.mModelType == 31100 || this.mModelType == 31120 || this.mModelType == 31170) {
                if (GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc77c\uccb4\ud615\uc870\uba85\uae30\ubcf8\ud615") > 0) {
                    returnData[1] = 15;
                } else if (GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc77c\uccb4\ud615\uc870\uba85\uc77c\uad04\uc18c\ub4f1\ubcd1\ud569\ud615") > 0) {
                    returnData[1] = 16;
                } else if (GetData[1].indexOf("\ub300\uc678\uac01\uc2e4\ud615") > 0) {
                    returnData[1] = 12;
                } else if (GetData[1].indexOf("\ub300\uc678\uae30\ubcf8\ud615") > 0) {
                    returnData[1] = 11;
                }
            } else {
                returnData[1] = GetData[1].indexOf("\ub300\uc678\uac01\uc2e4\ud615") > 0 ? 12 : 11;
            }
            String GetCount = GetData[1].split("[(]")[1].split("[:]")[0];
            GetCount = GetCount.trim();
            returnData[2] = Integer.parseInt(GetCount);
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnData;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] Get_BatchSW_Info() {
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58&\uc77c\uad04\uc18c\ub4f1");
        int[] returnData = new int[]{1, 22, 3, 4};
        if (this.mModelType == 11100 || this.mModelType == 31100 || this.mModelType == 31120 || this.mModelType == 31170) {
            returnData[0] = 1;
            returnData[1] = 26;
            returnData[2] = 3;
            returnData[3] = 4;
        } else {
            returnData[0] = 1;
            returnData[1] = 22;
            returnData[2] = 3;
            returnData[3] = 4;
        }
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (this.mModelType == 11100 || this.mModelType == 31100 || this.mModelType == 31120 || this.mModelType == 31170) {
                if (GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") > 0) {
                    returnData[1] = 25;
                } else {
                    if (GetData[1].indexOf("\ud604\uc0b0\ud5a5LCD\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") <= 0) {
                        returnData[0] = 0;
                        return returnData;
                    }
                    returnData[1] = 26;
                }
            } else if (GetData[1].indexOf("\ub300\uc678\ud5a5\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") > 0) {
                returnData[1] = 22;
            } else if (GetData[1].indexOf("\ub300\uc678\ud5a5\uc77c\uad04\uc18c\ub4f1\uc81c\uc5b4\uae30") > 0) {
                returnData[1] = 21;
            } else {
                if (GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") <= 0) {
                    returnData[0] = 0;
                    return returnData;
                }
                returnData[1] = 25;
            }
            String L1 = GetData[1].split("L1\uc124\uc815")[1].split("L2\uc124\uc815")[0];
            L1 = L1.replace("(", " ");
            L1 = L1.replace(")", " ");
            L1 = L1.trim();
            String L2 = GetData[1].split("L1\uc124\uc815")[1].split("L2\uc124\uc815")[1];
            L2 = L2.replace("(", " ");
            L2 = L2.replace(")", " ");
            L2 = L2.trim();
            returnData[2] = Integer.parseInt(L1);
            returnData[3] = Integer.parseInt(L2);
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new int[]{0, 22, 1, 2};
        }
    }

    public int[] Get_DoorLock_Info() {
        String[] GetData = this.GetSettingData("\ub514\uc9c0\ud138\ub3c4\uc5b4\ub77d");
        int[] returnData = new int[]{1, 32};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("\uc720\uc120") > 0) {
                returnData[1] = 31;
            } else if (GetData[1].indexOf("\ubb34\uc120") > 0) {
                returnData[1] = 32;
            } else if (GetData[1].indexOf("\uc9c0\ubb38\uc778\uc2dd") > 0) {
                returnData[1] = 33;
            } else {
                returnData[0] = 1;
                returnData[1] = 32;
                return returnData;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = new int[]{1, 32};
            return returnData;
        }
    }

    public int Get_Temper_Info() {
        String[] GetData = this.GetSettingData("\uc628\ub3c4\uc870\uc808\uae30");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int[] Get_Temper_FixRoomNumber() {
        String[] GetData = this.GetSettingData("\ub09c\ubc29\ubc29\uac1c\uc218\uace0\uc815");
        int[] returnData = new int[]{0, 0};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            String GetCount = GetData[1].split("[(]")[1].split("[:]")[0];
            GetCount = GetCount.trim();
            returnData[1] = Integer.parseInt(GetCount);
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData[0] = 0;
            return returnData;
        }
    }

    public int[] Get_Ventil_Info() {
        String[] GetData = this.GetSettingData("\ud658\uae30\uc2dc\uc2a4\ud15c");
        int[] returnData = new int[]{1, 31};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf(MAIN_GUI_TYPE_DEFAULT) > 0) {
                returnData[1] = 31;
            } else if (GetData[1].indexOf("LH\ud5a5") > 0) {
                returnData[1] = 32;
            } else if (GetData[1].indexOf("\ud6c4\ub4dc") > 0) {
                returnData[1] = 33;
            } else {
                returnData[0] = 1;
                returnData[1] = 31;
                return returnData;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData[0] = 0;
            returnData[1] = 31;
            return returnData;
        }
    }

    public int Get_AirCON_Info() {
        String[] GetData = this.GetSettingData("\uc2dc\uc2a4\ud15c\uc5d0\uc5b4\ucee8");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Elevator_Info() {
        String[] GetData = this.GetSettingData("\uc5d8\ub9ac\ubca0\uc774\ud130");
        try {
            if (GetData == null) {
                return 53;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                if (GetData[1].indexOf("\uce35\ud45c\uc2dc") > 0) {
                    return 53;
                }
                if (GetData[1].indexOf(MAIN_GUI_TYPE_DEFAULT) > 0) {
                    return 52;
                }
                return 53;
            }
            return 51;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 53;
        }
    }

    public int Get_RemoteCon_Info() {
        String[] GetData = this.GetSettingData("\ubb34\uc120\ub9ac\ubaa8\ucee8");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public String GetMainGUISelect() {
        String retStr = "";
        try {
            String[] GetData = this.GetSettingData("\uba54\uc778GUI\uc120\ud0dd");
            retStr = GetData[1].indexOf(MAIN_GUI_TYPE_DEFAULT) > 0 ? MAIN_GUI_TYPE_DEFAULT : (GetData[1].indexOf(MAIN_GUI_TYPE_METRO) > 0 ? MAIN_GUI_TYPE_METRO : (GetData[1].indexOf(MAIN_GUI_TYPE_HYOSUNG_CTR_ON) > 0 ? MAIN_GUI_TYPE_HYOSUNG_CTR_ON : (GetData[1].indexOf(MAIN_GUI_TYPE_HYOSUNG_CTR_OFF) > 0 ? MAIN_GUI_TYPE_HYOSUNG_CTR_OFF : (GetData[1].indexOf(MAIN_GUI_TYPE_HIMCHAN) > 0 ? MAIN_GUI_TYPE_HIMCHAN : MAIN_GUI_TYPE_DEFAULT))));
            return retStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.w((String)"WallpadDeviceSet", (String)"[GetMainGUISelect] Exception - Default");
            return MAIN_GUI_TYPE_DEFAULT;
        }
    }

    public int[] Get_RFDoorCAM_Info() {
        String[] GetData = this.GetSettingData("\ud604\uad00\uce74\uba54\ub77c");
        int[] returnData = new int[]{1, 51};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf(MAIN_GUI_TYPE_DEFAULT) > 0) {
                returnData[1] = 51;
            } else if (GetData[1].indexOf("RF\ud604\uad00\uce74\uba54\ub77c") > 0) {
                returnData[1] = 52;
            } else if (GetData[1].indexOf("\uc2a4\ub9c8\ud2b8\ud0a4") > 0) {
                returnData[1] = 53;
            } else if (GetData[1].indexOf("UKS") > 0) {
                returnData[1] = 54;
            } else if (GetData[1].indexOf("ETC") > 0) {
                returnData[1] = 55;
            } else if (GetData[1].indexOf("\uc2a4\ub9c8\ud2b8IOT\ud604\uad00\uce74\uba54\ub77c") > 0) {
                returnData[1] = 56;
            } else if (GetData[1].indexOf("\uc2a4\ub9c8\ud2b8\ud604\uad00\uce74\uba54\ub77c-\ud6a8\uc131") > 0) {
                returnData[1] = 57;
            } else if (GetData[1].indexOf("\uc2a4\ub9c8\ud2b8\ud604\uad00\uce74\uba54\ub77c-\ub300\uc6b0") > 0) {
                returnData[1] = 58;
            } else {
                returnData[0] = 1;
                returnData[1] = 51;
                return returnData;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData[0] = 1;
            returnData[1] = 51;
            return returnData;
        }
    }

    public int[] Get_CURTAIN_Info() {
        String[] GetData = this.GetSettingData("\uc804\ub3d9\ucee4\ud2bc");
        int[] returnData = new int[]{0, 41};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("\uc548\ubc29\ucee4\ud2bc") > 0) {
                returnData[1] = 41;
            } else if (GetData[1].indexOf("\uac70\uc2e4\ucee4\ud2bc") > 0) {
                returnData[1] = 42;
            } else if (GetData[1].indexOf("\uc548\ubc29\uac70\uc2e4\ucee4\ud2bc") > 0) {
                returnData[1] = 43;
            } else {
                returnData[0] = 0;
                returnData[1] = 41;
                return returnData;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData[0] = 0;
            returnData[1] = 41;
            return returnData;
        }
    }

    public int[] Get_RealTimeMetor_Info() {
        String[] GetData = this.GetSettingData("\uc2e4\uc2dc\uac04\uac80\uce68\uae30");
        int[] returnData = new int[]{0, 0};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            String GetCount = GetData[1].split("[(]")[1].split("[:]")[0];
            GetCount = GetCount.trim();
            returnData[1] = Integer.parseInt(GetCount);
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData[0] = 0;
            return returnData;
        }
    }

    public int Get_Energy_Devices_Info() {
        String[] GetData = this.GetSettingData("\uc5d0\ub108\uc9c0\uc81c\ud488\uad70");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_SmartDistribution_Info() {
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\ubd84\uc804\ubc18");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public boolean Get_KnxDistribution_Info() {
        String[] GetData = this.GetSettingData("KNX\ubd84\uc804\ubc18");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int Get_IPark_Energy_Info() {
        String[] GetData = this.GetSettingData("\uc544\uc774\ud30c\ud06c\uc5d0\ub108\uc9c0");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Idle_Power_Saving_Switch_Info() {
        String[] GetData = this.GetSettingData("\ub300\uae30\uc804\ub825\ucc28\ub2e8\uc2a4\uc704\uce58");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Energy_Module_Info() {
        String[] GetData = this.GetSettingData("\uc5d0\ub108\uc9c0\ubaa8\ub4c8");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_GAS_Info() {
        String[] GetData = this.GetSettingData("\uac00\uc2a4\ubc38\ube0c");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 1;
            return returnData;
        }
    }

    public int Get_Sensor_Set() {
        String[] GetData = this.GetSettingData("\ub3d9\uccb4\uc124\uc815");
        int returnData = 0;
        try {
            if (GetData == null) {
                returnData |= 2;
                return returnData |= 1;
            }
            if (GetData[1].indexOf("\ub3d9\uccb4\uc124\uc815") > 0) {
                String[] setted = GetData[1].split("\ub3d9\uccb4\uc124\uc815");
                if (setted[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                    String[] outsetted = GetData[1].split("\uc678\ubd80\ub3d9\uccb4\uc0ac\uc6a9");
                    if (outsetted[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                        returnData |= 2;
                    }
                    if ((outsetted = GetData[1].split("\ub0b4\ubd80\ub3d9\uccb4\uc0ac\uc6a9"))[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                        returnData |= 1;
                    }
                    if ((outsetted = GetData[1].split("\uc678\ubd80\ub3d9\uccb4\ub97c\ub0b4\ubd80\ub3d9\uccb4\ub85c\uc0ac\uc6a9"))[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                        returnData |= 4;
                    }
                } else {
                    return 0;
                }
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int GetDoorSoundLevel() {
        String[] GetData = this.GetSettingData("\ud604\uad00\ud3f0\uc0ac\uc6b4\ub4dc\ucd9c\ub825\uc74c\ub7c9");
        try {
            if (GetData == null) {
                return -1;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                String[] volsetted = GetData[1].split("\ubcfc\ub968");
                volsetted[1] = volsetted[1].replace("(", " ");
                volsetted[1] = volsetted[1].replace(")", " ");
                volsetted[1] = volsetted[1].trim();
                int idx = 0;
                try {
                    idx = Integer.parseInt(volsetted[1]);
                    if (idx > this.volindextbl.length - 1) {
                        idx = 0;
                    }
                    return this.volindextbl[idx];
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int Get_Security_IndoorMode_Sensor_Use() {
        String[] GetData = this.GetSettingData("\uc7ac\ud0dd\ubaa8\ub4dc\uc2dc\ub3d9\uccb4\uc13c\uc11c\uc0ac\uc6a9");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 1;
            return returnData;
        }
    }

    public int[] Get_Handicapped_Mode() {
        String[] GetData = this.GetSettingData("\uc7a5\uc560\uc778\ubaa8\ub4dc");
        int[] returnData = new int[]{0, 0};
        try {
            if (GetData == null) {
                Log.e((String)"WallpadDeviceSet", (String)"GetSettingData(\uc7a5\uc560\uc778\ubaa8\ub4dc) is null");
                return returnData;
            }
            String devInfo = GetData[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] DataInfo = (devInfo = devInfo.replace(')', '_')).split("_");
            if (DataInfo[3].equals("\uc0ac\uc6a9\ud568")) {
                returnData[0] = 1;
            }
            if (DataInfo[5].equals("\uc77c\ubc18\ubaa8\ub4dc")) {
                returnData[1] = 0;
            } else if (DataInfo[5].equals("\uccad\uac01\uc7a5\uc560\uc778")) {
                returnData[1] = 1;
            } else if (DataInfo[5].equals("\uc2dc\uac01\uc7a5\uc560\uc778")) {
                returnData[1] = 2;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnData;
        }
    }

    public boolean Set_Handicapped_Mode(int[] SetValue) {
        String sHandicapped = "\uc7a5\uc560\uc778\ubaa8\ub4dc";
        String sUseOrNot = "\uc0ac\uc6a9\uc548\ud568";
        String sMode = "\uc77c\ubc18\ubaa8\ub4dc";
        if (SetValue == null) {
            Log.e((String)"WallpadDeviceSet", (String)"intput[] is null");
            return false;
        }
        if (SetValue.length != 2) {
            Log.e((String)"WallpadDeviceSet", (String)"intput[]'s length is not 2");
            Log.e((String)"WallpadDeviceSet", (String)("intput[]'s length is " + SetValue.length));
            return false;
        }
        switch (SetValue[0]) {
            case 0: {
                sUseOrNot = "\uc0ac\uc6a9\uc548\ud568";
                break;
            }
            case 1: {
                sUseOrNot = "\uc0ac\uc6a9\ud568";
                break;
            }
            default: {
                Log.e((String)"WallpadDeviceSet", (String)("intput[0] is Error.  SetValue[0]: " + SetValue[0]));
                return false;
            }
        }
        switch (SetValue[1]) {
            case 0: {
                sMode = "\uc77c\ubc18\ubaa8\ub4dc";
                break;
            }
            case 1: {
                sMode = "\uccad\uac01\uc7a5\uc560\uc778";
                break;
            }
            case 2: {
                sMode = "\uc2dc\uac01\uc7a5\uc560\uc778";
                break;
            }
            default: {
                Log.e((String)"WallpadDeviceSet", (String)("intput[1] is Error.  SetValue[1]: " + SetValue[1]));
                return false;
            }
        }
        try {
            this.UpdateSettingData("subdev_list", sHandicapped, 0, "1(1:" + sHandicapped + "(" + sUseOrNot + ")\ubaa8\ub4dc(" + sMode + ")");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int Elevator_Button_inMainScreen_Use() {
        String[] GetData = this.GetSettingData("\uc5d8\ub9ac\ubca0\uc774\ud130\ud56b\ud0a4");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int[] Get_BookMark_Type() {
        String[] GetData = this.GetSettingData("\uc990\uaca8\ucc3e\uae30\uc544\uc774\ucf58\uc885\ub958");
        int[] returnData = new int[]{1, 0};
        try {
            if (GetData == null) {
                Log.e((String)"WallpadDeviceSet", (String)"GetSettingData(\uc990\uaca8\ucc3e\uae30\uc544\uc774\ucf58\uc885\ub958) is null");
                return returnData;
            }
            String devInfo = GetData[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] DataInfo = (devInfo = devInfo.replace(')', '_')).split("_");
            if (DataInfo[5].equals("\ud751\ubc31")) {
                returnData[1] = 0;
            } else if (DataInfo[5].equals("\uceec\ub7ec")) {
                returnData[1] = 1;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnData;
        }
    }

    public boolean GetGasDetect5Time() {
        Log.d((String)"WallpadDeviceSet", (String)"GetGasDetect5Time");
        int result = this.GetDeviceSetted("\uac00\uc2a4\uac10\uc9c05\ud68c\uc54c\ub78c");
        return result == 2;
    }

    public boolean Get_NonInternetSupportUse() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_NonInternetSupportUse");
        int result = this.GetDeviceSetted("\uc778\ud130\ub137\ubbf8\uc9c0\uc6d0");
        return result == 2;
    }

    public boolean Get_LivingEm_KitchenLight_Use() {
        int result = this.GetDeviceSetted("\uac70\uc2e4EM\uc8fc\ubc29\ub4f1");
        return result == 2;
    }

    public boolean Get_SmartPostUse() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_SmartPostUse");
        int result = this.GetDeviceSetted("\uc2a4\ub9c8\ud2b8\uc6b0\ud3b8\ud568");
        return result == 2;
    }

    public boolean Get_CookTopConcent_Use() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_CookTopConcent_Use");
        int result = this.GetDeviceSetted("\ucfe1\ud0d1\ucf58\uc13c\ud2b8");
        return result == 2;
    }

    public String[] Get_EnergyModule_Name() {
        String[] ReturnData = null;
        String[] GetData = this.GetSettingData("\uc5d0\ub108\uc9c0\ubaa8\ub4c8\uba85\uce6d");
        try {
            if (GetData == null) {
                Log.e((String)"WallpadDeviceSet", (String)"GetSettingData(\uc5d0\ub108\uc9c0\ubaa8\ub4c8\uba85\uce6d) is null");
                return null;
            }
            String devInfo = GetData[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] DataInfo = (devInfo = devInfo.replace(')', '_')).split("_");
            if (DataInfo[3].equals("\uc0ac\uc6a9\ud568")) {
                String[] TempData = DataInfo[5].split(",");
                if (TempData == null) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData is null");
                    return null;
                }
                if (TempData.length < 1) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData.length is 0");
                    return null;
                }
                ReturnData = new String[TempData.length];
                ReturnData = TempData;
                return ReturnData;
            }
            Log.e((String)"WallpadDeviceSet", (String)"\uc5d0\ub108\uc9c0\ubaa8\ub4c8\uba85\uce6d \uc0ac\uc6a9 \uc548\ud568");
            Log.e((String)"WallpadDeviceSet", (String)("DataInfo[3] :" + DataInfo[3]));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean GetZeroEnergyHouseInfo() {
        Log.d((String)"WallpadDeviceSet", (String)"GetZeroEnergyHouseInfo");
        String[] GetData = this.GetSettingData("\uc81c\ub85c\uc5d0\ub108\uc9c0\ud558\uc6b0\uc2a4");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return false;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean Get_CallAppCallTimeout() {
        String[] GetData = this.GetSettingData("\ud1b5\ud654\ud0c0\uc784\uc544\uc6c3");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\uc548\ud568") > 0) {
                returnData = false;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnData;
        }
    }

    public boolean Set_CallAppCallTimeout(boolean input) {
        String SettingValue = "\uc0ac\uc6a9\ud568";
        SettingValue = !input ? "\uc0ac\uc6a9\uc548\ud568" : "\uc0ac\uc6a9\ud568";
        try {
            this.UpdateSettingData("subdev_list", "\ud1b5\ud654\ud0c0\uc784\uc544\uc6c3", 0, "1(1:\ud1b5\ud654\ud0c0\uc784\uc544\uc6c3(" + SettingValue + ")");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean Get_IP_Expansion() {
        String[] GetData = this.GetSettingData("IP\ub300\uc5ed\ud655\uc7a5");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnData;
        }
    }

    public boolean Set_IP_Expansion(boolean input) {
        String SettingValue = "\uc0ac\uc6a9\uc548\ud568";
        SettingValue = !input ? "\uc0ac\uc6a9\uc548\ud568" : "\uc0ac\uc6a9\ud568";
        try {
            this.UpdateSettingData("subdev_list", "IP\ub300\uc5ed\ud655\uc7a5", 0, "1(1:IP\ub300\uc5ed\ud655\uc7a5(" + SettingValue + ")");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean GetEachRoomNameInfo() {
        Log.d((String)"WallpadDeviceSet", (String)"GetEachRoomNameInfo");
        String[] GetData = this.GetSettingData("\ub09c\ubc29\uc870\uba85\ubc29\uba85\uce6d\uc124\uc815");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return false;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean GetHDCSmartSwitch485Connection() {
        Log.d((String)"WallpadDeviceSet", (String)"GetHDCSmartSwitch485Connection");
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58485\uc124\uc815");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return false;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean GetBLESmartKeyUSE() {
        Log.d((String)"WallpadDeviceSet", (String)"GetBLESmartKeyUSE");
        int result = this.GetDeviceSetted("BLE\uc2a4\ub9c8\ud2b8\ud0a4");
        return result == 2;
    }

    public boolean GetNewDanjiServer() {
        Log.d((String)"WallpadDeviceSet", (String)"GetNewDanjiServer");
        int result = this.GetDeviceSetted("\uc2e0\ud615\ub2e8\uc9c0\uc11c\ubc84");
        if (result == 2) {
            Log.d((String)"WallpadDeviceSet", (String)"GetNewDanjiServer TRUE");
            return true;
        }
        Log.d((String)"WallpadDeviceSet", (String)"GetNewDanjiServer FALSE");
        return false;
    }

    public int[] Get_BLESmartKey_Info() {
        String[] GetData = this.GetSettingData("BLE\uc2a4\ub9c8\ud2b8\ud0a4");
        int[] returnData = new int[]{0, 61};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("(\uc2a4\ub9c8\ud2b8\ud0a4)") > 0) {
                returnData[1] = 62;
            } else if (GetData[1].indexOf("(\uc2a4\ub9c8\ud2b8\ubc34\ub4dc)") > 0) {
                returnData[1] = 63;
            } else {
                returnData[0] = 1;
                returnData[1] = 62;
                return returnData;
            }
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData[0] = 1;
            returnData[1] = 62;
            return returnData;
        }
    }

    public boolean GetCtrSequenceLimit() {
        Log.d((String)"WallpadDeviceSet", (String)"GetCtrSequenceLimit");
        int result = this.GetDeviceSetted("\uc81c\uc5b4\uc2dc\ud000\uc2a4\uc81c\ud55c");
        return result == 2;
    }

    public boolean Get_Integrated_Switch_Info() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_Integrated_Switch_Info");
        int result = this.GetDeviceSetted("\ud1b5\ud569\uc2a4\uc704\uce58");
        return result == 2;
    }

    public int Get_NoiseSensor_Use() {
        String[] GetData = this.GetSettingData("\uce35\uac04\uc18c\uc74c\uc13c\uc11c");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_InnerRoomDetectSensor_Use() {
        String[] GetData = this.GetSettingData("\uc7ac\uc2e4\uc13c\uc11c");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_ReliefCall_Use() {
        String[] GetData = this.GetSettingData("\uc548\uc2ec\ud1b5\ud654");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_RemoteCall_Use() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\uc6d0\uaca9\ud1b5\ud654");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public int Get_MobileAppAuth_Use() {
        String[] GetData = this.GetSettingData("\ubaa8\ubc14\uc77c\uc571\uc0ac\uc6a9\uc790\uc778\uc99d");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = 0;
            return returnData;
        }
    }

    public boolean Get_ElectricRange_Use() {
        String[] GetData = this.GetSettingData("\uc804\uae30\ub808\uc778\uc9c0");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }

    public boolean getVisitedVehicleRegiUsage() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\ucc28\ub7c9\ub4f1\ub85d");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }

    public boolean getBandLocationUsage() {
        String[] GetData = this.GetSettingData("\ubc34\ub4dc\uc704\uce58\ud655\uc778");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }

    public boolean GetEscapeLadderDownRecv() {
        int result = this.GetDeviceSetted("\ud53c\ub09c\uc0ac\ub2e4\ub9ac\uc785\ud558\uc218\uc2e0");
        return result == 2;
    }

    public boolean SetSubDevListItem(boolean input, String Define_ID) {
        String SettingValue = "\uc0ac\uc6a9\uc548\ud568";
        if (Define_ID == null) {
            return false;
        }
        SettingValue = !input ? "\uc0ac\uc6a9\uc548\ud568" : "\uc0ac\uc6a9\ud568";
        try {
            this.UpdateSettingData("subdev_list", Define_ID, 0, "1(1:" + Define_ID + "(" + SettingValue + ")");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int GetDeviceSetted(String item) {
        String[] GetData = this.GetSettingData(item);
        if (GetData == null) {
            return 0;
        }
        try {
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 3;
        }
    }

    public void SetDeviceEnable(String DevName, boolean onoff) {
        ContentValues values = new ContentValues();
        values.put(DEV_ENABLE, onoff ? DEV_ENABLE : DEV_DISABLE);
        String condi = "id = " + DevName;
        this.wdb.update("SubDeviceDB", values, condi, null);
    }

    public String[] GetDeviceinfo(String DevName) {
        String query = "select id, name, cnt,  enable, lononoff from SubDeviceDB where id = \"" + DevName + "\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        if (cursor.moveToNext()) {
            String[] getdata = new String[]{cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4)};
            return getdata;
        }
        cursor.close();
        return null;
    }

    public boolean GetDeviceEnable(String DevName) {
        String query = "select enable from SubDeviceDB where id = \"" + DevName + "\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        if (cursor.moveToNext() && cursor.getString(0).equals(DEV_ENABLE)) {
            cursor.close();
            return true;
        }
        cursor.close();
        return false;
    }

    public void SetDeviceCount(String DevName, int count) {
        ContentValues values = new ContentValues();
        values.put("cnt", String.valueOf(count));
        String condi = "id = " + DevName;
        this.wdb.update("SubDeviceDB", values, condi, null);
    }

    public boolean GetSubWpdUse() {
        Log.d((String)"WallpadDeviceSet", (String)"GetSubWpdUse");
        int result = this.GetDeviceSetted("\uc11c\ube0c\uc6d4\ud328\ub4dc");
        return result == 2;
    }

    public int[] GetSubWpdDirect_PSTN() {
        Log.d((String)"WallpadDeviceSet", (String)"[GetSubWpdDirect_PSTN]");
        String[] GetData = this.GetSettingData("\uc11c\ube0c\uc6d4\ud328\ub4dc\uad6d\uc120\uc804\ud654\uc5f0\ub3d9");
        int[] returnData = new int[]{0, 71};
        try {
            int i;
            if (GetData == null) {
                return returnData;
            }
            for (i = 0; i < GetData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_PSTN] GetData[" + i + "] = " + GetData[i]));
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData[0] = 1;
                returnData[1] = GetData[1].indexOf("(\uc9c1\uc811\uc5f0\ub3d9)") > 0 ? 73 : (GetData[1].indexOf("(\uba54\uc778\uc694\uccad)") > 0 ? 72 : 71);
            } else {
                returnData[0] = 0;
            }
            for (i = 0; i < returnData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_PSTN] returnData[" + i + "] = " + returnData[i]));
            }
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetSubWpdDirect_PSTN()");
            e.printStackTrace();
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
    }

    public int GetGatewayModelKindInfo() {
        Log.d((String)"WallpadDeviceSet", (String)"GetGatewayModelKindInfo");
        String[] DataInfo = this.GetSettingData("\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378");
        try {
            if (DataInfo == null) {
                Log.w((String)"WallpadDeviceSet", (String)"GetSettingData(\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378) is null");
                if (Version.getModelType() == 11100) {
                    this.UpdateSettingData("subdev_list", "\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378", 0, "1(1:\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378(\uc0ac\uc6a9\ud568)\uc885\ub958(IGW200)");
                } else if (Version.getModelType() == 31100 || this.mModelType == 31120 || this.mModelType == 31170) {
                    this.UpdateSettingData("subdev_list", "\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378", 0, "1(1:\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378(\uc0ac\uc6a9\ud568)\uc885\ub958(IGW300)");
                } else {
                    return -2;
                }
                DataInfo = this.GetSettingData("\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378");
                if (DataInfo != null) {
                    for (int i = 0; i < DataInfo.length; ++i) {
                        Log.i((String)"WallpadDeviceSet", (String)("[GetGatewayModelKindInfo] null -> default : " + DataInfo[i]));
                    }
                } else {
                    return -3;
                }
            }
            String devInfo = DataInfo[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
            if (parseData[3].equals("\uc0ac\uc6a9\ud568")) {
                String TempData = parseData[5];
                if (TempData == null) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData is null");
                    return -3;
                }
                if (TempData.equals("IGW200")) {
                    Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774 \ubaa8\ub378 \uc885\ub958 : IGW200");
                    return 200;
                }
                if (TempData.equals("IGW300")) {
                    Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774 \ubaa8\ub378 \uc885\ub958 : IGW300");
                    return 300;
                }
                Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774 \ubaa8\ub378 \uc885\ub958 : \ubbf8\uc815\uc758");
                return -1;
            }
            Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378 \uc885\ub958 : \uc0ac\uc6a9\uc548\ud568");
            return 100;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378 Exception");
            e.printStackTrace();
            return -4;
        }
    }

    public boolean Get_RemoteMeter_Use() {
        boolean ret = false;
        String[] DataInfo = this.GetSettingData("\uc6d0\uaca9\uac80\uce68");
        if (DataInfo != null) {
            for (int i = 0; i < DataInfo.length; ++i) {
                Log.i((String)"WallpadDeviceSet", (String)("[Get_RemoteMeter_Use] data : " + DataInfo[i]));
            }
        } else {
            Log.w((String)"WallpadDeviceSet", (String)"[Get_RemoteMeter_Use] - data null --> false");
            return false;
        }
        String devInfo = DataInfo[1];
        devInfo = devInfo.replace('(', '_');
        devInfo = devInfo.replace(':', '_');
        String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
        if (parseData[3].equals("\uc0ac\uc6a9\ud568")) {
            Log.i((String)"WallpadDeviceSet", (String)"[Get_RemoteMeter_Use] - RemoteMeter USE : true");
            ret = true;
        } else {
            Log.i((String)"WallpadDeviceSet", (String)"[Get_RemoteMeter_Use] - RemoteMeter USE : false");
            ret = false;
        }
        return ret;
    }

    public boolean StartTransaction() {
        try {
            this.wdb.beginTransaction();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean EndTransaction(boolean success) {
        try {
            if (success) {
                this.wdb.setTransactionSuccessful();
            }
            this.wdb.endTransaction();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void initSubDeviceTBL() {
        for (int i = 0; i < SubDevInitData.length; ++i) {
            ContentValues values = new ContentValues();
            values.put("id", SubDevInitData[i][0]);
            values.put("name", SubDevInitData[i][1]);
            values.put("devcnt", SubDevInitData[i][2]);
            values.put("cnt", SubDevInitData[i][3]);
            values.put("loc", SubDevInitData[i][4]);
            values.put(DEV_ENABLE, SubDevInitData[i][5]);
            values.put("logonoff", SubDevInitData[i][6]);
            this.wdb.insert("SubDeviceDB", null, values);
        }
    }

    public void InsertSettingData(String Type, String Name, int cnt, String value) {
        ContentValues values = new ContentValues();
        values.put("type", Type);
        values.put("name", Name);
        values.put("cnt", Integer.valueOf(cnt));
        values.put("value", value);
        this.wdb.insert("SettingDB", null, values);
    }

    public void UpdateSettingData(String Type, String Name, int cnt, String value) {
        String sqlStr = "DELETE FROM SettingDB where name=\"" + Name + "\";";
        this.wdb.execSQL(sqlStr);
        this.InsertSettingData(Type, Name, cnt, value);
    }

    public String[] GetSettingData(String Name) {
        String query = "select name, value from SettingDB where name = \"" + Name + "\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        if (cursor.moveToNext()) {
            String[] getdata = new String[]{cursor.getString(0).trim(), cursor.getString(1).trim()};
            return getdata;
        }
        cursor.close();
        return null;
    }

    public List<String[]> GetGuardList() {
        ArrayList<String[]> GuardList = new ArrayList<String[]>();
        String query = "select name, value from SettingDB where type = \"guard_list\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            String[] getdata = new String[]{cursor.getString(0), cursor.getString(1)};
            GuardList.add(getdata);
        }
        cursor.close();
        return GuardList;
    }

    public String[] GetSettingGroup() {
        String query = "select name, value from SettingDB group by type;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        String retval = "";
        int count = 0;
        while (cursor.moveToNext()) {
            retval = count == 0 ? cursor.getString(0) : retval + ";" + cursor.getString(0);
            ++count;
        }
        cursor.close();
        if (count == 0) {
            return null;
        }
        return retval.split(";");
    }

    public List<String[]> GetSettingGroupData(String groupname) {
        String query = "select name, value from SettingDB where type = \"" + groupname + "\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        ArrayList<String[]> retVal = new ArrayList<String[]>();
        while (cursor.moveToNext()) {
            String[] retdata = new String[]{cursor.getString(0), cursor.getString(1)};
            retVal.add(retdata);
        }
        cursor.close();
        return retVal;
    }

    public int GetGroupCount(String groupname) {
        String query = "select count() from SettingDB where type = \"" + groupname + "\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        int count = 0;
        while (cursor.moveToNext()) {
            count = cursor.getInt(0);
        }
        cursor.close();
        return count;
    }

    public void DeleteGuardData() {
        try {
            String sqlStr = "DELETE FROM SettingDB where type = \"guard_list\";";
            this.wdb.execSQL(sqlStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void DeleteGroupData(String groupName) {
        try {
            String sqlStr = "DELETE FROM SettingDB where type = \"" + groupName + "\";";
            this.wdb.execSQL(sqlStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long insertWallPADDB(String name, String Data2) {
        ContentValues values = new ContentValues();
        values.put("id", name);
        values.put("data", Data2);
        long ret = this.wdb.insert("SubDeviceDB", null, values);
        return ret;
    }

    public boolean Validate_IPAddress(String IPAddress) {
        try {
            Log.d((String)"WallpadDeviceSet", (String)("[Validate_IPAddress] IPAddress [" + IPAddress + "]"));
            if (IPAddress == null) {
                return false;
            }
            return mPattern.matcher(IPAddress).matches();
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Validate_IPAddress(String IPAddress)");
            e.printStackTrace();
            return false;
        }
    }

    public boolean Get_SmartKitchen_Use() {
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\ud0a4\uce5c");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_EasyModeUX_Support() {
        String[] GetData = this.GetSettingData("\uac04\ud3b8\ubaa8\ub4dcUX\uc9c0\uc6d0");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_DetectStranger_Use() {
        String[] GetData = this.GetSettingData("\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_RemoteCall_DoorOpenUse() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\uc6d0\uaca9\ud1b5\ud654-\ud604\uad00\ubb38\uc5f4\ub9bc");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_RemoteCall_HomeViewerUse() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\uc6d0\uaca9\ud1b5\ud654-\ud648\ubdf0\uc5b4");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnData = false;
            return returnData;
        }
    }
}

