/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class MultiSwitchAPI
extends WallPadDevAPI {
    private final String TAG = "MultiSwitchAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"MultiSwitchAPI", (String)s);
    }

    public MultiSwitchAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("MultiSwitchAPI create " + devctrcmd);
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "MULTISW";
        this.data = new Data();
        this.GetDeviceCount();
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"MultiSwitchAPI", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"MultiSwitchAPI", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.DeviceCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.DeviceCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            boolean bInstall;
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.MultiSwitch Device2 = new DataClasses.MultiSwitch();
            int index = 1;
            byte hRequestIndex = Byte.parseByte(retData[index++]);
            if (bInstall = Boolean.parseBoolean(retData[index++])) {
                Device2.info.Vender = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Year = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Month = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Day = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Number = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
                Device2.info.Support.hLightCnt = Byte.parseByte(retData[index++]);
                Device2.info.Support.hOutletCnt = Byte.parseByte(retData[index++]);
                Device2.info.Support.bV2CMDUsage = Boolean.parseBoolean(retData[index++]);
                Device2.info.Support.bDim = Boolean.parseBoolean(retData[index++]);
                Device2.info.Support.hDimLevel = Byte.parseByte(retData[index++]);
                Device2.info.Support.hDimEnabledCircuit = Byte.parseByte(retData[index++]);
                Device2.info.Support.bAirconCtrl = Boolean.parseBoolean(retData[index++]);
                if (Device2.info.Support.bAirconCtrl) {
                    int hairconCnt = Byte.parseByte(retData[index++]);
                    byte[] ahairconID = new byte[hairconCnt];
                    for (int i = 0; i < hairconCnt; ++i) {
                        ahairconID[i] = 0;
                        ahairconID[i] = Byte.parseByte(retData[index++]);
                    }
                    Device2.setAirconInfo((byte)hairconCnt, ahairconID);
                }
                Device2.setBasicInfo(Device2.info.Support.hLightCnt, Device2.info.Support.hOutletCnt);
                Device2.device.hLightCnt = Byte.parseByte(retData[index++]);
                if (Device2.device.hLightCnt > 0) {
                    boolean power = false;
                    boolean dimusage = false;
                    byte dimlevel = 0;
                    for (int i = 0; i < Device2.device.hLightCnt; ++i) {
                        power = Boolean.parseBoolean(retData[index++]);
                        dimusage = Boolean.parseBoolean(retData[index++]);
                        dimlevel = Byte.parseByte(retData[index++]);
                        Device2.device.setLight(i, power, dimusage, dimlevel);
                    }
                }
                Device2.device.hBatchOffStatus = Byte.parseByte(retData[index++]);
                Device2.device.hOutletCnt = Byte.parseByte(retData[index++]);
                if (Device2.device.hOutletCnt > 0) {
                    byte status = 0;
                    byte mode = 0;
                    double currentPower = 0.0;
                    double cotoffvalue = 0.0;
                    for (byte i = 0; i < Device2.device.hOutletCnt; i = (byte)(i + 1)) {
                        status = Byte.parseByte(retData[index++]);
                        mode = Byte.parseByte(retData[index++]);
                        currentPower = Double.parseDouble(retData[index++]);
                        cotoffvalue = Double.parseDouble(retData[index++]);
                        Device2.device.setOutlet(i, status, mode, currentPower, cotoffvalue);
                    }
                }
            } else {
                Device2.info.Install = false;
            }
            this.data.Device[hRequestIndex] = Device2;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "MultiSwitchAPI", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"MultiSwitchAPI", (String)"[Exception Error] ProcResult");
            LogUtil.errorLogInfo("", "MultiSwitchAPI", e);
            return -1;
        }
        return 0;
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.DeviceCnt = DeviceCount;
                    this.data.Device = new DataClasses.MultiSwitch[DeviceCount];
                    return 0;
                }
                return -1;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "MultiSwitchAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"MultiSwitchAPI", (String)("[GetDeviceCount] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "MultiSwitchAPI", e);
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetLightOnOff(byte Index, byte LightIdx, boolean OnOff) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"MultiSwitchAPI", (String)"[SetLightOnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(Index)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetLightOnOff] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        if (!this.LightIndexRangeCheck(Index, LightIdx)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetLightOnOff] Param - LightIdx  : Out Of Range (LightIdx:" + LightIdx + ")"));
            return -3;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightOnOff", Index, LightIdx, ByteOnOff, 0, 0);
    }

    public int SetLightDimV2(byte Index, byte LightIdx, byte DimLevel) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"MultiSwitchAPI", (String)"[SetLightDim] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(Index)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetLightDim] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        if (!this.LightIndexRangeCheck(Index, LightIdx)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetLightDim] Param - LightIdx  : Out Of Range (LightIdx:" + LightIdx + ")"));
            return -3;
        }
        byte dimLevel = DimLevel;
        return this.SendNReadCMD_int("SINKCTRL", "SetLightDimV2", Index, LightIdx, dimLevel, 0, 0);
    }

    public int SetConcentOnOff(byte Index, byte ConcentIdx, boolean OnOff) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"MultiSwitchAPI", (String)"[SetConcentOnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (Index != -1 && !this.DeviceIndexRangeCheck(Index)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetConcentOnOff] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        if (Index != -1 && !this.ConcentIndexRangeCheck(Index, ConcentIdx)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetConcentOnOff] Param - ConcentIdx  : Out Of Range (ConcentIdx:" + ConcentIdx + ")"));
            return -3;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentOnOff", Index, ConcentIdx, ByteOnOff, 0, 0);
    }

    public int SetConcentMode(byte Index, byte ConcentIdx, boolean OnOff) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"MultiSwitchAPI", (String)"[SetConcentMode] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (Index != -1 && !this.DeviceIndexRangeCheck(Index)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetConcentMode] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        if (Index != -1 && !this.ConcentIndexRangeCheck(Index, ConcentIdx)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetConcentMode] Param - ConcentIdx  : Out Of Range (ConcentIdx:" + ConcentIdx + ")"));
            return -3;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentMode", Index, ConcentIdx, ByteOnOff, 0, 0);
    }

    public int SetConcentCutOff(byte Index, byte ConcentIdx) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"MultiSwitchAPI", (String)"[SetConcentCutOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (Index != -1 && !this.DeviceIndexRangeCheck(Index)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetConcentCutOff] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        if (Index != -1 && !this.ConcentIndexRangeCheck(Index, ConcentIdx)) {
            Log.w((String)"MultiSwitchAPI", (String)("[SetConcentCutOff] Param - ConcentIdx  : Out Of Range (ConcentIdx:" + ConcentIdx + ")"));
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentCutOff", Index, ConcentIdx, 0, 0, 0);
    }

    public boolean isExist_ConcentDevice() {
        int ret;
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"MultiSwitchAPI", (String)"[isExist_ConcentDevice] DeviceCnt is '0'  Not Yet !!!");
            return false;
        }
        if (this.data.Device == null) {
            Log.w((String)"MultiSwitchAPI", (String)"[isExist_ConcentDevice] data.Device is null !!!");
            return false;
        }
        if (this.data.Device[0] == null && (ret = this.Refresh((byte)-1, false)) < 0) {
            Log.w((String)"MultiSwitchAPI", (String)("[isExist_ConcentDevice] Refresh Error (ret:" + ret + ")"));
            return false;
        }
        try {
            for (int i = 0; i < this.data.DeviceCnt; ++i) {
                if (this.data.Device[i] == null) {
                    return false;
                }
                if (this.data.Device[i].info.Support.hOutletCnt <= 0) continue;
                return true;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "MultiSwitchAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"MultiSwitchAPI", (String)"[Exception Error] isExist_ConcentDevice");
            LogUtil.errorLogInfo("", "MultiSwitchAPI", e);
            return false;
        }
        return false;
    }

    private boolean DeviceIndexRangeCheck(byte Index) {
        try {
            return Index >= 0 && Index < this.data.DeviceCnt;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "MultiSwitchAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"MultiSwitchAPI", (String)"[Exception Error] DeviceIndexRangeCheck");
            LogUtil.errorLogInfo("", "MultiSwitchAPI", e);
            return false;
        }
    }

    private boolean LightIndexRangeCheck(byte Index, byte LightIdx) {
        try {
            return !(this.data.Device[Index] == null ? LightIdx != -1 && (LightIdx >= 8 || LightIdx < 0) : LightIdx != -1 && (LightIdx >= this.data.Device[Index].info.Support.hLightCnt || LightIdx < 0));
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "MultiSwitchAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"MultiSwitchAPI", (String)"[Exception Error] LightIndexRangeCheck");
            LogUtil.errorLogInfo("", "MultiSwitchAPI", e);
            return false;
        }
    }

    private boolean ConcentIndexRangeCheck(byte Index, byte ConcentIdx) {
        try {
            return !(this.data.Device[Index] == null ? ConcentIdx != -1 && (ConcentIdx >= 8 || ConcentIdx < 0) : ConcentIdx != -1 && (ConcentIdx >= this.data.Device[Index].info.Support.hOutletCnt || ConcentIdx < 0));
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "MultiSwitchAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"MultiSwitchAPI", (String)"[Exception Error] ConcentIndexRangeCheck");
            LogUtil.errorLogInfo("", "MultiSwitchAPI", e);
            return false;
        }
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public DataClasses.MultiSwitch[] Device = null;
    }
}

