/*
 * Decompiled with CFR 0.152.
 */
package android.net.ethernet;

import android.net.ethernet.EthernetDevInfo;
import android.net.ethernet.IEthernetManager;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.util.LogUtil;

public class EthernetManager {
    public static final String TAG = "EthernetManager";
    public static final int ETH_DEVICE_SCAN_RESULT_READY = 0;
    public static final String ETH_STATE_CHANGED_ACTION = "android.net.ethernet.ETH_STATE_CHANGED";
    public static final String NETWORK_STATE_CHANGED_ACTION = "android.net.ethernet.STATE_CHANGE";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_ETH_EVENT = "eth_event";
    public static final String EXTRA_ETH_STATE = "eth_state";
    public static final int ETH_STATE_DISABLED = 1;
    public static final int ETH_STATE_ENABLED = 2;
    public static final int ETH_STATE_ENABLING = 3;
    public static final int ETH_STATE_UNKNOWN = 0;
    IEthernetManager mService;
    Handler mHandler;

    public void setCheckConnecting(int value) {
        try {
            this.mService.setCheckConnecting(value);
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not setCheckConnecting");
        }
    }

    public int getCheckConnecting() {
        try {
            return this.mService.getCheckConnecting();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void setStackConnected(boolean value) {
        try {
            this.mService.setStackConnected(value);
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not setStackConnected");
        }
    }

    public boolean getStackConnected() {
        try {
            return this.mService.getStackConnected();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setHWConnected(boolean value) {
        try {
            this.mService.setHWConnected(value);
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not setHWConnected");
        }
    }

    public boolean getHWConnected() {
        try {
            return this.mService.getHWConnected();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isEthDeviceFound() {
        try {
            if (this.mService == null) {
                return false;
            }
            return this.mService.isEthDeviceFound();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isEthConfigured() {
        try {
            return this.mService.isEthConfigured();
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not check eth config state");
            return false;
        }
    }

    public EthernetDevInfo getSavedEthConfig() {
        try {
            return this.mService.getSavedEthConfig();
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not get eth config");
            return null;
        }
    }

    public void UpdateEthDevInfo(EthernetDevInfo info) {
        try {
            this.mService.UpdateEthDevInfo(info);
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not update ethernet device info");
        }
    }

    public EthernetManager(IEthernetManager service, Handler handler) {
        Log.d((String)TAG, (String)"Init Ethernet Manager");
        this.mService = service;
        this.mHandler = handler;
    }

    public String[] getDeviceNameList() {
        try {
            return this.mService.getDeviceNameList();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void setEthEnabled(boolean enable) {
        try {
            this.mService.setEthState(enable ? 2 : 1);
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not set new state");
        }
    }

    public void setEthernetState(int state) {
        try {
            this.mService.setEthState(state);
        }
        catch (RemoteException e) {
            Log.i((String)TAG, (String)"Can not set new state");
        }
    }

    public int getEthState() {
        try {
            return this.mService.getEthState();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public boolean ethConfigured() {
        try {
            return this.mService.isEthConfigured();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int getTotalInterface() {
        try {
            return this.mService.getTotalInterface();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void ethSetDefaultConf() {
        try {
            this.mService.setEthMode("dhcp");
        }
        catch (RemoteException e) {
            LogUtil.errorLogInfo("", TAG, e);
        }
    }
}

