/*
 * Decompiled with CFR 0.152.
 */
package milsip.stack.sip;

import java.util.StringTokenizer;
import milsip.stack.sip.SIPStack;

public class SIPRequestLine {
    public String header = null;
    public int iMethodType = SIPStack.SIP_METHODTYPE_NONE;
    public String uri = null;
    public int version = 2;
    public int revision = 0;
    public int code = 0;
    public int iMessageType = SIPStack.SIP_MSGTYPE_NONE;
    public boolean flag = false;

    public SIPRequestLine(String message) {
        if (message != null) {
            int tokenCount;
            StringTokenizer tokenArray;
            StringTokenizer st = new StringTokenizer(message, "\n", true);
            boolean headerCount = false;
            block0: while (st.hasMoreTokens()) {
                this.header = st.nextToken();
                if (this.header.length() <= 1) continue;
                if (!headerCount && this.header.startsWith("INVITE") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_INVITE;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("BYE") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_BYE;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("ACK") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_ACK;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("CANCEL") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_CANCEL;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("OPTIONS") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_OPTIONS;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("INFO") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_INFO;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("PRACK") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_PRACK;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("MESSAGE") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_MESSAGE;
                    this.flag = true;
                    break;
                }
                if (!headerCount && this.header.startsWith("SUBSCRIBE") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_SUBSCRIBE;
                    break;
                }
                if (!headerCount && this.header.startsWith("REFER") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_REFER;
                    break;
                }
                if (!headerCount && this.header.startsWith("NOTIFY") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_NOTIFY;
                    break;
                }
                if (!headerCount && this.header.startsWith("PUBLISH") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_PUBLISH;
                    break;
                }
                if (!headerCount && this.header.startsWith("REGISTER") && this.header.endsWith("SIP/2.0\r")) {
                    this.iMessageType = SIPStack.SIP_MSGTYPE_REQUEST;
                    this.iMethodType = SIPStack.SIP_METHODTYPE_REGISTER;
                    this.flag = true;
                    break;
                }
                if (headerCount || !this.header.startsWith("SIP/2.0") || !this.header.endsWith("\r")) continue;
                this.iMessageType = SIPStack.SIP_MSGTYPE_RESPONSE;
                this.iMethodType = SIPStack.SIP_METHODTYPE_NONE;
                tokenArray = new StringTokenizer(this.header, " ", true);
                tokenCount = 0;
                String[] strSplit = this.header.split(" ");
                this.code = Integer.parseInt(strSplit[1]);
                while (tokenArray.hasMoreTokens()) {
                    String token = tokenArray.nextToken();
                    if (token.compareTo(" ") == 0 || ++tokenCount != 2) continue;
                    this.code = Integer.parseInt(token);
                }
                int iS = message.indexOf("CSeq: ");
                int iE = 0;
                if (iS < 0 || (iE = message.indexOf(SIPStack.SIP_LINE_END, iS)) <= 0) break;
                String strCSEQ = message.substring(iS, iE);
                tokenArray = new StringTokenizer(strCSEQ, " ", true);
                tokenCount = 0;
                while (tokenArray.hasMoreTokens()) {
                    String token = tokenArray.nextToken();
                    if (token.length() <= 0 || token.compareTo(" ") == 0 || ++tokenCount != 3) continue;
                    if (token.compareTo("REGISTER") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_REGISTER;
                    } else if (token.compareTo("INVITE") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_INVITE;
                    } else if (token.compareTo("CANCEL") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_CANCEL;
                    } else if (token.compareTo("BYE") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_BYE;
                    } else if (token.compareTo("INFO") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_INFO;
                    } else if (token.compareTo("OPTIONS") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_OPTIONS;
                    } else if (token.compareTo("ACK") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_ACK;
                    } else if (token.compareTo("REFER") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_REFER;
                    } else if (token.compareTo("NOTIFY") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_NOTIFY;
                    } else if (token.compareTo("PUBLISH") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_PUBLISH;
                    } else if (token.compareTo("MESSAGE") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_MESSAGE;
                    } else if (token.compareTo("SUBSCRIBE") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_SUBSCRIBE;
                    } else if (token.compareTo("PRACK") == 0) {
                        this.iMethodType = SIPStack.SIP_METHODTYPE_PRACK;
                    }
                    if (this.iMethodType == SIPStack.SIP_METHODTYPE_NONE) break block0;
                    this.flag = true;
                    break block0;
                }
                break block0;
            }
            if (this.flag && this.iMessageType == SIPStack.SIP_MSGTYPE_REQUEST && this.header != null) {
                tokenArray = new StringTokenizer(this.header, " ", true);
                tokenCount = 0;
                while (tokenArray.hasMoreTokens()) {
                    String token = tokenArray.nextToken();
                    if (token.compareTo(" ") == 0 || ++tokenCount != 2) continue;
                    this.uri = token;
                }
            }
        }
    }

    public void print() {
        System.out.println("=====================================================");
        System.out.println("HEADER:");
        System.out.println(this.header);
        System.out.println(".....................................................");
        System.out.println("flag\t\t:" + this.flag);
        System.out.println("iMethodType\t:" + this.iMethodType);
        System.out.println("uri\t\t\t:" + this.uri);
        System.out.println("code\t\t:" + this.code);
        System.out.println("version\t\t:" + this.version);
        System.out.println("revision\t:" + this.revision);
        System.out.println("iMessageType:" + this.iMessageType);
        System.out.println("=====================================================");
    }
}

