/*
 * Decompiled with CFR 0.152.
 */
package milsip.stack.sip;

import java.util.Date;
import java.util.StringTokenizer;
import java.util.Timer;
import milsip.stack.sip.BSSVideo;
import milsip.stack.sip.RFC2833;
import milsip.stack.sip.SIPAUTHENTICATEHeader;
import milsip.stack.sip.SIPCONTACTHeader;
import milsip.stack.sip.SIPCall;
import milsip.stack.sip.SIPHeader;
import milsip.stack.sip.SIPROUTEHeader;
import milsip.stack.sip.SIPRequestLine;
import milsip.stack.sip.SIPStack;
import milsip.stack.sip.SIPVIAHeader;

public class CMCore {
    String TAG = "CMCore";
    public String commandLine = null;
    public String viaH = null;
    public String maxforwardH = null;
    public String contactH = null;
    public String toH = null;
    public String fromH = null;
    public String callidH = null;
    public String cseqH = null;
    public String expiresH = null;
    public String allowH = null;
    public String useragentH = null;
    public String contentlengthH = null;
    public String authorizationH = null;
    public String serverIp = null;
    public int serverPort = 5060;
    public String serverDomain = null;
    public String id = null;
    public String cid = null;
    public String authid = null;
    public String authpassword = null;
    public String localIp = null;
    public String fromTag = null;
    public String callId = null;
    public int localPort = 5060;
    public byte[] byteAddress = null;
    public int CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_REGISTER;
    public int regState = SIPStack.SIP_REGSTATE_IDLE;
    public Date regTime = new Date();
    public Date callTime = new Date();
    public int expiresSeconds = 60;
    public int repeatRegisterCount = 0;
    public int registerNonceCount = 0;
    public String ifIp = null;
    public int ifPort = 5060;
    public String previfIp = null;
    public int previfPort = 5060;
    public boolean bInterfaceChanged = false;
    public String message = null;
    public int serviceMode = SIPStack.SIP_SERVICEMODE_BASIC;
    public boolean bRequestReadySet = false;
    public Timer SIGNALCTRLTimer = null;
    public Thread SIGNALCTRLThread = null;
    public boolean SIGNALCTRLRunning = false;
    public int ctrlIndex = 0;
    public Date ctrlIntervalTimer = new Date();
    public Date netcheckIntervalTimer = new Date();
    public Date registStatusTimer = new Date();
    public static Date pauseTime = new Date();
    public static boolean bPausing = true;
    public static final int BSSSIPStun_ICONTROLS_REGISTER = 1;
    public static final int BSSSIPStun_ICONTROLS_UNREGISTER = 2;
    public static final int BSSSIPStun_ICONTROLS_SET_INT_VALUE = 3;
    public static final int BSSSIPStun_ICONTROLS_SET_STRING_VALUE = 4;
    public static final int BSSSIPStun_ICONTROLS_CM_UPDATESTATUS_TRUE = 10;
    public static final int BSSSIPStun_ICONTROLS_CM_UPDATESTATUS_FALSE = 11;
    public static final int BSSSIPStun_ICONTROLS_CM_VIDEOSET_TRUE = 12;
    public static final int BSSSIPStun_ICONTROLS_CM_VIDEOSET_FALSE = 13;
    public static final int BSSSIPStun_ICONTROLS_CM_INCOMINGCALL = 14;
    public static final int BSSSIPStun_ICONTROLS_CM_CALLCONNECTED = 15;
    public static final int BSSSIPStun_ICONTROLS_CM_SHUTDOWNAPPLICATION = 16;
    public static final int BSSSIPStun_ICONTROLS_CM_BACKGROUNDINCOMINGCALL = 17;
    public static final int BSSSIPStun_ICONTROLS_CM_VIBRATOR_TRUE = 18;
    public static final int BSSSIPStun_ICONTROLS_CM_VIBRATOR_FALSE = 19;
    public static final int BSSSIPStun_ICONTROLS_CM_REGISTSTATUS_TRUE = 20;
    public static final int BSSSIPStun_ICONTROLS_CM_REGISTSTATUS_FALSE = 21;
    public static final int BSSSIPStun_ICONTROLS_CM_RINGBACKTONE_TRUE = 22;
    public static final int BSSSIPStun_ICONTROLS_CM_RINGBACKTONE_FALSE = 23;
    public static final int BSSSIPStun_ICONTROLS_CM_CALLEND_TRUE = 24;
    public static final int BSSSIPStun_ICONTROLS_CM_CALLEND_FALSE = 25;
    public static final int BSSSIPStun_ICONTROLS_CM_OUTBANDDTMF = 26;
    public static final int BSSSIPStun_ICONTROLS_CM_PADNUMBER = 27;
    public static final int BSSSIPStun_ICONTROLS_CM_PADTYPE = 28;
    public static final int BSSSIPStun_ICONTROLS_CM_CALLNEIGHBOR = 29;
    public static final int BSSSIPStun_ICONTROLS_CM_CALLGUARD = 30;
    public static final int BSSSIPStun_ICONTROLS_CM_CALLTIME = 31;
    public static final int BSSSIPStun_ICONTROLS_CM_INCOMINGMULTICALL = 32;
    public static final int BSSSIPStun_ICONTROLS_CM_ENDMULTICALL = 33;
    public static final int BSSSIPStun_ICONTROLS_CM_NORMALIZEMULTICALL = 34;
    public static final int BSSSIPStun_ICONTROLS_CM_CANCELMULTICALL = 35;
    public static final int BSSSIPStun_ICONTROLS_CM_OUTCALLFAIL = 36;
    public static final int BSSSIPStun_ICONTROLS_DIALER_ACCEPTMULTICALL = 40;
    public static final int BSSSIPStun_ICONTROLS_DIALER_REJECTMULTICALL = 41;
    public static final int BSSSIPStun_ICONTROLS_DIALER_CANCELMULTICALL = 42;
    public static final int BSSSIPStun_ICONTROLS_DIALER_COMMAND = 43;
    public static final int BSSSIPStun_ICONTROLS_DIALER_FORWARD = 44;
    public static final int BSSSIPStun_ICONTROLS_CONTACT_CALLNEIGHBOR = 50;
    public static final int BSSSIPStun_ICONTROLS_CONTACT_CALLGUARD = 51;
    public static final int BSSSIPStun_ICONTROLS_BLOCK_INVITE_MSG = 100;
    public static final int BSSSIPStun_ICONTROLS_PAUSING_DURATION = 1000;
    public static boolean bDialerActive = false;

    public CMCore() {
        System.out.println("[CMCore] ========== START ==========");
        if (!SIPStack.bStackLicensed) {
            System.out.println("\ub77c\uc774\uc2a8\uc2a4\ud0a4\ub97c \uc124\uc815\ud558\uc138\uc694.");
        }
        this.commandLine = null;
        this.viaH = null;
        this.maxforwardH = null;
        this.contactH = null;
        this.toH = null;
        this.fromH = null;
        this.callidH = null;
        this.cseqH = null;
        this.expiresH = null;
        this.allowH = null;
        this.useragentH = null;
        this.contentlengthH = null;
        this.authorizationH = null;
        this.serverIp = null;
        this.serverPort = 5060;
        this.serverDomain = null;
        this.id = null;
        this.cid = null;
        this.authid = null;
        this.authpassword = null;
        this.localIp = null;
        this.fromTag = null;
        this.callId = null;
        this.localPort = 5060;
        this.byteAddress = null;
        this.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_REGISTER;
        this.regState = SIPStack.SIP_REGSTATE_IDLE;
        this.regTime = new Date();
        this.callTime = new Date();
        this.expiresSeconds = 60;
        this.repeatRegisterCount = 0;
        this.registerNonceCount = 0;
        this.ifIp = null;
        this.ifPort = 5060;
        this.previfIp = null;
        this.previfPort = 5060;
        this.bInterfaceChanged = false;
        this.message = null;
        this.serviceMode = SIPStack.SIP_SERVICEMODE_BASIC;
        this.bRequestReadySet = false;
        this.SIGNALCTRLTimer = null;
        this.SIGNALCTRLThread = null;
        this.SIGNALCTRLRunning = false;
        this.ctrlIndex = 0;
        this.ctrlIntervalTimer = new Date();
        this.netcheckIntervalTimer = new Date();
        this.registStatusTimer = new Date();
    }

    public void action_0(byte[] byteLocalip, int localport, byte[] byteServerip, int serverport, byte[] byteServerdomain, byte[] byteId, byte[] byteCid, byte[] byteAuthid, byte[] byteAuthpassword) {
        this.byteAddress = this.byteAddress;
        this.localIp = new String(byteLocalip, 0, 0, byteLocalip.length);
        this.localPort = localport;
        SIPStack.localSdpIp = new String(byteLocalip, 0, 0, byteLocalip.length);
        if (SIPStack.usePrivateWiMax && (SIPStack.isInternetWiMax || SIPStack.isInternetMobile) && !SIPStack.isPrivateIp(SIPStack.localSdpIp)) {
            SIPStack.localSdpIp = "192.168.10.2";
        }
        this.ifIp = new String(byteLocalip, 0, 0, byteLocalip.length);
        this.ifPort = this.localPort;
        this.serverIp = new String(byteServerip, 0, 0, byteServerip.length);
        this.serverPort = serverport;
        this.serverDomain = new String(byteServerdomain, 0, 0, byteServerdomain.length);
        if (this.serverDomain == null || this.serverDomain.length() == 0) {
            this.serverDomain = new String(this.serverIp);
        }
        this.id = new String(byteId, 0, 0, byteId.length);
        this.cid = new String(byteCid, 0, 0, byteCid.length);
        if (this.cid.length() < 7 || this.cid.length() == 0) {
            this.cid = new String(this.id);
        }
        this.authid = new String(byteAuthid, 0, 0, byteAuthid.length);
        this.authpassword = new String(byteAuthpassword, 0, 0, byteAuthpassword.length);
        this.commandLine = "REGISTER sip:" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
        Date today = new Date();
        this.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + SIPStack.getViaBranch() + ";rport";
        this.maxforwardH = "Max-Forwards: 70";
        this.contactH = "Contact: <sip:" + this.id + "@" + this.localIp + ":" + this.localPort + ">";
        this.toH = "To: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">";
        this.fromTag = SIPStack.newTag();
        this.fromH = "From: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">;tag=" + this.fromTag;
        this.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
        this.callidH = "Call-ID: " + this.callId;
        if (this.CSEQ_NUMBER > 65556) {
            this.CSEQ_NUMBER = 0;
        }
        SIPStack.SIP_SEQUENCE_REGISTER = this.CSEQ_NUMBER;
        this.cseqH = "CSeq: " + this.CSEQ_NUMBER + " REGISTER";
        this.expiresH = "Expires: " + this.expiresSeconds;
        this.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
        this.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
        this.contentlengthH = "Content-Length: 0";
        this.message = String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
        if (SIPStack.bUseCtrlTimer) {
            if (this.SIGNALCTRLTimer != null) {
                this.SIGNALCTRLTimer.cancel();
            }
        } else {
            if (this.SIGNALCTRLThread != null) {
                this.SIGNALCTRLThread.interrupt();
            }
            this.SIGNALCTRLRunning = false;
        }
        this.SIGNALCTRLTimer = new Timer();
    }

    public void action_1(byte[] byteAddress, byte[] byteLocalip, int localport, String strServerHost, int serverport, String strServerDomain, byte[] byteId, byte[] byteCid, byte[] byteAuthid, byte[] byteAuthpassword) {
        this.localIp = new String(byteLocalip, 0, 0, byteLocalip.length);
        this.localPort = localport;
        SIPStack.localSdpIp = this.localIp;
        this.ifIp = new String(byteLocalip, 0, 0, byteLocalip.length);
        this.ifPort = this.localPort;
        this.serverPort = serverport;
        SIPStack.ipdns.bSipAddressResolved = false;
        SIPStack.ipdns.sipServerHost = "";
        this.serverDomain = "";
        this.serverIp = "";
        SIPStack.ipdns.sipTry = 0;
        if (strServerDomain != null && strServerDomain.length() > 0) {
            this.serverDomain = new String(strServerDomain);
        }
        if (strServerHost != null && strServerHost.length() > 0) {
            SIPStack.ipdns.sipServerHost = strServerHost;
        } else {
            SIPStack.ipdns.bSipAddressResolved = true;
        }
        this.id = new String(byteId, 0, 0, byteId.length);
        this.cid = new String(byteCid, 0, 0, byteCid.length);
        if (this.cid.length() < 7 || this.cid.length() == 0) {
            this.cid = new String(this.id);
        }
        this.authid = new String(byteAuthid, 0, 0, byteAuthid.length);
        this.authpassword = new String(byteAuthpassword, 0, 0, byteAuthpassword.length);
        this.commandLine = "REGISTER sip:" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
        Date today = new Date();
        this.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + SIPStack.getViaBranch() + ";rport";
        this.maxforwardH = "Max-Forwards: 70";
        this.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + this.localIp + ":" + this.localPort + ">";
        this.toH = "To: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">";
        this.fromTag = SIPStack.newTag();
        this.fromH = "From: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">;tag=" + this.fromTag;
        this.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
        this.callidH = "Call-ID: " + this.callId;
        if (this.CSEQ_NUMBER > 65556) {
            this.CSEQ_NUMBER = 0;
        }
        SIPStack.SIP_SEQUENCE_REGISTER = this.CSEQ_NUMBER;
        this.cseqH = "CSeq: " + this.CSEQ_NUMBER + " REGISTER";
        this.expiresH = "Expires: " + this.expiresSeconds;
        this.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
        this.useragentH = "User-Agent: " + SIPStack.USER_AGENT;
        this.contentlengthH = "Content-Length: 0";
        this.message = String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
        if (SIPStack.bUseCtrlTimer) {
            if (this.SIGNALCTRLTimer != null) {
                this.SIGNALCTRLTimer.cancel();
            }
        } else {
            if (this.SIGNALCTRLThread != null) {
                this.SIGNALCTRLThread.interrupt();
            }
            this.SIGNALCTRLRunning = false;
        }
        this.SIGNALCTRLTimer = new Timer();
    }

    public void action_2(String strId, String strCid, String strAuthid, String strAuthpassword, String strServerHost, String strServerDomain, int serverport) {
        this.serverIp = SIPStack.getIPV4(strServerHost);
        if (this.serverIp == null) {
            this.serverIp = "";
        }
        this.serverDomain = strServerDomain == null || strServerDomain.length() == 0 ? new String(this.serverIp) : new String(strServerDomain);
        this.serverPort = serverport;
        this.id = new String(strId);
        this.cid = new String(strCid);
        this.authid = new String(strAuthid);
        this.authpassword = new String(strAuthpassword);
        this.regState = SIPStack.SIP_REGSTATE_REGISTERING;
    }

    public boolean action_net_0() {
        try {
            if (!SIPStack.ipdns.bSipAddressResolved && SIPStack.ipdns.sipServerHost != null && SIPStack.ipdns.sipServerHost.length() > 0) {
                this.serverIp = SIPStack.getIPV4(SIPStack.ipdns.sipServerHost);
                ++SIPStack.ipdns.sipTry;
                if (this.serverIp == null) {
                    this.serverIp = "";
                } else {
                    SIPStack.ipdns.bSipAddressResolved = true;
                }
                if (this.serverDomain == null || this.serverDomain.length() == 0) {
                    this.serverDomain = new String(SIPStack.ipdns.sipServerHost);
                }
                if (this.serverIp != null && this.serverIp.length() > 0) {
                    this.regState = SIPStack.SIP_REGSTATE_REGISTERING;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void action_net_1(String host) {
        try {
            if (host != null && host.length() > 0) {
                String ip = SIPStack.getIPV4(host);
                if (ip != null && ip.length() > 0) {
                    SIPStack.networkStatus = SIPStack.SIP_NETIF_AVAILABLE;
                }
                if (ip != null && ip.length() > 0 && ip.compareToIgnoreCase(this.localIp) != 0) {
                    this.localIp = new String(ip);
                    SIPStack.localSdpIp = SIPStack.usePrivateWiMax && (SIPStack.isInternetWiMax || SIPStack.isInternetMobile) && !SIPStack.isPrivateIp(ip) ? "192.168.10.2" : new String(ip);
                    if (this.ifIp == null || this.ifIp.length() == 0 || this.ifPort <= 0) {
                        this.ifIp = new String(this.localIp);
                        this.ifPort = SIPStack.SIP_LOCAL_PORT;
                    }
                } else if (ip == null || ip.length() == 0) {
                    this.localIp = "127.0.0.1";
                    SIPStack.localSdpIp = "127.0.0.1";
                    SIPStack.networkStatus = SIPStack.SIP_NETIF_UNAVAILABLE;
                }
            } else if (host == null || host.length() == 0) {
                this.localIp = "127.0.0.1";
                SIPStack.localSdpIp = "127.0.0.1";
                SIPStack.networkStatus = SIPStack.SIP_NETIF_UNAVAILABLE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean action_net_2(String host) {
        try {
            if (host != null && host.length() > 0) {
                String ip = SIPStack.getIPV4(host);
                if (ip != null && ip.length() > 0) {
                    SIPStack.networkStatus = SIPStack.SIP_NETIF_AVAILABLE;
                }
                if (ip != null && ip.length() > 0 && ip.compareToIgnoreCase(this.localIp) != 0) {
                    this.localIp = new String(ip);
                    SIPStack.localSdpIp = SIPStack.usePrivateWiMax && (SIPStack.isInternetWiMax || SIPStack.isInternetMobile) && !SIPStack.isPrivateIp(ip) ? "192.168.10.2" : new String(ip);
                    this.ifIp = new String(this.localIp);
                    this.ifPort = SIPStack.SIP_LOCAL_PORT;
                    this.authorizationH = "";
                    return true;
                }
                if (ip == null || ip.length() == 0) {
                    this.localIp = "127.0.0.1";
                    SIPStack.localSdpIp = "127.0.0.1";
                    SIPStack.networkStatus = SIPStack.SIP_NETIF_UNAVAILABLE;
                }
            } else if (host == null || host.length() == 0) {
                this.localIp = "127.0.0.1";
                SIPStack.localSdpIp = "127.0.0.1";
                SIPStack.networkStatus = SIPStack.SIP_NETIF_UNAVAILABLE;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean action_net_3(String host) {
        try {
            if (host != null && host.length() > 0) {
                String ip = SIPStack.getIPV4(host);
                if (ip != null && ip.length() > 0) {
                    SIPStack.networkStatus = SIPStack.SIP_NETIF_AVAILABLE;
                }
                if (ip != null && ip.length() > 0 && ip.compareToIgnoreCase(this.localIp) != 0) {
                    this.localIp = new String(ip);
                    SIPStack.localSdpIp = SIPStack.usePrivateWiMax && (SIPStack.isInternetWiMax || SIPStack.isInternetMobile) && !SIPStack.isPrivateIp(ip) ? "192.168.10.2" : new String(ip);
                    this.bInterfaceChanged = true;
                    this.previfIp = this.ifIp;
                    this.previfPort = this.ifPort;
                    this.ifIp = new String(this.localIp);
                    this.ifPort = SIPStack.SIP_LOCAL_PORT;
                    return true;
                }
                if (ip == null || ip.length() == 0) {
                    this.localIp = "127.0.0.1";
                    SIPStack.localSdpIp = "127.0.0.1";
                    SIPStack.networkStatus = SIPStack.SIP_NETIF_UNAVAILABLE;
                }
            } else if (host == null || host.length() == 0) {
                this.localIp = "127.0.0.1";
                SIPStack.localSdpIp = "127.0.0.1";
                SIPStack.networkStatus = SIPStack.SIP_NETIF_UNAVAILABLE;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public SIPCONTACTHeader action_reg_0(String message) {
        try {
            String requestUri = "sip:" + this.id + "@" + this.localIp + ":" + this.localPort;
            if (this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0) {
                requestUri = this.bInterfaceChanged ? "sip:" + this.id + "@" + this.previfIp + ":" + this.previfPort : "sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort;
            }
            return new SIPCONTACTHeader(message, requestUri);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean action_reg_1(String message) {
        try {
            SIPVIAHeader viaHeader = new SIPVIAHeader(message);
            if (viaHeader.flag && viaHeader.rportService && viaHeader.rport > 0 && viaHeader.received.length() > 0 && (this.ifIp == null || this.ifIp.length() == 0 || this.ifPort <= 0 || this.ifIp.compareToIgnoreCase(viaHeader.received) != 0 || this.ifPort != viaHeader.rport)) {
                this.bInterfaceChanged = true;
                this.previfIp = this.ifIp;
                this.previfPort = this.ifPort;
                this.ifIp = new String(viaHeader.received);
                this.ifPort = viaHeader.getRport();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean action_reg_2(String message) {
        try {
            this.authorizationH = "";
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
            if (sipHeader == null || !sipHeader.flag) {
                sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
            }
            if (sipHeader != null && sipHeader.flag) {
                SIPAUTHENTICATEHeader authHeader = new SIPAUTHENTICATEHeader(sipHeader.header, SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
                if (authHeader == null || !authHeader.flag) {
                    authHeader = new SIPAUTHENTICATEHeader(sipHeader.header, SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
                }
                if (authHeader != null && authHeader.flag && authHeader.nonceValue.length() > 0 && authHeader.realmValue.length() > 0) {
                    String qop = authHeader.qopValue;
                    String uri = "sip:" + this.serverDomain + ":" + this.serverPort;
                    this.authorizationH = this.getAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_REGISTER);
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean action_reg_3(String message) {
        try {
            SIPAUTHENTICATEHeader authHeader;
            this.regState = SIPStack.SIP_REGSTATE_UNAUTHORIZED;
            this.authorizationH = "";
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE);
            if (sipHeader != null && sipHeader.flag && (authHeader = new SIPAUTHENTICATEHeader(sipHeader.header, SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE)) != null && authHeader.flag && authHeader.nonceValue.length() > 0 && authHeader.realmValue.length() > 0) {
                String qop = authHeader.qopValue;
                String uri = "sip:" + this.serverDomain + ":" + this.serverPort;
                this.authorizationH = this.getProxyAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_REGISTER);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void action_reg_4(String message) {
        try {
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_MINEXPIRES);
            if (sipHeader != null && sipHeader.flag) {
                this.expiresSeconds = Integer.parseInt(sipHeader.headerValue);
            }
            this.regState = SIPStack.SIP_REGSTATE_IDLE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean action_bye_0(SIPCall sipCall, String message) {
        try {
            SIPRequestLine requestLine = new SIPRequestLine(message);
            if (requestLine != null) {
                SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
                boolean bValidCall = false;
                if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                    bValidCall = true;
                }
                if (bValidCall && (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ)) != null && sipHeader.flag) {
                    int duration = 0;
                    Date currentTime = new Date();
                    if (sipCall.callTime_T4 != null) {
                        duration = (int)(currentTime.getTime() - sipCall.callTime_T4.getTime()) / 1000;
                    }
                    sipCall.BYE_CSEQ = sipHeader.callSequenceNumber();
                    sipCall.callState = 9;
                    sipCall.callTime_T6 = new Date();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean action_bye_1(SIPCall sipCall, String message) {
        try {
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
            boolean bValidCall = false;
            if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                bValidCall = true;
            }
            if (bValidCall && (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ)) != null && sipHeader.flag) {
                sipCall.BYE_CSEQ = sipHeader.callSequenceNumber();
                sipCall.bByedisconnected = false;
                sipCall.resetCall();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean action_info_0(SIPCall sipCall, String message, int msgType) {
        try {
            SIPHeader sipHeader;
            SIPRequestLine requestLine;
            if (msgType == SIPStack.SIP_MSGTYPE_REQUEST && sipCall.flag && sipCall.callState == 7 && (requestLine = new SIPRequestLine(message)) != null && (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID)) != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getAuthorizationHeader(String qop, String authid, String realmValue, String authpassword, String uri, String nonceValue, int methodType) {
        String strHeader = null;
        String finalDigest = null;
        String step1Digest = SIPStack.BSSMD5Get(String.valueOf(authid) + ":" + realmValue + ":" + authpassword);
        String step2Digest = null;
        if (methodType == SIPStack.SIP_METHODTYPE_REGISTER) {
            step2Digest = SIPStack.BSSMD5Get("REGISTER:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_INVITE) {
            step2Digest = SIPStack.BSSMD5Get("INVITE:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_CANCEL) {
            step2Digest = SIPStack.BSSMD5Get("CANCEL:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_ACK) {
            step2Digest = SIPStack.BSSMD5Get("ACK:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_BYE) {
            step2Digest = SIPStack.BSSMD5Get("BYE:" + uri);
        }
        ++this.registerNonceCount;
        if (qop.length() > 0) {
            int nonceCount = 0;
            String cnonce = SIPStack.BSSMD5Get("60cf184b29500b20" + this.registerNonceCount);
            if (nonceValue.length() > 0) {
                nonceCount = 1;
            }
            finalDigest = SIPStack.BSSMD5Get(String.valueOf(step1Digest) + ":" + nonceValue + ":" + String.format("%08x", nonceCount) + ":" + cnonce + ":" + qop + ":" + step2Digest);
            strHeader = "Authorization: Digest username=\"" + authid + "\", realm=\"" + realmValue + "\", nonce=\"" + nonceValue + "\", uri=\"" + uri + "\", response=\"" + finalDigest + "\", cnonce=\"" + cnonce + "\", nc=" + String.format("%08x", nonceCount) + ", qop=" + qop + ", algorithm=MD5";
        } else {
            finalDigest = SIPStack.BSSMD5Get(String.valueOf(step1Digest) + ":" + nonceValue + ":" + step2Digest);
            strHeader = "Authorization: Digest username=\"" + authid + "\", realm=\"" + realmValue + "\", nonce=\"" + nonceValue + "\", uri=\"" + uri + "\", response=\"" + finalDigest + "\", algorithm=MD5";
        }
        return strHeader;
    }

    public String getProxyAuthorizationHeader(String qop, String authid, String realmValue, String authpassword, String uri, String nonceValue, int methodType) {
        String strHeader = null;
        String finalDigest = null;
        String step1Digest = SIPStack.BSSMD5Get(String.valueOf(authid) + ":" + realmValue + ":" + authpassword);
        String step2Digest = null;
        if (methodType == SIPStack.SIP_METHODTYPE_REGISTER) {
            step2Digest = SIPStack.BSSMD5Get("REGISTER:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_INVITE) {
            step2Digest = SIPStack.BSSMD5Get("INVITE:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_CANCEL) {
            step2Digest = SIPStack.BSSMD5Get("CANCEL:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_ACK) {
            step2Digest = SIPStack.BSSMD5Get("ACK:" + uri);
        } else if (methodType == SIPStack.SIP_METHODTYPE_BYE) {
            step2Digest = SIPStack.BSSMD5Get("BYE:" + uri);
        }
        ++this.registerNonceCount;
        if (qop.length() > 0) {
            int nonceCount = 0;
            String cnonce = SIPStack.BSSMD5Get("60cf184b29500b20" + this.registerNonceCount);
            if (nonceValue.length() > 0) {
                nonceCount = 1;
            }
            finalDigest = SIPStack.BSSMD5Get(String.valueOf(step1Digest) + ":" + nonceValue + ":" + String.format("%08x", nonceCount) + ":" + cnonce + ":" + qop + ":" + step2Digest);
            strHeader = "Proxy-Authorization: Digest username=\"" + authid + "\", realm=\"" + realmValue + "\", nonce=\"" + nonceValue + "\", uri=\"" + uri + "\", response=\"" + finalDigest + "\", cnonce=\"" + cnonce + "\", nc=" + String.format("%08x", nonceCount) + ", qop=" + qop + ", algorithm=MD5";
        } else {
            finalDigest = SIPStack.BSSMD5Get(String.valueOf(step1Digest) + ":" + nonceValue + ":" + step2Digest);
            strHeader = "Proxy-Authorization: Digest username=\"" + authid + "\", realm=\"" + realmValue + "\", nonce=\"" + nonceValue + "\", uri=\"" + uri + "\", response=\"" + finalDigest + "\", algorithm=MD5";
        }
        return strHeader;
    }

    public boolean makeRegister() {
        try {
            ++this.CSEQ_NUMBER;
            this.commandLine = "REGISTER sip:" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            Date today = new Date();
            this.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + SIPStack.getViaBranch() + ";rport";
            this.maxforwardH = "Max-Forwards: 70";
            this.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + this.localIp + ":" + this.localPort + ">";
            this.toH = "To: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">";
            this.fromTag = SIPStack.newTag();
            this.fromH = "From: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">;tag=" + this.fromTag;
            if (this.callId == null || this.callId.length() == 0) {
                this.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
                this.callidH = "Call-ID: " + this.callId;
            }
            if (this.CSEQ_NUMBER > 65556) {
                this.CSEQ_NUMBER = 0;
            }
            SIPStack.SIP_SEQUENCE_REGISTER = this.CSEQ_NUMBER;
            this.cseqH = "CSeq: " + this.CSEQ_NUMBER + " REGISTER";
            this.expiresH = "Expires: " + this.expiresSeconds;
            this.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            this.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
            this.contentlengthH = "Content-Length: 0";
            this.message = this.authorizationH != null && this.authorizationH.length() > 0 ? String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.authorizationH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeUNRegister() {
        try {
            ++this.CSEQ_NUMBER;
            this.commandLine = "REGISTER sip:" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            Date today = new Date();
            this.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + SIPStack.getViaBranch() + ";rport";
            this.maxforwardH = "Max-Forwards: 70";
            this.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">;expires=0" : "Contact: <sip:" + this.id + "@" + this.localIp + ":" + this.localPort + ">;expires=0";
            this.toH = "To: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">";
            this.fromTag = SIPStack.newTag();
            this.fromH = "From: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">;tag=" + this.fromTag;
            if (this.callId == null || this.callId.length() == 0) {
                this.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
                this.callidH = "Call-ID: " + this.callId;
            }
            if (this.CSEQ_NUMBER > 65556) {
                this.CSEQ_NUMBER = 0;
            }
            SIPStack.SIP_SEQUENCE_REGISTER = this.CSEQ_NUMBER;
            this.cseqH = "CSeq: " + this.CSEQ_NUMBER + " REGISTER";
            this.expiresH = "Expires: 0";
            this.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            this.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
            this.contentlengthH = "Content-Length: 0";
            this.message = this.authorizationH != null && this.authorizationH.length() > 0 ? String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.authorizationH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeUNRegister(String contactip, int contactport) {
        try {
            ++this.CSEQ_NUMBER;
            this.commandLine = "REGISTER sip:" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            Date today = new Date();
            this.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + SIPStack.getViaBranch() + ";rport";
            this.maxforwardH = "Max-Forwards: 70";
            if (contactip == null || contactip.length() <= 0 || contactport <= 0) {
                return true;
            }
            this.contactH = "Contact: <sip:" + this.id + "@" + contactip + ":" + contactport + ">";
            this.toH = "To: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">";
            this.fromTag = SIPStack.newTag();
            this.fromH = "From: \"" + this.id + "\"<sip:" + this.id + "@" + this.serverDomain + ":" + this.serverPort + ">;tag=" + this.fromTag;
            if (this.callId == null || this.callId.length() == 0) {
                this.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
                this.callidH = "Call-ID: " + this.callId;
            }
            if (this.CSEQ_NUMBER > 65556) {
                this.CSEQ_NUMBER = 0;
            }
            SIPStack.SIP_SEQUENCE_REGISTER = this.CSEQ_NUMBER;
            this.cseqH = "CSeq: " + this.CSEQ_NUMBER + " REGISTER";
            this.expiresH = "Expires: 0";
            this.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            this.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
            this.contentlengthH = "Content-Length: 0";
            this.message = this.authorizationH != null && this.authorizationH.length() > 0 ? String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.authorizationH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(this.commandLine) + SIPStack.SIP_LINE_END + this.viaH + SIPStack.SIP_LINE_END + this.maxforwardH + SIPStack.SIP_LINE_END + this.contactH + SIPStack.SIP_LINE_END + this.fromH + SIPStack.SIP_LINE_END + this.toH + SIPStack.SIP_LINE_END + this.callidH + SIPStack.SIP_LINE_END + this.cseqH + SIPStack.SIP_LINE_END + this.expiresH + SIPStack.SIP_LINE_END + this.allowH + SIPStack.SIP_LINE_END + this.useragentH + SIPStack.SIP_LINE_END + this.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeCancel(SIPCall sipCall) {
        if (sipCall == null || !sipCall.flag) {
            return false;
        }
        sipCall.CANCEL_CSEQ = sipCall.CSEQ_NUMBER;
        if (sipCall.callState != 1 && sipCall.callState != 3 && sipCall.callState != 4) {
            return false;
        }
        String commandLine = "CANCEL sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
        String toH = "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
        if (sipCall.viaH == null || sipCall.viaH.length() == 0) {
            if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
                sipCall.viaBranch = SIPStack.getViaBranch();
            }
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
        }
        sipCall.cseqH = "CSeq: " + sipCall.CANCEL_CSEQ + " CANCEL";
        sipCall.contentlengthH = "Content-Length: 0";
        String routeString = "";
        if (sipCall.routeArray != null && sipCall.routeArray.length() > 0) {
            routeString = sipCall.routeArray.toString();
        }
        sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
        sipCall.message = sipCall.authorizationCANCELH != null && sipCall.authorizationCANCELH.length() > 0 ? String.valueOf(commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationCANCELH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
        return true;
    }

    public boolean makeRecancel(SIPCall sipCall) {
        if (sipCall == null || !sipCall.flag) {
            return false;
        }
        sipCall.CANCEL_CSEQ = sipCall.CSEQ_NUMBER;
        if (sipCall.callState != 11) {
            return false;
        }
        String commandLine = "CANCEL sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
        String toH = "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
        if (sipCall.viaH == null || sipCall.viaH.length() == 0) {
            if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
                sipCall.viaBranch = SIPStack.getViaBranch();
            }
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
        }
        sipCall.cseqH = "CSeq: " + sipCall.CANCEL_CSEQ + " CANCEL";
        sipCall.contentlengthH = "Content-Length: 0";
        String routeString = "";
        if (sipCall.routeArray != null && sipCall.routeArray.length() > 0) {
            routeString = sipCall.routeArray.toString();
        }
        sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
        sipCall.message = sipCall.authorizationCANCELH != null && sipCall.authorizationCANCELH.length() > 0 ? String.valueOf(commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationCANCELH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
        return true;
    }

    public boolean makeBye(SIPCall sipCall) {
        if (sipCall == null || !sipCall.flag) {
            return false;
        }
        if (sipCall.callState != 7 && sipCall.callState != 5 && sipCall.callState != 6) {
            return false;
        }
        String commandLine = null;
        commandLine = sipCall.remoteContactUri != null && sipCall.remoteContactUri.length() > 0 ? "BYE " + sipCall.remoteContactUri + " SIP/2.0" : "BYE sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
        if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
            sipCall.viaBranch = SIPStack.getViaBranch();
        }
        String viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch;
        String maxforwardH = "Max-Forwards: 70";
        String contactH = null;
        contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
        String toH = null;
        toH = sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN ? (sipCall.fromHeaderValue == null || sipCall.fromHeaderValue.length() == 0 ? "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag : "To: " + sipCall.fromHeaderValue) : "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.toTag;
        String fromH = null;
        fromH = sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN ? (sipCall.toHeaderValue == null || sipCall.toHeaderValue.length() == 0 ? "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.toTag : "From: " + sipCall.toHeaderValue) : "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
        sipCall.BYE_CSEQ = sipCall.CSEQ_NUMBER + 1;
        String cseqH = "CSeq: " + sipCall.BYE_CSEQ + " BYE";
        String contentlengthH = "Content-Length: 0";
        String routeString = "";
        if (sipCall.routeArray != null && sipCall.routeArray.length() > 0) {
            routeString = sipCall.routeArray.toString();
        }
        sipCall.message = sipCall.authorizationBYEH != null && sipCall.authorizationBYEH.length() > 0 ? String.valueOf(commandLine) + SIPStack.SIP_LINE_END + viaH + SIPStack.SIP_LINE_END + routeString + maxforwardH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationBYEH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(commandLine) + SIPStack.SIP_LINE_END + viaH + SIPStack.SIP_LINE_END + routeString + maxforwardH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
        return true;
    }

    public boolean makeReBye(SIPCall sipCall) {
        if (sipCall == null || !sipCall.flag) {
            return false;
        }
        if (sipCall.callState != 8 || !sipCall.bByedisconnected) {
            return false;
        }
        String commandLine = null;
        commandLine = sipCall.remoteContactUri != null && sipCall.remoteContactUri.length() > 0 ? "BYE " + sipCall.remoteContactUri + " SIP/2.0" : "BYE sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
        if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
            sipCall.viaBranch = SIPStack.getViaBranch();
        }
        String viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch;
        String maxforwardH = "Max-Forwards: 70";
        String contactH = null;
        contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
        String toH = null;
        toH = sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN ? (sipCall.fromHeaderValue == null || sipCall.fromHeaderValue.length() == 0 ? "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag : "To: " + sipCall.fromHeaderValue) : "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.toTag;
        String fromH = null;
        fromH = sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN ? (sipCall.toHeaderValue == null || sipCall.toHeaderValue.length() == 0 ? "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.toTag : "From: " + sipCall.toHeaderValue) : "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
        sipCall.BYE_CSEQ = sipCall.CSEQ_NUMBER + 1;
        String cseqH = "CSeq: " + sipCall.BYE_CSEQ + " BYE";
        String contentlengthH = "Content-Length: 0";
        String routeString = "";
        if (sipCall.routeArray != null && sipCall.routeArray.length() > 0) {
            routeString = sipCall.routeArray.toString();
        }
        sipCall.message = sipCall.authorizationBYEH != null && sipCall.authorizationBYEH.length() > 0 ? String.valueOf(commandLine) + SIPStack.SIP_LINE_END + viaH + SIPStack.SIP_LINE_END + routeString + maxforwardH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationBYEH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(commandLine) + SIPStack.SIP_LINE_END + viaH + SIPStack.SIP_LINE_END + routeString + maxforwardH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
        return true;
    }

    public String getVideomediadescription(int port) {
        String str = "";
        return str;
    }

    public boolean makeDirectcallMake(SIPCall sipCall, String number) {
        String postFix;
        String header = "";
        if (sipCall == null || sipCall.flag) {
            return false;
        }
        sipCall.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE++;
        if (SIPStack.SIP_SEQUENCE_INVITE > 65556) {
            SIPStack.SIP_SEQUENCE_INVITE = 1;
        }
        if (!sipCall.activeCallHandle(this.id, this.cid, this.authid, this.authpassword, number, sipCall.serverIp, sipCall.serverPort, sipCall.serverDomain, this.localIp, this.localPort)) {
            return false;
        }
        if (number.length() <= 0) {
            return false;
        }
        sipCall.commandLine = "INVITE sip:" + number + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + " SIP/2.0";
        Date today = new Date();
        sipCall.viaBranch = SIPStack.getViaBranch();
        sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
        sipCall.maxforwardH = "Max-Forwards: 70";
        sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
        sipCall.toH = "To: \"" + number + "\"<sip:" + number + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
        sipCall.fromTag = SIPStack.newTag();
        sipCall.fromH = "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
        if (BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED == BSSVideo.HNS_SERVICE_LOBBY) {
            postFix = "";
            if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
                postFix = BSSVideo.HNS_POSTFIX_GUARD;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
            } else if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
                postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
            } else {
                postFix = BSSVideo.HNS_POSTFIX_LOBBY;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
            }
            sipCall.callId = String.valueOf(BSSVideo.HNS_PREFIX_LOBBY) + SIPStack.BSSMD5Get(this.viaH) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + "." + postFix;
            sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_LOBBY;
            BSSVideo.bProgressvideooffer = true;
        } else if (BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
            postFix = "";
            if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
                postFix = BSSVideo.HNS_POSTFIX_GUARD;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
            } else if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
                postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
            } else {
                postFix = BSSVideo.HNS_POSTFIX_GUARD;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
            }
            sipCall.callId = String.valueOf(BSSVideo.HNS_PREFIX_GUARD) + SIPStack.BSSMD5Get(this.viaH) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + "." + postFix;
            sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_GUARD;
            BSSVideo.bProgressvideooffer = true;
        } else if (BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
            postFix = "";
            if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
                postFix = BSSVideo.HNS_POSTFIX_GUARD;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                BSSVideo.bProgressvideooffer = true;
            } else if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
                postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                BSSVideo.bProgressvideooffer = true;
            } else {
                postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
                BSSVideo.bProgressvideooffer = false;
            }
            sipCall.callId = String.valueOf(BSSVideo.HNS_PREFIX_NEIGHBOR) + SIPStack.BSSMD5Get(this.viaH) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + "." + postFix;
            sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
        } else {
            sipCall.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
            sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
            sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
            BSSVideo.bProgressvideooffer = false;
        }
        sipCall.callidH = "Call-ID: " + sipCall.callId;
        sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
        sipCall.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
        sipCall.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
        if (sipCall.cid != null && sipCall.cid.length() > 0) {
            sipCall.passertedidentityH = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            header = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">" + SIPStack.SIP_LINE_END;
        } else {
            sipCall.passertedidentityH = null;
            header = "";
        }
        int audioport = SIPStack.getFreeAudioRtpPort();
        if (audioport > 0) {
            sipCall.constructSdp();
        }
        if (sipCall.sdp != null && sipCall.sdp.flag) {
            sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
            if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
            } else {
                sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
            }
            sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
            sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
        }
        String body = null;
        sipCall.contenttypeH = "";
        if (sipCall.sdp != null && sipCall.sdp.flag) {
            sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
            body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(audioport + 2) : sipCall.sdp.getBodyString();
            sipCall.contentlengthH = "Content-Length: " + body.length();
        } else {
            body = "";
            sipCall.contentlengthH = "Content-Length: 0";
        }
        sipCall.callState = 1;
        sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
        sipCall.message = sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length() > 0 ? String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.authorizationINVITEH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body : String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
        return true;
    }

    public boolean INVITEParser_action_0(SIPCall sipCall, String message) {
        try {
            SIPRequestLine requestLine = new SIPRequestLine(message);
            if (requestLine != null && sipCall != null && sipCall.flag && sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_OUT) {
                SIPHeader seqHeader;
                SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
                boolean bValidCall = false;
                if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0 && (seqHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ)) != null && seqHeader.callSequenceNumber() == sipCall.CSEQ_NUMBER) {
                    sipCall.responseCode = requestLine.code;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean ACKParser_action_0(SIPCall sipCall, String message) {
        try {
            SIPRequestLine requestLine;
            if ((sipCall.callState == 23 || sipCall.callState == 24) && (requestLine = new SIPRequestLine(message)) != null) {
                SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
                boolean bValidCall = false;
                if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                    bValidCall = true;
                }
                if (bValidCall && (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ)) != null && sipHeader.flag) {
                    sipCall.ACK_CSEQ = sipHeader.callSequenceNumber();
                    sipCall.callMode = SIPStack.SIP_CALLMODE_BASIC;
                    sipCall.callState = 7;
                    sipCall.resetUpdateheaders();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean ACKParser_action_1(SIPCall sipCall, String message) {
        try {
            SIPRequestLine requestLine = new SIPRequestLine(message);
            if (requestLine != null) {
                boolean bValidCall = false;
                SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
                if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                    bValidCall = true;
                }
                if (bValidCall && (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ)) != null && sipHeader.flag) {
                    sipCall.ACK_CSEQ = sipHeader.callSequenceNumber();
                    sipCall.callState = 7;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean ACKParser_action_2(SIPCall sipCall, String message) {
        try {
            boolean bValidCall = false;
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
            if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean CANCELParser_action_0(SIPCall sipCall, String message) {
        try {
            SIPRequestLine requestLine = new SIPRequestLine(message);
            if (requestLine != null) {
                SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
                boolean bValidCall = false;
                if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                    bValidCall = true;
                }
                if (bValidCall && (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ)) != null && sipHeader.flag) {
                    sipCall.CANCEL_CSEQ = sipHeader.callSequenceNumber();
                    sipCall.callState = 12;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean CANCELParser_action_1(SIPCall sipCall, String message) {
        try {
            SIPRequestLine requestLine = new SIPRequestLine(message);
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
            boolean bValidCall = false;
            if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && sipCall.callId != null && sipHeader.headerValue.compareTo(sipCall.callId) == 0) {
                bValidCall = true;
            }
            if (bValidCall) {
                if (requestLine.code != 401) {
                    // empty if block
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String makeAcceptCancelRequest(SIPCall sipCall, String message) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            sipCall.BYE_CSEQ = sipCall.ACK_CSEQ;
            String commandLine = null;
            String viaH = null;
            Object maxforwardH = null;
            Object contactH = null;
            String toH = null;
            String fromH = null;
            String callidH = null;
            String cseqH = null;
            Object expiresH = null;
            Object allowH = null;
            Object useragentH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 200 " + SIPStack.getResponseDescription(200) + SIPStack.SIP_LINE_END;
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_VIA);
            viaH = sipHeader != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_FROM);
            fromH = sipHeader != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_TO);
            if (sipHeader != null && sipHeader.flag) {
                toH = String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END;
                if (toH.indexOf("tag=") < 0) {
                    toH = String.valueOf(sipHeader.header) + ";tag=" + SIPStack.newTag() + SIPStack.SIP_LINE_END;
                }
            } else {
                toH = "";
            }
            callidH = (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ);
            if (sipHeader != null && sipHeader.flag) {
                sipCall.CANCEL_CSEQ = sipHeader.callSequenceNumber();
                cseqH = String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END;
            } else {
                cseqH = "";
            }
            contentlengthH = "Content-Length: 0\r\n";
            String sendmessage = String.valueOf(commandLine) + viaH + fromH + toH + callidH + cseqH + contentlengthH + SIPStack.SIP_LINE_END;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String makeSendProgressingwithbody(SIPCall sipCall) {
        try {
            String commandLine = null;
            String contactH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 183 " + SIPStack.getResponseDescription(183) + SIPStack.SIP_LINE_END;
            String viaString = "";
            if (sipCall.viaArray.length() > 0) {
                viaString = sipCall.viaArray.toString();
            }
            String routeString = "";
            if (sipCall.recordrouteArray.length() > 0) {
                routeString = sipCall.recordrouteArray.toString();
            }
            contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            String contenttypeString = "";
            String bodyString = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                String body = "";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getFinalBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getFinalBodyString();
                if (body != null && body.length() > 0) {
                    bodyString = body;
                    contenttypeString = "Content-Type: application/SDP\r\n";
                }
            }
            contentlengthH = "Content-Length: " + bodyString.length() + SIPStack.SIP_LINE_END;
            String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contenttypeString + contentlengthH + SIPStack.SIP_LINE_END + bodyString;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String makeSendProgressing(SIPCall sipCall) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            String commandLine = null;
            String contactH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 180 " + SIPStack.getResponseDescription(180) + SIPStack.SIP_LINE_END;
            String viaString = "";
            if (sipCall.viaArray.length() > 0) {
                viaString = sipCall.viaArray.toString();
            }
            String routeString = "";
            if (sipCall.recordrouteArray != null && sipCall.recordrouteArray.length() > 0) {
                routeString = sipCall.recordrouteArray.toString();
            }
            contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            contentlengthH = "Content-Length: 0\r\n";
            String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_END;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String makeSendProceeding(SIPCall sipCall) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            String commandLine = null;
            String contactH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 100 " + SIPStack.getResponseDescription(100) + SIPStack.SIP_LINE_END;
            String viaString = "";
            if (sipCall.viaArray.length() > 0) {
                viaString = sipCall.viaArray.toString();
            }
            String routeString = "";
            if (sipCall.recordrouteArray != null && sipCall.recordrouteArray.length() > 0) {
                routeString = sipCall.recordrouteArray.toString();
            }
            contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            contentlengthH = "Content-Length: 0\r\n";
            String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_END;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String makeSendAccept(SIPCall sipCall) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            if (sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN && sipCall.callState == 2) {
                String commandLine = null;
                String contactH = null;
                String contentlengthH = null;
                commandLine = "SIP/2.0 200 " + SIPStack.getResponseDescription(200) + SIPStack.SIP_LINE_END;
                String viaString = "";
                if (sipCall.viaArray.length() > 0) {
                    viaString = sipCall.viaArray.toString();
                }
                String routeString = "";
                if (sipCall.recordrouteArray.length() > 0) {
                    routeString = sipCall.recordrouteArray.toString();
                }
                contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                String contenttypeString = "";
                String bodyString = "";
                if (sipCall.sdp != null && sipCall.sdp.flag) {
                    String body = "";
                    body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getFinalBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getFinalBodyString();
                    if (body != null && body.length() > 0) {
                        bodyString = body;
                        contenttypeString = "Content-Type: application/SDP\r\n";
                    }
                }
                contentlengthH = "Content-Length: " + bodyString.length() + SIPStack.SIP_LINE_END;
                String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contenttypeString + contentlengthH + SIPStack.SIP_LINE_END + bodyString;
                return sendmessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String makeDirectsendAccept(SIPCall sipCall) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            if (sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN && sipCall.callState == 2) {
                String commandLine = null;
                String contactH = null;
                String contentlengthH = null;
                commandLine = "SIP/2.0 200 " + SIPStack.getResponseDescription(200) + SIPStack.SIP_LINE_END;
                String viaString = "";
                if (sipCall.viaArray.length() > 0) {
                    viaString = sipCall.viaArray.toString();
                }
                String routeString = "";
                if (sipCall.recordrouteArray.length() > 0) {
                    routeString = sipCall.recordrouteArray.toString();
                }
                contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                String contenttypeString = "";
                String bodyString = "";
                if (sipCall.sdp != null && sipCall.sdp.flag) {
                    String body = "";
                    body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getFinalBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getFinalBodyString();
                    if (body != null && body.length() > 0) {
                        bodyString = body;
                        contenttypeString = "Content-Type: application/SDP\r\n";
                    }
                }
                contentlengthH = "Content-Length: " + bodyString.length() + SIPStack.SIP_LINE_END;
                String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contenttypeString + contentlengthH + SIPStack.SIP_LINE_END + bodyString;
                return sendmessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public boolean makeCallMake(SIPCall sipCall, String number) {
        try {
            String header = "";
            if (sipCall == null || sipCall.flag) {
                return false;
            }
            sipCall.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE++;
            if (SIPStack.SIP_SEQUENCE_INVITE > 65556) {
                SIPStack.SIP_SEQUENCE_INVITE = 1;
            }
            if (!sipCall.activeCallHandle(this.id, this.cid, this.authid, this.authpassword, number, this.serverIp, this.serverPort, this.serverDomain, this.localIp, this.localPort)) {
                return false;
            }
            if (number.length() <= 0) {
                return false;
            }
            sipCall.commandLine = "INVITE sip:" + number + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            Date today = new Date();
            sipCall.viaBranch = SIPStack.getViaBranch();
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            sipCall.maxforwardH = "Max-Forwards: 70";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            sipCall.toH = "To: \"" + number + "\"<sip:" + number + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
            sipCall.fromTag = SIPStack.newTag();
            sipCall.fromH = "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
            sipCall.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
            sipCall.callidH = "Call-ID: " + sipCall.callId;
            sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
            sipCall.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            sipCall.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
            if (sipCall.cid != null && sipCall.cid.length() > 0) {
                sipCall.passertedidentityH = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                header = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">" + SIPStack.SIP_LINE_END;
            } else {
                sipCall.passertedidentityH = null;
                header = "";
            }
            int audioport = SIPStack.getFreeAudioRtpPort();
            if (audioport > 0) {
                sipCall.constructSdp();
            }
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
                if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                } else {
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                }
                sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
                sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
            }
            String body = null;
            sipCall.contenttypeH = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getBodyString();
                sipCall.contentlengthH = "Content-Length: " + body.length();
            } else {
                body = "";
                sipCall.contentlengthH = "Content-Length: 0";
            }
            sipCall.callState = 1;
            sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
            if (sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length() > 0) {
                sipCall.message = String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.authorizationINVITEH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
                return true;
            }
            sipCall.message = String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeSendReInvite(SIPCall sipCall) {
        try {
            String header = null;
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
            sipCall.callState = 1;
            sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
            String body = null;
            sipCall.contenttypeH = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getBodyString();
                sipCall.contentlengthH = "Content-Length: " + body.length();
            } else {
                body = "";
                sipCall.contentlengthH = "Content-Length: 0";
            }
            if (sipCall.cid != null && sipCall.cid.length() > 0) {
                sipCall.passertedidentityH = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                header = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">" + SIPStack.SIP_LINE_END;
            } else {
                sipCall.passertedidentityH = null;
                header = "";
            }
            if (sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length() > 0) {
                sipCall.message = String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.authorizationINVITEH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
                return true;
            }
            sipCall.message = String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String makeRejectCall(SIPCall sipCall, int code) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            if (sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN && (sipCall.callState == 2 || sipCall.callState == 12)) {
                String commandLine = null;
                String contactH = null;
                String contentlengthH = null;
                commandLine = "SIP/2.0 " + code + " " + SIPStack.getResponseDescription(code) + SIPStack.SIP_LINE_END;
                String viaString = "";
                if (sipCall.viaArray.length() > 0) {
                    viaString = sipCall.viaArray.toString();
                }
                String routeString = "";
                if (sipCall.recordrouteArray.length() > 0) {
                    routeString = sipCall.recordrouteArray.toString();
                }
                contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                contentlengthH = "Content-Length: 0" + SIPStack.SIP_LINE_END;
                String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_END;
                return sendmessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String makeRejectCall(SIPCall sipCall, int code, String contact) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            if (sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN && (sipCall.callState == 2 || sipCall.callState == 12)) {
                String commandLine = null;
                String contactH = null;
                String contentlengthH = null;
                commandLine = "SIP/2.0 " + code + " " + SIPStack.getResponseDescription(code) + SIPStack.SIP_LINE_END;
                String viaString = "";
                if (sipCall.viaArray.length() > 0) {
                    viaString = sipCall.viaArray.toString();
                }
                String routeString = "";
                if (sipCall.recordrouteArray.length() > 0) {
                    routeString = sipCall.recordrouteArray.toString();
                }
                contactH = "Contact: <" + contact + ">";
                contentlengthH = "Content-Length: 0" + SIPStack.SIP_LINE_END;
                String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_END;
                return sendmessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String makeRejectCall(String message, int code, String localIp, int localPort, String remoteIp, int remotePort) {
        try {
            if (message == null || message.length() == 0 || remoteIp == null || remoteIp.length() == 0 || remotePort <= 0) {
                return "";
            }
            String viaH = "";
            StringBuffer viaArray = new StringBuffer();
            String routeH = "";
            StringBuffer routeArray = new StringBuffer();
            String recordrouteH = "";
            StringBuffer recordrouteArray = new StringBuffer();
            String contactH = "";
            String fromH = "";
            String callidH = "";
            String cseqH = "";
            String contentlengthH = "";
            StringTokenizer tokenArray = new StringTokenizer(message, SIPStack.SIP_LINE_END, true);
            while (tokenArray.hasMoreTokens()) {
                String s2;
                int iS_;
                String s1;
                int iS;
                String token = tokenArray.nextToken().trim();
                if (token.length() <= 0 || token.compareTo("\r") == 0 || token.compareTo("\n") == 0) continue;
                if (token.startsWith("From: ")) {
                    fromH = String.valueOf(token) + SIPStack.SIP_LINE_END;
                    continue;
                }
                if (token.startsWith("f: ")) {
                    fromH = String.valueOf(token) + SIPStack.SIP_LINE_END;
                    continue;
                }
                if (token.startsWith("To: ")) {
                    if (token.indexOf("tag=") < 0) {
                        this.toH = String.valueOf(token) + ";tag=" + new Date().getTime() + SIPStack.SIP_LINE_END;
                        continue;
                    }
                    this.toH = String.valueOf(token) + SIPStack.SIP_LINE_END;
                    continue;
                }
                if (token.startsWith("t: ")) {
                    if (token.indexOf("tag=") < 0) {
                        this.toH = String.valueOf(token) + ";tag=" + new Date().getTime() + SIPStack.SIP_LINE_END;
                        continue;
                    }
                    this.toH = String.valueOf(token) + SIPStack.SIP_LINE_END;
                    continue;
                }
                if (token.startsWith("Via: ")) {
                    if (viaH == null || viaH.length() == 0) {
                        viaH = token;
                        iS = token.indexOf(";rport=");
                        if (iS > 0 && token.indexOf(";received=") < 0) {
                            s1 = token.substring(0, iS);
                            iS_ = token.indexOf(";", iS + 1);
                            s2 = null;
                            if (iS_ > 0) {
                                s2 = token.substring(iS_ + 1);
                                if (s1 != null && s2 != null) {
                                    viaH = String.valueOf(s1) + ";" + s2;
                                } else if (s1 != null) {
                                    viaH = s1;
                                }
                            } else {
                                viaH = s1;
                            }
                            if (viaH != null && viaH.length() > 0) {
                                viaH = String.valueOf(viaH) + ";received=" + remoteIp + ";rport=" + remotePort;
                            }
                        }
                        if (viaH == null || viaH.length() <= 0) continue;
                        viaArray.append(String.valueOf(viaH) + SIPStack.SIP_LINE_END);
                        continue;
                    }
                    viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                    continue;
                }
                if (token.startsWith("v: ")) {
                    if (viaH == null || viaH.length() == 0) {
                        viaH = token;
                        iS = token.indexOf(";rport=");
                        if (iS > 0 && token.indexOf(";received=") < 0) {
                            s1 = token.substring(0, iS);
                            iS_ = token.indexOf(";", iS + 1);
                            s2 = null;
                            if (iS_ > 0) {
                                s2 = token.substring(iS_ + 1);
                                if (s1 != null && s2 != null) {
                                    viaH = String.valueOf(s1) + ";" + s2;
                                } else if (s1 != null) {
                                    viaH = s1;
                                }
                            } else {
                                viaH = s1;
                            }
                            if (viaH != null && viaH.length() > 0) {
                                viaH = String.valueOf(viaH) + ";received=" + remoteIp + ";rport=" + remotePort;
                            }
                        }
                        if (viaH == null || viaH.length() <= 0) continue;
                        viaArray.append(String.valueOf(viaH) + SIPStack.SIP_LINE_END);
                        continue;
                    }
                    viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                    continue;
                }
                if (token.startsWith("Record-Route: ")) {
                    if (recordrouteH == null || recordrouteH.length() == 0) {
                        routeH = null;
                        routeArray = new StringBuffer();
                        recordrouteH = token;
                        recordrouteArray.append(String.valueOf(recordrouteH) + SIPStack.SIP_LINE_END);
                        routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                        continue;
                    }
                    recordrouteArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                    routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                    continue;
                }
                if (token.startsWith("Call-ID: ")) {
                    callidH = String.valueOf(token) + SIPStack.SIP_LINE_END;
                    continue;
                }
                if (token.startsWith("i: ")) {
                    callidH = String.valueOf(token) + SIPStack.SIP_LINE_END;
                    continue;
                }
                if (token.startsWith("CSeq: ")) {
                    cseqH = String.valueOf(token) + SIPStack.SIP_LINE_END;
                    continue;
                }
                if (token.startsWith("Content-Length: ")) {
                    contentlengthH = "Content-Length: 0\r\n";
                    continue;
                }
                if (!token.startsWith("l: ")) continue;
                contentlengthH = "Content-Length: 0\r\n";
            }
            String commandLine = "SIP/2.0 " + code + " " + SIPStack.getResponseDescription(code) + SIPStack.SIP_LINE_END;
            String viaString = "";
            if (viaArray.length() > 0) {
                viaString = viaArray.toString();
            }
            String routeString = "";
            if (recordrouteArray.length() > 0) {
                routeString = recordrouteArray.toString();
            }
            contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + localIp + ":" + localPort + ">";
            contentlengthH = "Content-Length: 0" + SIPStack.SIP_LINE_END;
            String sendmessage = String.valueOf(commandLine) + viaString + routeString + fromH + this.toH + callidH + cseqH + contactH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_END;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String makeSendUpdateAccept(SIPCall sipCall) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            if (sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN && sipCall.callState == 23) {
                String body;
                String commandLine = null;
                String contactH = null;
                String contentlengthH = null;
                commandLine = "SIP/2.0 200 " + SIPStack.getResponseDescription(200) + SIPStack.SIP_LINE_END;
                String viaString = "";
                if (sipCall.viaArray.length() > 0) {
                    viaString = sipCall.viaArray.toString();
                }
                String routeString = "";
                if (sipCall.recordrouteArray.length() > 0) {
                    routeString = sipCall.recordrouteArray.toString();
                }
                sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                String contenttypeString = "";
                String bodyString = "";
                if (sipCall.sdp != null && sipCall.sdp.flag && (body = sipCall.sdp.getFinalBodyString()) != null && body.length() > 0) {
                    bodyString = body;
                    contenttypeString = "Content-Type: application/SDP\r\n";
                }
                contentlengthH = "Content-Length: " + bodyString.length() + SIPStack.SIP_LINE_END;
                String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contenttypeString + contentlengthH + SIPStack.SIP_LINE_END + bodyString;
                return sendmessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public boolean makeSendRedirectCall(SIPCall sipCall, String message) {
        try {
            String postFix;
            String header = null;
            if (message == null || message.length() == 0) {
                return false;
            }
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            SIPCONTACTHeader contactHeader = new SIPCONTACTHeader(message);
            if (contactHeader == null || !contactHeader.flag) {
                return false;
            }
            sipCall.initializeRedirectCall();
            sipCall.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE++;
            if (SIPStack.SIP_SEQUENCE_INVITE > 65556) {
                SIPStack.SIP_SEQUENCE_INVITE = 1;
            }
            if (contactHeader != null && contactHeader.sipuri != null && contactHeader.sipuri.length() > 0) {
                sipCall.commandLine = "INVITE " + contactHeader.sipuri + " SIP/2.0";
                sipCall.remoteIp = contactHeader.ip;
                sipCall.remotePort = contactHeader.port;
                sipCall.dnis = contactHeader.username;
                sipCall.serverDomain = contactHeader.ip;
                sipCall.serverPort = contactHeader.port;
                BSSVideo.HNS_SERVICE_RECEIVER_SELECTED = BSSVideo.HNS_SERVICE_NEIGHBOR;
                if (contactHeader.username.startsWith("lobby")) {
                    BSSVideo.HNS_SERVICE_RECEIVER_SELECTED = BSSVideo.HNS_SERVICE_LOBBY;
                } else if (contactHeader.username.startsWith("office")) {
                    BSSVideo.HNS_SERVICE_RECEIVER_SELECTED = BSSVideo.HNS_SERVICE_GUARD;
                }
            } else {
                return false;
            }
            Date today = new Date();
            sipCall.viaBranch = SIPStack.getViaBranch();
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            sipCall.maxforwardH = "Max-Forwards: 70";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            sipCall.toH = "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
            sipCall.fromTag = SIPStack.newTag();
            sipCall.fromH = "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
            if (BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED == BSSVideo.HNS_SERVICE_LOBBY) {
                postFix = "";
                if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
                    postFix = BSSVideo.HNS_POSTFIX_GUARD;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                } else if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
                    postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                } else {
                    postFix = BSSVideo.HNS_POSTFIX_LOBBY;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
                }
                sipCall.callId = String.valueOf(BSSVideo.HNS_PREFIX_LOBBY) + SIPStack.BSSMD5Get(this.viaH) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + "." + postFix;
                sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_LOBBY;
                BSSVideo.bProgressvideooffer = true;
            } else if (BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
                postFix = "";
                if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
                    postFix = BSSVideo.HNS_POSTFIX_GUARD;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                } else if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
                    postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                } else {
                    postFix = BSSVideo.HNS_POSTFIX_GUARD;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
                }
                sipCall.callId = String.valueOf(BSSVideo.HNS_PREFIX_GUARD) + SIPStack.BSSMD5Get(this.viaH) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + "." + postFix;
                sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_GUARD;
                BSSVideo.bProgressvideooffer = true;
            } else if (BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
                postFix = "";
                if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_GUARD) {
                    postFix = BSSVideo.HNS_POSTFIX_GUARD;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                    BSSVideo.bProgressvideooffer = true;
                } else if (BSSVideo.HNS_SERVICE_RECEIVER_SELECTED == BSSVideo.HNS_SERVICE_NEIGHBOR) {
                    postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                    BSSVideo.bProgressvideooffer = true;
                } else {
                    postFix = BSSVideo.HNS_POSTFIX_NEIGHBOR;
                    sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
                    BSSVideo.bProgressvideooffer = false;
                }
                sipCall.callId = String.valueOf(BSSVideo.HNS_PREFIX_NEIGHBOR) + SIPStack.BSSMD5Get(this.viaH) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + "." + postFix;
                sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
            } else {
                sipCall.callId = String.valueOf(SIPStack.BSSMD5Get(this.viaH)) + SIPStack.BSSMD5Get("1198602188") + today.getSeconds() + ".";
                sipCall.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
                sipCall.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                BSSVideo.bProgressvideooffer = false;
            }
            sipCall.callidH = "Call-ID: " + sipCall.callId;
            sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
            sipCall.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            sipCall.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
            if (sipCall.cid != null && sipCall.cid.length() > 0) {
                sipCall.passertedidentityH = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                header = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">" + SIPStack.SIP_LINE_END;
            } else {
                sipCall.passertedidentityH = null;
                header = "";
            }
            int audioport = SIPStack.getFreeAudioRtpPort();
            if (audioport > 0) {
                sipCall.constructSdp();
            }
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
                if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                } else {
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                }
                sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
                sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
            }
            String body = null;
            sipCall.contenttypeH = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getBodyString();
                sipCall.contentlengthH = "Content-Length: " + body.length();
            } else {
                body = "";
                sipCall.contentlengthH = "Content-Length: 0";
            }
            sipCall.callState = 1;
            sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
            sipCall.message = String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeReactionForWWWAUTHENTICATE(SIPCall sipCall, String message) {
        try {
            String header = null;
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            sipCall.CSEQ_NUMBER = ++SIPStack.SIP_SEQUENCE_INVITE;
            if (SIPStack.SIP_SEQUENCE_INVITE > 65556) {
                SIPStack.SIP_SEQUENCE_INVITE = 1;
            }
            sipCall.authorizationINVITEH = "";
            sipCall.authorizationCANCELH = "";
            sipCall.authorizationBYEH = "";
            sipCall.authorizationACKH = "";
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
            if (sipHeader == null || !sipHeader.flag) {
                sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
            }
            if (sipHeader != null && sipHeader.flag) {
                SIPAUTHENTICATEHeader authHeader = new SIPAUTHENTICATEHeader(sipHeader.header, SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
                if (authHeader == null || !authHeader.flag) {
                    authHeader = new SIPAUTHENTICATEHeader(sipHeader.header, SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
                }
                if (authHeader != null && authHeader.flag && authHeader.nonceValue.length() > 0 && authHeader.realmValue.length() > 0) {
                    String qop = authHeader.qopValue;
                    String uri = "sip:" + this.serverDomain + ":" + this.serverPort;
                    sipCall.authorizationINVITEH = this.getAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_INVITE);
                    sipCall.authorizationCANCELH = this.getAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_CANCEL);
                    sipCall.authorizationBYEH = this.getAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_BYE);
                    sipCall.authorizationACKH = this.getAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_ACK);
                }
            }
            sipCall.commandLine = "INVITE sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            sipCall.viaBranch = SIPStack.getViaBranch();
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            sipCall.maxforwardH = "Max-Forwards: 70";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            sipCall.toH = "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
            sipCall.fromTag = SIPStack.newTag();
            sipCall.fromH = "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
            sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
            sipCall.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            sipCall.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
            if (sipCall.cid != null && sipCall.cid.length() > 0) {
                sipCall.passertedidentityH = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                header = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">" + SIPStack.SIP_LINE_END;
            } else {
                sipCall.passertedidentityH = null;
                header = "";
            }
            if (sipCall.sdp == null) {
                int audioport = SIPStack.getFreeAudioRtpPort();
                if (audioport > 0) {
                    sipCall.constructSdp();
                }
                if (sipCall.sdp != null && sipCall.sdp.flag) {
                    sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
                    if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                    } else {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                    }
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
                    sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
                }
            }
            String body = null;
            sipCall.contenttypeH = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getBodyString();
                sipCall.contentlengthH = "Content-Length: " + body.length();
            } else {
                body = "";
                sipCall.contentlengthH = "Content-Length: 0";
            }
            sipCall.callState = 1;
            sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
            sipCall.message = "";
            sipCall.message = sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length() > 0 ? String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.authorizationINVITEH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body : String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeReactionForPROXYAUTHENTICATE(SIPCall sipCall, String message) {
        try {
            String header = null;
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            sipCall.CSEQ_NUMBER = ++SIPStack.SIP_SEQUENCE_INVITE;
            if (SIPStack.SIP_SEQUENCE_INVITE > 65556) {
                SIPStack.SIP_SEQUENCE_INVITE = 1;
            }
            sipCall.authorizationINVITEH = "";
            sipCall.authorizationCANCELH = "";
            sipCall.authorizationBYEH = "";
            sipCall.authorizationACKH = "";
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE);
            if (sipHeader != null && sipHeader.flag) {
                SIPAUTHENTICATEHeader authHeader = new SIPAUTHENTICATEHeader(sipHeader.header, SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE);
                if (authHeader.flag && authHeader.nonceValue.length() > 0 && authHeader.realmValue.length() > 0) {
                    String qop = authHeader.qopValue;
                    String uri = "sip:" + this.serverDomain + ":" + this.serverPort;
                    sipCall.authorizationINVITEH = this.getProxyAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_INVITE);
                    sipCall.authorizationCANCELH = this.getProxyAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_CANCEL);
                    sipCall.authorizationBYEH = this.getProxyAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_BYE);
                    sipCall.authorizationACKH = this.getProxyAuthorizationHeader(qop, this.authid, authHeader.realmValue, this.authpassword, uri, authHeader.nonceValue, SIPStack.SIP_METHODTYPE_ACK);
                }
            }
            sipCall.commandLine = "INVITE sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            sipCall.viaBranch = SIPStack.getViaBranch();
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            sipCall.maxforwardH = "Max-Forwards: 70";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            sipCall.toH = "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
            sipCall.fromTag = SIPStack.newTag();
            sipCall.fromH = "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
            sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
            sipCall.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            sipCall.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
            if (sipCall.cid != null && sipCall.cid.length() > 0) {
                sipCall.passertedidentityH = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
                header = "P-Asserted-Identity: <sip:" + sipCall.cid + "@" + sipCall.localIp + ":" + sipCall.localPort + ">" + SIPStack.SIP_LINE_END;
            } else {
                sipCall.passertedidentityH = null;
                header = "";
            }
            if (sipCall.sdp == null) {
                int audioport = SIPStack.getFreeAudioRtpPort();
                if (audioport > 0) {
                    sipCall.constructSdp();
                }
                if (sipCall.sdp != null && sipCall.sdp.flag) {
                    sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
                    if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                    } else {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                    }
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
                    sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
                }
            }
            String body = null;
            sipCall.contenttypeH = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getBodyString();
                sipCall.contentlengthH = "Content-Length: " + body.length();
            } else {
                body = "";
                sipCall.contentlengthH = "Content-Length: 0";
            }
            sipCall.callState = 1;
            sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
            sipCall.message = sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length() > 0 ? String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.authorizationINVITEH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body : String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + header + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String makeRedirectIncomingCall(SIPCall sipCall, String redirectId) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            if (redirectId == null || redirectId.length() == 0) {
                return "";
            }
            if (sipCall.callDirection == SIPStack.SIP_CALLDIRECTION_IN && (sipCall.callState == 2 || sipCall.callState == 12)) {
                String commandLine = null;
                String contactH = null;
                String contentlengthH = null;
                commandLine = "SIP/2.0 302 " + SIPStack.getResponseDescription(302) + SIPStack.SIP_LINE_END;
                String viaString = "";
                if (sipCall.viaArray.length() > 0) {
                    viaString = sipCall.viaArray.toString();
                }
                String routeString = "";
                if (sipCall.recordrouteArray.length() > 0) {
                    routeString = sipCall.recordrouteArray.toString();
                }
                contactH = "Contact: <sip:" + redirectId + "@" + this.serverIp + ":" + this.serverPort + ">";
                contentlengthH = "Content-Length: 0" + SIPStack.SIP_LINE_END;
                String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_END;
                return sendmessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String makeSendProgressing(SIPCall sipCall, String body) {
        try {
            SIPHeader sipHeader;
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            if (body == null || body.length() <= 0) {
                return "";
            }
            String commandLine = null;
            String contactH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 183 " + SIPStack.getResponseDescription(183) + SIPStack.SIP_LINE_END;
            String viaString = "";
            if (sipCall.viaArray.length() > 0) {
                viaString = sipCall.viaArray.toString();
            }
            this.viaH = (sipHeader = new SIPHeader(this.message, SIPStack.SIP_HEADERTYPE_VIA)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            String routeString = "";
            if (sipCall.recordrouteArray != null && sipCall.recordrouteArray.length() > 0) {
                routeString = sipCall.recordrouteArray.toString();
            }
            contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            contentlengthH = "Content-Length: " + body.length() + SIPStack.SIP_LINE_END;
            String contenttypeH = "";
            if (body != null && body.length() > 0) {
                contenttypeH = "Content-Type: application/SDP" + SIPStack.SIP_LINE_END;
            }
            String sendmessage = String.valueOf(commandLine) + viaString + routeString + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + contactH + SIPStack.SIP_LINE_END + contenttypeH + contentlengthH + SIPStack.SIP_LINE_END + body;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean makeSendAck(SIPCall sipCall, String message) {
        try {
            sipCall.routeIp = "";
            sipCall.routePort = 5060;
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            sipCall.ACK_CSEQ = sipCall.CSEQ_NUMBER;
            sipCall.reverseRecordRoute(message);
            sipCall.commandLine = sipCall.remoteContactUri != null && sipCall.remoteContactUri.length() > 0 ? "ACK " + sipCall.remoteContactUri + " SIP/2.0" : "ACK sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            if (sipCall.viaH == null || sipCall.viaH.length() == 0) {
                if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
                    sipCall.viaBranch = SIPStack.getViaBranch();
                }
                sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            }
            sipCall.cseqH = "CSeq: " + sipCall.ACK_CSEQ + " ACK";
            sipCall.contentlengthH = "Content-Length: 0";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            String routeString = "";
            if (sipCall.routeArray != null && sipCall.routeArray.length() > 0) {
                SIPROUTEHeader header;
                routeString = sipCall.routeArray.toString();
                if (sipCall.routeH != null && sipCall.routeH.length() > 0 && (header = new SIPROUTEHeader(sipCall.routeH)) != null && header.flag) {
                    sipCall.routeIp = header.getIp();
                    sipCall.routePort = header.getPort();
                }
            }
            sipCall.message = sipCall.authorizationACKH != null && sipCall.authorizationACKH.length() > 0 ? String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationACKH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeSendFinalAck(SIPCall sipCall, String message) {
        try {
            String fromH = null;
            String toH = null;
            String callidH = null;
            String viaH = null;
            String commandLine = null;
            String contentlengthH = null;
            String cseqH = null;
            SIPHeader sipheader = null;
            sipCall.routeIp = "";
            sipCall.routePort = 5060;
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_FROM);
            if (sipheader == null || !sipheader.flag || sipheader.header == null || sipheader.header.length() <= 0) {
                return false;
            }
            fromH = new String(sipheader.header);
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_TO);
            if (sipheader == null || !sipheader.flag || sipheader.header == null || sipheader.header.length() <= 0) {
                return false;
            }
            toH = new String(sipheader.header);
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
            if (sipheader == null || !sipheader.flag || sipheader.header == null || sipheader.header.length() <= 0) {
                return false;
            }
            callidH = new String(sipheader.header);
            int ACK_CSEQ = sipCall.CSEQ_NUMBER;
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ);
            if (sipheader != null && sipheader.flag && sipheader.callSequenceNumber() >= 0) {
                ACK_CSEQ = sipheader.callSequenceNumber();
            }
            sipCall.reverseRecordRoute(message);
            commandLine = sipCall.remoteContactUri != null && sipCall.remoteContactUri.length() > 0 ? "ACK " + sipCall.remoteContactUri + " SIP/2.0" : "ACK sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_VIA);
            if (sipheader != null && sipheader.flag && (viaH = new String(sipheader.header)) != null && viaH.length() > 0) {
                String branch = "";
                int index = viaH.indexOf(";branch=");
                if (index > 0) {
                    branch = viaH.substring(index + 1);
                }
                if ((index = branch.indexOf(";")) > 0) {
                    branch = branch.substring(0, index);
                }
                if ((index = viaH.indexOf(";received=")) > 0) {
                    viaH = viaH.substring(0, index);
                }
                if ((index = viaH.indexOf(";rport=")) > 0) {
                    viaH = viaH.substring(0, index);
                }
                viaH = String.valueOf(viaH) + ";" + branch;
            }
            if (viaH == null || viaH.length() == 0) {
                viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + SIPStack.getViaBranch() + ";rport";
            }
            cseqH = "CSeq: " + ACK_CSEQ + " ACK";
            contentlengthH = "Content-Length: 0";
            String routeString = "";
            if (sipCall.routeArray != null && sipCall.routeArray.length() > 0) {
                SIPROUTEHeader header;
                routeString = sipCall.routeArray.toString();
                if (sipCall.routeH != null && sipCall.routeH.length() > 0 && (header = new SIPROUTEHeader(sipCall.routeH)) != null && header.flag) {
                    sipCall.routeIp = header.getIp();
                    sipCall.routePort = header.getPort();
                }
            }
            sipCall.message = sipCall.authorizationACKH != null && sipCall.authorizationACKH.length() > 0 ? String.valueOf(commandLine) + SIPStack.SIP_LINE_END + fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + viaH + SIPStack.SIP_LINE_END + routeString + callidH + SIPStack.SIP_LINE_END + cseqH + SIPStack.SIP_LINE_END + sipCall.authorizationACKH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(commandLine) + SIPStack.SIP_LINE_END + fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + viaH + SIPStack.SIP_LINE_END + routeString + callidH + SIPStack.SIP_LINE_END + cseqH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String makeSendFinalAck(SIPCall sipCall, String message, String remoteIp, int remotePort) {
        try {
            String fromH = null;
            String toH = null;
            String callidH = null;
            String viaH = null;
            String commandLine = null;
            String contentlengthH = null;
            String cseqH = null;
            SIPHeader sipheader = null;
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_FROM);
            if (sipheader == null || !sipheader.flag || sipheader.header == null || sipheader.header.length() <= 0) {
                return "";
            }
            fromH = new String(sipheader.header);
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_TO);
            if (sipheader == null || !sipheader.flag || sipheader.header == null || sipheader.header.length() <= 0) {
                return "";
            }
            toH = new String(sipheader.header);
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
            if (sipheader == null || !sipheader.flag || sipheader.header == null || sipheader.header.length() <= 0) {
                return "";
            }
            callidH = new String(sipheader.header);
            int ACK_CSEQ = 0;
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ);
            if (sipheader != null && sipheader.flag && sipheader.callSequenceNumber() >= 0) {
                ACK_CSEQ = sipheader.callSequenceNumber();
            }
            commandLine = "ACK sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            sipheader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_VIA);
            if (sipheader != null && sipheader.flag && (viaH = new String(sipheader.header)) != null && viaH.length() > 0) {
                String branch = "";
                int index = viaH.indexOf(";branch=");
                if (index > 0) {
                    branch = viaH.substring(index + 1);
                }
                if ((index = branch.indexOf(";")) > 0) {
                    branch = branch.substring(0, index);
                }
                if ((index = viaH.indexOf(";received=")) > 0) {
                    viaH = viaH.substring(0, index);
                }
                if ((index = viaH.indexOf(";rport=")) > 0) {
                    viaH = viaH.substring(0, index);
                }
                viaH = String.valueOf(viaH) + ";" + branch;
            }
            if (viaH == null || viaH.length() == 0) {
                viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + SIPStack.getViaBranch() + ";rport";
            }
            cseqH = "CSeq: " + ACK_CSEQ + " ACK";
            contentlengthH = "Content-Length: 0";
            String sendmessage = String.valueOf(commandLine) + SIPStack.SIP_LINE_END + fromH + SIPStack.SIP_LINE_END + toH + SIPStack.SIP_LINE_END + viaH + SIPStack.SIP_LINE_END + callidH + SIPStack.SIP_LINE_END + cseqH + SIPStack.SIP_LINE_END + contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean makeSendRedirectFinalAck(SIPCall sipCall, String message) {
        try {
            sipCall.routeIp = "";
            sipCall.routePort = 5060;
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            sipCall.ACK_CSEQ = sipCall.CSEQ_NUMBER;
            sipCall.reverseRecordRoute(message);
            sipCall.commandLine = "ACK sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            if (sipCall.viaH == null || sipCall.viaH.length() == 0) {
                if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
                    sipCall.viaBranch = SIPStack.getViaBranch();
                }
                sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            }
            sipCall.cseqH = "CSeq: " + sipCall.ACK_CSEQ + " ACK";
            sipCall.contentlengthH = "Content-Length: 0";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            String routeString = "";
            if (sipCall.routeArray != null && sipCall.routeArray.length() > 0) {
                SIPROUTEHeader header;
                routeString = sipCall.routeArray.toString();
                if (sipCall.routeH != null && sipCall.routeH.length() > 0 && (header = new SIPROUTEHeader(sipCall.routeH)) != null && header.flag) {
                    sipCall.routeIp = header.getIp();
                    sipCall.routePort = header.getPort();
                }
            }
            sipCall.message = sipCall.authorizationACKH != null && sipCall.authorizationACKH.length() > 0 ? String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationACKH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND : String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + routeString + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String makeSendByeResponse(SIPCall sipCall, String message) {
        try {
            SIPHeader sipHeader;
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            sipCall.BYE_CSEQ = sipCall.ACK_CSEQ;
            String commandLine = null;
            String viaH = null;
            String toH = null;
            String fromH = null;
            String callidH = null;
            String cseqH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 200 " + SIPStack.getResponseDescription(200) + SIPStack.SIP_LINE_END;
            viaH = sipCall.getViaArray(message);
            if (viaH == null || viaH.length() == 0) {
                viaH = "";
            }
            fromH = (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_FROM)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_TO);
            if (sipHeader != null && sipHeader.flag) {
                toH = String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END;
                if (toH.indexOf("tag=") < 0) {
                    toH = String.valueOf(sipHeader.header) + ";tag=" + SIPStack.newTag() + SIPStack.SIP_LINE_END;
                }
            } else {
                toH = "";
            }
            callidH = (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ);
            if (sipHeader != null && sipHeader.flag) {
                sipCall.BYE_CSEQ = sipHeader.callSequenceNumber();
                cseqH = String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END;
            } else {
                cseqH = "";
            }
            contentlengthH = "Content-Length: 0\r\n";
            String sendmessage = String.valueOf(commandLine) + viaH + fromH + toH + callidH + cseqH + contentlengthH + SIPStack.SIP_LINE_END;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String makeSendOptionsResponse(SIPCall sipCall, String message, int code) {
        try {
            SIPHeader sipHeader;
            if (sipCall == null || !sipCall.flag) {
                return "";
            }
            String commandLine = null;
            String viaH = null;
            String toH = null;
            String fromH = null;
            String callidH = null;
            String cseqH = null;
            String allowH = null;
            String useragentH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 " + code + " " + SIPStack.getResponseDescription(code) + SIPStack.SIP_LINE_END;
            viaH = sipCall.getViaArray(message);
            if (viaH == null || viaH.length() == 0) {
                viaH = "";
            }
            fromH = (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_FROM)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_TO);
            if (sipHeader != null && sipHeader.flag) {
                toH = String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END;
                if (toH.indexOf("tag=") < 0) {
                    toH = String.valueOf(sipHeader.header) + ";tag=" + SIPStack.newTag() + SIPStack.SIP_LINE_END;
                }
            } else {
                toH = "";
            }
            callidH = (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ);
            cseqH = sipHeader != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO" + SIPStack.SIP_LINE_END;
            useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o" + SIPStack.SIP_LINE_END;
            contentlengthH = "Content-Length: 0\r\n";
            String sendmessage = String.valueOf(commandLine) + viaH + fromH + toH + callidH + cseqH + allowH + useragentH + contentlengthH + SIPStack.SIP_LINE_END;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String makeSendInfoResponse(SIPCall sipCall, String message, int code) {
        if (sipCall == null || !sipCall.flag) {
            return "";
        }
        try {
            SIPHeader sipHeader;
            String commandLine = null;
            String viaH = null;
            String toH = null;
            String fromH = null;
            String callidH = null;
            String cseqH = null;
            String allowH = null;
            String useragentH = null;
            String contentlengthH = null;
            commandLine = "SIP/2.0 " + code + " " + SIPStack.getResponseDescription(code) + SIPStack.SIP_LINE_END;
            viaH = sipCall.getViaArray(message);
            if (viaH == null || viaH.length() == 0) {
                viaH = "";
            }
            fromH = (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_FROM)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_TO);
            if (sipHeader != null && sipHeader.flag) {
                toH = String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END;
                if (toH.indexOf("tag=") < 0) {
                    toH = String.valueOf(sipHeader.header) + ";tag=" + SIPStack.newTag() + SIPStack.SIP_LINE_END;
                }
            } else {
                toH = "";
            }
            callidH = (sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID)) != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CSEQ);
            cseqH = sipHeader != null && sipHeader.flag ? String.valueOf(sipHeader.header) + SIPStack.SIP_LINE_END : "";
            this.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" + SIPStack.SIP_LINE_END : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">" + SIPStack.SIP_LINE_END;
            allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO" + SIPStack.SIP_LINE_END;
            useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o" + SIPStack.SIP_LINE_END;
            contentlengthH = "Content-Length: 0\r\n";
            String sendmessage = String.valueOf(commandLine) + viaH + fromH + toH + callidH + cseqH + this.contactH + allowH + useragentH + contentlengthH + SIPStack.SIP_LINE_END;
            return sendmessage;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean makeSendUpdate(SIPCall sipCall) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            String viaBranch = sipCall.viaBranch;
            sipCall.setUpdateheaders("sendonly");
            sipCall.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE++;
            if (SIPStack.SIP_SEQUENCE_INVITE > 65556) {
                SIPStack.SIP_SEQUENCE_INVITE = 1;
            }
            sipCall.commandLine = "INVITE sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            sipCall.viaBranch = viaBranch;
            if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
                sipCall.viaBranch = SIPStack.getViaBranch();
            }
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            sipCall.maxforwardH = "Max-Forwards: 70";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            if (sipCall.toH == null || sipCall.toH.length() == 0) {
                sipCall.toH = "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
            }
            if (sipCall.fromH == null || sipCall.fromH.length() == 0) {
                sipCall.fromTag = SIPStack.newTag();
                sipCall.fromH = "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
            }
            sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
            sipCall.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            sipCall.useragentH = "User-Agent: " + SIPStack.USER_AGENT;
            if (sipCall.sdp == null) {
                int audioport = SIPStack.getFreeAudioRtpPort();
                if (audioport > 0) {
                    sipCall.constructSdp();
                }
                if (sipCall.sdp != null && sipCall.sdp.flag) {
                    sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
                    if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                    } else {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                    }
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
                    sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
                }
            }
            String body = null;
            sipCall.contenttypeH = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getBodyString();
                sipCall.contentlengthH = "Content-Length: " + body.length();
            } else {
                body = "";
                sipCall.contentlengthH = "Content-Length: 0";
            }
            sipCall.callState = 20;
            sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
            sipCall.message = sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length() > 0 ? String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationINVITEH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body : String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean makeSendUpdate(SIPCall sipCall, String flow) {
        try {
            if (sipCall == null || !sipCall.flag) {
                return false;
            }
            String viaBranch = sipCall.viaBranch;
            sipCall.setUpdateheaders(flow);
            sipCall.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE++;
            if (SIPStack.SIP_SEQUENCE_INVITE > 65556) {
                SIPStack.SIP_SEQUENCE_INVITE = 1;
            }
            sipCall.commandLine = "INVITE sip:" + sipCall.dnis + "@" + this.serverDomain + ":" + this.serverPort + " SIP/2.0";
            sipCall.viaBranch = viaBranch;
            if (sipCall.viaBranch == null || sipCall.viaBranch.length() == 0) {
                sipCall.viaBranch = SIPStack.getViaBranch();
            }
            sipCall.viaH = "Via: SIP/2.0/UDP " + this.localIp + ":" + this.localPort + ";branch=" + sipCall.viaBranch + ";rport";
            sipCall.maxforwardH = "Max-Forwards: 70";
            sipCall.contactH = this.ifIp != null && this.ifIp.length() > 0 && this.ifPort > 0 ? "Contact: <sip:" + this.id + "@" + this.ifIp + ":" + this.ifPort + ">" : "Contact: <sip:" + this.id + "@" + sipCall.localIp + ":" + sipCall.localPort + ">";
            if (sipCall.toH == null || sipCall.toH.length() == 0) {
                sipCall.toH = "To: \"" + sipCall.dnis + "\"<sip:" + sipCall.dnis + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">";
            }
            if (sipCall.fromH == null || sipCall.fromH.length() == 0) {
                sipCall.fromTag = SIPStack.newTag();
                sipCall.fromH = "From: \"" + sipCall.id + "\"<sip:" + sipCall.id + "@" + sipCall.serverDomain + ":" + sipCall.serverPort + ">;tag=" + sipCall.fromTag;
            }
            sipCall.cseqH = "CSeq: " + sipCall.CSEQ_NUMBER + " INVITE";
            sipCall.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
            sipCall.useragentH = "User-Agent: " + SIPStack.USER_AGENT;
            if (sipCall.sdp == null) {
                int audioport = SIPStack.getFreeAudioRtpPort();
                if (audioport > 0) {
                    sipCall.constructSdp();
                }
                if (sipCall.sdp != null && sipCall.sdp.flag) {
                    sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
                    if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                    } else {
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                        sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                    }
                    sipCall.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
                    sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
                }
            }
            String body = null;
            sipCall.contenttypeH = "";
            if (sipCall.sdp != null && sipCall.sdp.flag) {
                sipCall.contenttypeH = "Content-Type: application/SDP\r\n";
                body = SIPStack.bVideocommunication ? String.valueOf(sipCall.sdp.getBodyString()) + this.getVideomediadescription(sipCall.sdp.audioM.mediaPort + 2) : sipCall.sdp.getBodyString();
                sipCall.contentlengthH = "Content-Length: " + body.length();
            } else {
                body = "";
                sipCall.contentlengthH = "Content-Length: 0";
            }
            sipCall.callState = 20;
            sipCall.callDirection = SIPStack.SIP_CALLDIRECTION_OUT;
            sipCall.message = sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length() > 0 ? String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.authorizationINVITEH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body : String.valueOf(sipCall.commandLine) + SIPStack.SIP_LINE_END + sipCall.viaH + SIPStack.SIP_LINE_END + sipCall.maxforwardH + SIPStack.SIP_LINE_END + sipCall.contactH + SIPStack.SIP_LINE_END + sipCall.fromH + SIPStack.SIP_LINE_END + sipCall.toH + SIPStack.SIP_LINE_END + sipCall.callidH + SIPStack.SIP_LINE_END + sipCall.cseqH + SIPStack.SIP_LINE_END + sipCall.allowH + SIPStack.SIP_LINE_END + sipCall.useragentH + SIPStack.SIP_LINE_END + sipCall.contenttypeH + sipCall.contentlengthH + SIPStack.SIP_LINE_DOUBLEEND + body;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getCallfailReason(int finalCode) {
        String desc = "";
        switch (finalCode) {
            case 200: {
                desc = "\ud1b5\ud654";
                break;
            }
            case 300: {
                desc = "\uac70\uc808";
                break;
            }
            case 301: {
                desc = "\uac70\uc808";
                break;
            }
            case 302: {
                desc = "\uac70\uc808";
                break;
            }
            case 305: {
                desc = "\uac70\uc808";
                break;
            }
            case 380: {
                desc = "\uac70\uc808";
                break;
            }
            case 400: {
                desc = "\uac70\uc808";
                break;
            }
            case 401: {
                desc = "\uac70\uc808";
                break;
            }
            case 402: {
                desc = "\uac70\uc808";
                break;
            }
            case 403: {
                desc = "\uac70\uc808";
                break;
            }
            case 404: {
                desc = "\uac70\uc808";
                break;
            }
            case 405: {
                desc = "\uac70\uc808";
                break;
            }
            case 406: {
                desc = "\uac70\uc808";
                break;
            }
            case 407: {
                desc = "\uac70\uc808";
                break;
            }
            case 408: {
                desc = "\uac70\uc808";
                break;
            }
            case 409: {
                desc = "\uac70\uc808";
                break;
            }
            case 410: {
                desc = "\uac70\uc808";
                break;
            }
            case 411: {
                desc = "\uac70\uc808";
                break;
            }
            case 413: {
                desc = "\uac70\uc808";
                break;
            }
            case 414: {
                desc = "\uac70\uc808";
                break;
            }
            case 415: {
                desc = "\uac70\uc808";
                break;
            }
            case 420: {
                desc = "\uac70\uc808";
                break;
            }
            case 421: {
                desc = "\uac70\uc808";
                break;
            }
            case 423: {
                desc = "\uac70\uc808";
                break;
            }
            case 480: {
                desc = "\uac70\uc808";
                break;
            }
            case 481: {
                desc = "\uac70\uc808";
                break;
            }
            case 482: {
                desc = "\uac70\uc808";
                break;
            }
            case 483: {
                desc = "\uac70\uc808";
                break;
            }
            case 484: {
                desc = "\uac70\uc808";
                break;
            }
            case 485: {
                desc = "\uac70\uc808";
                break;
            }
            case 486: {
                desc = "\uac70\uc808";
                break;
            }
            case 487: {
                desc = "\ud1b5\ud654\uc911";
                break;
            }
            case 488: {
                desc = "\uac70\uc808";
                break;
            }
            case 500: {
                desc = "\uac70\uc808";
                break;
            }
            case 501: {
                desc = "\uac70\uc808";
                break;
            }
            case 502: {
                desc = "\uac70\uc808";
                break;
            }
            case 503: {
                desc = "\uac70\uc808";
                break;
            }
            case 504: {
                desc = "\uac70\uc808";
                break;
            }
            case 505: {
                desc = "\uac70\uc808";
                break;
            }
            case 600: {
                desc = "\uac70\uc808";
                break;
            }
            case 603: {
                desc = "\uac70\uc808";
                break;
            }
            case 604: {
                desc = "\uac70\uc808";
                break;
            }
            case 606: {
                desc = "\uac70\uc808";
                break;
            }
            case 700: {
                desc = "\ud1b5\ud654\uc885\ub8cc";
            }
        }
        return desc;
    }
}

