/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class WallpadFaceIDRegData
extends wallpaddbmgr {
    private static final String TAG = "WallpadFaceIDRegData";
    public List<FaceIDDataClass> SyncData = new ArrayList<FaceIDDataClass>();
    private final String INIT_HEX = "00000000";
    private final String INIT_DATE = "0000:00:00:00:00:00";
    private final int USED_FALSE = 0;
    private final int USED_TRUE = 1;
    private final int MAX_COUNT = 255;

    public WallpadFaceIDRegData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("FaceIDRegDB")) {
            try {
                Log.i((String)TAG, (String)"[Create] CreateFaceIDRegDB");
                if (this.wdb != null) {
                    this.wdb.execSQL("create table FaceIDRegDB (id INTEGER unique, Used INTEGER, FaceID text, RegDate text, LastUseDate text, Nickname text);");
                }
                boolean bRet = this.InitInsert();
                Log.i((String)TAG, (String)("[Create] InitInsert = " + bRet));
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Create] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    private boolean InitInsert() {
        for (int i = 0; i < 255; ++i) {
            long ret;
            ContentValues values = this.GetInitValues(i + 1);
            if (this.wdb == null || (ret = this.wdb.insert("FaceIDRegDB", null, values)) >= 0L) continue;
            return false;
        }
        return true;
    }

    private boolean TestInitInsert() {
        Log.v((String)"yjyoon", (String)"TestInitInsert()");
        for (int i = 0; i < 255; ++i) {
            long ret;
            ContentValues values = i < 10 ? this.TestGetInitValues(i + 1) : this.GetInitValues(i + 1);
            if (this.wdb == null || (ret = this.wdb.insert("FaceIDRegDB", null, values)) >= 0L) continue;
            return false;
        }
        return true;
    }

    private ContentValues GetInitValues(int id) {
        ContentValues values = new ContentValues();
        values.put("id", Integer.valueOf(id));
        values.put("Used", Integer.valueOf(0));
        values.put("FaceID", "00");
        values.put("RegDate", "0000:00:00:00:00:00");
        values.put("LastUseDate", "0000:00:00:00:00:00");
        values.put("NickName", "");
        return values;
    }

    private ContentValues TestGetInitValues(int id) {
        String nick = "";
        ContentValues values = new ContentValues();
        values.put("id", Integer.valueOf(id));
        if (id == 8 || id == 9) {
            values.put("Used", Integer.valueOf(0));
        } else {
            values.put("Used", Integer.valueOf(1));
        }
        values.put("FaceID", String.format("%02X", id));
        values.put("RegDate", String.format("2022:06:16:11:30:%d", id));
        values.put("LastUseDate", String.format("2022:06:16:12:30:%d", id));
        if (id == 3) {
            nick = "\uc288\ud37c\ub9e8";
        } else if (id == 4) {
            nick = "\uc6b8\ud2b8\ub77c\ub9e8";
        }
        values.put("NickName", nick);
        return values;
    }

    public int GetEmptyId() {
        Cursor cursor = this.wdb.rawQuery("select id, Used from FaceIDRegDB;", null);
        try {
            int Used = 0;
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 0) continue;
                int id = cursor.getInt(0);
                cursor.close();
                return id;
            }
            cursor.close();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            return -100;
        }
        catch (Exception e) {
            cursor.close();
            Log.e((String)TAG, (String)"[GetEmptyId] Exception Error !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
        return -1;
    }

    public int Register(byte id, byte FaceID) {
        if ((id & 0xFF) < 1 || (id & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (id:" + id + ")"));
            return -1;
        }
        if ((FaceID & 0xFF) < 1 || (FaceID & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[Update] Param - FaceID  Out Of Range !!! (FaceID:" + FaceID + ")"));
            return -2;
        }
        int ret = 0;
        int ExistId = this.isExist(FaceID);
        if (ExistId > 0) {
            Log.w((String)TAG, (String)("[Update] isExist - Find !!! (ExistId:" + ExistId + ", FaceID:" + String.format("%02X", FaceID) + ")"));
            ret = this.UnRegister((byte)ExistId);
            Log.w((String)TAG, (String)("[Update] isExist - Find !!! UnRegister - ret:" + ret));
        }
        String whereClause = "id = " + id;
        ContentValues values = new ContentValues();
        values.put("Used", Integer.valueOf(1));
        values.put("FaceID", String.format("%02X", FaceID));
        GregorianCalendar cal = new GregorianCalendar();
        String DateStr = cal.get(1) + ":" + (cal.get(2) + 1) + ":" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        values.put("RegDate", DateStr);
        values.put("LastUseDate", DateStr);
        values.put("Nickname", "");
        ret = this.wdb.update("FaceIDRegDB", values, whereClause, null);
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public int RegisterAll(byte total, ArrayList<Byte> FaceID) {
        if ((total & 0xFF) < 1 || (total & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (total:" + total + ")"));
            return -1;
        }
        for (int i = 0; i < (total & 0xFF); ++i) {
            byte faceId = FaceID.get(i);
            if ((faceId & 0xFF) < 0 || (faceId & 0xFF) > 255) {
                Log.w((String)TAG, (String)("[Update] Param - FaceID  Out Of Range !!! (FaceID:" + faceId + ")"));
                return -2;
            }
            if ((faceId & 0xFF) == 0) continue;
            int ret = 0;
            int ExistId = this.isExist(faceId);
            if (ExistId > 0) continue;
            int id = ExistId > 0 ? ExistId : this.GetEmptyId();
            String whereClause = "id = " + id;
            ContentValues values = new ContentValues();
            values.put("Used", Integer.valueOf(1));
            values.put("FaceID", String.format("%02X", faceId));
            GregorianCalendar cal = new GregorianCalendar();
            String DateStr = cal.get(1) + ":" + (cal.get(2) + 1) + ":" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
            values.put("RegDate", DateStr);
            values.put("LastUseDate", DateStr);
            values.put("Nickname", "");
            ret = this.wdb.update("FaceIDRegDB", values, whereClause, null);
            if (ret >= 0) continue;
            return -10;
        }
        return 0;
    }

    public int UnRegister(byte id) {
        String whereClause;
        if ((id & 0xFF) < 1 || (id & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (id:" + id + ")"));
            return -1;
        }
        ContentValues values = this.GetInitValues(id & 0xFF);
        int ret = this.wdb.update("FaceIDRegDB", values, whereClause = "id = " + (id & 0xFF), null);
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public int UnRegisterAll() {
        int ret = -1;
        for (int i = 0; i < 255; ++i) {
            ret = this.UnRegister((byte)(i + 1));
            if (ret >= 0) continue;
            return -100 + -i;
        }
        return 0;
    }

    public int FindId(byte FaceID) {
        Cursor cursor = this.wdb.rawQuery("select id, Used, FaceID from FaceIDRegDB;", null);
        try {
            int Used = 0;
            String IdStr = String.format("%02X", FaceID);
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 1 || IdStr == null || !IdStr.equals(cursor.getString(2))) continue;
                int id = cursor.getInt(0);
                cursor.close();
                return id;
            }
            cursor.close();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            return -100;
        }
        catch (Exception e) {
            cursor.close();
            Log.e((String)TAG, (String)"[FindId] Exception Error !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
        return -1;
    }

    public int UpdateLastUseDate(byte id) {
        if ((id & 0xFF) < 1 || (id & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (id:" + id + ")"));
            return -1;
        }
        String whereClause = "id = " + (id & 0xFF);
        ContentValues values = new ContentValues();
        GregorianCalendar cal = new GregorianCalendar();
        String DateStr = cal.get(1) + ":" + (cal.get(2) + 1) + ":" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        values.put("LastUseDate", DateStr);
        int ret = this.wdb.update("FaceIDRegDB", values, whereClause, null);
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public int isExist(byte FaceID) {
        if ((FaceID & 0xFF) < 1 || (FaceID & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[isExist] Param - FaceID  Out Of Range !!! (FaceID:" + FaceID + ")"));
            return -10;
        }
        Cursor cursor = this.wdb.rawQuery("select id, Used, FaceID from FaceIDRegDB;", null);
        try {
            int Used = 0;
            String nIdStr = String.format("%02X", FaceID);
            String IdStr = null;
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 1) continue;
                IdStr = cursor.getString(2);
                if (nIdStr == null || IdStr == null || !nIdStr.equals(IdStr)) continue;
                int id = cursor.getInt(0);
                return id;
            }
            cursor.close();
            return -1;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            this.SyncData.clear();
            return -100;
        }
        catch (Exception e) {
            cursor.close();
            this.SyncData.clear();
            Log.e((String)TAG, (String)"[isExist] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
    }

    public String getNickname(byte FaceID) {
        if ((FaceID & 0xFF) < 1 || (FaceID & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[getNickname] Param - FaceID  Out Of Range !!! (FaceID:" + FaceID + ")"));
            return null;
        }
        Cursor cursor = this.wdb.rawQuery("select id, Used, FaceID, Nickname from FaceIDRegDB;", null);
        try {
            int Used = 0;
            String nIdStr = String.format("%02X", FaceID);
            String IdStr = null;
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 1) continue;
                IdStr = cursor.getString(2);
                if (nIdStr == null || IdStr == null || !nIdStr.equals(IdStr)) continue;
                String id = cursor.getString(3);
                return id;
            }
            cursor.close();
            return null;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            this.SyncData.clear();
            return null;
        }
        catch (Exception e) {
            cursor.close();
            this.SyncData.clear();
            Log.e((String)TAG, (String)"[getNickname] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
            return null;
        }
    }

    public int SetNickname(byte FaceID, String NewNickname) {
        if ((FaceID & 0xFF) < 1 || (FaceID & 0xFF) > 255) {
            Log.w((String)TAG, (String)("[SetNickname] Param - FaceID  Out Of Range !!! (FaceID:" + FaceID + ")"));
            return -2;
        }
        if (NewNickname == null) {
            Log.w((String)TAG, (String)"[SetNickname] Param - NewNickname is NULL !!!");
            return -3;
        }
        int ret = 0;
        int ExistId = this.isExist(FaceID);
        if (ExistId > 0) {
            Log.w((String)TAG, (String)("[SetNickname] isExist - Find !!! (ExistId:" + ExistId + ", FaceID:" + String.format("%02X", FaceID) + ")"));
            ret = this.UnRegister((byte)ExistId);
            Log.w((String)TAG, (String)("[SetNickname] isExist - Find !!! UnRegister - ret:" + ret));
        }
        String whereClause = "id = " + ExistId;
        ContentValues values = new ContentValues();
        values.put("Used", Integer.valueOf(1));
        values.put("FaceID", String.format("%02X", FaceID));
        GregorianCalendar cal = new GregorianCalendar();
        String DateStr = cal.get(1) + ":" + (cal.get(2) + 1) + ":" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        values.put("RegDate", DateStr);
        values.put("LastUseDate", DateStr);
        values.put("Nickname", NewNickname);
        ret = this.wdb.update("FaceIDRegDB", values, whereClause, null);
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public List<FaceIDDataClass> GetFaceIDRegData() {
        Cursor cursor = this.wdb.rawQuery("select id, Used, FaceID, RegDate, LastUseDate, Nickname from FaceIDRegDB ORDER BY FaceID ASC;", null);
        try {
            this.SyncData.clear();
            int Used = 0;
            String RegDateStr = null;
            String LastUseDateStr = null;
            int testI = 0;
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 1) continue;
                FaceIDDataClass getdata = new FaceIDDataClass();
                getdata.id = cursor.getInt(0);
                getdata.FaceID = cursor.getString(2);
                RegDateStr = cursor.getString(3);
                LastUseDateStr = cursor.getString(4);
                getdata.Nickname = cursor.getString(5);
                ++testI;
                String[] retData = null;
                retData = RegDateStr.split(":");
                if (retData != null && retData.length >= 6) {
                    getdata.RegDateCal = new GregorianCalendar();
                    getdata.RegDateCal.set(1, Integer.parseInt(retData[0]));
                    getdata.RegDateCal.set(2, Integer.parseInt(retData[1]) - 1);
                    getdata.RegDateCal.set(5, Integer.parseInt(retData[2]));
                    getdata.RegDateCal.set(11, Integer.parseInt(retData[3]));
                    getdata.RegDateCal.set(12, Integer.parseInt(retData[4]));
                    getdata.RegDateCal.set(13, Integer.parseInt(retData[5]));
                }
                if ((retData = LastUseDateStr.split(":")) != null && retData.length >= 6) {
                    getdata.LastUseDateCal = new GregorianCalendar();
                    getdata.LastUseDateCal.set(1, Integer.parseInt(retData[0]));
                    getdata.LastUseDateCal.set(2, Integer.parseInt(retData[1]) - 1);
                    getdata.LastUseDateCal.set(5, Integer.parseInt(retData[2]));
                    getdata.LastUseDateCal.set(11, Integer.parseInt(retData[3]));
                    getdata.LastUseDateCal.set(12, Integer.parseInt(retData[4]));
                    getdata.LastUseDateCal.set(13, Integer.parseInt(retData[5]));
                }
                this.SyncData.add(getdata);
            }
            cursor.close();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            this.SyncData.clear();
            return null;
        }
        catch (Exception e) {
            cursor.close();
            this.SyncData.clear();
            Log.e((String)TAG, (String)"[GetFaceIDRegData] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
            return null;
        }
        return this.SyncData;
    }

    private static String GetByteStringFormat(byte[] in) {
        if (in == null) {
            return null;
        }
        if (in.length != 4) {
            return null;
        }
        return String.format("%02X%02X%02X%02X", in[0], in[1], in[2], in[3]);
    }

    public String ToDebugFaceIDData(List<FaceIDDataClass> data) {
        String retstr = "-----------------------------\r\n";
        retstr = retstr + "FaceIDData\r\n";
        retstr = retstr + "-----------------------------\r\n";
        if (data.isEmpty()) {
            retstr = retstr + "Empty ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        for (int i = 0; i < data.size(); ++i) {
            FaceIDDataClass getData = data.get(i);
            if (getData == null) continue;
            retstr = retstr + getData.ToDebugString();
        }
        retstr = retstr + "-----------------------------\r\n";
        return retstr;
    }

    public int GetCount() {
        Cursor cursor = this.wdb.rawQuery("select id, Used from FaceIDRegDB;", null);
        try {
            int i = 0;
            while (cursor.moveToNext()) {
                int Used = cursor.getInt(1);
                if (Used != 1) continue;
                ++i;
            }
            cursor.close();
            return i;
        }
        catch (RuntimeException var6) {
            LogUtil.errorLogInfo("", "WallpadSmartKeyRegData", var6);
            cursor.close();
            return -100;
        }
        catch (Exception var7) {
            cursor.close();
            Log.e((String)"WallpadSmartKeyRegData", (String)"[GetCount] Exception Error !!!");
            LogUtil.errorLogInfo("", "WallpadSmartKeyRegData", var7);
            return -100;
        }
    }

    public static class FaceIDDataClass {
        public int id = -1;
        public String FaceID = null;
        public Calendar RegDateCal = null;
        public Calendar LastUseDateCal = null;
        public String Nickname = null;

        public String ToDebugString() {
            String retStr = "==========================\r\nid  -  " + this.id + "\r\n==========================\r\nFaceID         : " + this.FaceID + "\r\nRegDateCal     : " + this.RegDateCal.get(1) + "-" + (this.RegDateCal.get(2) + 1) + "-" + this.RegDateCal.get(5) + "  " + this.RegDateCal.get(11) + ":" + this.RegDateCal.get(12) + ":" + this.RegDateCal.get(13) + "\r\nLastUseDateCal : " + this.LastUseDateCal.get(1) + "-" + (this.LastUseDateCal.get(2) + 1) + "-" + this.LastUseDateCal.get(5) + "  " + this.LastUseDateCal.get(11) + ":" + this.LastUseDateCal.get(12) + ":" + this.LastUseDateCal.get(13) + "\r\nNickname       : " + this.Nickname + "\r\n==========================\r\n\r\n";
            return retStr;
        }
    }
}

