/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kr.co.icontrols.wallpadsupport.Version;

public class WallpadDeviceSet
extends wallpaddbmgr {
    private final String TAG = "WallpadDeviceSet";
    public static final String DEV_ID_THERMO = "thermostat";
    public static final String DEV_ID_LIGHT = "light";
    public static final String DEV_ID_GAS = "gas";
    public static final String DEV_ID_BATCHLIGHT = "batchlight";
    public static final String DEV_ID_CURTAIN = "curtain";
    public static final String DEV_ID_VENTIL = "ventil";
    public static final String DEV_ID_DOORLOCK = "doorlock";
    public static final String DEV_ID_AIRCON = "aircon";
    public static final String DEV_ID_REMOTEMETER = "RemoteMeter";
    public static final String DEV_ID_RFDOORCAM = "RfDoorCam";
    public static final String DEV_ID_REMOTECON = "Remotecon";
    public static final String DEV_ID_SUBPHONE = "subphone";
    public static final String DEV_ID_SMARTSW = "SmartSwitch";
    public static final String DEV_ENABLE = "enable";
    public static final String DEV_DISABLE = "disable";
    private static String[][] SubDevInitData = null;
    public static final int DO_NOT_USE = 0;
    public static final int DO_USE = 1;
    public static final int Curtain = 1;
    public static final int RollScreen = 2;
    public static final int LIGHT_TYPE_LIVING = 11;
    public static final int LIGHT_TYPE_ROOM = 12;
    public static final int LIGHT_TYPE_HDC_INTLIGHT_NORMAL = 15;
    public static final int LIGHT_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT = 16;
    public static final int LIGHT_TYPE_ZEROENERGY_ENERGYMETER = 17;
    public static final int LIGHT_TYPE_SMART_DISTRIBUTION = 18;
    public static final int LIGHT_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT_MULTISWITCH = 19;
    public static final String LIGHT_CONTROLLER_TYPE_LIVING_ROOM = "\ub300\uc678\uae30\ubcf8\ud615";
    public static final String LIGHT_CONTROLLER_TYPE_ROOMS = "\ub300\uc678\uac01\uc2e4\ud615";
    public static final String LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_NORMAL = "\ud604\uc0b0\ud5a5\uc77c\uccb4\ud615\uc870\uba85\uae30\ubcf8\ud615";
    public static final String LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT = "\ud604\uc0b0\ud5a5\uc77c\uccb4\ud615\uc870\uba85\uc77c\uad04\uc18c\ub4f1\ubcd1\ud569\ud615";
    public static final String LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT_MULTISWITCH = "\ud604\uc0b0\ud5a5\uc77c\uccb4\ud615\uc870\uba85\uc77c\uad04\uc18c\ub4f1\ubcd1\ud569\ud615_\uc5d0\ub108\uc9c0\ubbf8\ud130";
    public static final String LIGHT_CONTROLLER_TYPE_SMART_DISTRIBUTION = "\uc2a4\ub9c8\ud2b8\ubd84\uc804\ubc18\uc870\uba85";
    public int mModelType = Version.getModelType();
    public static final int BATCH_TYPE_GENERAL = 21;
    public static final int BATCH_TYPE_SMART = 22;
    public static final int BATCH_TYPE_HDC_OLD_SMART = 25;
    public static final int BATCH_TYPE_HDC_LCD_SMART = 26;
    public static final int BATCH_TYPE_HDC_ALLLIGHT = 27;
    public static final int DOORLOCK_TYPE_NORMAL = 31;
    public static final int DOORLOCK_TYPE_RF = 32;
    public static final int DOORLOCK_TYPE_FINGERPRINT = 33;
    public static final int VENTIL_TYPE_NORMAL_OLD = 31;
    public static final int VENTIL_TYPE_LH = 32;
    public static final int VENTIL_TYPE_HOOD = 33;
    public static final int VENTIL_TYPE_NORMAL_NEW = 34;
    public static final int SYSTEMAIRCON_NONE = 131;
    public static final int SYSTEMAIRCON_SAMSUNG_AIR = 132;
    public static final int SYSTEMAIRCON_SAMSUNG_AIR_HEAT = 133;
    public static final int SYSTEMAIRCON_LG_AIR = 134;
    public static final int SYSTEMAIRCON_LG_AIR_HEAT = 135;
    public static final int SYSTEMAIRCON_ETC = 136;
    public static final String SYSTEM_AIRCON_SAMSUNG_AIR = "\uc0bc\uc131\ub0c9\ubc29";
    public static final String SYSTEM_AIRCON_SAMSUNG_AIR_HEAT = "\uc0bc\uc131\ub0c9\ub09c\ubc29";
    public static final String SYSTEM_AIRCON_LG_AIR = "LG\ub0c9\ubc29";
    public static final String SYSTEM_AIRCON_LG_AIR_HEAT = "LG\ub0c9\ub09c\ubc29";
    public static final String SYSTEM_AIRCON_ETC = "\uae30\ud0c0APU";
    public static final int ELEVATOR_NONE = 51;
    public static final int ELEVATOR_SIMPLE = 52;
    public static final int ELEVATOR_FLOOR = 53;
    public static final String MAIN_GUI_TYPE_DEFAULT = "\uae30\ubcf8";
    public static final String MAIN_GUI_TYPE_METRO = "\uba54\ud2b8\ub85c";
    public static final String MAIN_GUI_TYPE_HYOSUNG = "\ud6a8\uc131";
    public static final String MAIN_GUI_TYPE_HIMCHAN = "\ud798\ucc2c";
    public static final int DOORTYPE_NONE = 50;
    public static final int DOORTYPE_BASIC = 51;
    public static final int DOORTYPE_RFCAM = 52;
    public static final int DOORTYPE_SMARTKEY = 53;
    public static final int DOORTYPE_UKS = 54;
    public static final int DOORTYPE_ETC = 55;
    public static final int DOORTYPE_IOT_SMART = 56;
    public static final int DOORTYPE_HYOSUNG_SMART = 57;
    public static final int DOORTYPE_DAEWOO_SMART = 58;
    public static final int DOORTYPE_SMARTKEY_EXTERNAL = 59;
    public static final String DOOR_CAMERA_TYPE_DEFAULT = "\uae30\ubcf8";
    public static final String DOOR_CAMERA_TYPE_RF_DOOR_CAMERA = "RF\ud604\uad00\uce74\uba54\ub77c";
    public static final String DOOR_CAMERA_TYPE_SMART_KEY = "\uc2a4\ub9c8\ud2b8\ud0a4";
    public static final String DOOR_CAMERA_TYPE_UKS = "UKS";
    public static final String DOOR_CAMERA_TYPE_ETC = "ETC";
    public static final String DOOR_CAMERA_TYPE_IOT_SMART = "\uc2a4\ub9c8\ud2b8IOT\ud604\uad00\uce74\uba54\ub77c";
    public static final String DOOR_CAMERA_TYPE_HYOSUNG_SMART = "\uc2a4\ub9c8\ud2b8\ud604\uad00\uce74\uba54\ub77c-\ud6a8\uc131";
    public static final String DOOR_CAMERA_TYPE_DAEWOO_SMART = "\uc2a4\ub9c8\ud2b8\ud604\uad00\uce74\uba54\ub77c-\ub300\uc6b0";
    public static final String DOOR_CAMERA_TYPE_SMART_KEY_EXTERNAL = "\ub300\uc678\uc2a4\ub9c8\ud2b8\ud0a4\ud604\uad00\uce74\uba54\ub77c";
    public static final int CURTAIN_TYPE_ROOM = 41;
    public static final int CURTAIN_TYPE_LIVING = 42;
    public static final int CURTAIN_TYPE_ALL = 43;
    public static final int SET_IN_MOTION = 1;
    public static final int SET_OUT_MOTION = 2;
    public static final int SET_OUT_TO_IN_MOTION = 4;
    public static final String MOTION_SETTING_TYPE_USE_OUTER_MOTION_DETECTOR = "\uc678\ubd80\ub3d9\uccb4\uc0ac\uc6a9";
    public static final String MOTION_SETTING_TYPE_USE_INNER_MOTION_DETECTOR = "\ub0b4\ubd80\ub3d9\uccb4\uc0ac\uc6a9";
    public static final String MOTION_SETTING_TYPE_USE_OUTER_MOTION_DETECTOR_TO_INNER_MOTION = "\uc678\ubd80\ub3d9\uccb4\ub97c\ub0b4\ubd80\ub3d9\uccb4\ub85c\uc0ac\uc6a9";
    int[] volindextbl = new int[]{-1, 19, 26, 31, 35, 40, 43, 46, 48, 52, 56};
    public static final int HANDICAPPED_MODE_NORMAL = 0;
    public static final int HANDICAPPED_MODE_HEARING = 1;
    public static final int HANDICAPPED_MODE_BLIND = 2;
    public static final int HANDICAPPED_DO_NOT_USE = 0;
    public static final int HANDICAPPED_USE = 1;
    public static final int BLACK_TYPE = 0;
    public static final int COLOR_TYPE = 1;
    public static final int BLESMARTKEY_NONUSE = 61;
    public static final int BLESMARTKEY_KEY = 62;
    public static final int BLESMARTKEY_BAND = 63;
    public static final String BLE_SMARTKEY_TYPE_NONUSE = "\uc0ac\uc6a9\uc548\ud568";
    public static final String BLE_SMARTKEY_TYPE_SMARTKEY = "\uc2a4\ub9c8\ud2b8\ud0a4";
    public static final String BLE_SMARTKEY_TYPE_SMARTBAND = "\uc2a4\ub9c8\ud2b8\ubc34\ub4dc";
    public static final int DEV_DATA_NONE = 0;
    public static final int DEV_DATA_DISABLE = 1;
    public static final int DEV_DATA_ENABLE = 2;
    public static final int DEV_DATA_ERROR = 3;
    public static final int SUBWPD_CTR_NONUSE = 71;
    public static final int SUBWPD_CTR_MAINREQ = 72;
    public static final int SUBWPD_CTR_DIRECT = 73;
    private static Pattern mPattern = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    public static final int HEATONEDEVICE_NONE = 80;
    public static final int HEATONEDEVICE_VENTI = 81;
    public static final int HEATONEDEVICE_LIGHT = 82;
    public static final int HEATONEDEVICE_VENTILIGHT = 83;
    public static final int SMARTSWITCH_ENERGY_NONE = 90;
    public static final int SMARTSWITCH_ENERGY_REALTIME = 91;
    public static final int SMARTSWITCH_ENERGY_REMOTE = 92;
    public static final int LCDKEEPER_NONE = 100;
    public static final int LCDKEEPER_PROTECT = 101;
    public static final int LCDKEEPER_RECOVER = 102;
    public static final int LCDKEEPER_PROTECT_RECOVER = 103;
    public static final int POWERCONTROLLER_TYPE_NONE = 110;
    public static final int POWERCONTROLLER_TYPE_DEFAULT = 111;
    public static final int POWERCONTROLLER_TYPE_DIRECT = 112;
    public static final int POWERCONTROLLER_TYPE_MEASURE = 113;
    public static final String POWER_CONTROLLER_TYPE_DEFAULT = "\uae30\ubcf8";
    public static final String POWER_CONTROLLER_TYPE_DIRECT = "\uc9c1\uacb0\ubcf4\ub4dc";
    public static final String POWER_CONTROLLER_TYPE_MEASURE = "\uc804\ub825\uce21\uc815\uc9c1\uacb0\ubcf4\ub4dc";
    public static final int ESCAPELADDER_DOWN_SEND_NONE = 120;
    public static final int ESCAPELADDER_DOWN_SEND_UPPER = 121;
    public static final int ESCAPELADDER_DOWN_SEND_BELOW = 122;
    public static final int CONSTRUCTION_SPECIAL_FUNCTION_NONE = 130;
    public static final int CONSTRUCTION_SPECIAL_FUNCTION_SK = 131;
    public static final int CONSTRUCTION_SPECIAL_FUNCTION_DW = 132;
    public static final int KITCHEN_EM_BATCH_CTRL = 140;
    public static final int KITCHEN_EM_ORDER_CTRL = 141;
    public static final int KITCHEN_EM_ORDER_CTRL_RESET = 142;

    public WallpadDeviceSet(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("SettingDB")) {
            try {
                if (this.wdb != null) {
                    this.wdb.execSQL("create table SettingDB (type  text, name text unique, cnt INTEGER, value text);");
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            }
            catch (Exception e) {
                LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            }
        }
        if (!this.CheckTableExist("SubDeviceDB")) {
            try {
                if (this.wdb != null) {
                    this.wdb.execSQL("create table SubDeviceDB (id text unique, name  text, devcnt text, cnt text, loc text, enable text, lononoff text);");
                }
                this.initSubDeviceTBL();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            }
            catch (Exception e) {
                LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            }
        }
    }

    private static void Init_SubDevInitData() {
        String[][] temp_SubDevInitData = new String[][]{{DEV_ID_THERMO, "\uc628\ub3c4\uc870\uc808\uae30", "1", "0", "\uac01\ubc29", DEV_ENABLE, DEV_ENABLE}, {DEV_ID_LIGHT, "\uc870\uba85\uc81c\uc5b4\uae30", "1", "0", "\uac70\uc2e4", DEV_ENABLE, DEV_ENABLE}, {DEV_ID_GAS, "\uac00\uc2a4\ubc38\ube0c", "1", "0", "\uc8fc\ubc29", DEV_ENABLE, DEV_ENABLE}, {DEV_ID_BATCHLIGHT, "\uc77c\uad04\uc18c\ub4f1", "1", "0", "none", DEV_ENABLE, DEV_ENABLE}, {DEV_ID_CURTAIN, "\uc804\ub3d9\ucee4\ud2bc", "1", "0", "none", DEV_DISABLE, DEV_ENABLE}, {DEV_ID_VENTIL, "\ud658\uae30\uc2dc\uc2a4\ud15c", "1", "0", "none", DEV_ENABLE, DEV_ENABLE}, {DEV_ID_DOORLOCK, "\ub514\uc9c0\ud138\ub3c4\uc5b4\ub77d", "1", "0", "none", DEV_DISABLE, DEV_ENABLE}, {DEV_ID_AIRCON, "\uc2dc\uc2a4\ud15c\uc5d0\uc5b4\ucee8", "1", "0", "none", DEV_DISABLE, DEV_ENABLE}, {DEV_ID_REMOTEMETER, "\uc6d0\uaca9\uac80\uce68", "1", "0", "none", DEV_DISABLE, DEV_ENABLE}, {DEV_ID_RFDOORCAM, "RF\ub3c4\uc5b4\ucea0", "1", "0", "none", DEV_DISABLE, DEV_ENABLE}, {DEV_ID_REMOTECON, "\ub9ac\ubaa8\ucf58", "1", "0", "none", DEV_DISABLE, DEV_ENABLE}, {DEV_ID_SUBPHONE, "\uc11c\ube0c\ud3f0", "1", "0", "none", DEV_ENABLE, DEV_ENABLE}, {DEV_ID_SMARTSW, "\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58", "1", "0", "none", DEV_DISABLE, DEV_ENABLE}};
        SubDevInitData = new String[temp_SubDevInitData.length][temp_SubDevInitData[0].length];
        for (int i = 0; i < temp_SubDevInitData.length; ++i) {
            for (int j = 0; j < temp_SubDevInitData[i].length; ++j) {
                WallpadDeviceSet.SubDevInitData[i][j] = temp_SubDevInitData[i][j];
            }
        }
    }

    public int[] getFrontCameraSettingInfo() {
        String[] GetData = this.GetSettingData("\ud604\uad00\uce74\uba54\ub77c");
        int[] returnData = new int[]{1, 51};
        try {
            if (GetData == null) {
                Log.w((String)"WallpadDeviceSet", (String)"[getFrontCameraSettingInfo] GetData is null!!");
                return returnData;
            }
            String strValue = GetData[0];
            if (!strValue.equalsIgnoreCase("\ud604\uad00\uce74\uba54\ub77c")) {
                Log.w((String)"WallpadDeviceSet", (String)("[getFrontCameraSettingInfo] The name is wrong!! must be \ud604\uad00\uce74\uba54\ub77c, strValue -> " + strValue));
                return returnData;
            }
            strValue = GetData[1];
            strValue = strValue.replace('(', '_');
            strValue = strValue.replace(':', '_');
            String[] astrDetailValue = (strValue = strValue.replace(')', '_')).split("_");
            if (!astrDetailValue[3].equalsIgnoreCase("\uc0ac\uc6a9\ud568")) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (astrDetailValue[5].equalsIgnoreCase("\uae30\ubcf8")) {
                returnData[1] = 51;
            } else if (astrDetailValue[5].equalsIgnoreCase(DOOR_CAMERA_TYPE_RF_DOOR_CAMERA)) {
                returnData[1] = 52;
            } else if (astrDetailValue[5].equalsIgnoreCase(DOOR_CAMERA_TYPE_SMART_KEY_EXTERNAL)) {
                returnData[1] = 59;
            } else if (astrDetailValue[5].equalsIgnoreCase("\uc2a4\ub9c8\ud2b8\ud0a4")) {
                returnData[1] = 53;
            } else if (astrDetailValue[5].equalsIgnoreCase(DOOR_CAMERA_TYPE_UKS)) {
                returnData[1] = 54;
            } else if (astrDetailValue[5].equalsIgnoreCase(DOOR_CAMERA_TYPE_ETC)) {
                returnData[1] = 55;
            } else if (astrDetailValue[5].equalsIgnoreCase(DOOR_CAMERA_TYPE_IOT_SMART)) {
                returnData[1] = 56;
            } else if (astrDetailValue[5].equalsIgnoreCase(DOOR_CAMERA_TYPE_HYOSUNG_SMART)) {
                returnData[1] = 57;
            } else if (astrDetailValue[5].equalsIgnoreCase(DOOR_CAMERA_TYPE_DAEWOO_SMART)) {
                returnData[1] = 58;
            } else {
                returnData[0] = 1;
                returnData[1] = 51;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            Log.e((String)"WallpadDeviceSet", (String)"[RuntimeException] getFrontCameraSettingInfo()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 1;
            returnData[1] = 51;
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] getFrontCameraSettingInfo()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 1;
            returnData[1] = 51;
            return returnData;
        }
    }

    public int[] Get_Light_info() {
        String[] GetData = this.GetSettingData("\uc870\uba85\uc81c\uc5b4\uae30");
        int[] returnData = new int[]{1, 11, 6};
        if (this.mModelType == 11100) {
            returnData[1] = 16;
            returnData[2] = 5;
        }
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (this.mModelType == 11100) {
                returnData[1] = GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_NORMAL) > 0 ? 15 : (GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_SMART_DISTRIBUTION) > 0 ? 18 : 16);
            } else if (this.mModelType == 31100 || this.mModelType == 31500 || this.mModelType == 31170 || this.mModelType == 31570 || this.mModelType == 31120 || this.mModelType == 31520 || this.mModelType == 31640 || this.mModelType == 31660 || this.mModelType == 31630) {
                if (GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_NORMAL) > 0) {
                    returnData[1] = 15;
                } else if (GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT_MULTISWITCH) > 0) {
                    returnData[1] = 19;
                } else if (GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT) > 0) {
                    returnData[1] = 16;
                } else if (GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_ROOMS) > 0) {
                    returnData[1] = 12;
                } else if (GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_LIVING_ROOM) > 0) {
                    returnData[1] = 11;
                }
            } else {
                returnData[1] = GetData[1].indexOf(LIGHT_CONTROLLER_TYPE_ROOMS) > 0 ? 12 : 11;
            }
            String GetCount = GetData[1].split("[(]")[1].split("[:]")[0];
            GetCount = GetCount.trim();
            returnData[2] = Integer.parseInt(GetCount);
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public boolean Set_LightingControllerType(int nValue) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_LightingControllerType] nValue: " + nValue));
            String strLightingControllerType = BLE_SMARTKEY_TYPE_NONUSE;
            String strSettingValue = "1(1:BLE\uc2a4\ub9c8\ud2b8\ud0a4(\uc0ac\uc6a9\uc548\ud568)";
            if (nValue == 0) {
                strLightingControllerType = BLE_SMARTKEY_TYPE_NONUSE;
            } else if (nValue == 11) {
                strLightingControllerType = LIGHT_CONTROLLER_TYPE_LIVING_ROOM;
            } else if (nValue == 12) {
                strLightingControllerType = LIGHT_CONTROLLER_TYPE_ROOMS;
            } else if (nValue == 15) {
                strLightingControllerType = LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_NORMAL;
            } else if (nValue == 16) {
                strLightingControllerType = LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT;
            } else if (nValue == 19) {
                strLightingControllerType = LIGHT_CONTROLLER_TYPE_HDC_INTLIGHT_ADD_BATCHLIGHT_MULTISWITCH;
            } else if (nValue == 18) {
                strLightingControllerType = LIGHT_CONTROLLER_TYPE_SMART_DISTRIBUTION;
            } else {
                Log.w((String)"WallpadDeviceSet", (String)("[Set_LightingControllerType] Unsupported LightingController tyep: " + nValue));
                return false;
            }
            strSettingValue = strLightingControllerType.equalsIgnoreCase(BLE_SMARTKEY_TYPE_NONUSE) ? "1(1:\uc870\uba85\uc81c\uc5b4\uae30(\uc0ac\uc6a9\uc548\ud568)" : (Version.getModelType() == 31120 || Version.getModelType() == 31520 || this.mModelType == 31640 || this.mModelType == 31660 ? "1(3:\uc870\uba85\uc81c\uc5b4\uae30(\uc0ac\uc6a9\ud568)\uc885\ub958(" + strLightingControllerType + ")" : "1(1:\uc870\uba85\uc81c\uc5b4\uae30(\uc0ac\uc6a9\ud568)\uc885\ub958(" + strLightingControllerType + ")");
            Log.i((String)"WallpadDeviceSet", (String)("[Set_LightingControllerType] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\uc870\uba85\uc81c\uc5b4\uae30", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_LightingControllerType(int nValue)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] Get_BatchSW_Info() {
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58&\uc77c\uad04\uc18c\ub4f1");
        int[] returnData = new int[]{1, 22, 3, 4};
        if (this.mModelType == 31100 || this.mModelType == 31500 || this.mModelType == 31170 || this.mModelType == 31570 || this.mModelType == 31120 || this.mModelType == 31520 || this.mModelType == 31640 || this.mModelType == 31660 || this.mModelType == 11100 || this.mModelType == 31630) {
            returnData[0] = 1;
            returnData[1] = 26;
            returnData[2] = 3;
            returnData[3] = 4;
        } else {
            returnData[0] = 1;
            returnData[1] = 22;
            returnData[2] = 3;
            returnData[3] = 4;
        }
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (this.mModelType == 31100 || this.mModelType == 31500 || this.mModelType == 31170 || this.mModelType == 31570 || this.mModelType == 31120 || this.mModelType == 31520 || this.mModelType == 31640 || this.mModelType == 31660 || this.mModelType == 11100 || this.mModelType == 31630) {
                if (GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc81c\uc77c\uc804\uae30\uc77c\uad04\uc18c\ub4f1\uc81c\uc5b4\uae30") > 0) {
                    returnData[1] = 27;
                    returnData[2] = 3;
                    returnData[3] = 4;
                    return returnData;
                }
                if (GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") > 0) {
                    returnData[1] = 25;
                } else {
                    if (GetData[1].indexOf("\ud604\uc0b0\ud5a5LCD\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") <= 0) {
                        returnData[0] = 0;
                        return returnData;
                    }
                    returnData[1] = 26;
                }
            } else if (GetData[1].indexOf("\ub300\uc678\ud5a5\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") > 0) {
                returnData[1] = 22;
            } else if (GetData[1].indexOf("\ub300\uc678\ud5a5\uc77c\uad04\uc18c\ub4f1\uc81c\uc5b4\uae30") > 0) {
                returnData[1] = 21;
            } else {
                if (GetData[1].indexOf("\ud604\uc0b0\ud5a5\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58") <= 0) {
                    returnData[0] = 0;
                    return returnData;
                }
                returnData[1] = 25;
            }
            String L1 = GetData[1].split("L1\uc124\uc815")[1].split("L2\uc124\uc815")[0];
            L1 = L1.replace("(", " ");
            L1 = L1.replace(")", " ");
            L1 = L1.trim();
            String L2 = GetData[1].split("L1\uc124\uc815")[1].split("L2\uc124\uc815")[1];
            L2 = L2.replace("(", " ");
            L2 = L2.replace(")", " ");
            L2 = L2.trim();
            returnData[2] = Integer.parseInt(L1);
            returnData[3] = Integer.parseInt(L2);
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return new int[]{0, 22, 1, 2};
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return new int[]{0, 22, 1, 2};
        }
    }

    public int[] Get_DoorLock_Info() {
        String[] GetData = this.GetSettingData("\ub514\uc9c0\ud138\ub3c4\uc5b4\ub77d");
        int[] returnData = new int[]{1, 32};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("\uc720\uc120") > 0) {
                returnData[1] = 31;
            } else if (GetData[1].indexOf("\ubb34\uc120") > 0) {
                returnData[1] = 32;
            } else if (GetData[1].indexOf("\uc9c0\ubb38\uc778\uc2dd") > 0) {
                returnData[1] = 33;
            } else {
                returnData[0] = 1;
                returnData[1] = 32;
                return returnData;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = new int[]{1, 32};
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = new int[]{1, 32};
            return returnData;
        }
    }

    public int Get_Temper_Info() {
        String[] GetData = this.GetSettingData("\uc628\ub3c4\uc870\uc808\uae30");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int[] Get_Temper_FixRoomNumber() {
        String[] GetData = this.GetSettingData("\ub09c\ubc29\ubc29\uac1c\uc218\uace0\uc815");
        int[] returnData = new int[]{0, 0};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            String GetCount = GetData[1].split("[(]")[1].split("[:]")[0];
            GetCount = GetCount.trim();
            returnData[1] = Integer.parseInt(GetCount);
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            return returnData;
        }
    }

    public int[] Get_Ventil_Info() {
        String[] GetData = this.GetSettingData("\ud658\uae30\uc2dc\uc2a4\ud15c");
        int[] returnData = new int[]{1, 31};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("\uae30\ubcf8") > 0) {
                returnData[1] = 31;
            } else if (GetData[1].indexOf("LH\ud5a5") > 0) {
                returnData[1] = 32;
            } else if (GetData[1].indexOf("\ud6c4\ub4dc") > 0) {
                returnData[1] = 33;
            } else if (GetData[1].indexOf("\uc2e0\uaddc") > 0) {
                returnData[1] = 34;
            } else {
                returnData[0] = 1;
                returnData[1] = 31;
                return returnData;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 31;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 31;
            return returnData;
        }
    }

    public int Get_AirCON_Info() {
        String[] GetData = this.GetSettingData("\uc2dc\uc2a4\ud15c\uc5d0\uc5b4\ucee8");
        try {
            if (GetData == null) {
                return 131;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                if (GetData[1].indexOf(SYSTEM_AIRCON_SAMSUNG_AIR) > 0) {
                    return 132;
                }
                if (GetData[1].indexOf(SYSTEM_AIRCON_SAMSUNG_AIR_HEAT) > 0) {
                    return 133;
                }
                if (GetData[1].indexOf(SYSTEM_AIRCON_LG_AIR) > 0) {
                    return 134;
                }
                if (GetData[1].indexOf(SYSTEM_AIRCON_LG_AIR_HEAT) > 0) {
                    return 135;
                }
                if (GetData[1].indexOf(SYSTEM_AIRCON_ETC) > 0) {
                    return 136;
                }
            } else {
                return 131;
            }
            Log.w((String)"WallpadDeviceSet", (String)"[Get_AirCON_Info] \uc2dc\uc2a4\ud15c\uc5d0\uc5b4\ucee8 \uc885\ub958 \ubbf8\uc815\uc758");
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return 131;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return 131;
        }
        return 131;
    }

    public int Get_Shading_Use() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_Shading_Use");
        String[] GetData = this.GetSettingData("\uc804\ub3d9\ucee4\ud2bc");
        if (GetData == null) {
            return 0;
        }
        Log.i((String)"WallpadDeviceSet", (String)("-------------------------------[Get_Shading_Use] Lnegth: " + GetData.length));
        for (int i = 0; i < GetData.length; ++i) {
            Log.i((String)"WallpadDeviceSet", (String)("-------------------------------[Get_Shading_Use] Data  [" + i + "]" + GetData[i].toString()));
        }
        try {
            if (GetData[1].contains("\uc885\ub958")) {
                if (GetData[1].indexOf("(\uc804\ub3d9\ucee4\ud2bc)") > 0) {
                    return 1;
                }
                if (GetData[1].indexOf("\ub864\uc2a4\ud06c\ub9b0") > 0) {
                    return 2;
                }
                return 0;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                return 1;
            }
            return 0;
        }
        catch (RuntimeException re) {
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int Get_Purity_Info() {
        String[] GetData = this.GetSettingData("\uccad\uc815\ud658\uae30");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Louver_Info() {
        String[] GetData = this.GetSettingData("\uc804\ub3d9\ub8e8\ubc84");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Biometics_Info() {
        String[] GetData = this.GetSettingData("\uc0dd\uccb4\uc778\uc2dd");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Elevator_Info() {
        String[] GetData = this.GetSettingData("\uc5d8\ub9ac\ubca0\uc774\ud130");
        try {
            if (GetData == null) {
                return 53;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                if (GetData[1].indexOf("\uce35\ud45c\uc2dc") > 0) {
                    return 53;
                }
                if (GetData[1].indexOf("\uae30\ubcf8") > 0) {
                    return 52;
                }
                return 53;
            }
            return 51;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return 53;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return 53;
        }
    }

    public int Get_RemoteCon_Info() {
        String[] GetData = this.GetSettingData("\ubb34\uc120\ub9ac\ubaa8\ucee8");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public String GetMainGUISelect() {
        String retStr = "";
        try {
            String[] GetData = this.GetSettingData("\uba54\uc778GUI\uc120\ud0dd");
            retStr = GetData[1].indexOf("\uae30\ubcf8") > 0 ? "\uae30\ubcf8" : (GetData[1].indexOf(MAIN_GUI_TYPE_METRO) > 0 ? MAIN_GUI_TYPE_METRO : (GetData[1].indexOf(MAIN_GUI_TYPE_HYOSUNG) > 0 ? MAIN_GUI_TYPE_HYOSUNG : (GetData[1].indexOf(MAIN_GUI_TYPE_HIMCHAN) > 0 ? MAIN_GUI_TYPE_HIMCHAN : "\uae30\ubcf8")));
            return retStr;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return "\uae30\ubcf8";
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            Log.w((String)"WallpadDeviceSet", (String)"[GetMainGUISelect] Exception - Default");
            return "\uae30\ubcf8";
        }
    }

    public int[] Get_RFDoorCAM_Info() {
        String[] GetData = this.GetSettingData("\ud604\uad00\uce74\uba54\ub77c");
        int[] returnData = new int[]{1, 51};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("\uae30\ubcf8") > 0) {
                returnData[1] = 51;
            } else if (GetData[1].indexOf(DOOR_CAMERA_TYPE_RF_DOOR_CAMERA) > 0) {
                returnData[1] = 52;
            } else if (GetData[1].indexOf("\ub300\uc678\uc2a4\ub9c8\ud2b8\ud0a4") > 0) {
                returnData[1] = 59;
            } else if (GetData[1].indexOf("\uc2a4\ub9c8\ud2b8\ud0a4") > 0) {
                returnData[1] = 53;
            } else if (GetData[1].indexOf(DOOR_CAMERA_TYPE_UKS) > 0) {
                returnData[1] = 54;
            } else if (GetData[1].indexOf(DOOR_CAMERA_TYPE_ETC) > 0) {
                returnData[1] = 55;
            } else if (GetData[1].indexOf(DOOR_CAMERA_TYPE_IOT_SMART) > 0) {
                returnData[1] = 56;
            } else if (GetData[1].indexOf(DOOR_CAMERA_TYPE_HYOSUNG_SMART) > 0) {
                returnData[1] = 57;
            } else if (GetData[1].indexOf(DOOR_CAMERA_TYPE_DAEWOO_SMART) > 0) {
                returnData[1] = 58;
            } else {
                returnData[0] = 1;
                returnData[1] = 51;
                return returnData;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 1;
            returnData[1] = 51;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 1;
            returnData[1] = 51;
            return returnData;
        }
    }

    public boolean Set_DoorCameraType(int nValue) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_DoorCameraType] nValue: " + nValue));
            String strCameraType = "\uae30\ubcf8";
            String strSettingValue = "1(1:\ud604\uad00\uce74\uba54\ub77c(\uc0ac\uc6a9\ud568)\uc885\ub958(" + strCameraType + ")";
            if (nValue == 50) {
                strCameraType = BLE_SMARTKEY_TYPE_NONUSE;
            } else if (nValue == 51) {
                strCameraType = "\uae30\ubcf8";
            } else if (nValue == 52) {
                strCameraType = DOOR_CAMERA_TYPE_RF_DOOR_CAMERA;
            } else if (nValue == 53) {
                strCameraType = "\uc2a4\ub9c8\ud2b8\ud0a4";
            } else if (nValue == 59) {
                strCameraType = DOOR_CAMERA_TYPE_SMART_KEY_EXTERNAL;
            } else if (nValue == 54) {
                strCameraType = DOOR_CAMERA_TYPE_UKS;
            } else if (nValue == 55) {
                strCameraType = DOOR_CAMERA_TYPE_ETC;
            } else if (nValue == 56) {
                strCameraType = DOOR_CAMERA_TYPE_IOT_SMART;
            } else if (nValue == 57) {
                strCameraType = DOOR_CAMERA_TYPE_HYOSUNG_SMART;
            } else if (nValue == 58) {
                strCameraType = DOOR_CAMERA_TYPE_DAEWOO_SMART;
            } else {
                Log.w((String)"WallpadDeviceSet", (String)("[Set_DoorCameraType] Unsupported door camera tyep: " + nValue));
                return false;
            }
            strSettingValue = strCameraType.equalsIgnoreCase(BLE_SMARTKEY_TYPE_NONUSE) ? "1(1:\ud604\uad00\uce74\uba54\ub77c(\uc0ac\uc6a9\uc548\ud568)" : "1(1:\ud604\uad00\uce74\uba54\ub77c(\uc0ac\uc6a9\ud568)\uc885\ub958(" + strCameraType + ")";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_DoorCameraType] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\ud604\uad00\uce74\uba54\ub77c", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_DoorCamera(int nValue)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public int[] Get_CURTAIN_Info() {
        String[] GetData = this.GetSettingData("\uc804\ub3d9\ucee4\ud2bc");
        int[] returnData = new int[]{0, 41};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("\uc548\ubc29\ucee4\ud2bc") > 0) {
                returnData[1] = 41;
            } else if (GetData[1].indexOf("\uac70\uc2e4\ucee4\ud2bc") > 0) {
                returnData[1] = 42;
            } else if (GetData[1].indexOf("\uc548\ubc29\uac70\uc2e4\ucee4\ud2bc") > 0) {
                returnData[1] = 43;
            } else {
                returnData[0] = 0;
                returnData[1] = 41;
                return returnData;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 41;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 41;
            return returnData;
        }
    }

    public int[] Get_RealTimeMetor_Info() {
        String[] GetData = this.GetSettingData("\uc2e4\uc2dc\uac04\uac80\uce68\uae30");
        int[] returnData = new int[]{0, 0};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            String GetCount = GetData[1].split("[(]")[1].split("[:]")[0];
            GetCount = GetCount.trim();
            returnData[1] = Integer.parseInt(GetCount);
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            return returnData;
        }
    }

    public int Get_Energy_Devices_Info() {
        String[] GetData = this.GetSettingData("\uc5d0\ub108\uc9c0\uc81c\ud488\uad70");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_DistributionPannelType_Info() {
        String[] GetData = this.GetSettingData("\ubd84\uc804\ubc18");
        int returnData = 0;
        try {
            Log.d((String)"WallpadDeviceSet", (String)"Get_DistributionPannelType_Info");
            String[] DataInfo = this.GetSettingData("\ubd84\uc804\ubc18");
            if (DataInfo == null) {
                Log.w((String)"WallpadDeviceSet", (String)"GetSettingData(\ubd84\uc804\ubc18) is null");
                if (this.mModelType == 11100 || this.mModelType == 31120 || this.mModelType == 31520 || this.mModelType == 31640 || this.mModelType == 31660) {
                    this.UpdateSettingData("subdev_list", "\ubd84\uc804\ubc18", 0, "1(1:\ubd84\uc804\ubc18(\uc0ac\uc6a9\uc548\ud568)\uc885\ub958(\uc0ac\uc6a9\uc548\ud568)");
                } else if (this.mModelType == 31100 || this.mModelType == 31500 || this.mModelType == 31170 || this.mModelType == 31570 || this.mModelType == 31630) {
                    this.UpdateSettingData("subdev_list", "\ubd84\uc804\ubc18", 0, "1(1:\ubd84\uc804\ubc18(\uc0ac\uc6a9\ud568)\uc885\ub958(\uc2a4\ub9c8\ud2b8\ubd84\uc804\ubc18)");
                } else {
                    return -2;
                }
                DataInfo = this.GetSettingData("\ubd84\uc804\ubc18");
                if (DataInfo != null) {
                    for (int i = 0; i < DataInfo.length; ++i) {
                        Log.i((String)"WallpadDeviceSet", (String)("[Get_DistributionPannelType_Info] null -> default : " + DataInfo[i]));
                    }
                } else {
                    return -3;
                }
            }
            String devInfo = DataInfo[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
            if (parseData[3].equals("\uc0ac\uc6a9\ud568")) {
                String TempData = parseData[5];
                if (TempData == null) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData is null");
                    return -3;
                }
                if (TempData.equals("\uc2a4\ub9c8\ud2b8\ubd84\uc804\ubc18")) {
                    Log.d((String)"WallpadDeviceSet", (String)"\ubd84\uc804\ubc18 \uc885\ub958 : \uc2a4\ub9c8\ud2b8 \ubd84\uc804\ubc18");
                    return 1;
                }
                if (TempData.equals("KNX\ubd84\uc804\ubc18")) {
                    Log.d((String)"WallpadDeviceSet", (String)"\ubd84\uc804\ubc18 \uc885\ub958 : KNX \ubd84\uc804\ubc18");
                    return 2;
                }
                Log.d((String)"WallpadDeviceSet", (String)"\ubd84\uc804\ubc18 \uc885\ub958 : \ubbf8\uc815\uc758");
                return -1;
            }
            Log.d((String)"WallpadDeviceSet", (String)"\ubd84\uc804\ubc18 \uc885\ub958 : \uc0ac\uc6a9\uc548\ud568");
            return 0;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_IPark_Energy_Info() {
        String[] GetData = this.GetSettingData("\uc544\uc774\ud30c\ud06c\uc5d0\ub108\uc9c0");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Idle_Power_Saving_Switch_Info() {
        String[] GetData = this.GetSettingData("\ub300\uae30\uc804\ub825\ucc28\ub2e8\uc2a4\uc704\uce58");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_Energy_Module_Info() {
        String[] GetData = this.GetSettingData("\uc5d0\ub108\uc9c0\ubaa8\ub4c8");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_GAS_Info() {
        String[] GetData = this.GetSettingData("\uac00\uc2a4\ubc38\ube0c");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 1;
            return returnData;
        }
    }

    public int Get_Thermo_Info() {
        String[] GetData = this.GetSettingData("\uc628\ub3c4\uc870\uc808\uae30");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 1;
            return returnData;
        }
    }

    public int Get_Sensor_Set() {
        String[] GetData = this.GetSettingData("\ub3d9\uccb4\uc124\uc815");
        int returnData = 0;
        try {
            if (GetData == null) {
                returnData |= 2;
                return returnData |= 1;
            }
            if (GetData[1].indexOf("\ub3d9\uccb4\uc124\uc815") > 0) {
                String[] setted = GetData[1].split("\ub3d9\uccb4\uc124\uc815");
                if (setted[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                    String[] outsetted = GetData[1].split(MOTION_SETTING_TYPE_USE_OUTER_MOTION_DETECTOR);
                    if (outsetted[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                        returnData |= 2;
                    }
                    if ((outsetted = GetData[1].split(MOTION_SETTING_TYPE_USE_INNER_MOTION_DETECTOR))[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                        returnData |= 1;
                    }
                    if ((outsetted = GetData[1].split(MOTION_SETTING_TYPE_USE_OUTER_MOTION_DETECTOR_TO_INNER_MOTION))[1].split("[)]")[0].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                        returnData |= 4;
                    }
                } else {
                    return 0;
                }
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public boolean Set_MotionSensorType(boolean bUsage, boolean bOut, boolean bIn, boolean bOutAsIn) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_MotionSensorType] bUsage: " + bUsage + ", bOut: " + bOut + ", bIn: " + bIn + ", bOutAsIn: " + bOutAsIn));
            String strSettingValue = "1(1:\ub3d9\uccb4\uc124\uc815(\uc0ac\uc6a9\ud568)\uc678\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\ud568)\ub0b4\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\uc548\ud568)\uc678\ubd80\ub3d9\uccb4\ub97c\ub0b4\ubd80\ub3d9\uccb4\ub85c\uc0ac\uc6a9(\uc0ac\uc6a9\uc548\ud568))";
            String strSettingValue_Motion = "\ub3d9\uccb4\uc124\uc815(\uc0ac\uc6a9\ud568)";
            String strSettingValue_Out = "\uc678\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\ud568)";
            String strSettingValue_In = "\ub0b4\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\uc548\ud568)";
            String strSettingValue_OutAsIn = "\uc678\ubd80\ub3d9\uccb4\ub97c\ub0b4\ubd80\ub3d9\uccb4\ub85c\uc0ac\uc6a9(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue_Motion = bUsage ? "\ub3d9\uccb4\uc124\uc815(\uc0ac\uc6a9\ud568)" : "\ub3d9\uccb4\uc124\uc815(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue_Out = bOut ? "\uc678\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\ud568)" : "\uc678\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue_In = bIn ? "\ub0b4\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\ud568)" : "\ub0b4\ubd80\ub3d9\uccb4\uc0ac\uc6a9(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue_OutAsIn = bOutAsIn ? "\uc678\ubd80\ub3d9\uccb4\ub97c\ub0b4\ubd80\ub3d9\uccb4\ub85c\uc0ac\uc6a9(\uc0ac\uc6a9\ud568)" : "\uc678\ubd80\ub3d9\uccb4\ub97c\ub0b4\ubd80\ub3d9\uccb4\ub85c\uc0ac\uc6a9(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue = "1(1:" + strSettingValue_Motion + strSettingValue_Out + strSettingValue_In + strSettingValue_OutAsIn + ")";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_BLESmartKeyType] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\ub3d9\uccb4\uc124\uc815", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_MotionSensorType(boolean bUsage, boolean bOut, boolean bIn, boolean bOutAsIn)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public int GetDoorSoundLevel() {
        String[] GetData = this.GetSettingData("\ud604\uad00\ud3f0\uc0ac\uc6b4\ub4dc\ucd9c\ub825\uc74c\ub7c9");
        try {
            if (GetData == null) {
                return -1;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                String[] volsetted = GetData[1].split("\ubcfc\ub968");
                volsetted[1] = volsetted[1].replace("(", " ");
                volsetted[1] = volsetted[1].replace(")", " ");
                volsetted[1] = volsetted[1].trim();
                int idx = 0;
                try {
                    idx = Integer.parseInt(volsetted[1]);
                    if (idx > this.volindextbl.length - 1) {
                        idx = 0;
                    }
                    return this.volindextbl[idx];
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
                    return -1;
                }
                catch (Exception e) {
                    LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
                    return -1;
                }
            }
            return -1;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return -1;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return -1;
        }
    }

    public int Get_Security_IndoorMode_Sensor_Use() {
        String[] GetData = this.GetSettingData("\uc7ac\ud0dd\ubaa8\ub4dc\uc2dc\ub3d9\uccb4\uc13c\uc11c\uc0ac\uc6a9");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 1;
            return returnData;
        }
    }

    public int[] Get_Handicapped_Mode() {
        String[] GetData = this.GetSettingData("\uc7a5\uc560\uc778\ubaa8\ub4dc");
        int[] returnData = new int[]{0, 0};
        try {
            if (GetData == null) {
                Log.e((String)"WallpadDeviceSet", (String)"GetSettingData(\uc7a5\uc560\uc778\ubaa8\ub4dc) is null");
                return returnData;
            }
            String devInfo = GetData[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] DataInfo = (devInfo = devInfo.replace(')', '_')).split("_");
            if (DataInfo[3].equals("\uc0ac\uc6a9\ud568")) {
                returnData[0] = 1;
            }
            if (DataInfo[5].equals("\uc77c\ubc18\ubaa8\ub4dc")) {
                returnData[1] = 0;
            } else if (DataInfo[5].equals("\uccad\uac01\uc7a5\uc560\uc778")) {
                returnData[1] = 1;
            } else if (DataInfo[5].equals("\uc2dc\uac01\uc7a5\uc560\uc778")) {
                returnData[1] = 2;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public boolean Set_Handicapped_Mode(int[] SetValue) {
        String sHandicapped = "\uc7a5\uc560\uc778\ubaa8\ub4dc";
        String sUseOrNot = BLE_SMARTKEY_TYPE_NONUSE;
        String sMode = "\uc77c\ubc18\ubaa8\ub4dc";
        if (SetValue == null) {
            Log.e((String)"WallpadDeviceSet", (String)"intput[] is null");
            return false;
        }
        if (SetValue.length != 2) {
            Log.e((String)"WallpadDeviceSet", (String)"intput[]'s length is not 2");
            Log.e((String)"WallpadDeviceSet", (String)("intput[]'s length is " + SetValue.length));
            return false;
        }
        switch (SetValue[0]) {
            case 0: {
                sUseOrNot = BLE_SMARTKEY_TYPE_NONUSE;
                break;
            }
            case 1: {
                sUseOrNot = "\uc0ac\uc6a9\ud568";
                break;
            }
            default: {
                Log.e((String)"WallpadDeviceSet", (String)("intput[0] is Error.  SetValue[0]: " + SetValue[0]));
                return false;
            }
        }
        switch (SetValue[1]) {
            case 0: {
                sMode = "\uc77c\ubc18\ubaa8\ub4dc";
                break;
            }
            case 1: {
                sMode = "\uccad\uac01\uc7a5\uc560\uc778";
                break;
            }
            case 2: {
                sMode = "\uc2dc\uac01\uc7a5\uc560\uc778";
                break;
            }
            default: {
                Log.e((String)"WallpadDeviceSet", (String)("intput[1] is Error.  SetValue[1]: " + SetValue[1]));
                return false;
            }
        }
        try {
            this.UpdateSettingData("subdev_list", sHandicapped, 0, "1(1:" + sHandicapped + "(" + sUseOrNot + ")\ubaa8\ub4dc(" + sMode + ")");
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public int Elevator_Button_inMainScreen_Use() {
        String[] GetData = this.GetSettingData("\uc5d8\ub9ac\ubca0\uc774\ud130\ud56b\ud0a4");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int[] Get_BookMark_Type() {
        String[] GetData = this.GetSettingData("\uc990\uaca8\ucc3e\uae30\uc544\uc774\ucf58\uc885\ub958");
        int[] returnData = new int[]{1, 0};
        try {
            if (GetData == null) {
                Log.e((String)"WallpadDeviceSet", (String)"GetSettingData(\uc990\uaca8\ucc3e\uae30\uc544\uc774\ucf58\uc885\ub958) is null");
                return returnData;
            }
            String devInfo = GetData[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] DataInfo = (devInfo = devInfo.replace(')', '_')).split("_");
            if (DataInfo[5].equals("\ud751\ubc31")) {
                returnData[1] = 0;
            } else if (DataInfo[5].equals("\uceec\ub7ec")) {
                returnData[1] = 1;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public boolean GetGasDetect5Time() {
        Log.d((String)"WallpadDeviceSet", (String)"GetGasDetect5Time");
        int result = this.GetDeviceSetted("\uac00\uc2a4\uac10\uc9c05\ud68c\uc54c\ub78c");
        return result == 2;
    }

    public boolean Get_NonInternetSupportUse() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_NonInternetSupportUse");
        int result = this.GetDeviceSetted("\uc778\ud130\ub137\ubbf8\uc9c0\uc6d0");
        return result == 2;
    }

    public boolean Get_LivingEm_KitchenLight_Use() {
        int result = this.GetDeviceSetted("\uac70\uc2e4EM\uc8fc\ubc29\ub4f1");
        return result == 2;
    }

    public boolean Get_SmartPostUse() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_SmartPostUse");
        int result = this.GetDeviceSetted("\uc2a4\ub9c8\ud2b8\uc6b0\ud3b8\ud568");
        return result == 2;
    }

    public boolean Get_CookTopConcent_Use() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_CookTopConcent_Use");
        int result = this.GetDeviceSetted("\ucfe1\ud0d1\ucf58\uc13c\ud2b8");
        return result == 2;
    }

    public String[] Get_EnergyModule_Name() {
        String[] ReturnData = null;
        String[] GetData = this.GetSettingData("\uc5d0\ub108\uc9c0\ubaa8\ub4c8\uba85\uce6d");
        try {
            if (GetData == null) {
                Log.e((String)"WallpadDeviceSet", (String)"GetSettingData(\uc5d0\ub108\uc9c0\ubaa8\ub4c8\uba85\uce6d) is null");
                return null;
            }
            String devInfo = GetData[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] DataInfo = (devInfo = devInfo.replace(')', '_')).split("_");
            if (DataInfo[3].equals("\uc0ac\uc6a9\ud568")) {
                String[] TempData = DataInfo[5].split(",");
                if (TempData == null) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData is null");
                    return null;
                }
                if (TempData.length < 1) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData.length is 0");
                    return null;
                }
                ReturnData = new String[TempData.length];
                ReturnData = TempData;
                return ReturnData;
            }
            Log.e((String)"WallpadDeviceSet", (String)"\uc5d0\ub108\uc9c0\ubaa8\ub4c8\uba85\uce6d \uc0ac\uc6a9 \uc548\ud568");
            Log.e((String)"WallpadDeviceSet", (String)("DataInfo[3] :" + DataInfo[3]));
            return null;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return null;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return null;
        }
    }

    public boolean GetZeroEnergyHouseInfo() {
        Log.d((String)"WallpadDeviceSet", (String)"GetZeroEnergyHouseInfo");
        String[] GetData = this.GetSettingData("\uc81c\ub85c\uc5d0\ub108\uc9c0\ud558\uc6b0\uc2a4");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return false;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean Get_CallAppCallTimeout() {
        String[] GetData = this.GetSettingData("\ud1b5\ud654\ud0c0\uc784\uc544\uc6c3");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf(BLE_SMARTKEY_TYPE_NONUSE) > 0) {
                returnData = false;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public boolean Set_CallAppCallTimeout(boolean input) {
        String SettingValue = "\uc0ac\uc6a9\ud568";
        SettingValue = !input ? BLE_SMARTKEY_TYPE_NONUSE : "\uc0ac\uc6a9\ud568";
        try {
            this.UpdateSettingData("subdev_list", "\ud1b5\ud654\ud0c0\uc784\uc544\uc6c3", 0, "1(1:\ud1b5\ud654\ud0c0\uc784\uc544\uc6c3(" + SettingValue + ")");
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean Get_IP_Expansion() {
        String[] GetData = this.GetSettingData("IP\ub300\uc5ed\ud655\uc7a5");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public boolean Set_IP_Expansion(boolean input) {
        String SettingValue = BLE_SMARTKEY_TYPE_NONUSE;
        SettingValue = !input ? BLE_SMARTKEY_TYPE_NONUSE : "\uc0ac\uc6a9\ud568";
        try {
            this.UpdateSettingData("subdev_list", "IP\ub300\uc5ed\ud655\uc7a5", 0, "1(1:IP\ub300\uc5ed\ud655\uc7a5(" + SettingValue + ")");
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean GetEachRoomNameInfo() {
        Log.d((String)"WallpadDeviceSet", (String)"GetEachRoomNameInfo");
        String[] GetData = this.GetSettingData("\ub09c\ubc29\uc870\uba85\ubc29\uba85\uce6d\uc124\uc815");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return false;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean GetHDCSmartSwitch485Connection() {
        Log.d((String)"WallpadDeviceSet", (String)"GetHDCSmartSwitch485Connection");
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58485\uc124\uc815");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return false;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean GetBLESmartKeyUSE() {
        Log.d((String)"WallpadDeviceSet", (String)"GetBLESmartKeyUSE");
        int result = this.GetDeviceSetted("BLE\uc2a4\ub9c8\ud2b8\ud0a4");
        return result == 2;
    }

    public boolean GetEMSProtocolUse() {
        String[] GetData = this.GetSettingData("EMS\ud504\ub85c\ud1a0\ucf5c");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public int GetNewDanjiServer() {
        int result = 1;
        Log.d((String)"WallpadDeviceSet", (String)"GetNewDanjiServer");
        String[] GetData = this.GetSettingData("\uc2e0\ud615\ub2e8\uc9c0\uc11c\ubc84");
        if (GetData == null) {
            return 1;
        }
        Log.i((String)"WallpadDeviceSet", (String)("-------------------------------[GetNewDanjiServer_] Lnegth: " + GetData.length));
        for (int i = 0; i < GetData.length; ++i) {
            Log.i((String)"WallpadDeviceSet", (String)("-------------------------------[GetNewDanjiServer_] Data  [" + i + "]" + GetData[i].toString()));
        }
        try {
            if (GetData[1].contains("\uc885\ub958")) {
                if (GetData[1].indexOf("2.0") > 0) {
                    return 2;
                }
                if (GetData[1].indexOf("1.0") > 0) {
                    return 1;
                }
                return 0;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                return 2;
            }
            return 1;
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int[] Get_BLESmartKey_Info() {
        String[] GetData = this.GetSettingData("BLE\uc2a4\ub9c8\ud2b8\ud0a4");
        int[] returnData = new int[]{0, 61};
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData[0] = 0;
                return returnData;
            }
            returnData[0] = 1;
            if (GetData[1].indexOf("(\uc2a4\ub9c8\ud2b8\ud0a4)") > 0) {
                returnData[1] = 62;
            } else if (GetData[1].indexOf("(\uc2a4\ub9c8\ud2b8\ubc34\ub4dc)") > 0) {
                returnData[1] = 63;
            } else {
                returnData[0] = 1;
                returnData[1] = 62;
                return returnData;
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 1;
            returnData[1] = 62;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 1;
            returnData[1] = 62;
            return returnData;
        }
    }

    public boolean Set_BLESmartKeyType(int nValue) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_BLESmartKeyType] nValue: " + nValue));
            String strBLESmartKeyType = BLE_SMARTKEY_TYPE_NONUSE;
            String strSettingValue = "1(1:BLE\uc2a4\ub9c8\ud2b8\ud0a4(\uc0ac\uc6a9\uc548\ud568)";
            if (nValue == 61) {
                strBLESmartKeyType = BLE_SMARTKEY_TYPE_NONUSE;
            } else if (nValue == 62) {
                strBLESmartKeyType = "\uc2a4\ub9c8\ud2b8\ud0a4";
            } else if (nValue == 63) {
                strBLESmartKeyType = BLE_SMARTKEY_TYPE_SMARTBAND;
            } else {
                Log.w((String)"WallpadDeviceSet", (String)("[Set_BLESmartKeyType] Unsupported BLEsmartkey tyep: " + nValue));
                return false;
            }
            strSettingValue = strBLESmartKeyType.equalsIgnoreCase(BLE_SMARTKEY_TYPE_NONUSE) ? "1(1:BLE\uc2a4\ub9c8\ud2b8\ud0a4(\uc0ac\uc6a9\uc548\ud568)" : "1(1:BLE\uc2a4\ub9c8\ud2b8\ud0a4(\uc0ac\uc6a9\ud568)\uc885\ub958(" + strBLESmartKeyType + ")";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_BLESmartKeyType] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "BLE\uc2a4\ub9c8\ud2b8\ud0a4", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_BLESmartKeyType(int nValue)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean GetCtrSequenceLimit() {
        Log.d((String)"WallpadDeviceSet", (String)"GetCtrSequenceLimit");
        int result = this.GetDeviceSetted("\uc81c\uc5b4\uc2dc\ud000\uc2a4\uc81c\ud55c");
        return result == 2;
    }

    public boolean Get_Integrated_Switch_Info() {
        Log.d((String)"WallpadDeviceSet", (String)"Get_Integrated_Switch_Info");
        int result = this.GetDeviceSetted("\ud1b5\ud569\uc2a4\uc704\uce58");
        return result == 2;
    }

    public boolean Set_IntegratedSwitchUsage(boolean bUsage) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_IntegratedSwitchUsage] bUsage: " + bUsage));
            String strSettingValue = "1(1:\ud1b5\ud569\uc2a4\uc704\uce58(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue = bUsage ? "1(1:\ud1b5\ud569\uc2a4\uc704\uce58(\uc0ac\uc6a9\ud568)" : "1(1:\ud1b5\ud569\uc2a4\uc704\uce58(\uc0ac\uc6a9\uc548\ud568)";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_IntegratedSwitchUsage] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\ud1b5\ud569\uc2a4\uc704\uce58", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_IntegratedSwitchUsage(boolean bUsage)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public int Get_NoiseSensor_Use() {
        String[] GetData = this.GetSettingData("\uce35\uac04\uc18c\uc74c\uc13c\uc11c");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_InnerRoomDetectSensor_Use() {
        String[] GetData = this.GetSettingData("\uc7ac\uc2e4\uc13c\uc11c");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_ReliefCall_Use() {
        String[] GetData = this.GetSettingData("\uc548\uc2ec\ud1b5\ud654");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_RemoteCall_Use() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\uc6d0\uaca9\ud1b5\ud654");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public int Get_MobileAppAuth_Use() {
        String[] GetData = this.GetSettingData("\ubaa8\ubc14\uc77c\uc571\uc0ac\uc6a9\uc790\uc778\uc99d");
        int returnData = 0;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 0;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 0;
            return returnData;
        }
    }

    public boolean Get_ElectricRange_Use() {
        String[] GetData = this.GetSettingData("\uc804\uae30\ub808\uc778\uc9c0");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean getVisitedVehicleRegiUsage() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\ucc28\ub7c9\ub4f1\ub85d");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean getBandLocationUsage() {
        String[] GetData = this.GetSettingData("\ubc34\ub4dc\uc704\uce58\ud655\uc778");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean GetEscapeLadderDownRecv() {
        int result = this.GetDeviceSetted("\ud53c\ub09c\uc0ac\ub2e4\ub9ac\uc785\ud558\uc218\uc2e0");
        return result == 2;
    }

    public boolean Set_RefugeLadderUsage(boolean bUsage) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_RefugeLadderUsage] bUsage: " + bUsage));
            String strSettingValue = "1(1:\ud53c\ub09c\uc0ac\ub2e4\ub9ac(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue = bUsage ? "1(1:\ud53c\ub09c\uc0ac\ub2e4\ub9ac(\uc0ac\uc6a9\ud568)" : "1(1:\ud53c\ub09c\uc0ac\ub2e4\ub9ac(\uc0ac\uc6a9\uc548\ud568)";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_RefugeLadderUsage] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\ud53c\ub09c\uc0ac\ub2e4\ub9ac", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_RefugeLadderUsage(boolean bUsage)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean Set_SUBPHONE_BAUDRATE_9600(boolean bUsage) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_SUBPHONE_BAUDRATE_9600] bUsage: " + bUsage));
            String strSettingValue = "";
            strSettingValue = bUsage ? "1(1:\uc11c\ube0c\ud3f0\ud1b5\uc2e0\uc18d\ub3c4(\uc0ac\uc6a9\ud568)\uc885\ub958(9600)" : "1(1:\uc11c\ube0c\ud3f0\ud1b5\uc2e0\uc18d\ub3c4(\uc0ac\uc6a9\ud568)\uc885\ub958(1200)";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_SUBPHONE_BAUDRATE_9600] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\ud53c\ub09c\uc0ac\ub2e4\ub9ac", 0, strSettingValue);
            if (bUsage) {
                this.UpdateSettingData("subdev_list", "\uc11c\ube0c\ud3f0\ud1b5\uc2e0\uc18d\ub3c4", 0, "1(1:\uc11c\ube0c\ud3f0\ud1b5\uc2e0\uc18d\ub3c4(\uc0ac\uc6a9\ud568)\uc885\ub958(9600)");
            } else {
                this.UpdateSettingData("subdev_list", "\uc11c\ube0c\ud3f0\ud1b5\uc2e0\uc18d\ub3c4", 0, "1(1:\uc11c\ube0c\ud3f0\ud1b5\uc2e0\uc18d\ub3c4(\uc0ac\uc6a9\ud568)\uc885\ub958(1200)");
            }
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_SUBPHONE_BAUDRATE_9600 (boolean bUsage)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean Set_EnergyDevicesUsage(boolean bUsage) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_EnergyDevicesUsage] bUsage: " + bUsage));
            String strSettingValue = "1(1:\uc5d0\ub108\uc9c0\uc81c\ud488\uad70(\uc0ac\uc6a9\uc548\ud568)";
            strSettingValue = bUsage ? "1(1:\uc5d0\ub108\uc9c0\uc81c\ud488\uad70(\uc0ac\uc6a9\ud568)" : "1(1:\uc5d0\ub108\uc9c0\uc81c\ud488\uad70(\uc0ac\uc6a9\uc548\ud568)";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_EnergyDevicesUsage] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\uc5d0\ub108\uc9c0\uc81c\ud488\uad70", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_EnergyDevicesUsage(boolean bUsage)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean SetSubDevListItem(boolean input, String Define_ID) {
        String SettingValue = BLE_SMARTKEY_TYPE_NONUSE;
        if (Define_ID == null) {
            return false;
        }
        SettingValue = !input ? BLE_SMARTKEY_TYPE_NONUSE : "\uc0ac\uc6a9\ud568";
        try {
            this.UpdateSettingData("subdev_list", Define_ID, 0, "1(1:" + Define_ID + "(" + SettingValue + ")");
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public int GetDeviceSetted(String item) {
        String[] GetData = this.GetSettingData(item);
        if (GetData == null) {
            return 0;
        }
        try {
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                return 2;
            }
            return 1;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return 3;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return 3;
        }
    }

    public void SetDeviceEnable(String DevName, boolean onoff) {
        ContentValues values = new ContentValues();
        values.put(DEV_ENABLE, onoff ? DEV_ENABLE : DEV_DISABLE);
        String condi = "id = " + DevName;
        if (this.wdb != null) {
            this.wdb.update("SubDeviceDB", values, condi, null);
        }
    }

    public String[] GetDeviceinfo(String DevName) {
        String query = "select id, name, cnt,  enable, lononoff from SubDeviceDB where id = \"" + DevName + "\";";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext()) {
                String[] getdata = new String[]{cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4)};
                return getdata;
            }
            cursor.close();
        }
        return null;
    }

    public boolean GetDeviceEnable(String DevName) {
        String query = "select enable from SubDeviceDB where id = \"" + DevName + "\";";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext() && cursor.getString(0).equals(DEV_ENABLE)) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }

    public void SetDeviceCount(String DevName, int count) {
        ContentValues values = new ContentValues();
        values.put("cnt", String.valueOf(count));
        String condi = "id = " + DevName;
        this.wdb.update("SubDeviceDB", values, condi, null);
    }

    public boolean GetSubWpdUse() {
        Log.d((String)"WallpadDeviceSet", (String)"GetSubWpdUse");
        int result = this.GetDeviceSetted("\uc11c\ube0c\uc6d4\ud328\ub4dc");
        return result == 2;
    }

    public int[] GetSubWpdDirect_Light() {
        Log.d((String)"WallpadDeviceSet", (String)"[GetSubWpdDirect_Light]");
        String[] GetData = this.GetSettingData("\uc11c\ube0c\uc6d4\ud328\ub4dc\uc870\uba85\uc5f0\ub3d9");
        int[] returnData = new int[]{0, 71};
        try {
            int i;
            if (GetData == null) {
                return returnData;
            }
            for (i = 0; i < GetData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Light] GetData[" + i + "] = " + GetData[i]));
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData[0] = 1;
                returnData[1] = GetData[1].indexOf("(\uc9c1\uc811\uc5f0\ub3d9)") > 0 ? 73 : (GetData[1].indexOf("(\uba54\uc778\uc694\uccad)") > 0 ? 72 : 71);
            } else {
                returnData[0] = 0;
            }
            for (i = 0; i < returnData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Light] returnData[" + i + "] = " + returnData[i]));
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetSubWpdDirect_Light()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
    }

    public int[] GetSubWpdDirect_Heater() {
        Log.d((String)"WallpadDeviceSet", (String)"[GetSubWpdDirect_Heater]");
        String[] GetData = this.GetSettingData("\uc11c\ube0c\uc6d4\ud328\ub4dc\ub09c\ubc29\uc5f0\ub3d9");
        int[] returnData = new int[]{0, 71};
        try {
            int i;
            if (GetData == null) {
                return returnData;
            }
            for (i = 0; i < GetData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Heater] GetData[" + i + "] = " + GetData[i]));
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData[0] = 1;
                returnData[1] = GetData[1].indexOf("(\uc9c1\uc811\uc5f0\ub3d9)") > 0 ? 73 : (GetData[1].indexOf("(\uba54\uc778\uc694\uccad)") > 0 ? 72 : 71);
            } else {
                returnData[0] = 0;
            }
            for (i = 0; i < returnData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Heater] returnData[" + i + "] = " + returnData[i]));
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetSubWpdDirect_Heater()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
    }

    public int[] GetSubWpdDirect_Gas() {
        Log.d((String)"WallpadDeviceSet", (String)"[GetSubWpdDirect_Gas]");
        String[] GetData = this.GetSettingData("\uc11c\ube0c\uc6d4\ud328\ub4dc\uac00\uc2a4\uc5f0\ub3d9");
        int[] returnData = new int[]{0, 71};
        try {
            int i;
            if (GetData == null) {
                return returnData;
            }
            for (i = 0; i < GetData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Gas] GetData[" + i + "] = " + GetData[i]));
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData[0] = 1;
                returnData[1] = GetData[1].indexOf("(\uc9c1\uc811\uc5f0\ub3d9)") > 0 ? 73 : (GetData[1].indexOf("(\uba54\uc778\uc694\uccad)") > 0 ? 72 : 71);
            } else {
                returnData[0] = 0;
            }
            for (i = 0; i < returnData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Gas] returnData[" + i + "] = " + returnData[i]));
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetSubWpdDirect_Gas()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
    }

    public int[] GetSubWpdDirect_Dlock() {
        Log.d((String)"WallpadDeviceSet", (String)"[GetSubWpdDirect_Dlock]");
        String[] GetData = this.GetSettingData("\uc11c\ube0c\uc6d4\ud328\ub4dc\ub3c4\uc5b4\ub77d\uc5f0\ub3d9");
        int[] returnData = new int[]{0, 71};
        try {
            int i;
            if (GetData == null) {
                return returnData;
            }
            for (i = 0; i < GetData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Dlock] GetData[" + i + "] = " + GetData[i]));
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData[0] = 1;
                returnData[1] = GetData[1].indexOf("(\uc9c1\uc811\uc5f0\ub3d9)") > 0 ? 73 : (GetData[1].indexOf("(\uba54\uc778\uc694\uccad)") > 0 ? 72 : 71);
            } else {
                returnData[0] = 0;
            }
            for (i = 0; i < returnData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Dlock] returnData[" + i + "] = " + returnData[i]));
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetSubWpdDirect_Dlock()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
    }

    public int[] GetSubWpdDirect_Venti() {
        Log.d((String)"WallpadDeviceSet", (String)"[GetSubWpdDirect_Venti]");
        String[] GetData = this.GetSettingData("\uc11c\ube0c\uc6d4\ud328\ub4dc\ud658\uae30\uc5f0\ub3d9");
        int[] returnData = new int[]{0, 71};
        try {
            int i;
            if (GetData == null) {
                return returnData;
            }
            for (i = 0; i < GetData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Venti] GetData[" + i + "] = " + GetData[i]));
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData[0] = 1;
                returnData[1] = GetData[1].indexOf("(\uc9c1\uc811\uc5f0\ub3d9)") > 0 ? 73 : (GetData[1].indexOf("(\uba54\uc778\uc694\uccad)") > 0 ? 72 : 71);
            } else {
                returnData[0] = 0;
            }
            for (i = 0; i < returnData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_Venti] returnData[" + i + "] = " + returnData[i]));
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetSubWpdDirect_Venti()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
    }

    public int[] GetSubWpdDirect_PSTN() {
        Log.d((String)"WallpadDeviceSet", (String)"[GetSubWpdDirect_PSTN]");
        String[] GetData = this.GetSettingData("\uc11c\ube0c\uc6d4\ud328\ub4dc\uad6d\uc120\uc804\ud654\uc5f0\ub3d9");
        int[] returnData = new int[]{0, 71};
        try {
            int i;
            if (GetData == null) {
                return returnData;
            }
            for (i = 0; i < GetData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_PSTN] GetData[" + i + "] = " + GetData[i]));
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData[0] = 1;
                returnData[1] = GetData[1].indexOf("(\uc9c1\uc811\uc5f0\ub3d9)") > 0 ? 73 : (GetData[1].indexOf("(\uba54\uc778\uc694\uccad)") > 0 ? 72 : 71);
            } else {
                returnData[0] = 0;
            }
            for (i = 0; i < returnData.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[GetSubWpdDirect_PSTN] returnData[" + i + "] = " + returnData[i]));
            }
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetSubWpdDirect_PSTN()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData[0] = 0;
            returnData[1] = 71;
            return returnData;
        }
    }

    public int GetGatewayModelKindInfo() {
        Log.d((String)"WallpadDeviceSet", (String)"GetGatewayModelKindInfo");
        String[] DataInfo = this.GetSettingData("\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378");
        try {
            if (DataInfo == null) {
                Log.w((String)"WallpadDeviceSet", (String)"GetSettingData(\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378) is null");
                if (this.mModelType == 11100) {
                    this.UpdateSettingData("subdev_list", "\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378", 0, "1(1:\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378(\uc0ac\uc6a9\ud568)\uc885\ub958(IGW200)");
                } else if (this.mModelType == 31100 || this.mModelType == 31500 || this.mModelType == 31170 || this.mModelType == 31570 || this.mModelType == 31120 || this.mModelType == 31520 || this.mModelType == 31640 || this.mModelType == 31660 || this.mModelType == 31630) {
                    this.UpdateSettingData("subdev_list", "\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378", 0, "1(1:\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378(\uc0ac\uc6a9\ud568)\uc885\ub958(IGW300)");
                } else {
                    return -2;
                }
                DataInfo = this.GetSettingData("\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378");
                if (DataInfo != null) {
                    for (int i = 0; i < DataInfo.length; ++i) {
                        Log.i((String)"WallpadDeviceSet", (String)("[GetGatewayModelKindInfo] null -> default : " + DataInfo[i]));
                    }
                } else {
                    return -3;
                }
            }
            String devInfo = DataInfo[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
            if (parseData[3].equals("\uc0ac\uc6a9\ud568")) {
                String TempData = parseData[5];
                if (TempData == null) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData is null");
                    return -3;
                }
                if (TempData.equals("IGW200")) {
                    Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774 \ubaa8\ub378 \uc885\ub958 : IGW200");
                    return 200;
                }
                if (TempData.equals("IGW300")) {
                    Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774 \ubaa8\ub378 \uc885\ub958 : IGW300");
                    return 300;
                }
                Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774 \ubaa8\ub378 \uc885\ub958 : \ubbf8\uc815\uc758");
                return -1;
            }
            Log.d((String)"WallpadDeviceSet", (String)"\uac8c\uc774\ud2b8\uc6e8\uc774\ubaa8\ub378 \uc885\ub958 : \uc0ac\uc6a9\uc548\ud568");
            return 100;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return -4;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] GetGatewayModelKindInfo()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return -4;
        }
    }

    public boolean Get_RemoteMeter_Use() {
        boolean ret = false;
        String[] DataInfo = this.GetSettingData("\uc6d0\uaca9\uac80\uce68");
        if (DataInfo != null) {
            for (int i = 0; i < DataInfo.length; ++i) {
                Log.i((String)"WallpadDeviceSet", (String)("[Get_RemoteMeter_Use] data : " + DataInfo[i]));
            }
        } else {
            Log.w((String)"WallpadDeviceSet", (String)"[Get_RemoteMeter_Use] - data null --> false");
            return false;
        }
        String devInfo = DataInfo[1];
        devInfo = devInfo.replace('(', '_');
        devInfo = devInfo.replace(':', '_');
        String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
        if (parseData[3].equals("\uc0ac\uc6a9\ud568")) {
            Log.i((String)"WallpadDeviceSet", (String)"[Get_RemoteMeter_Use] - RemoteMeter USE : true");
            ret = true;
        } else {
            Log.i((String)"WallpadDeviceSet", (String)"[Get_RemoteMeter_Use] - RemoteMeter USE : false");
            ret = false;
        }
        return ret;
    }

    public boolean StartTransaction() {
        try {
            if (this.wdb != null) {
                this.wdb.beginTransaction();
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
        return true;
    }

    public boolean EndTransaction(boolean success) {
        try {
            if (success && this.wdb != null) {
                this.wdb.setTransactionSuccessful();
            }
            if (this.wdb != null) {
                this.wdb.endTransaction();
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
        return true;
    }

    public void initSubDeviceTBL() {
        if (SubDevInitData == null) {
            WallpadDeviceSet.Init_SubDevInitData();
        }
        for (int i = 0; i < SubDevInitData.length; ++i) {
            ContentValues values = new ContentValues();
            values.put("id", SubDevInitData[i][0]);
            values.put("name", SubDevInitData[i][1]);
            values.put("devcnt", SubDevInitData[i][2]);
            values.put("cnt", SubDevInitData[i][3]);
            values.put("loc", SubDevInitData[i][4]);
            values.put(DEV_ENABLE, SubDevInitData[i][5]);
            values.put("logonoff", SubDevInitData[i][6]);
            if (this.wdb == null) continue;
            this.wdb.insert("SubDeviceDB", null, values);
        }
    }

    public void InsertSettingData(String Type, String Name, int cnt, String value) {
        ContentValues values = new ContentValues();
        values.put("type", Type);
        values.put("name", Name);
        values.put("cnt", Integer.valueOf(cnt));
        values.put("value", value);
        if (this.wdb != null) {
            this.wdb.insert("SettingDB", null, values);
        }
    }

    public void UpdateSettingData(String Type, String Name, int cnt, String value) {
        String sqlStr = "DELETE FROM SettingDB where name=\"" + Name + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
        this.InsertSettingData(Type, Name, cnt, value);
    }

    public String[] GetSettingData(String Name) {
        String query = "select name, value from SettingDB where name = \"" + Name + "\";";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext()) {
                String[] getdata = new String[]{cursor.getString(0).trim(), cursor.getString(1).trim()};
                return getdata;
            }
            cursor.close();
        }
        return null;
    }

    public List<String[]> GetGuardList() {
        ArrayList<String[]> GuardList = new ArrayList<String[]>();
        String query = "select name, value from SettingDB where type = \"guard_list\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            String[] getdata = new String[]{cursor.getString(0), cursor.getString(1)};
            GuardList.add(getdata);
        }
        cursor.close();
        return GuardList;
    }

    public String[] GetSettingGroup() {
        String query = "select name, value from SettingDB group by type;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        String retval = "";
        int count = 0;
        while (cursor.moveToNext()) {
            retval = count == 0 ? cursor.getString(0) : retval + ";" + cursor.getString(0);
            ++count;
        }
        cursor.close();
        if (count == 0) {
            return null;
        }
        return retval.split(";");
    }

    public List<String[]> GetSettingGroupData(String groupname) {
        String query = "select name, value from SettingDB where type = \"" + groupname + "\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        ArrayList<String[]> retVal = new ArrayList<String[]>();
        while (cursor.moveToNext()) {
            String[] retdata = new String[]{cursor.getString(0), cursor.getString(1)};
            retVal.add(retdata);
        }
        cursor.close();
        return retVal;
    }

    public int GetGroupCount(String groupname) {
        String query = "select count() from SettingDB where type = \"" + groupname + "\";";
        Cursor cursor = this.wdb.rawQuery(query, null);
        int count = 0;
        while (cursor.moveToNext()) {
            count = cursor.getInt(0);
        }
        cursor.close();
        return count;
    }

    public void DeleteGuardData() {
        try {
            String sqlStr = "DELETE FROM SettingDB where type = \"guard_list\";";
            this.wdb.execSQL(sqlStr);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
    }

    public void DeleteGroupData(String groupName) {
        try {
            String sqlStr = "DELETE FROM SettingDB where type = \"" + groupName + "\";";
            this.wdb.execSQL(sqlStr);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
    }

    @Override
    public long insertWallPADDB(String name, String Data2) {
        ContentValues values = new ContentValues();
        values.put("id", name);
        values.put("data", Data2);
        long ret = this.wdb.insert("SubDeviceDB", null, values);
        return ret;
    }

    public boolean Validate_IPAddress(String IPAddress) {
        try {
            Log.d((String)"WallpadDeviceSet", (String)("[Validate_IPAddress] IPAddress [" + IPAddress + "]"));
            if (IPAddress == null) {
                return false;
            }
            return mPattern.matcher(IPAddress).matches();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Validate_IPAddress(String IPAddress)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean Get_SmartKitchen_Use() {
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\ud0a4\uce5c");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_EasyModeUX_Support() {
        String[] GetData = this.GetSettingData("\uac04\ud3b8\ubaa8\ub4dcUX\uc9c0\uc6d0");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_RemoteCall_DoorOpenUse() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\uc6d0\uaca9\ud1b5\ud654-\ud604\uad00\ubb38\uc5f4\ub9bc");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_RemoteCall_HomeViewerUse() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\uc6d0\uaca9\ud1b5\ud654-\ud648\ubdf0\uc5b4");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_Stranger_RecordUse() {
        String[] GetData = this.GetSettingData("\uac70\ub3d9\uc218\uc0c1\uc790\ub179\ud654");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_EmergencyContact_SwitchUse() {
        String[] GetData = this.GetSettingData("\ube44\uc0c1\uc811\uc810\uc2a4\uc704\uce58");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_SendWeather_ReverseUse() {
        String[] GetData = this.GetSettingData("\uc11c\ube0c\ud3f0\ub0a0\uc528\uc815\ubcf4\uc5ed\uc21c\uc804\uc1a1");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_SafeStreetLightUse() {
        String[] GetData = this.GetSettingData("\uc548\uc804\uac00\ub85c\ub4f1");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_BathSensorUse() {
        String[] GetData = this.GetSettingData("\uc695\uc2e4\uc13c\uc11c\ub4f1");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_FrontCallUse() {
        String[] GetData = this.GetSettingData("\ud604\uad00");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_LobbyCallUse() {
        String[] GetData = this.GetSettingData("\ub85c\ube44");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_GuardCallUse() {
        String[] GetData = this.GetSettingData("\uacbd\ube44");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_ResidenceCallUse() {
        String[] GetData = this.GetSettingData("\uc774\uc6c3");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_PSTNCallUse() {
        String[] GetData = this.GetSettingData("\uad6d\uc120");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_CallHistoryUse() {
        String[] GetData = this.GetSettingData("\ud1b5\ud654\ub0b4\uc5ed");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_VisitorPicUse() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uc790\uc0ac\uc9c4");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public String Get_RemoteCallSvr_WebPort() {
        String[] GetData = this.GetSettingData("\ubc29\ubb38\uac1d\uc6d0\uaca9\ud1b5\ud654WEB\ud3ec\ud2b8");
        String returnData = "8089";
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData = GetData[1].indexOf("(8088)") > 0 ? "8088" : "8089";
            }
            Log.d((String)"WallpadDeviceSet", (String)("[Get_RemoteCallSvr_WebPort] returnData [" + returnData + "]"));
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public boolean Get_VentiServiceQRUse() {
        String[] GetData = this.GetSettingData("\ud658\uae30\ucf00\uc5b4\uc11c\ube44\uc2a4QR");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_TheDisabledHomeSet() {
        String[] GetData = this.GetSettingData("\uc7a5\uc560\uc778\uc138\ub300");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_CO2ReductionSet() {
        String[] GetData = this.GetSettingData("\uc774\uc0b0\ud654\ud0c4\uc18c\uc808\uac10\ub960");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public int Get_HeatOneDevice_Use() {
        String[] GetData = this.GetSettingData("\ub09c\ubc29\uc77c\uccb4\ud615");
        try {
            if (GetData != null) {
                String TempData;
                String devInfo = GetData[1];
                devInfo = devInfo.replace('(', '_');
                devInfo = devInfo.replace(':', '_');
                String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
                if (parseData[3].equals("\uc0ac\uc6a9\ud568") && (TempData = parseData[5]) != null) {
                    if (TempData.equals("\ub09c\ubc29\ud658\uae30")) {
                        Log.d((String)"WallpadDeviceSet", (String)"\ub09c\ubc29\uc77c\uccb4\ud615: \ub09c\ubc29\ud658\uae30");
                        return 81;
                    }
                    if (TempData.equals("\ub09c\ubc29\uc870\uba85")) {
                        Log.d((String)"WallpadDeviceSet", (String)"\ub09c\ubc29\uc77c\uccb4\ud615: \ub09c\ubc29\uc870\uba85");
                        return 82;
                    }
                    if (TempData.equals("\ub09c\ubc29\ud658\uae30\uc870\uba85")) {
                        Log.d((String)"WallpadDeviceSet", (String)"\ub09c\ubc29\uc77c\uccb4\ud615: \ub09c\ubc29\ud658\uae30\uc870\uba85");
                        return 83;
                    }
                    Log.d((String)"WallpadDeviceSet", (String)"\ub09c\ubc29\uc77c\uccb4\ud615: \ubbf8\uc815\uc758");
                }
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Get_HeatOneDevice_Use()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return 80;
    }

    public int Get_SmartSwitchEnergy_Kind() {
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58\uc5d0\ub108\uc9c0\uc885\ub958");
        try {
            if (GetData != null) {
                String TempData;
                String devInfo = GetData[1];
                devInfo = devInfo.replace('(', '_');
                devInfo = devInfo.replace(':', '_');
                String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
                if (parseData[3].equals("\uc0ac\uc6a9\ud568") && (TempData = parseData[5]) != null) {
                    if (TempData.equals("\uc2e4\uc2dc\uac04\uac80\uce68\uae30")) {
                        Log.d((String)"WallpadDeviceSet", (String)"[Get_SmartSwitchEnergy_Kind] \uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58 \uc5d0\ub108\uc9c0 \uc885\ub958: \uc2e4\uc2dc\uac04\uac80\uce68\uae30");
                        return 91;
                    }
                    if (TempData.equals("\uc6d0\uaca9\uac80\uce68\uae30")) {
                        Log.d((String)"WallpadDeviceSet", (String)"[Get_SmartSwitchEnergy_Kind] \uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58 \uc5d0\ub108\uc9c0 \uc885\ub958: \uc6d0\uaca9\uac80\uce68\uae30");
                        return 92;
                    }
                    Log.d((String)"WallpadDeviceSet", (String)"[Get_SmartSwitchEnergy_Kind] \uc2a4\ub9c8\ud2b8\uc2a4\uc704\uce58 \uc5d0\ub108\uc9c0 \uc885\ub958: \ubbf8\uc815\uc758");
                }
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Get_SmartSwitchEnergy_Kind()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return 90;
    }

    public int getLCDKeeperUsage() {
        int returnData = 101;
        try {
            String[] GetData = this.GetSettingData("LCDKEEPER");
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                if (GetData[1].indexOf("(\ubcf4\ud638\ubaa8\ub4dc)") > 0) {
                    returnData = 101;
                } else if (GetData[1].indexOf("(\ubcf5\uad6c\ubaa8\ub4dc)") > 0) {
                    returnData = 102;
                } else if (GetData[1].indexOf("(\ubcf4\ud638/\ubcf5\uad6c\ubaa8\ub4dc)") > 0) {
                    returnData = 103;
                }
            }
            Log.d((String)"WallpadDeviceSet", (String)("[getLCDKeeperUsage] LCDKeeperUsage [" + returnData + "]"));
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public int Get_PowerControllerType_Info() {
        String[] GetData = this.GetSettingData("\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30");
        boolean returnData = false;
        try {
            Log.d((String)"WallpadDeviceSet", (String)"Get_PowerControllerType_Info");
            String[] DataInfo = this.GetSettingData("\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30");
            if (DataInfo == null) {
                Log.w((String)"WallpadDeviceSet", (String)"GetSettingData(\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30) is null");
                DataInfo = this.GetSettingData("\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30");
                if (DataInfo != null) {
                    for (int i = 0; i < DataInfo.length; ++i) {
                        Log.i((String)"WallpadDeviceSet", (String)("[Get_PowerControllerType_Info] null -> default : " + DataInfo[i]));
                    }
                } else {
                    return -3;
                }
            }
            String devInfo = DataInfo[1];
            devInfo = devInfo.replace('(', '_');
            devInfo = devInfo.replace(':', '_');
            String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
            if (parseData[3].equals("\uc0ac\uc6a9\ud568")) {
                String TempData = parseData[5];
                if (TempData == null) {
                    Log.e((String)"WallpadDeviceSet", (String)"TempData is null");
                    return -3;
                }
                if (TempData.equals(POWER_CONTROLLER_TYPE_DIRECT)) {
                    Log.d((String)"WallpadDeviceSet", (String)"\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30 \uc885\ub958 : \uc9c1\uacb0\ubcf4\ub4dc");
                    return 112;
                }
                if (TempData.equals(POWER_CONTROLLER_TYPE_MEASURE)) {
                    Log.d((String)"WallpadDeviceSet", (String)"\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30 \uc885\ub958 : \uc804\ub825\uce21\uc815 \uc9c1\uacb0\ubcf4\ub4dc");
                    return 113;
                }
                Log.d((String)"WallpadDeviceSet", (String)"\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30 \uc885\ub958 : \uae30\ubcf8");
                return 111;
            }
            Log.d((String)"WallpadDeviceSet", (String)"\ud1b5\ud569\uc804\ub825\uc81c\uc5b4\uae30 \uc885\ub958 : \uc0ac\uc6a9\uc548\ud568");
            return 110;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return 110;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return 110;
        }
    }

    public boolean Get_LH_Gateway_Use() {
        String[] GetData = this.GetSettingData("LH\uac8c\uc774\ud2b8\uc6e8\uc774");
        boolean returnData = false;
        try {
            if (GetData == null) {
                Log.w((String)"WallpadDeviceSet", (String)"[Get_LH_Gateway_Use] GetData is null!!!");
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public int getEscapeLadderDownSend() {
        int returnData = 120;
        try {
            String[] GetData = this.GetSettingData("\ud53c\ub09c\uc0ac\ub2e4\ub9ac\uc804\uc1a1");
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                if (GetData[1].indexOf("\uc717\uc9d1") > 0) {
                    returnData = 121;
                } else if (GetData[1].indexOf("\uc544\ub7ab\uc9d1") > 0) {
                    returnData = 122;
                }
            }
            Log.d((String)"WallpadDeviceSet", (String)("[getEscapeLadderDownSend] returnData [" + returnData + "]"));
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public boolean setEscapeLadderDownSend(int nValue) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[setEscapeLadderDownSend] nValue: " + nValue));
            String strEscapeLadderSend = BLE_SMARTKEY_TYPE_NONUSE;
            String strSettingValue = "1(1:\ud53c\ub09c\uc0ac\ub2e4\ub9ac\uc804\uc1a1(\uc0ac\uc6a9\uc548\ud568)";
            if (nValue == 120) {
                strEscapeLadderSend = BLE_SMARTKEY_TYPE_NONUSE;
            } else if (nValue == 121) {
                strEscapeLadderSend = "\uc717\uc9d1";
            } else if (nValue == 122) {
                strEscapeLadderSend = "\uc544\ub7ab\uc9d1";
            } else {
                Log.w((String)"WallpadDeviceSet", (String)("[setEscapeLadderDownSend] Unsupported EscapeLadderSend type: " + nValue));
                return false;
            }
            strSettingValue = strEscapeLadderSend.equalsIgnoreCase(BLE_SMARTKEY_TYPE_NONUSE) ? "1(1:\ud53c\ub09c\uc0ac\ub2e4\ub9ac\uc804\uc1a1(\uc0ac\uc6a9\uc548\ud568)" : "1(1:\ud53c\ub09c\uc0ac\ub2e4\ub9ac\uc804\uc1a1(\uc0ac\uc6a9\ud568)\uc885\ub958(" + strEscapeLadderSend + ")";
            Log.i((String)"WallpadDeviceSet", (String)("[setEscapeLadderDownSend] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\ud53c\ub09c\uc0ac\ub2e4\ub9ac\uc804\uc1a1", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] setEscapeLadderDownSend(int nValue)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean Get_KakaoUse() {
        String[] GetData = this.GetSettingData("\uce74\uce74\uc624\ud648");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = false;
                return returnData;
            }
            returnData = true;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public boolean Get_KakaoShow() {
        boolean returnData = false;
        try {
            if (this.Get_KakaoUse()) {
                String[] GetData = this.GetSettingData("\uce74\uce74\uc624\ud648\ubcf4\uae30");
                if (GetData == null) {
                    returnData = true;
                } else if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                    returnData = true;
                }
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public boolean Set_KakaoShow(boolean value) {
        try {
            Log.i((String)"WallpadDeviceSet", (String)("[Set_KakaoShow] nValue: " + value));
            String strKakaoshow = "\uc0ac\uc6a9";
            String strSettingValue = "1(1:\uce74\uce74\uc624\ud648\ubcf4\uae30(\uc0ac\uc6a9\ud568)";
            strSettingValue = value ? "1(1:\uce74\uce74\uc624\ud648\ubcf4\uae30(\uc0ac\uc6a9\ud568)" : "1(1:\uce74\uce74\uc624\ud648\ubcf4\uae30(\uc0ac\uc6a9\uc548\ud568)";
            Log.i((String)"WallpadDeviceSet", (String)("[Set_KakaoShow] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\uce74\uce74\uc624\ud648\ubcf4\uae30", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Set_KakaoShow(boolean value)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean Get_SmartIOTCamFlipUse() {
        String[] GetData = this.GetSettingData("\uc2a4\ub9c8\ud2b8\ud604\uad00\uce74\uba54\ub77c\uc88c\uc6b0\ubc18\uc804");
        boolean returnData = false;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public int Get_Construction_SpecialFunc() {
        String[] GetData = this.GetSettingData("\uac74\uc124\uc0ac\ud2b9\ud654\uae30\ub2a5");
        int returnData = 130;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                if (GetData[1].indexOf("SK\uac74\uc124") > 0) {
                    returnData = 131;
                } else if (GetData[1].indexOf("\ub300\uc6b0\uac74\uc124") > 0) {
                    returnData = 132;
                }
            }
            Log.d((String)"WallpadDeviceSet", (String)("[Get_Construction_SpecialFunc] returnData [" + returnData + "]"));
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public int Get_SmartDoorCam_Dutaion() {
        String[] GetData = this.GetSettingData("\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\uc2dc\uac04");
        int returnData = 60;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                String devInfo = GetData[1];
                devInfo = devInfo.replace('(', '_');
                devInfo = devInfo.replace(':', '_');
                String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
                if (parseData.length != 6) {
                    Log.d((String)"WallpadDeviceSet", (String)("[Get_SmartDoorCam_Duration]Parsing Error : InputData [" + GetData[1] + "]"));
                    return returnData;
                }
                if (parseData[5].contains("\ucd08")) {
                    parseData[5] = parseData[5].replace("\ucd08", "");
                }
                returnData = Integer.parseInt(parseData[5]);
            }
            Log.d((String)"WallpadDeviceSet", (String)("[Get_SmartDoorCam_Duration] returnData [" + returnData + "]"));
            return returnData;
        }
        catch (RuntimeException re) {
            Log.e((String)"WallpadDeviceSet", (String)"[RuntimeException] Get_SmartDoorCam_Duration()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Get_SmartDoorCam_Duration()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public void Set_SmartDoorCam_Duration(boolean isUse, int duration) {
        try {
            String _use = isUse ? "\uc0ac\uc6a9\ud568" : BLE_SMARTKEY_TYPE_NONUSE;
            String value = String.valueOf(duration) + "\ucd08";
            String inputValue = isUse ? "1(1:\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\uc2dc\uac04(" + _use + ")\uc885\ub958(" + value + ")" : "1(1:\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\uc2dc\uac04(" + _use + ")";
            this.UpdateSettingData("subdev_list", "\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\uc2dc\uac04", 0, inputValue);
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)("[Exception] Set_SmartDoorCam_Duration( isUse : " + isUse + ", Duration : " + duration + ")"));
        }
    }

    public void Set_SmartDoorCam_CheckCount(boolean isUse, int count) {
        try {
            String _use = isUse ? "\uc0ac\uc6a9\ud568" : BLE_SMARTKEY_TYPE_NONUSE;
            String value = String.valueOf(count);
            String inputValue = isUse ? "1(1:\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\ud69f\uc218(" + _use + ")\uc885\ub958(" + value + ")" : "1(1:\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\ud69f\uc218(" + _use + ")";
            this.UpdateSettingData("subdev_list", "\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\ud69f\uc218", 0, inputValue);
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)("[Exception] Set_SmartDoorCam_CheckCount( isUse : " + isUse + ", Count : " + count + ")"));
        }
    }

    public int Get_SmartDoorCam_Check_Count() {
        String[] GetData = this.GetSettingData("\uac70\ub3d9\uc218\uc0c1\uc790\uac10\uc9c0\ud69f\uc218");
        int returnData = 5;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                String devInfo = GetData[1];
                devInfo = devInfo.replace('(', '_');
                devInfo = devInfo.replace(':', '_');
                String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
                if (parseData.length != 6) {
                    Log.d((String)"WallpadDeviceSet", (String)("[Get_SmartDoorCam_Check_Count]Parsing Error : InputData [" + GetData[1] + "]"));
                    return returnData;
                }
                returnData = Integer.parseInt(parseData[5]);
            }
            Log.d((String)"WallpadDeviceSet", (String)("[Get_SmartDoorCam_Check_Count] returnData [" + returnData + "]"));
            return returnData;
        }
        catch (RuntimeException re) {
            Log.e((String)"WallpadDeviceSet", (String)"[RuntimeException] Get_SmartDoorCam_Check_Count()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return returnData;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] Get_SmartDoorCam_Check_Count()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return returnData;
        }
    }

    public boolean Get_MainGUICtrlUse() {
        String[] GetData = this.GetSettingData("\uc81c\uc5b4\uae30\ub2a5");
        boolean returnData = true;
        try {
            if (GetData == null) {
                return returnData;
            }
            returnData = GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = false;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = false;
            return returnData;
        }
    }

    public int getSDB_EM_Light_Option() {
        String[] GetData = this.GetSettingData("\uac01\uc2e4EM\uc81c\uc5b4\uc635\uc158");
        try {
            if (GetData != null) {
                String TempData;
                String devInfo = GetData[1];
                devInfo = devInfo.replace('(', '_');
                devInfo = devInfo.replace(':', '_');
                String[] parseData = (devInfo = devInfo.replace(')', '_')).split("_");
                if (parseData[3].equals("\uc0ac\uc6a9\ud568") && (TempData = parseData[5]) != null) {
                    if (TempData.equals("\uc77c\uad04\uc81c\uc5b4")) {
                        Log.d((String)"WallpadDeviceSet", (String)"[getSDB_EM_Light_Option] \uac01\uc2e4EM \uc81c\uc5b4 \uc635\uc158: \uc77c\uad04\uc81c\uc5b4");
                        return 140;
                    }
                    if (TempData.equals("\uc21c\ucc28\uc81c\uc5b4")) {
                        Log.d((String)"WallpadDeviceSet", (String)"[getSDB_EM_Light_Option] \uac01\uc2e4EM \uc81c\uc5b4 \uc635\uc158: \uc21c\ucc28\uc81c\uc5b4");
                        return 141;
                    }
                    if (TempData.equals("\uc21c\ucc28\uc81c\uc5b4\ucd08\uae30\ud654")) {
                        Log.d((String)"WallpadDeviceSet", (String)"[getSDB_EM_Light_Option] \uac01\uc2e4EM \uc81c\uc5b4 \uc635\uc158: \uc21c\ucc28\uc81c\uc5b4 & \ucd08\uae30\ud654");
                        return 142;
                    }
                    Log.d((String)"WallpadDeviceSet", (String)"[getSDB_EM_Light_Option] \uac01\uc2e4EM \uc81c\uc5b4 \uc635\uc158: \ubbf8\uc815\uc758");
                }
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] getSDB_EM_Light_Option()");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return 142;
    }

    public boolean setSDB_EM_Light_Option(int nValue) {
        try {
            if (nValue < 140 || 142 < nValue) {
                Log.w((String)"WallpadDeviceSet", (String)("[setSDB_EM_Light_Option] nValue is out of range!! -> " + nValue));
                return false;
            }
            String strSettingValue = "";
            if (nValue == 140) {
                strSettingValue = "1(1:\uac01\uc2e4EM\uc81c\uc5b4\uc635\uc158(\uc0ac\uc6a9\ud568)\uc885\ub958(\uc77c\uad04\uc81c\uc5b4))";
            } else if (nValue == 141) {
                strSettingValue = "1(1:\uac01\uc2e4EM\uc81c\uc5b4\uc635\uc158(\uc0ac\uc6a9\ud568)\uc885\ub958(\uc21c\ucc28\uc81c\uc5b4))";
            } else if (nValue == 142) {
                strSettingValue = "1(1:\uac01\uc2e4EM\uc81c\uc5b4\uc635\uc158(\uc0ac\uc6a9\ud568)\uc885\ub958(\uc21c\ucc28\uc81c\uc5b4\ucd08\uae30\ud654))";
            }
            Log.i((String)"WallpadDeviceSet", (String)("[setSDB_EM_Light_Option] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "\uac01\uc2e4EM\uc81c\uc5b4\uc635\uc158", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] setSDB_EM_Light_Option(int nValue)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean setHDCLinker(String[] Linkers) {
        try {
            String linkers = "none";
            if (Linkers == null) {
                Log.w((String)"WallpadDeviceSet", (String)"[setHDCLinker] Linkers is null!!");
                linkers = "none";
            } else {
                Log.i((String)"WallpadDeviceSet", (String)("[setHDCLinker] Linkers [" + Linkers.length + "]"));
                for (int i = 0; i < Linkers.length; ++i) {
                    linkers = i == 0 ? Linkers[i] : linkers + "_" + Linkers[i];
                }
            }
            String strSettingValue = "\uc0ac\uc6a9";
            strSettingValue = linkers == "none" ? "1(1:HDCLINKER(\uc0ac\uc6a9\uc548\ud568))" : "1(1:HDCLINKER(\uc0ac\uc6a9\ud568)\uc885\ub958(" + linkers + "))";
            Log.i((String)"WallpadDeviceSet", (String)("[setHDCLinker] strSettingValue: " + strSettingValue));
            this.UpdateSettingData("subdev_list", "HDCLINKER", 0, strSettingValue);
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"WallpadDeviceSet", (String)"[Exception] setHDCLinker(String strLinkers)");
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            return false;
        }
    }

    public boolean getHDCLinkerUsage() {
        boolean bResult = false;
        try {
            String[] data = this.GetSettingData("HDCLINKER");
            if (data == null) {
                bResult = false;
            } else if (data[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                bResult = true;
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return bResult;
    }

    public String[] getHDCLinker() {
        String[] returnData = null;
        try {
            String[] data = this.GetSettingData("HDCLINKER");
            if (data == null) {
                return null;
            }
            for (int i = 0; i < data.length; ++i) {
                Log.e((String)"WallpadDeviceSet", (String)("[getHDCLinker] data[" + i + "] = " + data[i]));
            }
            if (data[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                String[] strLinkers = data[1].split("\uc885\ub958\\(");
                if ((strLinkers = strLinkers[1].split("\\)"))[0] != null) {
                    Log.i((String)"WallpadDeviceSet", (String)("[getHDCLinker] strLinkers[0] = " + strLinkers[0]));
                    returnData = strLinkers[0].split("_");
                } else if (this.setHDCLinker(null)) {
                    String strSettingValue = "1(1:HDCLINKER(\uc0ac\uc6a9\uc548\ud568))";
                    this.UpdateSettingData("subdev_list", "HDCLINKER", 0, strSettingValue);
                    returnData = null;
                }
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public boolean Get_Notice() {
        boolean returnData = false;
        try {
            String[] GetData = this.GetSettingData("\uacf5\uc9c0\uc0ac\ud56d");
            if (GetData == null) {
                returnData = true;
            } else if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData = true;
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public boolean Get_AutoPicture() {
        boolean returnData = false;
        try {
            String[] GetData = this.GetSettingData("\uc804\uc790\uc561\uc790");
            if (GetData == null) {
                returnData = true;
            } else if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData = true;
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public boolean Get_Weather() {
        boolean returnData = false;
        try {
            String[] GetData = this.GetSettingData("\ub0a0\uc528");
            if (GetData == null) {
                returnData = true;
            } else if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData = true;
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public boolean Get_Memo() {
        boolean returnData = false;
        try {
            String[] GetData = this.GetSettingData("\uba54\ubaa8");
            if (GetData == null) {
                returnData = true;
            } else if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData = true;
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public boolean Get_Scedule() {
        boolean returnData = false;
        try {
            String[] GetData = this.GetSettingData("\uc77c\uc815\ud45c");
            if (GetData == null) {
                returnData = true;
            } else if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") > 0) {
                returnData = true;
            }
        }
        catch (NullPointerException e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
        }
        return returnData;
    }

    public int Get_Auto_AllightOff() {
        String[] GetData = this.GetSettingData("\uc790\ub3d9\uc77c\uad04\uc18c\ub4f1\ud574\uc81c");
        int returnData = 1;
        try {
            if (GetData == null) {
                return returnData;
            }
            if (GetData[1].indexOf("\uc0ac\uc6a9\ud568") <= 0) {
                returnData = 0;
                return returnData;
            }
            returnData = 1;
            return returnData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", re);
            returnData = 1;
            return returnData;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", "WallpadDeviceSet", e);
            returnData = 1;
            return returnData;
        }
    }
}

