/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class WallPadRemoteCallUserData
extends wallpaddbmgr {
    private static final String TAG = "WPRemoteCallUserData";
    private static String[] VALUE_NAME_HISTORY_USER = new String[]{"PHONE_KEY", "NAME", "MONITOR_AUTH", "LOBBY_OPEN", "DOOR_OPEN", "HOME_VIEWER"};

    public WallPadRemoteCallUserData(Context ctx) {
        super(ctx);
        try {
            if (!this.CheckTableExist("RemoteCallUserDB")) {
                Log.i((String)TAG, (String)"[WallPadRemoteCallUserData] Create Table!!!");
                if (this.wdb != null) {
                    this.wdb.execSQL("create table RemoteCallUserDB (seqnum INTEGER PRIMARY KEY AUTOINCREMENT, PHONE_KEY text, NAME text, MONITOR_AUTH text, LOBBY_OPEN text, DOOR_OPEN text, HOME_VIEWER text);");
                }
            } else {
                Log.i((String)TAG, (String)"[WallPadRemoteCallUserData] Table is already exist!!!");
                String query = "select * from RemoteCallUserDB;";
                if (this.wdb != null) {
                    Cursor cursor = this.wdb.rawQuery(query, null);
                    int nColumnCnt = cursor.getColumnCount();
                    Log.i((String)TAG, (String)("[WallPadRemoteCallUserData] nColumnCnt [" + nColumnCnt + "]"));
                    for (int i = 0; i < nColumnCnt; ++i) {
                        Log.d((String)TAG, (String)("[WallPadRemoteCallUserData] cursor.getColumnName (" + i + ") = " + cursor.getColumnName(i)));
                    }
                    boolean bCompare = true;
                    for (int i = 1; i < nColumnCnt; ++i) {
                        if (cursor.getColumnName(i).equals(VALUE_NAME_HISTORY_USER[i - 1])) continue;
                        bCompare = false;
                        break;
                    }
                    Log.i((String)TAG, (String)("[WallPadRemoteCallUserData] bCompare [" + bCompare + "]"));
                    if (nColumnCnt != VALUE_NAME_HISTORY_USER.length + 1 || !bCompare) {
                        String strQuery = "DROP TABLE RemoteCallUserDB;";
                        this.wdb.execSQL(strQuery);
                        Log.i((String)TAG, (String)"[WallPadRemoteCallUserData] Create Table Again!!!");
                        this.wdb.execSQL("create table RemoteCallUserDB (seqnum INTEGER PRIMARY KEY AUTOINCREMENT, PHONE_KEY text, NAME text, MONITOR_AUTH text, LOBBY_OPEN text, DOOR_OPEN text, HOME_VIEWER text);");
                    }
                }
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] WallPadRemoteCallUserData(Context ctx)");
            LogUtil.errorLogInfo("", TAG, e);
        }
    }

    public void AddRemoteCallUserInfo(String PhoneKey, String Name) {
        ContentValues values = new ContentValues();
        values.put(VALUE_NAME_HISTORY_USER[0], PhoneKey);
        values.put(VALUE_NAME_HISTORY_USER[1], Name);
        values.put(VALUE_NAME_HISTORY_USER[2], "1");
        values.put(VALUE_NAME_HISTORY_USER[3], "1");
        values.put(VALUE_NAME_HISTORY_USER[4], "0");
        values.put(VALUE_NAME_HISTORY_USER[5], "0");
        if (this.wdb != null) {
            this.wdb.insert("RemoteCallUserDB", null, values);
        }
    }

    public void UpdateRemoteCallUserInfo(String PhoneKey, String Key, String Value) {
        String query = "UPDATE RemoteCallUserDB set " + Key + " = '" + Value + "' where PHONE_KEY = \"" + PhoneKey + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(query);
        }
    }

    public void DeleteRemoteCallUserName(String Name) {
        String query = "DELETE FROM RemoteCallUserDB where name = " + Name + ";";
        if (this.wdb != null) {
            this.wdb.execSQL(query);
        }
    }

    public void DeleteRemoteCallUserPhoneKey(String PhoneKey) {
        String query = "DELETE FROM RemoteCallUserDB where PHONE_KEY = \"" + PhoneKey + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(query);
        }
    }

    public void DeleteAllRemoteCallUserInfo() {
        String query = "DELETE FROM RemoteCallUserDB;";
        if (this.wdb != null) {
            this.wdb.execSQL(query);
        }
    }

    public int isExistRemoteCallUser(String PhoneKey) {
        block7: {
            String query = "select count(*) from RemoteCallUserDB where PHONE_KEY = \"" + PhoneKey + "\";";
            String getdata = null;
            if (PhoneKey == null) {
                Log.w((String)TAG, (String)"[isExistRemoteCallUser] Param - PhoneKey  is null !!!");
                return -10;
            }
            try {
                if (this.wdb != null) {
                    Cursor cursor = this.wdb.rawQuery(query, null);
                    if (cursor != null) {
                        while (cursor.moveToNext()) {
                            getdata = cursor.getString(0).trim();
                        }
                        cursor.close();
                        return Integer.parseInt(getdata);
                    }
                    break block7;
                }
                return -999;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Exception] isExistRemoteCallUser(String PhoneKey)");
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
        return -999;
    }

    public List<RemoteCallUserClass> GetRemoteCallUserData() {
        ArrayList<RemoteCallUserClass> SyncData = new ArrayList<RemoteCallUserClass>();
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery("select seqnum, " + VALUE_NAME_HISTORY_USER[0] + ", " + VALUE_NAME_HISTORY_USER[1] + ", " + VALUE_NAME_HISTORY_USER[2] + ", " + VALUE_NAME_HISTORY_USER[3] + ", " + VALUE_NAME_HISTORY_USER[4] + ", " + VALUE_NAME_HISTORY_USER[5] + " from " + "RemoteCallUserDB" + " order by seqnum asc;", null);
            try {
                while (cursor.moveToNext()) {
                    RemoteCallUserClass data = new RemoteCallUserClass();
                    data.seq = cursor.getInt(0);
                    data.PhoneKey = cursor.getString(1);
                    data.Name = cursor.getString(2);
                    data.MonitorAuth = cursor.getString(3);
                    data.LobbyOpenAuth = cursor.getString(4);
                    data.DoorOpenAuth = cursor.getString(5);
                    data.HomeViewerAuth = cursor.getString(6);
                    SyncData.add(data);
                }
                cursor.close();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                cursor.close();
                SyncData.clear();
                return null;
            }
            catch (Exception e) {
                cursor.close();
                SyncData.clear();
                Log.e((String)TAG, (String)"[Exception] GetRemoteCallUserData()");
                LogUtil.errorLogInfo("", TAG, e);
                return null;
            }
        }
        return SyncData;
    }

    public int GetRemoteCallUserCnt() {
        String query = "select count(*) from RemoteCallUserDB;";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            try {
                if (cursor.moveToNext()) {
                    String getdata = cursor.getString(0).trim();
                    int remoteUserCnt = Integer.parseInt(getdata);
                    Log.d((String)TAG, (String)("[GetRemoteCallUserCnt] remoteUserCnt [" + remoteUserCnt + "]"));
                    return remoteUserCnt;
                }
                cursor.close();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Exception] GetRemoteCallUserCnt()");
                cursor.close();
            }
        }
        return -999;
    }

    public String ToDebugRemoteCallUserData(List<RemoteCallUserClass> data) {
        String retstr = "-----------------------------\r\n";
        retstr = retstr + "RemoteCallUserClass\r\n";
        retstr = retstr + "-----------------------------\r\n";
        if (data.isEmpty()) {
            retstr = retstr + "Empty ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        for (int i = 0; i < data.size(); ++i) {
            RemoteCallUserClass getData = data.get(i);
            if (getData == null) continue;
            retstr = retstr + getData.ToDebugString();
        }
        retstr = retstr + "-----------------------------\r\n";
        return retstr;
    }

    public static class RemoteCallUserClass {
        public int seq = -1;
        public String Name = null;
        public String PhoneKey = null;
        public String MonitorAuth = null;
        public String LobbyOpenAuth = null;
        public String DoorOpenAuth = null;
        public String HomeViewerAuth = null;

        public String ToDebugString() {
            String retStr = "==========================\r\nseq             : " + this.seq + "\r\n==========================\r\nName           : " + this.Name + "\r\nPhoneKey           : " + this.PhoneKey + "\r\nMonitorAuth           : " + this.MonitorAuth + "\r\nLobbyOpenAuth           : " + this.LobbyOpenAuth + "\r\nDoorOpenAuth           : " + this.DoorOpenAuth + "\r\nHomeViewerAuth           : " + this.HomeViewerAuth + "\r\n==========================\r\n\r\n";
            return retStr;
        }
    }
}

