/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class WallpadAccessData
extends wallpaddbmgr {
    private static final String TAG = "WallpadAccessData";
    private int MAX_COUNT = 100;
    public List<AccessDataClass> SyncData = new ArrayList<AccessDataClass>();

    public WallpadAccessData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("AccessDB")) {
            try {
                Log.i((String)TAG, (String)"[Create] CreateAccessDB");
                if (this.wdb != null) {
                    this.wdb.execSQL("create table AccessDB (seqnum INTEGER PRIMARY KEY AUTOINCREMENT, Kind text, Date text, SerialNumber text);");
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Create] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    public int Insert(String Kind, String sn) {
        long ret;
        if (Kind == null) {
            Log.w((String)TAG, (String)"[Insert] Param - Kind is null !!!");
            return -1;
        }
        if (!KIND.RangeCheck(Kind)) {
            Log.w((String)TAG, (String)("[Insert] Param - Kind RangeCheck Error (" + Kind + ")"));
            return -2;
        }
        if (Kind.equals("SMART_KEY") && sn == null) {
            Log.w((String)TAG, (String)"[Insert] Param - sn is null !!!");
            return -3;
        }
        int Count = this.getCount();
        if (Count < 0) {
            Log.w((String)TAG, (String)("[Insert] getCount() Error !!! (Count:" + Count + ")"));
            return -4;
        }
        if (Count >= this.MAX_COUNT) {
            int DelCount = Count - (this.MAX_COUNT - 1);
            for (int i = 0; i < DelCount; ++i) {
                int ret2 = this.Delete(0);
                if (ret2 >= 0) continue;
                Log.w((String)TAG, (String)("[Insert] Delete() Error !!! (ret:" + ret2 + ")"));
            }
        }
        ContentValues values = new ContentValues();
        values.put("Kind", Kind);
        GregorianCalendar cal = new GregorianCalendar();
        String DateStr = cal.get(1) + ":" + (cal.get(2) + 1) + ":" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        values.put("Date", DateStr);
        if (sn != null) {
            values.put("SerialNumber", sn);
        }
        if (this.wdb != null && (ret = this.wdb.insert("AccessDB", null, values)) < 0L) {
            return -10;
        }
        return 0;
    }

    public int Delete(int index) {
        if (index < 0) {
            Log.w((String)TAG, (String)("[Delete] Param - index Out Of Range #1 !!! (index:" + index + ")"));
            return -1;
        }
        int Count = this.getCount();
        if (Count < 0) {
            Log.w((String)TAG, (String)("[Delete] getCount() Error !!! (Count:" + Count + ")"));
            return -2;
        }
        if (Count == 0) {
            Log.w((String)TAG, (String)"[Delete] Count is Zero !!!");
            return -3;
        }
        if (index >= Count) {
            Log.w((String)TAG, (String)("[Delete] Param - index Out Of Range #2 !!! (index:" + index + ", Count:" + Count + ")"));
            return -4;
        }
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery("select seqnum from AccessDB;", null);
            int seqnum = 0;
            try {
                boolean bRet = cursor.moveToPosition(index);
                if (!bRet) {
                    cursor.close();
                    Log.w((String)TAG, (String)"[Delete] moveToPosition return false !!!");
                    return -5;
                }
                seqnum = cursor.getInt(0);
                cursor.close();
                if (seqnum <= 0) {
                    Log.w((String)TAG, (String)("[Delete] seqnum Out Of Range !!! (seqnum:" + seqnum + ")"));
                    return -6;
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                cursor.close();
                return -100;
            }
            catch (Exception e) {
                cursor.close();
                Log.e((String)TAG, (String)"[Delete] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
                return -100;
            }
            String whereClause = "seqnum = " + seqnum;
            int ret = this.wdb.delete("AccessDB", whereClause, null);
            if (ret < 0) {
                Log.w((String)TAG, (String)("[Delete] delete Error (ret:" + ret + ")"));
                return -10;
            }
        }
        return 0;
    }

    public int DeleteAll() {
        int Count = this.getCount();
        if (Count < 0) {
            Log.w((String)TAG, (String)("[DeleteAll] getCount() Error !!! (Count:" + Count + ")"));
            return -1;
        }
        String sqldata = "delete from AccessDB;";
        try {
            if (this.wdb != null) {
                this.wdb.execSQL(sqldata);
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[DeleteAll] Exception Error !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
        return 0;
    }

    public int getCount() {
        String query = "select count(*) from AccessDB;";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext()) {
                String getdata = cursor.getString(0).trim();
                try {
                    return Integer.parseInt(getdata);
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", TAG, re);
                    return -999;
                }
                catch (Exception e) {
                    return -999;
                }
            }
            cursor.close();
        }
        return -1000;
    }

    public List<AccessDataClass> GetData() {
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery("select seqnum, Kind, Date, SerialNumber from AccessDB;", null);
            try {
                this.SyncData.clear();
                String DateStr = null;
                while (cursor.moveToNext()) {
                    AccessDataClass getdata = new AccessDataClass();
                    getdata.seqnum = cursor.getInt(0);
                    getdata.Kind = cursor.getString(1);
                    DateStr = cursor.getString(2);
                    getdata.SerialNumber = cursor.getString(3);
                    String[] retData = null;
                    retData = DateStr.split(":");
                    if (retData != null && retData.length >= 6) {
                        getdata.Date = new GregorianCalendar();
                        getdata.Date.set(1, Integer.parseInt(retData[0]));
                        getdata.Date.set(2, Integer.parseInt(retData[1]) - 1);
                        getdata.Date.set(5, Integer.parseInt(retData[2]));
                        getdata.Date.set(11, Integer.parseInt(retData[3]));
                        getdata.Date.set(12, Integer.parseInt(retData[4]));
                        getdata.Date.set(13, Integer.parseInt(retData[5]));
                    }
                    this.SyncData.add(getdata);
                }
                cursor.close();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                cursor.close();
                this.SyncData.clear();
                return null;
            }
            catch (Exception e) {
                cursor.close();
                this.SyncData.clear();
                Log.e((String)TAG, (String)"[GetData] Exception Error");
                LogUtil.errorLogInfo("", TAG, e);
                return null;
            }
        }
        return this.SyncData;
    }

    public String ToDebugData(List<AccessDataClass> data) {
        String retstr = "-----------------------------\r\n";
        retstr = retstr + "WallpadAccessData\r\n";
        retstr = retstr + "-----------------------------\r\n";
        if (data == null) {
            retstr = retstr + "null ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        if (data.isEmpty()) {
            retstr = retstr + "Empty ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        for (int i = 0; i < data.size(); ++i) {
            AccessDataClass getData = data.get(i);
            if (getData == null) continue;
            retstr = retstr + getData.ToDebugString(i);
        }
        retstr = retstr + "-----------------------------\r\n";
        return retstr;
    }

    public boolean setMaxCount(int ChangeCount) {
        if (ChangeCount < 10 || ChangeCount > 1000) {
            Log.w((String)TAG, (String)("[setMaxCount] Out Of Range Param (ChangeCount:" + ChangeCount + ")"));
            return false;
        }
        this.MAX_COUNT = ChangeCount;
        return true;
    }

    public static class AccessDataClass {
        public int seqnum = -1;
        public String Kind = null;
        public Calendar Date = null;
        public String SerialNumber = null;

        public String ToDebugString(int index) {
            String retStr = "==========================\r\nindex  -  " + index + "\r\n==========================\r\nseqnum       : " + this.seqnum + "\r\nKind         : " + this.Kind + "\r\nDate         : " + this.Date.get(1) + "-" + (this.Date.get(2) + 1) + "-" + this.Date.get(5) + "  " + this.Date.get(11) + ":" + this.Date.get(12) + ":" + this.Date.get(13) + "\r\nSerialNumber : " + this.SerialNumber + "\r\n==========================\r\n\r\n";
            return retStr;
        }
    }

    public static final class KIND {
        public static final String WPAD_CALL = "WPAD_CALL";
        public static final String WPAD_CTRL = "WPAD_CTRL";
        public static final String SMART_KEY = "SMART_KEY";
        public static final String REMOCON = "REMOCON";
        public static final String KITCHEN_TV = "KITCHEN_TV";
        public static final String BATHROOM_PHONE = "BATHROOM_PHONE";
        public static final String SUB_DEVICE = "SUB_DEVICE";
        public static final String SMART_KEY_DETECTION = "SMART_KEY_DETECTION";
        public static final String FPDLOCK_PWDCARD_5OVER = "FPDLOCK_PWDCARD_5OVER";
        public static final String FPDLOCK_FP_10OVER = "FPDLOCK_FP_10OVER";
        public static final String PASSWORD = "PASSWORD";
        public static final String CARDKEY = "CARDKEY";
        public static final String FINGER_PRINT = "FINGER_PRINT";

        public static boolean RangeCheck(String CheckStr) {
            if (CheckStr.equals(WPAD_CALL)) {
                return true;
            }
            if (CheckStr.equals(WPAD_CTRL)) {
                return true;
            }
            if (CheckStr.equals(SMART_KEY)) {
                return true;
            }
            if (CheckStr.equals(REMOCON)) {
                return true;
            }
            if (CheckStr.equals(KITCHEN_TV)) {
                return true;
            }
            if (CheckStr.equals(BATHROOM_PHONE)) {
                return true;
            }
            if (CheckStr.equals(SUB_DEVICE)) {
                return true;
            }
            if (CheckStr.equals(SMART_KEY_DETECTION)) {
                return true;
            }
            if (CheckStr.equals(FPDLOCK_PWDCARD_5OVER)) {
                return true;
            }
            if (CheckStr.equals(FPDLOCK_FP_10OVER)) {
                return true;
            }
            if (CheckStr.equals(PASSWORD)) {
                return true;
            }
            if (CheckStr.equals(CARDKEY)) {
                return true;
            }
            return CheckStr.equals(FINGER_PRINT);
        }

        public static String getName(String CheckStr) {
            if (CheckStr.equals(WPAD_CALL)) {
                return "\uc6d4\ud328\ub4dc [\ud1b5\ud654]";
            }
            if (CheckStr.equals(WPAD_CTRL)) {
                return "\uc6d4\ud328\ub4dc [\uc81c\uc5b4]";
            }
            if (CheckStr.equals(SMART_KEY)) {
                return "\uc2a4\ub9c8\ud2b8\ud0a4";
            }
            if (CheckStr.equals(REMOCON)) {
                return "\ubb34\uc120\ub9ac\ubaa8\ucf58";
            }
            if (CheckStr.equals(KITCHEN_TV)) {
                return "\uc8fc\ubc29TV";
            }
            if (CheckStr.equals(BATHROOM_PHONE)) {
                return "\uc695\uc2e4\ud3f0";
            }
            if (CheckStr.equals(SUB_DEVICE)) {
                return "\uc11c\ube0c\uae30\uae30";
            }
            if (CheckStr.equals(SMART_KEY_DETECTION)) {
                return "\uc2a4\ub9c8\ud2b8\ud0a4\uac10\uc9c0";
            }
            if (CheckStr.equals(FPDLOCK_PWDCARD_5OVER)) {
                return "\ube44\ubc00\ubc88\ud638/\uce74\ub4dc 5\ud68c\ucd08\uacfc";
            }
            if (CheckStr.equals(FPDLOCK_FP_10OVER)) {
                return "\uc9c0\ubb38\uc778\uc2dd 10\ud68c\ucd08\uacfc";
            }
            if (CheckStr.equals(PASSWORD)) {
                return "\ube44\ubc00\ubc88\ud638 \ucd9c\uc785";
            }
            if (CheckStr.equals(CARDKEY)) {
                return "\uce74\ub4dc\ud0a4 \ucd9c\uc785";
            }
            if (CheckStr.equals(FINGER_PRINT)) {
                return "\uc9c0\ubb38\uc778\uc2dd \ucd9c\uc785";
            }
            return "\uc815\uc758\ub418\uc9c0\uc54a\uc74c";
        }
    }
}

