/*
 * Copyright (C) 2014 Android LobbyPhone(TCC8935) Project
 *
 * FileName : CardReaderSerialPort.java
 * Project : Android LobbyPhone(TCC8935) Project
 * Company : HDC I-CONTROLS ( www.icontrols.co.kr )
 * Author : Jeffrey Nam
 * E-mail : jeffnam0524@gmail.com, cwnam@icontrols.co.kr
 * Date : 2014.05.28
 */

package kr.co.icontrols.iencryptor.aes128;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import android.content.Context;
import android.util.Log;

public class AES_128 {
    static final String TAG = "AES_128";
    
    static Context mContext;
    
    private static String CRYPTIONKEY_NORMAL = "iBESTINACCESSKEY";
    private static String CRYPTIONKEY_SMARTKEY_CAM = "iCONTROLSMARTKEY";
    private static byte[] hCRYPTIONINITVECTOR_NORMAL = { 7, 8, 5, 1, 8, 3, 1, 1, 9, 7, 9, 0, 5, 2, 4, 0 };
    private static byte[] hCRYPTIONINITVECTOR_SMART_CAM = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
    private static String strTRANSFORM_AES_CFB_PKCS5 = "AES/CFB/PKCS5Padding";
    private static String strTRANSFORM_AES_ECB_NO = "AES/ECB/NoPadding";
    
    public AES_128(Context context) {
        mContext = context;
    }
    
    public static enum ENCRYPTTYPE {
        NORMAL,
        SMARTKEY_CAM;
    }
    // =================================================================================================
    // [[ AES 128 ȣȭ Լ ]] region
    // =================================================================================================
    /**
     * AES 128 ȣȭ
     * 
     * Ʒ  Լ ̸ ٸ   ´.
     *  - public static byte[] Encrypt(ENCRYPTTYPE eEncryptType, byte[] hTargetData)
     *  - public static byte[] Encrypt_CFB(ENCRYPTTYPE eEncryptType, byte[] hTargetData)
     * 
     * @param eEncryptType  : ȣȭ  (ENCRYPTTYPE)<br>
     *                                                            - ENCRYPTTYPE.NORMAL : Ű   , iMAP Ǵ ȣȭ<br>
     *                                                            - ENCRYPTTYPE.SMARTKEY_CAM : Ʈѽ ƮŰ  ī޶  Ǵ ȣȭ
     *@param hTargetData    : ȣȭ  (byte[])
     *@return byte[]              : ȣȭ  (byte[])
     * 
     * @Example
     * <pre class="prettyprint">
     * -   , iMAP Ž
     *    AES_128.Encrypt(ENCRYPTTYPE.NORMAL, TargetData));
     * - ƮŰ ī޶ Ž
     *    AES_128.Encrypt(ENCRYPTTYPE.SMARTKEY_CAM, TargetData));
     * </pre>
     */
    public static byte[] Encrypt(ENCRYPTTYPE eEncryptType, byte[] hTargetData) {
        try {
            String strCryptionKey = "";
            byte[] hCryptionIV = new byte[16];
            
            if (eEncryptType == ENCRYPTTYPE.NORMAL) {
                strCryptionKey = CRYPTIONKEY_NORMAL;
                hCryptionIV = hCRYPTIONINITVECTOR_NORMAL;
            }
            else if (eEncryptType == ENCRYPTTYPE.SMARTKEY_CAM) {
                strCryptionKey = CRYPTIONKEY_SMARTKEY_CAM;
                hCryptionIV = hCRYPTIONINITVECTOR_SMART_CAM;
            }
            else {
                strCryptionKey = CRYPTIONKEY_NORMAL;
                hCryptionIV = hCRYPTIONINITVECTOR_NORMAL;
            }
            
            byte[] hCryptionKey = strCryptionKey.getBytes("ASCII");
            SecretKeySpec mSecretKeySpec = new SecretKeySpec(hCryptionKey, "AES");
            Cipher mCipher = Cipher.getInstance(strTRANSFORM_AES_CFB_PKCS5);
            IvParameterSpec mIvParameterSpec = new IvParameterSpec(hCryptionIV);
            mCipher.init(Cipher.ENCRYPT_MODE, mSecretKeySpec, mIvParameterSpec);
            byte[] hResult = mCipher.doFinal(hTargetData);
            byte[] hEncrypted = new byte[hTargetData.length];
            for (int i = 0; i < hTargetData.length; i++) {
                hEncrypted[i] = hResult[i];
            }
            return hEncrypted;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] Encrypt(eEncryptType, strTargetData)");
            e.printStackTrace();
            return null;
        }
    }
    
    // =================================================================================================
    // [[ AES 128 ȣȭ Լ ]] region
    // =================================================================================================
    /**
     * AES 128 ȣȭ (CFB ), Zigbee  
     *  Zigbee  ȣȭ (Լ )
     * 
     * Ʒ  Լ ̸ ٸ   ´.
     *  - public static byte[] Encrypt(ENCRYPTTYPE eEncryptType, byte[] hTargetData)
     *  - public static byte[] Encrypt_CFB(ENCRYPTTYPE eEncryptType, byte[] hTargetData)
     * 
     * @param eEncryptType  : ȣȭ  (ENCRYPTTYPE)<br>
     *                                                            - ENCRYPTTYPE.NORMAL : Ű   , iMAP Ǵ ȣȭ<br>
     *                                                            - ENCRYPTTYPE.SMARTKEY_CAM : Ʈѽ ƮŰ  ī޶  Ǵ ȣȭ
     *@param hTargetData    : ȣȭ  (byte[])
     *@return byte[]              : ȣȭ  (byte[])
     * 
     * @Example
     * <pre class="prettyprint">
     * -   , iMAP Ž
     *    AES_128.Encrypt_CFB(ENCRYPTTYPE.NORMAL, TargetData));
     * - ƮŰ ī޶ Ž
     *    AES_128.Encrypt_CFB(ENCRYPTTYPE.SMARTKEY_CAM, TargetData));
     * </pre>
     */
    public static byte[] Encrypt_CFB(ENCRYPTTYPE eEncryptType, byte[] hTargetData) {
        try {
            String strCryptionKey = "";
            byte[] hCryptionIV = new byte[16];
            
            if (eEncryptType == ENCRYPTTYPE.NORMAL) {
                strCryptionKey = CRYPTIONKEY_NORMAL;
                hCryptionIV = hCRYPTIONINITVECTOR_NORMAL;
            }
            else if (eEncryptType == ENCRYPTTYPE.SMARTKEY_CAM) {
                strCryptionKey = CRYPTIONKEY_SMARTKEY_CAM;
                hCryptionIV = hCRYPTIONINITVECTOR_SMART_CAM;
            }
            else {
                strCryptionKey = CRYPTIONKEY_NORMAL;
                hCryptionIV = hCRYPTIONINITVECTOR_NORMAL;
            }
            
            byte[] hCryptionKey = strCryptionKey.getBytes("ASCII");
            SecretKeySpec mSecretKeySpec = new SecretKeySpec(hCryptionKey, "AES");
            Cipher mCipher = Cipher.getInstance(strTRANSFORM_AES_CFB_PKCS5);
            IvParameterSpec mIvParameterSpec = new IvParameterSpec(hCryptionIV);
            mCipher.init(Cipher.ENCRYPT_MODE, mSecretKeySpec, mIvParameterSpec);
            byte[] hResult = mCipher.doFinal(hTargetData);
            byte[] hEncrypted = new byte[hTargetData.length];
            for (int i = 0; i < hTargetData.length; i++) {
                hEncrypted[i] = hResult[i];
            }
            return hEncrypted;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] Encrypt_CFB(eEncryptType, strTargetData)");
            e.printStackTrace();
            return null;
        }
    }
    
    
    // =================================================================================================
    // [[ AES 128 ȣȭ Լ ]] region
    // =================================================================================================
    /**
     * AES 128 ȣȭ (ECB ), BT  
     * 
     * 
     * @param eEncryptType  : ȣȭ  (ENCRYPTTYPE)<br>
     *                                                            - ENCRYPTTYPE.NORMAL : Ű   , iMAP Ǵ ȣȭ<br>
     *                                                            - ENCRYPTTYPE.SMARTKEY_CAM : Ʈѽ ƮŰ  ī޶  Ǵ ȣȭ
     *@param hTargetData    : ȣȭ  (byte[])<br>
     *                                                            - 16Byte ̾߸ Ѵ.<br>
     *@return byte[]              : ȣȭ  (byte[])
     * 
     * @Example
     * <pre class="prettyprint">
     * -   , iMAP Ž
     *    AES_128.Encrypt_ECB(ENCRYPTTYPE.NORMAL, TargetData));
     * - ƮŰ ī޶ Ž
     *    AES_128.Encrypt_ECB(ENCRYPTTYPE.SMARTKEY_CAM, TargetData));
     * </pre>
     */
    public static byte[] Encrypt_ECB(ENCRYPTTYPE eCryptType, byte[] hTargetData) {
        try {
            if (hTargetData.length != 16) {
                Log.w(TAG, "[Encrypt_ECB] The length of hTargetData must be 16!!");
                return null;
            }
            
            String strCryptionKey = "";
            
            if (eCryptType == ENCRYPTTYPE.NORMAL) strCryptionKey = CRYPTIONKEY_NORMAL;
            else if (eCryptType == ENCRYPTTYPE.SMARTKEY_CAM) strCryptionKey = CRYPTIONKEY_SMARTKEY_CAM;
            else strCryptionKey = CRYPTIONKEY_NORMAL;
            
//            Key aesKey = new SecretKeySpec(strCryptionKey.getBytes(), "AES");
            SecretKeySpec mSecretKeySpec = new SecretKeySpec(strCryptionKey.getBytes(), "AES");
            Cipher mCipher = Cipher.getInstance(strTRANSFORM_AES_ECB_NO);
            mCipher.init(Cipher.ENCRYPT_MODE, mSecretKeySpec);
            byte[] hResult = mCipher.doFinal(hTargetData);
            byte[] hEncrypted = new byte[hTargetData.length];
            for (int i = 0; i < hTargetData.length; i++) {
                hEncrypted[i] = hResult[i];
            }
            return hEncrypted;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] Encrypt_ECB(eEncryptType, strTargetData)");
            e.printStackTrace();
            return null;
        }
    }
    
    // =================================================================================================
    // [[ AES 128 ȣȭ Լ ]] region
    // =================================================================================================
    /**
     * AES 128 ȣȭ (ECB ), BT  
     * 
     * 
     * @param eEncryptType  : ȣȭ  (ENCRYPTTYPE)<br>
     *                                                            - ENCRYPTTYPE.NORMAL : Ű   , iMAP Ǵ ȣȭ<br>
     *                                                            - ENCRYPTTYPE.SMARTKEY_CAM : Ʈѽ ƮŰ  ī޶  Ǵ ȣȭ
     *@param hTargetData    : ȣȭ  (byte[])<br>
     *                                                            - 16Byte ̾߸ Ѵ.<br>
     *@return byte[]              : ȣȭ  (byte[])
     * 
     * @Example
     * <pre class="prettyprint">
     * -   , iMAP Ž
     *    AES_128.Encrypt_ECB(ENCRYPTTYPE.NORMAL, TargetData));
     * - ƮŰ ī޶ Ž
     *    AES_128.Encrypt_ECB(ENCRYPTTYPE.SMARTKEY_CAM, TargetData));
     * </pre>
     */
    public static byte[] Decrypt_ECB(ENCRYPTTYPE eCryptType, byte[] hTargetData) {
        try {
            if (hTargetData.length != 16) {
                Log.w(TAG, "[Encrypt_ECB] The length of hTargetData must be 16!!");
                return null;
            }
            
            String strCryptionKey = "";
            
            if (eCryptType == ENCRYPTTYPE.NORMAL) strCryptionKey = CRYPTIONKEY_NORMAL;
            else if (eCryptType == ENCRYPTTYPE.SMARTKEY_CAM) strCryptionKey = CRYPTIONKEY_SMARTKEY_CAM;
            else strCryptionKey = CRYPTIONKEY_NORMAL;
            
//            Key aesKey = new SecretKeySpec(strCryptionKey.getBytes(), "AES");
            SecretKeySpec mSecretKeySpec = new SecretKeySpec(strCryptionKey.getBytes(), "AES");
            Cipher mCipher = Cipher.getInstance(strTRANSFORM_AES_ECB_NO);
            mCipher.init(Cipher.DECRYPT_MODE, mSecretKeySpec);
            byte[] hResult = mCipher.doFinal(hTargetData);
            byte[] hDecrypted = new byte[hTargetData.length];
            for (int i = 0; i < hTargetData.length; i++) {
                hDecrypted[i] = hResult[i];
            }
            return hDecrypted;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] Decrypt_ECB(ENCRYPTTYPE eCryptType, byte[] hTargetData)");
            e.printStackTrace();
            return null;
        }
    }
    
    
    
    
    
    
    
}