/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class WallpadSalesSampleData
extends wallpaddbmgr {
    private static final String TAG = "WallpadSalesSampleData";
    public static final String DATABASE_TABLE = "salessample";
    public static final String KEY_ID = "_id";
    public static final String KEY_MODE = "mode";
    public static final String KEY_VALUE = "value";
    private static final String DATABASE_CREATE = "create table salessample (_id integer primary key autoincrement, mode integer default -1, value integer default 0 ); ";
    public static final int SALES_SAMPLE_MODE_BASE = 0;
    public static final int SALES_SAMPLE_MODE_SLEEP = 1;
    public static final int SALES_SAMPLE_MODE_HW_BUTTON_OPERATION = 2;
    public static final int SALES_SAMPLE_MODE_ELEVATOR = 3;
    public static final int SALES_SAMPLE_MODE_PARKING = 4;
    public static final int SALES_SAMPLE_MODE_DOOR_CAMERA = 5;
    public static final int SALES_SAMPLE_MODE_DEVICE_CONTROLLER = 6;
    public static final int SALES_SAMPLE_MODE_ADDITIONAL_FUNCTION = 7;
    public static final int SALES_SAMPLE_MODE_CALL = 8;
    public static final int SALES_SAMPLE_MODE_ADDITIONAL_FUNCTION_SELECT = 9;
    public static final int SALES_SAMPLE_MODE_SENSOR_DETECTING = 10;
    public static final int SALES_SAMPLE_MODE_ROOM_NUMBER = 11;
    public static final int SALES_SAMPLE_MODE_LIGHT_SHOW_MAINSCREEN = 12;
    public static final int SALES_SAMPLE_MODE_LOGO_SHOW_OPTION = 13;
    public static final int SALES_SAMPLE_MODE_DO_NOT_USED = 0;
    public static final int SALES_SAMPLE_MODE_DO_USED = 1;
    public static final int SALES_SAMPLE_MODE_DISABLED = 0;
    public static final int SALES_SAMPLE_MODE_ENABLED = 1;
    public static final int SALES_SAMPLE_ADDITIONAL_FUNCTION_SELECT_DEFAULT = 0;
    public static final int SALES_SAMPLE_ADDITIONAL_FUNCTION_SELECT_EXTENTION = 1;
    private static int[][] SalesSampleInitData = null;

    public WallpadSalesSampleData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist(DATABASE_TABLE)) {
            try {
                if (this.wdb != null) {
                    this.wdb.execSQL(DATABASE_CREATE);
                }
                this.initSalesSampleTBL();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    private static void Init_SalesSampleInitData() {
        int[][] temp_SalesSampleInitData = new int[][]{{1, 1}, {2, 1}, {3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}, {9, 0}, {10, 1}, {11, 6}, {12, 1}, {13, 0}};
        SalesSampleInitData = new int[temp_SalesSampleInitData.length][temp_SalesSampleInitData[0].length];
        for (int i = 0; i < temp_SalesSampleInitData.length; ++i) {
            for (int j = 0; j < temp_SalesSampleInitData[i].length; ++j) {
                WallpadSalesSampleData.SalesSampleInitData[i][j] = temp_SalesSampleInitData[i][j];
            }
        }
    }

    public void initSalesSampleTBL() {
        if (SalesSampleInitData == null) {
            WallpadSalesSampleData.Init_SalesSampleInitData();
        }
        for (int i = 0; i < SalesSampleInitData.length; ++i) {
            ContentValues values = new ContentValues();
            values.put(KEY_MODE, Integer.valueOf(SalesSampleInitData[i][0]));
            values.put(KEY_VALUE, Integer.valueOf(SalesSampleInitData[i][1]));
            if (this.wdb == null) continue;
            this.wdb.insert(DATABASE_TABLE, null, values);
        }
    }

    public void insertSalesSampleData(int mode, int value) {
        ContentValues values = new ContentValues();
        values.put(KEY_MODE, Integer.valueOf(mode));
        values.put(KEY_VALUE, Integer.valueOf(value));
        if (this.wdb != null) {
            this.wdb.insert(DATABASE_TABLE, null, values);
        }
    }

    public void deleteSalesSampleData(int mode) {
        String sqlStr = "DELETE FROM salessample where mode = " + mode + ";";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public void updateSalesSampleData(int mode, int value) {
        this.deleteSalesSampleData(mode);
        this.insertSalesSampleData(mode, value);
    }

    public int getSalesSampleData(int mode) {
        String query = "select value from salessample where mode = " + mode + ";";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext()) {
                int getdata = cursor.getInt(0);
                Log.d((String)TAG, (String)("getSalesSampleData mode : " + getdata));
                return getdata;
            }
            cursor.close();
        }
        return -1;
    }

    public List<int[]> getSalesSampleDataList() {
        ArrayList<int[]> dataList = new ArrayList<int[]>();
        String query = "select mode, value from salessample";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            while (cursor.moveToNext()) {
                int[] getdata = new int[]{cursor.getInt(0), cursor.getInt(1)};
                dataList.add(getdata);
            }
            cursor.close();
        }
        return dataList;
    }

    public int GetSampleRoomNumber() {
        try {
            int RoomNumber = this.getSalesSampleData(11);
            if (RoomNumber >= 1 && RoomNumber <= 6) {
                Log.d((String)TAG, (String)("[GetSampleRoomNumber] RoomNumber : " + RoomNumber));
                return RoomNumber;
            }
            Log.e((String)TAG, (String)"[GetSampleRoomNumber] getSalesSampleData is error. ");
            Log.e((String)TAG, (String)"[GetSampleRoomNumber] RoomNumber : 6");
            return 6;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return 6;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("[ExceptionError] - GetSampleRoomNumber : " + e));
            LogUtil.errorLogInfo("", TAG, e);
            return 6;
        }
    }

    public int GetSampleMainScreenLogoOption() {
        try {
            int OptionNumber = this.getSalesSampleData(13);
            if (OptionNumber >= 0 && OptionNumber <= 6) {
                Log.d((String)TAG, (String)("[GetSampleMainScreenLogoOption] OptionNumber : " + OptionNumber));
                return OptionNumber;
            }
            Log.e((String)TAG, (String)"[GetSampleMainScreenLogoOption] getSalesSampleData is error. ");
            Log.e((String)TAG, (String)"[GetSampleMainScreenLogoOption] OptionNumber : 0");
            return 0;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return 0;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("[ExceptionError] - GetSampleMainScreenLogoOption : " + e));
            LogUtil.errorLogInfo("", TAG, e);
            return 0;
        }
    }
}

