/*
 * Decompiled with CFR 0.152.
 */
package ceres.security;

public class SeedAlg {
    static long[] SS0 = new long[]{696885672L, 92635524L, 382128852L, 331600848L, 340021332L, 487395612L, 747413676L, 621093156L, 491606364L, 0x3434340L, 0x18081018L, 504238620L, 289493328L, 1020063996L, 181060296L, 591618912L, 0x28082028L, 0x4444044L, 0x20002020L, 495817116L, 549511392L, 583197408L, 0x8C8C0C8L, 386339604L, 629514660L, 261063564L, 0x3030300L, 994800504L, 0x3B8BB3B8L, 0x13031310L, 314757840L, 0x2ECEE2ECL, 809529456L, 0xC8C808CL, 1057960764L, 680042664L, 0x32023230L, 0x1DCDD1DCL, 919007988L, 876900468L, 751624428L, 361075092L, 185271048L, 390550356L, 474763356L, 457921368L, 1032696252L, 0x1010100L, 0x24042024L, 0x1C0C101CL, 860058480L, 411603096L, 0x10001010L, 0xCCCC0CCL, 851636976L, 432656856L, 0x2C0C202CL, 667411428L, 843215472L, 0x3838380L, 462132120L, 297914832L, 109478532L, 164217288L, 541089888L, 272650320L, 595829664L, 734782440L, 218956044L, 914797236L, 512660124L, 256852812L, 931640244L, 441078360L, 113689284L, 944271480L, 646357668L, 0x12021210L, 797942700L, 365285844L, 557932896L, 0x3C3C3C0L, 881111220L, 0x1414140L, 306336336L, 1028485500L, 227377548L, 0x8080008L, 521081628L, 0x19899198L, 0L, 420024600L, 0x4040004L, 323179344L, 935850996L, 566354400L, 1036907004L, 910586484L, 789521196L, 654779172L, 813740208L, 0xB8B8388L, 235799052L, 730571688L, 578986656L, 776888940L, 327390096L, 223166796L, 692674920L, 1011642492L, 151585032L, 168428040L, 1066382268L, 802153452L, 868479984L, 96846276L, 126321540L, 0x14041014L, 1053750012L, 608460900L, 516870876L, 772678188L, 189481800L, 436867608L, 101057028L, 0x21012120L, 726360936L, 0x26466264L, 0x2020200L, 902164980L, 310547088L, 0xA8A8288L, 0xC0C000CL, 864269232L, 1045328508L, 281071824L, 977957496L, 0x7474344L, 377918100L, 633725412L, 637936164L, 0x808080L, 764256684L, 533713884L, 562143648L, 0x30003030L, 923218740L, 781099692L, 906375732L, 352653588L, 0x22022220L, 0x38083038L, 885321972L, 663200676L, 0x5454144L, 0xC4C404CL, 0x1818180L, 701096424L, 0x4848084L, 394761108L, 889532724L, 197903304L, 0xECEC2CCL, 0x3C0C303CL, 826372464L, 0x11011110L, 130532292L, 0x9898188L, 893743476L, 1003222008L, 449499864L, 952692984L, 344232084L, 424235352L, 0x2828280L, 0x4C4C0C4L, 0x3FCFF3FCL, 155795784L, 956903736L, 658989924L, 0xC0C0C0L, 0xFCFC3CCL, 398971860L, 948482232L, 252642060L, 244220556L, 0x2424240L, 0x23032320L, 293704080L, 743202924L, 466342872L, 612671652L, 0x34043034L, 834793968L, 0x8484048L, 0x2C2C2C0L, 793731948L, 1024274748L, 755835180L, 0x404040L, 1049539260L, 1041117756L, 1015853244L, 0x1C1C1C0L, 0x2A8AA2A8L, 982168248L, 240009804L, 0x15455154L, 990589752L, 483184860L, 675831912L, 1062171516L, 478974108L, 415813848L, 172638792L, 373707348L, 0x37477374L, 545300640L, 768467436L, 0x6464244L, 897954228L, 722150184L, 625303908L, 986379000L, 600040416L, 965325240L, 830583216L, 529503132L, 508449372L, 969535992L, 650568420L, 847426224L, 0x31013130L, 717939432L, 760045932L, 525292380L, 616882404L, 817950960L, 0xDCDC1CCL, 0x8888088L, 369496596L, 973746744L, 407392344L, 348442836L, 574775904L, 688464168L, 117900036L, 0x33033330L, 684253416L, 453710616L, 84214020L, 961114488L, 276861072L, 709517928L, 705307176L, 445289112L};
    static long[] SS1 = new long[]{0x38380830L, -399980320L, 741149985L, -1540979038L, -871379005L, -601960750L, -1338801229L, -1204254544L, -1406169181L, 1612726368L, 0x54154551L, -1006123069L, 0x44044440L, 1815039843L, 1747667811L, 1478183763L, -1073495101L, 1612857954L, 0x30330333L, -1271560783L, 673777953L, -1608482656L, -534592798L, -1540913245L, -804011053L, -1877900911L, 0x10110111L, 67503618L, 0x1C1C0C10L, -1136882512L, 875955762L, 1208699715L, -332410909L, -2012706688L, 1814842464L, -1473738592L, 337053459L, -1006320448L, 336987666L, -197868304L, -1073560894L, 1141196097L, -534658591L, -736704814L, 1010765619L, 1010634033L, -1945203070L, -1743222640L, 0x28280820L, 1276005954L, -197736718L, 1010699826L, -1541044831L, -130430479L, 202181889L, -601894957L, -669464368L, 673909539L, 0x64264662L, 2017086066L, 606537507L, 741281571L, -265174543L, 1882342002L, 0x40024242L, -736836400L, 0x40014141L, -1073692480L, 1882407795L, 1680295779L, -1406366560L, -2012509309L, -197670925L, -1406300767L, -2147450752L, 471797523L, -938816830L, 0x2C2C0C20L, -1473607006L, 0x34340430L, -804076846L, 134941443L, -332476702L, -399914527L, 1545424209L, -1810594672L, 0x18180810L, -130496272L, 1410811731L, -1406234974L, 0x8080800L, -1006254655L, 0x10130313L, -871510591L, -2079947134L, -1204188751L, -62926861L, 2084392305L, -1073626687L, 0x30310131L, -197802511L, -2012575102L, 1747602018L, -1338932815L, -804142639L, 0x20200020L, -736639021L, 131586L, 0x20220222L, 0x4040400L, 1747470432L, 1882276209L, 67569411L, -669266989L, -1675784815L, -1743156847L, 1612792161L, -1136750926L, -467220766L, 1478052177L, -602026543L, 1343308113L, -1877966704L, -602092336L, -1743091054L, -1608285277L, -1473541213L, -804208432L, -2147384959L, 202313475L, 1141327683L, 404359698L, -534527005L, -332608288L, -1945268863L, -1136685133L, -1810463086L, 2017151859L, 1545358416L, -1608351070L, -1608416863L, 1612923747L, 0x20230323L, 1275940161L, -938948416L, -1675719022L, -1675850608L, 943327794L, 0xC0C0C00L, 741215778L, -1204122958L, 1814974050L, -1675653229L, 1478117970L, -265108750L, -1877835118L, -265042957L, 1208568129L, 2016954480L, -871576384L, 336921873L, -130298893L, 1882210416L, 1949648241L, 2084523891L, 875889969L, 0x10100010L, 197379L, 1680098400L, 1814908257L, -1006188862L, 1949582448L, -736770607L, -1271626576L, -399848734L, 134809857L, 1949714034L, 404293905L, -62992654L, 0x40004040L, 0x10120212L, -534724384L, -1136816719L, 67437825L, -130364686L, 65793L, -265240336L, 673843746L, 1545490002L, -1473672799L, 1410745938L, 0x40034343L, -2080012927L, 0x14140410L, -2012640895L, -1743025261L, -1338998608L, -467286559L, 0x48084840L, 2017020273L, -1810397293L, -63124240L, 471731730L, -2147319166L, 0x20210121L, -1945334656L, 404425491L, 1545555795L, 0x74374773L, 1410614352L, -1338867022L, 471665937L, 606405921L, 1276071747L, 0L, 1141261890L, -332542495L, 1477986384L, 1343373906L, -399782941L, 2084458098L, -669332782L, -938882623L, -63058447L, 0x30300030L, -1810528879L, 1680164193L, 0x3C3C0C30L, -1271494990L, -467352352L, -1204057165L, 2084326512L, 202247682L, 1343242320L, 943262001L, 606471714L, 0x30320232L, -2080078720L, 1747536225L, -1877769325L, 876021555L, -467154973L, 0x24240420L, -1541110624L, -938751037L, 1343439699L, 134875650L, -2079881341L, -669398575L, 0x4C0C4C40L, -2147253373L, -1945137277L, -871444798L, 943393587L, 1208633922L, -1271429197L};
    static long[] SS2 = new long[]{-1582814839L, -2122054267L, -757852474L, -741338173L, 1347687492L, 287055117L, -1599329140L, 556016901L, 1364991309L, 0x43400343L, 0x10181808L, 303832590L, 1364201793L, -251904820L, -1027077430L, 1667244867L, 0x20282808L, 0x40440444L, 0x20202000L, -1852039795L, -522182464L, -488627518L, -1060632376L, 320083719L, -1583078011L, -2087972977L, 0x3000303L, 1937259339L, -1279771765L, 0x13101303L, -758115646L, -487838002L, 1886400576L, -2138305396L, 859586319L, -1599592312L, 0x32303202L, -774103603L, -218876218L, 1886663748L, -521392948L, -1852566139L, 50858763L, 1398019911L, 1348213836L, 1398283083L, -1313063539L, 0x1000101L, 0x20242404L, 0x101C1C0CL, 1936732995L, -1869080440L, 0x10101000L, -1060369204L, -219139390L, -774366775L, 0x202C2C0CL, -471586873L, 1919955522L, -2088762493L, -1818748021L, -774893119L, -2105276794L, -1043854903L, 1616912448L, 1347424320L, -1549786237L, -471323701L, 17566989L, -1296812410L, -1835262322L, 1129058127L, -1280034937L, 1381505610L, -1027340602L, 1886926920L, -1566300538L, 0x12101202L, -1548996721L, -774629947L, 1633689921L, -1010826301L, -1330367356L, 0x41400141L, 1380979266L, 1903967565L, -2121527923L, 526344L, 320610063L, -1852302967L, 0L, 286791945L, 263172L, 1397756739L, -202098745L, -505404991L, -235127347L, 1920218694L, 590098191L, 589571847L, -1330630528L, -2088236149L, 34344462L, -1549259893L, -1566563710L, 1651256910L, -1819274365L, 1095503181L, 1634216265L, 1887190092L, 17303817L, 34081290L, -1279508593L, -471060529L, -202361917L, -1044118075L, -2088499321L, 0x10141404L, -218349874L, 1617175620L, -757326130L, 573320718L, 1128794955L, 303569418L, 33818118L, 0x21202101L, 1667771211L, 0x62642646L, 0x2000202L, -235653691L, -1836051838L, -2105013622L, 789516L, -1280298109L, 1920745038L, -791670592L, 1920481866L, 1128531783L, -1835788666L, -505141819L, 572794374L, -2139094912L, -1582551667L, -740548657L, -1583341183L, 0x30303000L, 859059975L, -1565774194L, 842282502L, 286528773L, 0x22202202L, 0x30383808L, -252431164L, -1549523065L, 1094976837L, 0x404C0C4CL, -2122317439L, -504878647L, -2138831740L, -1819011193L, 825505029L, -1010299957L, -1026814258L, 0x303C3C0CL, 1903178049L, 0x11101101L, -1010563129L, -2121791095L, 1903441221L, -201835573L, -757589302L, -252167992L, -1869343612L, 1364728137L, -2105539966L, -1060895548L, -201572401L, 1095240009L, 825768201L, 1667508039L, -1061158720L, -1010036785L, -741075001L, -1330104184L, 51121935L, -2104750450L, 0x42400242L, 0x23202303L, -1852829311L, 1617701964L, -740811829L, -1599855484L, 0x30343404L, -235916863L, 0x40480848L, -1027603774L, 1668034383L, 826031373L, 556543245L, 0x40400040L, -1296286066L, 842808846L, -1329841012L, -1044381247L, -1566037366L, -1296549238L, 1112280654L, 0x51541545L, 859323147L, -790881076L, 1617438792L, 1937522511L, -1868817268L, -791144248L, 1112017482L, 1381242438L, 0x73743747L, -1600118656L, -504615475L, 1111754310L, -1313589883L, 589835019L, 1633953093L, -218613046L, -471850045L, -1313326711L, -1313853055L, -1818484849L, 1381768782L, -235390519L, -488364346L, -1297075582L, 0x31303101L, -488101174L, 1634479437L, 1398546255L, -521919292L, -252694336L, -1043591731L, -2138568568L, 303306246L, 842545674L, 1347950664L, -791407420L, 1650467394L, 556280073L, 50595591L, 0x33303303L, -521656120L, 320346891L, 17040645L, 1903704393L, -1869606784L, 1650993738L, 573057546L, -1835525494L};
    static long[] SS3 = new long[]{0x8303838L, -924784600L, 220277805L, -2036161498L, -809251825L, -825041890L, -2085375949L, -2001684424L, -1885098961L, 1080057888L, 0x45515415L, -943471609L, 0x44404404L, 1331915823L, 1264805931L, 1263753243L, -1010581501L, 1113743394L, 0x3333033L, -2051951563L, 153167913L, -2136956896L, -1025318878L, -2019318745L, -1009528813L, -2121166831L, 0x1111011L, 100795398L, 0xC101C1CL, -1934574532L, 103953462L, 1262700555L, -807146449L, -2004842488L, 1281387564L, -2002737112L, 118690839L, -993999868L, 101848086L, -990841804L, -1027424254L, 1161905157L, -1042161631L, -959261674L, 0xF333C3FL, 221330493L, -1904047090L, -2003789800L, 0x8202828L, 1312967694L, -957156298L, 238173246L, -2053004251L, -906889159L, 218172429L, -808199137L, -925837288L, 186853419L, 0x46626426L, 1249015866L, 119743527L, 253963311L, -1041108943L, 1114796082L, 0x42424002L, -992947180L, 0x41414001L, -1061109760L, 1131638835L, 1197696039L, -1935627220L, -1954314229L, -940313545L, -1918784467L, -2139062272L, 252910623L, -893204470L, 0xC202C2CL, -1969051606L, 0x4303434L, -1026371566L, 184748043L, -823989202L, -907941847L, 1297177629L, -2070899692L, 0x8101818L, -923731912L, 1196643351L, -1901941714L, 0x8000808L, -977157115L, 0x3131013L, -842937331L, -2038266874L, -1984841671L, -806093761L, 1299283005L, -1044267007L, 0x1313031L, -973999051L, -1971156982L, 1247963178L, -2119061455L, -1043214319L, 0x202020L, -942418921L, 0x2020002L, 0x2222022L, 0x4000404L, 1214277672L, 1097953329L, 117638151L, -875309029L, -1919837155L, -1986947047L, 1096900641L, -1900889026L, -958208986L, 1230067737L, -841884643L, 1095847953L, -2138009584L, -858727396L, -1970104294L, -2086428637L, -1952208853L, -1060057072L, -2122219519L, 251857935L, 1195590663L, 168957978L, -1008476125L, -857674708L, -1920889843L, -1884046273L, -2037214186L, 1265858619L, 1280334876L, -2103271390L, -2120114143L, 1130586147L, 0x3232023L, 1296124941L, -926889976L, -1902994402L, -1936679908L, 171063354L, 0xC000C0CL, 0xE222C2EL, -1967998918L, 1315073070L, -1886151649L, 1246910490L, -1024266190L, -2104324078L, -1007423437L, 1229015049L, 1215330360L, -859780084L, 0x5111415L, -873203653L, 1081110576L, 1165063221L, 1332968511L, 87110709L, 0x101010L, 0x3030003L, 1147167780L, 1298230317L, -960314362L, 1148220468L, -976104427L, -2068794316L, -891099094L, 151062537L, 1181905974L, 0x9111819L, -822936514L, 0x40404000L, 0x2121012L, -1059004384L, -1917731779L, 83952645L, -890046406L, 0x1010001L, -1057951696L, 0xA22282AL, 1314020382L, -1985894359L, 1179800598L, 0x43434003L, -2055109627L, 0x4101414L, -1987999735L, -1953261541L, -2135904208L, -975051739L, 0x48404808L, 1232173113L, -2020371433L, -856622020L, 236067870L, -2105376766L, 0x1212021L, -1937732596L, 185800731L, 1330863135L, 0x47737437L, 1146115092L, -2102218702L, 0xD111C1DL, 86058021L, 1329810447L, 0L, 1178747910L, -840831955L, 1213224984L, 1112690706L, -874256341L, 1316125758L, -892151782L, -910047223L, -839779267L, 0x303030L, -2054056939L, 1164010533L, 0xC303C3CL, -2035108810L, -991894492L, -1951156165L, 1282440252L, 235015182L, 1079005200L, 154220601L, 0x6222426L, 0x2323032L, -2071952380L, 1231120425L, -2087481325L, 0x7333437L, -941366233L, 0x4202424L, -2069847004L, -876361717L, 1129533459L, 167905290L, -2021424121L, -908994535L, 0x4C404C0CL, -2088534013L, -1887204337L, -826094578L, 0xB33383BL, 1245857802L, -2018266057L};
    static long[] KC = new long[]{-1640531527L, 1013904243L, 2027808486L, -239350324L, -478700647L, -957401293L, -1914802585L, 465362127L, 930724254L, 1861448508L, -572070280L, -1144140559L, 2006686179L, -281594938L, -563189875L, -1126379749L};
    long[] RoundKey = new long[32];

    public SeedAlg(byte[] key) {
        this.seedEncRoundKey(key);
    }

    public byte[] encrypt(byte[] plainData) {
        int nLoopCnt = plainData.length / 16 + (plainData.length % 16 == 0 ? 0 : 1);
        byte[] retArray = new byte[nLoopCnt * 16];
        for (int i = 0; i < nLoopCnt; ++i) {
            int j;
            long[] nTemp = new long[4];
            for (j = 0; j < 4; ++j) {
                nTemp[j] = this.makeLong(plainData, i * 16 + j * 4);
            }
            nTemp = this.encrypt16(nTemp);
            for (j = 0; j < 16; ++j) {
                retArray[i * 16 + j] = this.getAByteLong(nTemp[j / 4], 3 - j % 4);
            }
        }
        return retArray;
    }

    private long[] encrypt16(long[] plainData) {
        boolean bSwapFlag = false;
        for (int i = 0; i < 16; ++i) {
            plainData = this.SeedRound(plainData, i, bSwapFlag);
            bSwapFlag = !bSwapFlag;
        }
        return new long[]{plainData[2], plainData[3], plainData[0], plainData[1]};
    }

    public byte[] decrypt(byte[] cipherData) {
        int nLoopCnt = cipherData.length / 16 + (cipherData.length % 16 == 0 ? 0 : 1);
        byte[] retArray = new byte[nLoopCnt * 16];
        for (int i = 0; i < nLoopCnt; ++i) {
            int j;
            long[] nTemp = new long[4];
            for (j = 0; j < 4; ++j) {
                nTemp[j] = this.makeLong(cipherData, i * 16 + j * 4);
            }
            nTemp = this.decrypt16(nTemp);
            for (j = 0; j < 16; ++j) {
                retArray[i * 16 + j] = this.getAByteLong(nTemp[j / 4], 3 - j % 4);
            }
        }
        return retArray;
    }

    private void seedEncRoundKey(byte[] pbUserKey) {
        long[] keyData = new long[]{this.makeLong(pbUserKey, 0), this.makeLong(pbUserKey, 4), this.makeLong(pbUserKey, 8), this.makeLong(pbUserKey, 12)};
        long T0 = keyData[0] + keyData[2] - KC[0];
        long T1 = keyData[1] - keyData[3] + KC[0];
        this.RoundKey[0] = SS0[(int)this.getAByteToLong(T0, 0)] ^ SS1[(int)this.getAByteToLong(T0, 1)] ^ SS2[(int)this.getAByteToLong(T0, 2)] ^ SS3[(int)this.getAByteToLong(T0, 3)];
        this.RoundKey[1] = SS0[(int)this.getAByteToLong(T1, 0)] ^ SS1[(int)this.getAByteToLong(T1, 1)] ^ SS2[(int)this.getAByteToLong(T1, 2)] ^ SS3[(int)this.getAByteToLong(T1, 3)];
        for (int i = 0; i < 7; ++i) {
            keyData = this.encRoundKeyUpdate0(keyData, i * 2 + 1);
            keyData = this.encRoundKeyUpdate1(keyData, i * 2 + 2);
        }
        this.encRoundKeyUpdate0(keyData, 15);
    }

    private long[] decrypt16(long[] cipherData) {
        boolean bSwapFlag = false;
        for (int i = 15; i >= 0; --i) {
            cipherData = this.SeedRound(cipherData, i, bSwapFlag);
            bSwapFlag = !bSwapFlag;
        }
        return new long[]{cipherData[2], cipherData[3], cipherData[0], cipherData[1]};
    }

    private long[] encRoundKeyUpdate0(long[] keyData, int roundCnt) {
        long T0 = keyData[0];
        keyData[0] = keyData[0] >> 8 & 0xFFFFFFFFL ^ keyData[1] << 24 & 0xFFFFFFFFL;
        keyData[1] = keyData[1] >> 8 & 0xFFFFFFFFL ^ T0 << 24 & 0xFFFFFFFFL;
        T0 = keyData[0] + keyData[2] - KC[roundCnt] & 0xFFFFFFFFL;
        long T1 = keyData[1] + KC[roundCnt] - keyData[3] & 0xFFFFFFFFL;
        this.RoundKey[roundCnt * 2] = SS0[(int)this.getAByteToLong(T0, 0)] ^ SS1[(int)this.getAByteToLong(T0, 1)] ^ SS2[(int)this.getAByteToLong(T0, 2)] ^ SS3[(int)this.getAByteToLong(T0, 3)];
        this.RoundKey[roundCnt * 2 + 1] = SS0[(int)this.getAByteToLong(T1, 0)] ^ SS1[(int)this.getAByteToLong(T1, 1)] ^ SS2[(int)this.getAByteToLong(T1, 2)] ^ SS3[(int)this.getAByteToLong(T1, 3)];
        return keyData;
    }

    private long[] encRoundKeyUpdate1(long[] keyData, int roundCnt) {
        long T0 = keyData[2];
        keyData[2] = (keyData[2] << 8 ^ keyData[3] >> 24) & 0xFFFFFFFFL;
        keyData[3] = (keyData[3] << 8 ^ T0 >> 24) & 0xFFFFFFFFL;
        T0 = keyData[0] + keyData[2] - KC[roundCnt] & 0xFFFFFFFFL;
        long T1 = keyData[1] + KC[roundCnt] - keyData[3] & 0xFFFFFFFFL;
        this.RoundKey[roundCnt * 2] = SS0[(int)this.getAByteToLong(T0, 0)] ^ SS1[(int)this.getAByteToLong(T0, 1)] ^ SS2[(int)this.getAByteToLong(T0, 2)] ^ SS3[(int)this.getAByteToLong(T0, 3)];
        this.RoundKey[roundCnt * 2 + 1] = SS0[(int)this.getAByteToLong(T1, 0)] ^ SS1[(int)this.getAByteToLong(T1, 1)] ^ SS2[(int)this.getAByteToLong(T1, 2)] ^ SS3[(int)this.getAByteToLong(T1, 3)];
        return keyData;
    }

    private byte getAByteLong(long src, int index) {
        return (byte)(src >>> index * 8 & 0xFFL);
    }

    private long getAByteToLong(long src, int index) {
        return src >> index * 8 & 0xFFL;
    }

    private long makeLong(byte[] byteArray, int nStartIndex) {
        long b1 = byteArray.length <= nStartIndex ? 0L : (0xFFL & (long)byteArray[nStartIndex + 0]) << 24;
        long b2 = byteArray.length <= nStartIndex + 1 ? 0L : (0xFFL & (long)byteArray[nStartIndex + 1]) << 16;
        long b3 = byteArray.length <= nStartIndex + 2 ? 0L : (0xFFL & (long)byteArray[nStartIndex + 2]) << 8;
        long b4 = byteArray.length <= nStartIndex + 3 ? 0L : 0xFFL & (long)byteArray[nStartIndex + 3];
        return b1 + b2 + b3 + b4;
    }

    private long[] SeedRound(long[] data, int roundIndex, boolean swapFlag) {
        long[] lArray;
        long R1;
        long R0;
        long L1;
        long L0;
        if (!swapFlag) {
            L0 = data[0];
            L1 = data[1];
            R0 = data[2];
            R1 = data[3];
        } else {
            R0 = data[0];
            R1 = data[1];
            L0 = data[2];
            L1 = data[3];
        }
        long T0 = R0 ^ this.RoundKey[roundIndex * 2];
        long T1 = R1 ^ this.RoundKey[roundIndex * 2 + 1];
        T1 ^= T0;
        T1 = SS0[(int)this.getAByteToLong(T1, 0)] ^ SS1[(int)this.getAByteToLong(T1, 1)] ^ SS2[(int)this.getAByteToLong(T1, 2)] ^ SS3[(int)this.getAByteToLong(T1, 3)];
        T0 += T1;
        T0 = SS0[(int)this.getAByteToLong(T0, 0)] ^ SS1[(int)this.getAByteToLong(T0, 1)] ^ SS2[(int)this.getAByteToLong(T0, 2)] ^ SS3[(int)this.getAByteToLong(T0, 3)];
        T1 += T0;
        T1 = SS0[(int)this.getAByteToLong(T1, 0)] ^ SS1[(int)this.getAByteToLong(T1, 1)] ^ SS2[(int)this.getAByteToLong(T1, 2)] ^ SS3[(int)this.getAByteToLong(T1, 3)];
        L0 ^= (T0 += T1);
        L1 ^= T1;
        if (swapFlag) {
            long[] lArray2 = new long[4];
            lArray2[0] = R0;
            lArray2[1] = R1;
            lArray2[2] = L0;
            lArray = lArray2;
            lArray2[3] = L1;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = L0;
            lArray3[1] = L1;
            lArray3[2] = R0;
            lArray = lArray3;
            lArray3[3] = R1;
        }
        return lArray;
    }
}

