/*
 * Decompiled with CFR 0.152.
 */
package ceres.cminterface;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.util.Log;
import ceres.api.AECParam;
import ceres.api.SipManager;
import ceres.cminterface.CMAccStatus;
import ceres.cminterface.CMCallInfo;
import ceres.cminterface.DupCallInfo;
import ceres.cminterface.NPMetrics;
import ceres.pcminterface.PCMInterface;
import ceres.security.Base64Utils;
import ceres.srinterface.SRInterface;
import ceres.utils.IpAddress;
import ceres.utils.Threading;
import ceres.utils.printlog;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class CMInterface {
    private static final String THIS_FILE = "CMInterface";
    private static final String FILTER_STR = "codecs_test";
    private static Base64Utils base64;
    private static String m_PhoneNumber;
    private static String m_OneNumber;
    private static String m_Address;
    private static String m_Password;
    private static String m_AuthId;
    private static String m_ProxyAddr;
    private static String m_ProxyPort;
    private static String m_RegAddr;
    private static String m_RegPort;
    private static String m_LocalPort;
    private static String m_LocalMediaPort;
    private static String m_RemoteMediaPort;
    private static String m_RegAddr2;
    private static String m_RegPort2;
    private static String m_RegAddr3;
    private static String m_RegPort3;
    private static String m_RegAddr4;
    private static String m_RegPort4;
    private static String m_SVRName;
    private static String m_SVRName2;
    private static String m_SVRName3;
    private static String m_SVRName4;
    private static String m_Provider;
    private static String m_ACodecPri;
    private static String m_ReRegTime;
    private static String m_SessionTime;
    private static String m_SessionExpireTime;
    private static String m_TransactionTime;
    private static String m_DTMFType;
    private static String m_URLType;
    private static String m_PTime;
    private static String m_VCodecPri;
    private static String m_SRTPOption;
    private static String m_SDCOnOff;
    private static String m_VideoOnOff;
    private static String m_VideoSize;
    private static String m_VCodecFrameRate;
    private static String m_VCodecBandwidth;
    private static String m_VCodec_MAXBR;
    private static String m_H264_Pmode;
    private static String m_MPEG4VES_Pli;
    private static String m_AECOnOff;
    private static String m_OneNumberOnOff;
    private static String m_SpamOnOff;
    private static String m_RedirectOption;
    private static String m_HWSamplingRate;
    private static String m_AudioMode;
    private static String m_JBMinMax;
    private static String m_DeviceIP;
    private static String m_TelEventPT;
    private static String m_VideoMAXSize;
    private static String m_MAXCall;
    private static String m_URLRule;
    private static String m_SRTP_SKey;
    private static String m_Log_LV_SIP;
    private static String m_Log_LV_RTP;
    private static String m_Log_LV_CM;
    private static String m_Log_LV_MCM;
    private static String m_Log_LV_MMM;
    private static String m_Log_LV_UI;
    private static String m_VADOnOff;
    private static String m_NSOnOff;
    private static String m_CNGOnOff;
    private static String m_AECMemo;
    private static String m_AECDelay;
    private static String m_AECTimeSpan;
    private static String m_AECERL;
    private static String m_AECDynVol;
    private static String m_AECDynVolMin;
    private static String m_AECUpdateSpeed;
    private static String m_AECWMaxIndex;
    private static String m_AECWScale;
    public static Context mContext;
    private static AudioManager audioManager;
    protected static PCMInterface mPCMIF;
    protected static SRInterface mSRIF;
    protected CMCallInfo dupCallInfo = null;
    protected AECParam aecparam = null;
    private static final int CERES_DEINIT_STATE = 0;
    private static int ceres_init_state;
    private static int register_state;
    private WifiManager wifiManager = null;
    private ConnectivityManager connManager = null;
    private static int regi_callback_cnt;
    private static int network_change_cnt;
    BroadcastReceiver mBRWifi = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            printlog.d(CMInterface.THIS_FILE, "wifichangeReceiver test...");
            network_change_cnt++;
            if (network_change_cnt >= 2) {
                if (action.equals("android.net.wifi.STATE_CHANGE")) {
                    printlog.i(CMInterface.THIS_FILE, "NETWORK_STATE_CHANGED_ACTION");
                    this.onWifiChanged(intent);
                }
                if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                    printlog.i(CMInterface.THIS_FILE, "CONNECTIVITY_ACTION");
                    this.onConnChanged(intent);
                }
            }
        }

        public void onWifiChanged(Intent intent) {
            NetworkInfo networkInfo_wifi = CMInterface.this.connManager.getNetworkInfo(1);
            if (networkInfo_wifi != null && networkInfo_wifi.isAvailable()) {
                if (networkInfo_wifi.getState() == NetworkInfo.State.CONNECTED) {
                    printlog.w(CMInterface.THIS_FILE, "wifi_NETWORK_STATE_CONNECTED");
                    String localIpAddress2 = IpAddress.deviceIP_get();
                    printlog.w(CMInterface.THIS_FILE, "wifi_STATE_ENABLED : localIpAddress2 : " + localIpAddress2);
                    CMInterface.this.dispatchCallStateCBEvent(0);
                    CMInterface.this.CERES_ModifyConfiguration();
                } else if (networkInfo_wifi.getState() == NetworkInfo.State.CONNECTING) {
                    printlog.w(CMInterface.THIS_FILE, "wifi_NETWORK_STATE_CONNECTING");
                } else if (networkInfo_wifi.getState() == NetworkInfo.State.DISCONNECTED) {
                    printlog.w(CMInterface.THIS_FILE, "wifi_NETWORK_STATE_DISCONNECTED");
                } else if (networkInfo_wifi.getState() == NetworkInfo.State.DISCONNECTING) {
                    printlog.w(CMInterface.THIS_FILE, "wifi_NETWORK_STATE_DISCONNECTING");
                } else if (networkInfo_wifi.getState() == NetworkInfo.State.SUSPENDED) {
                    printlog.w(CMInterface.THIS_FILE, "wifi_NETWORK_STATE_SUSPENDED");
                } else if (networkInfo_wifi.getState() == NetworkInfo.State.UNKNOWN) {
                    printlog.w(CMInterface.THIS_FILE, "wifi_NETWORK_STATE_UNKNOWN");
                }
            }
        }

        public void onConnChanged(Intent intent) {
            NetworkInfo networkInfo_3g = CMInterface.this.connManager.getNetworkInfo(0);
            NetworkInfo networkInfo_wifi = CMInterface.this.connManager.getNetworkInfo(1);
            if (networkInfo_3g != null && networkInfo_3g.isConnected() && !networkInfo_wifi.isConnected()) {
                printlog.w(CMInterface.THIS_FILE, "wifi_3gNETWORK_STATE_CONNECTED : " + networkInfo_3g.getExtraInfo());
                String localIpAddress = IpAddress.deviceIP_get();
                printlog.w(CMInterface.THIS_FILE, "wifi_STATE_ENABLED : localIpAddress : " + localIpAddress + " subtype :" + networkInfo_3g.getType());
                CMInterface.this.dispatchCallStateCBEvent(0);
                CMInterface.this.CERES_ModifyConfiguration();
            } else if (networkInfo_3g != null && !networkInfo_3g.isConnected() && !networkInfo_wifi.isConnected()) {
                CMInterface.this.dispatchCallStateCBEvent(0);
            }
        }
    };
    private static Handler handler;
    private static int mic_volume_level;
    private static int spk_volume_level;
    public static OnCallbackListener onCallStateCBListener;
    public static OnCallbackListener onMediaUpdateCBListener;
    public static OnMonitorListener onCheckCBListener;
    public static OnLoopbackListener onLoopbackCBListener;
    public static OnTapsStatusListener onTapsStatusEvent;
    public static int m_callIdx;
    private static boolean isFirstRun;
    private static int mDigital_SpkVolume;
    private static int mDigital_MicVolume;
    private static int mInitDigital_SpkVolume;
    private static int mInitDigital_MicVolume;
    private static WorkerHandler msgHandler;
    private static PowerManager.WakeLock incomingCallLock;
    private static PowerManager.WakeLock eventLock;
    private HandlerThread handlerThread;
    public static final int ON_CALL_STATE = 0;
    public static final int ON_REGISTRATION_STATE = 1;
    public static final int ON_MEDIA_VIDEO = 2;
    public static final int ON_MEDIA_UPDATE = 3;
    public static final int ON_MEDIA_LOOPBACK_CONNECT = 4;
    public static final int ON_MEDIA_LOOPBACK_DISCONNECT = 5;
    public static final int ON_TAPS_REPORT_STATE = 6;
    public static final int STATE_INPUT_PHONENUM = 0;
    public static final int STATE_OUT_GOING = 1;
    public static final int STATE_IN_COMMING = 2;
    public static final int STATE_ON_CALL = 3;
    public static final int STATE_ON_IDLE = 4;
    public static final int STATE_ERROR = 5;

    native int CMIF_Initialize();

    native int CMIF_TAPS_Init();

    native int CMIF_Close();

    native int CMIF_Register();

    native int CMIF_UnRegister();

    native int CMIF_MakeCall(byte[] var1, int var2);

    native int CMIF_AcceptCall(int var1, int var2);

    native int CMIF_ReleaseCall(int var1);

    native int CMIF_CancelCall(int var1);

    native int CMIF_RejectCall(int var1);

    native int CMIF_SendDtmf(int var1, byte[] var2);

    native int CMIF_HoldCall(int var1);

    native int CMIF_UnHoldCall(int var1);

    native int CMIF_SetHeadSetState(int var1);

    native int CMIF_SetBuildDevice(int var1);

    native int CMIF_SetBuildVersion(int var1);

    native int CMIF_SetLocalIPAddress(byte[] var1);

    native int CMIF_IsVideoCall(int var1);

    static native int CMIF_SetDigitalVolume(int var0, int var1, int var2);

    native int CMIF_GetDefaultDigitalVolume(int var1);

    public static final native int get_account_status(int var0, long var1, CMAccStatus var3);

    public static final native long call_dump__SWIG_1(int var0, int var1, String var2);

    public static final native String char_return_TEST(int var0, int var1, String var2);

    native String CMIF_GetVersion(int var1);

    public void CERES_PhoneNumber_set(String phoneNumber) {
        m_PhoneNumber = phoneNumber;
    }

    public String CERES_PhoneNumber_get() {
        return m_PhoneNumber;
    }

    public void CERES_OneNumber_set(String oneNumber) {
        m_OneNumber = oneNumber;
    }

    public String CERES_OneNumber_get() {
        return m_OneNumber;
    }

    public void CERES_Address_set(String address) {
        m_Address = address;
    }

    public String CERES_Address_get() {
        return m_Address;
    }

    public void CERES_Password_set(String password) {
        m_Password = password;
    }

    public String CERES_Password_get() {
        return m_Password;
    }

    public void CERES_AuthId_set(String authId) {
        m_AuthId = authId;
    }

    public String CERES_AuthId_get() {
        return m_AuthId;
    }

    public void CERES_ProxyAddr_set(String proxyAddr) {
        m_ProxyAddr = proxyAddr;
    }

    public String CERES_ProxyAddr_get() {
        return m_ProxyAddr;
    }

    public void CERES_ProxyPort_set(String proxyPort) {
        m_ProxyPort = proxyPort;
    }

    public String CERES_ProxyPort_get() {
        return m_ProxyPort;
    }

    public void CERES_RegAddr_set(String regAddr) {
        m_RegAddr = regAddr;
    }

    public String CERES_RegAddr_get() {
        return m_RegAddr;
    }

    public void CERES_RegPort_set(String regPort) {
        m_RegPort = regPort;
    }

    public String CERES_RegPort_get() {
        return m_RegPort;
    }

    public void CERES_LocalPort_set(String localport) {
        m_LocalPort = localport;
    }

    public String CERES_LocalPort_get() {
        return m_ProxyPort;
    }

    public void CERES_LocalMediaPort_set(String localMediaPort) {
        m_LocalMediaPort = localMediaPort;
    }

    public String CERES_LocalMediaPort_get() {
        return m_LocalMediaPort;
    }

    public void CERES_RemoteMediaPort_set(String remoteMediaPort) {
        m_RemoteMediaPort = remoteMediaPort;
    }

    public String CERES_RemoteMediaPort_get() {
        return m_RemoteMediaPort;
    }

    public void CERES_Provider_set(String provider) {
        m_Provider = provider;
    }

    public String CERES_Provider_get() {
        return m_Provider;
    }

    public void CERES_AudioCodecPrio_set(String audioCodecPrio) {
        m_ACodecPri = audioCodecPrio;
    }

    public String CERES_AudioCodecPrio_get() {
        return m_ACodecPri;
    }

    public int CMI_Loopback_AudioCodecInt_get() {
        String str = "";
        if (m_ACodecPri.length() <= 0) {
            printlog.w(THIS_FILE, "m_ACodecPri.length() : " + m_ACodecPri.length());
            m_ACodecPri = "a1a2a3a2a4a6a5a7a8a9";
            printlog.w(THIS_FILE, "m_ACodecPri : " + m_ACodecPri);
        }
        StringTokenizer st1 = new StringTokenizer(m_ACodecPri, "a");
        str = st1.nextToken();
        return Integer.parseInt(str);
    }

    public int CMI_Loopback_VideoCodecInt_get() {
        String str = "";
        if (m_VCodecPri.length() <= 0) {
            printlog.w(THIS_FILE, "m_VCodecPri.length() : " + m_VCodecPri.length());
            m_VCodecPri = "a128a130a131a129";
            printlog.w(THIS_FILE, "m_VCodecPri : " + m_VCodecPri);
        }
        StringTokenizer st1 = new StringTokenizer(m_VCodecPri, "a");
        str = st1.nextToken();
        return Integer.parseInt(str);
    }

    public void CERES_ReRegTime_set(String reRegTime) {
        m_ReRegTime = reRegTime;
    }

    public String CERES_ReRegTime_get() {
        return m_ReRegTime;
    }

    public void CERES_SessionTime_set(String sessionTime) {
        m_SessionTime = sessionTime;
    }

    public String CERES_SessionTime_get() {
        return m_SessionTime;
    }

    public void CERES_SessionExpireTime_set(String sessionExpireTime) {
        m_SessionExpireTime = sessionExpireTime;
    }

    public String CERES_SessionExpireTime_get() {
        return m_SessionExpireTime;
    }

    public void CERES_TransactionTime_set(String transactionTime) {
        m_TransactionTime = transactionTime;
    }

    public String CERES_TransactionTime_get() {
        return m_TransactionTime;
    }

    public void CERES_DTMFType_set(String dtmfType) {
        m_DTMFType = dtmfType;
    }

    public String CERES_DTMFType_get() {
        return m_DTMFType;
    }

    public void CERES_URLType_set(String urlType) {
        m_URLType = urlType;
    }

    public String CERES_URLType_get() {
        return m_URLType;
    }

    public void CERES_PTime_set(String pTime) {
        m_PTime = pTime;
    }

    public String CERES_PTime_get() {
        if (m_PTime.length() <= 0) {
            m_PTime = "20";
        }
        return m_PTime;
    }

    public void CERES_AECState_set(String aecState) {
        m_AECOnOff = aecState;
    }

    public String CERES_AECState_get() {
        return m_AECOnOff;
    }

    public void CERES_JBMinMax_set(String jbMinMax) {
        m_JBMinMax = jbMinMax;
    }

    public String CERES_JBMinMax_get() {
        return m_JBMinMax;
    }

    public void CERES_VADState_set(String vadState) {
        m_VADOnOff = vadState;
    }

    public String CERES_VADState_get() {
        return m_VADOnOff;
    }

    public void CERES_NSState_set(String nsState) {
        m_NSOnOff = nsState;
    }

    public String CERES_NSState_get() {
        return m_NSOnOff;
    }

    public void CERES_CNGState_set(String cngState) {
        m_CNGOnOff = cngState;
    }

    public String CERES_CNGState_get() {
        return m_CNGOnOff;
    }

    public void CERES_SDCState_set(String vadState) {
        m_SDCOnOff = vadState;
    }

    public String CERES_SDCState_get() {
        return m_SDCOnOff;
    }

    public void CERES_VideoSize_set(String videoSize) {
        m_VideoSize = videoSize;
    }

    public String CERES_VideoSize_get() {
        return m_VideoSize;
    }

    public void CERES_VCodec_FrameRate_set(String frameRate) {
        m_VCodecFrameRate = frameRate;
    }

    public String CERES_VCodec_FrameRate_get() {
        return m_VCodecFrameRate;
    }

    public void CERES_VCodec_Bandwidth_set(String bandwidth) {
        m_VCodecBandwidth = bandwidth;
    }

    public String CERES_VCodec_Bandwidth_get() {
        return m_VCodecBandwidth;
    }

    public void CERES_VCodec_MAXBR_set(String maxBR) {
        m_VCodec_MAXBR = maxBR;
    }

    public String CERES_VCodec_MAXBR_get() {
        return m_VCodec_MAXBR;
    }

    public void CERES_H264_Pmode_set(String h264Pmode) {
        m_H264_Pmode = h264Pmode;
    }

    public String CERES_H264_Pmode_get() {
        return m_H264_Pmode;
    }

    public void CERES_MPEG4VES_Pli_set(String mpeg4vesPli) {
        m_MPEG4VES_Pli = mpeg4vesPli;
    }

    public String CERES_MPEG4VES_Pli_get() {
        return m_MPEG4VES_Pli;
    }

    public void CERES_VideoState_set(String videoState) {
        m_VideoOnOff = videoState;
    }

    public String CERES_VideoState_get() {
        return m_VideoOnOff;
    }

    public void CERES_OneNumberState_set(String oneNumberState) {
        m_OneNumberOnOff = oneNumberState;
    }

    public String CERES_OneNumberState_get() {
        return m_OneNumberOnOff;
    }

    public void CERES_SpamState_set(String spamState) {
        m_SpamOnOff = spamState;
    }

    public String CERES_SpamState_get() {
        return m_SpamOnOff;
    }

    public void CERES_RedirectState_set(String redirectState) {
        m_RedirectOption = redirectState;
    }

    public String CERES_RedirectState_get() {
        return m_RedirectOption;
    }

    public void CERES_SamplingRate_set(String samplingRate) {
        m_HWSamplingRate = samplingRate;
    }

    public String CERES_SamplingRate_get() {
        return m_HWSamplingRate;
    }

    public void CERES_AudioMode_set(String audioMode) {
        m_AudioMode = audioMode;
    }

    public String CERES_AudioMode_get() {
        return m_AudioMode;
    }

    public void CERES_SIPLogLevel_set(String logLevel) {
        m_Log_LV_SIP = logLevel;
    }

    public String CERES_SIPLogLevel_get() {
        return m_Log_LV_SIP;
    }

    public void CERES_RTPLogLevel_set(String logLevel) {
        m_Log_LV_RTP = logLevel;
    }

    public String CERES_RTPLogLevel_get() {
        return m_Log_LV_RTP;
    }

    public void CERES_CallManagerLogLevel_set(String logLevel) {
        m_Log_LV_CM = logLevel;
    }

    public String CERES_CallManagerLogLevel_get() {
        return m_Log_LV_CM;
    }

    public void CERES_MCallManagerLogLevel_set(String logLevel) {
        m_Log_LV_MCM = logLevel;
    }

    public String CERES_MCallManagerLogLevel_get() {
        return m_Log_LV_MCM;
    }

    public void CERES_MMediaManagerLogLevel_set(String logLevel) {
        m_Log_LV_MMM = logLevel;
    }

    public String CERES_MMediaManagerLogLevel_get() {
        return m_Log_LV_MMM;
    }

    public void CERES_UILogLevel_set(String logLevel) {
        m_Log_LV_UI = logLevel;
    }

    public String CERES_UILogLevel_get() {
        return m_Log_LV_UI;
    }

    public void CERES_VideoCodecPrio_set(String videoCodecPrio) {
        m_VCodecPri = videoCodecPrio;
    }

    public String CERES_VideoCodecPrio_get() {
        return m_VCodecPri;
    }

    public void CERES_SRTPState_set(String srtpState) {
        m_SRTPOption = srtpState;
    }

    public String CERES_SRTPState_get() {
        return m_SRTPOption;
    }

    private static void lockCpu() {
        if (eventLock != null) {
            eventLock.acquire();
        }
    }

    private static void unlockCpu() {
        if (eventLock != null && eventLock.isHeld()) {
            eventLock.release();
        }
    }

    public CMInterface() {
        printlog.d(THIS_FILE, "CMInterface....");
    }

    public static int CERES_InitState_get() {
        Log.v((String)"yjyoon", (String)"CERES_InitState_get()");
        printlog.i(THIS_FILE, "CERES_InitState_get : " + ceres_init_state);
        return ceres_init_state;
    }

    private static void CERES_InitState_set(int state) {
        Log.v((String)"yjyoon", (String)"CERES_InitState_set()");
        printlog.i(THIS_FILE, "CERES_InitState_set : " + state);
        ceres_init_state = state;
    }

    public int CERES_RegiState_get() {
        return register_state;
    }

    private static int CERES_RegiState_set(int state) {
        register_state = state;
        return register_state;
    }

    private void initService(Context context) {
        if (this.handlerThread == null) {
            printlog.i(THIS_FILE, "initService handlerThread Start");
            this.handlerThread = new HandlerThread("UAStateAsyncWorker");
            this.handlerThread.start();
        }
        if (msgHandler == null) {
            printlog.i(THIS_FILE, "initService new WorkerHandler");
            msgHandler = new WorkerHandler(this.handlerThread.getLooper());
        }
    }

    private void deInitService() {
        printlog.d(THIS_FILE, "deInitService");
        if (this.handlerThread != null) {
            Threading.stopHandlerThread(this.handlerThread);
        }
        this.handlerThread = null;
        msgHandler = null;
        if (eventLock != null) {
            while (eventLock.isHeld()) {
                eventLock.release();
            }
        }
    }

    public void CERES_ModifyConfiguration() {
        this.CMIF_Close();
        this.CMIF_Initialize();
        this.CERES_Register();
    }

    public int CERES_TAPS_Init(Context context) {
        int iRet = 1;
        System.loadLibrary("aCERES");
        Log.v((String)"yjyoon", (String)"CERES_TAP_INIT loadLibrary.");
        this.CMIF_TAPS_Init();
        return iRet;
    }

    public void CERES_Initialize(Context context) {
        System.loadLibrary("aCERES");
        Log.v((String)"yjyoon", (String)"CERES_Initialize loadLibrary.");
        network_change_cnt = 0;
        printlog.v(THIS_FILE, "mContext : " + mContext);
        m_DeviceIP = IpAddress.deviceIP_get();
        if (this.dupCallInfo == null) {
            this.dupCallInfo = new CMCallInfo();
        }
        if (mContext == null) {
            mContext = context;
        }
        if (mPCMIF == null) {
            mPCMIF = new PCMInterface(mContext);
        }
        if (mSRIF == null) {
            mSRIF = new SRInterface(mContext);
        }
        audioManager = (AudioManager)mContext.getSystemService("audio");
        this.CMIF_Initialize();
        this.initService(mContext);
        CMInterface.CERES_InitState_set(1);
        if (SipManager.DEVICE_NAME.equalsIgnoreCase("M110")) {
            printlog.d(THIS_FILE, "CERES_INIT : S");
            CMInterface.AudioInCall_set(3);
        }
        this.wifiManager = (WifiManager)mContext.getSystemService("wifi");
        this.connManager = (ConnectivityManager)mContext.getSystemService("connectivity");
        IntentFilter i = new IntentFilter();
        i.addAction("android.net.wifi.STATE_CHANGE");
        i.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        mContext.registerReceiver(this.mBRWifi, i);
    }

    public SRInterface SRInterface_get() {
        return mSRIF;
    }

    public int CERES_Close() {
        this.deInitService();
        if (SipManager.DEVICE_NAME.equalsIgnoreCase("M110")) {
            printlog.d(THIS_FILE, "build_device : " + SipManager.DEVICE_NAME);
            CMInterface.AudioInCall_set(0);
        }
        CMInterface.CERES_InitState_set(0);
        if (this.dupCallInfo != null) {
            this.dupCallInfo = null;
        }
        if (this.mBRWifi != null) {
            try {
                printlog.d(THIS_FILE, " service debug Unregister telephony receiver");
                if (mContext != null) {
                    mContext.unregisterReceiver(this.mBRWifi);
                }
                this.mBRWifi = null;
            }
            catch (IllegalArgumentException e) {
                printlog.e(THIS_FILE, " service debug Has not to unregister telephony receiver");
            }
        }
        mPCMIF = null;
        if (mContext != null) {
            mContext = null;
        }
        return this.CMIF_Close();
    }

    public static void AECParams_set(AECParam aecparam) {
        printlog.i(THIS_FILE, "   -------------------------------------------------------- ");
        printlog.i(THIS_FILE, "   id                    : " + aecparam._id);
        printlog.i(THIS_FILE, "   memo                  : " + aecparam.memo);
        printlog.i(THIS_FILE, "   delay                 : " + aecparam.delay);
        printlog.i(THIS_FILE, "   time_span             : " + aecparam.time_span);
        printlog.i(THIS_FILE, "   erl                   : " + aecparam.erl);
        printlog.i(THIS_FILE, "   dynamic_vol_mic       : " + aecparam.dynamic_vol_mic);
        printlog.i(THIS_FILE, "   dynamic_vol_mic_min   : " + aecparam.dynamic_vol_mic_min);
        printlog.i(THIS_FILE, "   update_speed          : " + aecparam.update_speed);
        printlog.i(THIS_FILE, "   weight_max_index      : " + aecparam.weight_max_index);
        printlog.i(THIS_FILE, "   weight_scale          : " + aecparam.weight_scale);
        printlog.i(THIS_FILE, "   -------------------------------------------------------- ");
        m_AECMemo = aecparam.memo;
        m_AECDelay = aecparam.delay;
        m_AECTimeSpan = aecparam.time_span;
        m_AECERL = aecparam.erl;
        m_AECDynVol = aecparam.dynamic_vol_mic;
        m_AECDynVolMin = aecparam.dynamic_vol_mic_min;
        m_AECUpdateSpeed = aecparam.update_speed;
        m_AECWMaxIndex = aecparam.weight_max_index;
        m_AECWScale = aecparam.weight_scale;
    }

    private void printDeviceInfo() {
        printlog.i(THIS_FILE, "BOARD : " + Build.BOARD);
        printlog.i(THIS_FILE, "BRAND : " + Build.BRAND);
        printlog.i(THIS_FILE, "CPU_ABI : " + Build.CPU_ABI);
        printlog.i(THIS_FILE, "DEVICE : " + Build.DEVICE);
        printlog.i(THIS_FILE, "DEVICE : " + Build.DEVICE.substring(4, 9));
        printlog.i(THIS_FILE, "DISPLAY : " + Build.DISPLAY);
        printlog.i(THIS_FILE, "FINGERPRINT : " + Build.FINGERPRINT);
        printlog.i(THIS_FILE, "HOST : " + Build.HOST);
        printlog.i(THIS_FILE, "ID : " + Build.ID);
        printlog.i(THIS_FILE, "MANUFACTURER : " + Build.MANUFACTURER);
        printlog.i(THIS_FILE, "MODEL : " + Build.MODEL);
        printlog.i(THIS_FILE, "PRODUCT : " + Build.PRODUCT);
        printlog.i(THIS_FILE, "TAGS : " + Build.TAGS);
        printlog.i(THIS_FILE, "TYPE : " + Build.TYPE);
        printlog.i(THIS_FILE, "USER : " + Build.USER);
        printlog.i(THIS_FILE, "SDK : " + Build.VERSION.SDK);
    }

    public static int AudioInCall_set(int mode) {
        printlog.i(THIS_FILE, " AudioInCall_set setMode : " + mode);
        audioManager.setMode(mode);
        return 0;
    }

    public static int setParameters(String value) {
        String param = "\"" + value + "\"";
        printlog.d(THIS_FILE, "param : " + param);
        audioManager.setParameters(param);
        return 0;
    }

    public int CERES_Register() {
        return this.CMIF_Register();
    }

    public int CERES_UnRegister() {
        return this.CMIF_UnRegister();
    }

    public int CERES_MakeCall(String phoneNumber, int mediaType) {
        int iRet = 1;
        int len = phoneNumber.length();
        byte[] l_PhoneNumber = null;
        Log.v((String)"yjyoon", (String)("33 len=" + len + " phoneNumber=" + phoneNumber + " mediaType " + mediaType));
        if (len > 0) {
            if (l_PhoneNumber == null) {
                l_PhoneNumber = new byte[512];
            }
            phoneNumber.getBytes(0, len, l_PhoneNumber, 0);
            l_PhoneNumber[len] = 0;
            iRet = this.CMIF_MakeCall(l_PhoneNumber, mediaType);
        } else {
            printlog.e(THIS_FILE, "CERES_MakeCall, phoneNumber length error!!!");
        }
        return iRet;
    }

    public int CERES_AcceptCall(int callIdx, int mediaType) {
        int iRet = 1;
        iRet = this.CMIF_AcceptCall(callIdx, mediaType);
        if (iRet != 0) {
            printlog.e(THIS_FILE, "CMIF_AcceptCall, Error : " + iRet + ", callIdx : " + callIdx + ", mediaType : " + mediaType);
        }
        return iRet;
    }

    public int CERES_CloseCall(int callIdx) {
        int iRet = 1;
        iRet = this.CMIF_ReleaseCall(callIdx);
        if (iRet != 0) {
            printlog.e(THIS_FILE, "CMIF_ReleaseCall, Error : " + iRet + ", callIdx : " + callIdx);
        }
        return iRet;
    }

    public int CERES_HoldCall(int callIdx) {
        int iRet = 1;
        iRet = this.CMIF_HoldCall(callIdx);
        if (iRet != 0) {
            printlog.e(THIS_FILE, "CMIF_HoldCall, Error : " + iRet + ", callIdx : " + callIdx);
        }
        return iRet;
    }

    public int CERES_UnHoldCall(int callIdx) {
        int iRet = 1;
        iRet = this.CMIF_UnHoldCall(callIdx);
        if (iRet != 0) {
            printlog.e(THIS_FILE, "CMIF_UnHoldCall, Error : " + iRet + ", callIdx : " + callIdx);
        }
        return iRet;
    }

    public int CERES_CancelCall(int callIdx) {
        int iRet = 1;
        iRet = this.CMIF_CancelCall(callIdx);
        if (iRet != 0) {
            printlog.e(THIS_FILE, "CMIF_CancelCall, Error : " + iRet + ", callIdx : " + callIdx);
        }
        return iRet;
    }

    public int CERES_RejectCall(int callIdx) {
        int iRet = 1;
        iRet = this.CMIF_RejectCall(callIdx);
        if (iRet != 0) {
            printlog.e(THIS_FILE, "CMIF_RejectCall, Error : " + iRet + ", callIdx : " + callIdx);
        }
        return iRet;
    }

    public int CERES_SendDTMF(int callIdx, String digit) {
        int iRet = 1;
        int len = digit.length();
        byte[] l_Digit = null;
        int moduleId = Integer.parseInt(digit);
        printlog.d(THIS_FILE, "CERES_Version_get(" + moduleId + ") : " + this.CERES_Version_get(moduleId));
        if (len > 0) {
            if (l_Digit == null) {
                l_Digit = new byte[10];
            }
            digit.getBytes(0, digit.length(), l_Digit, 0);
            l_Digit[len] = 0;
            iRet = this.CMIF_SendDtmf(callIdx, l_Digit);
            if (iRet != 0) {
                printlog.e(THIS_FILE, "CMIF_RejectCall, Error : " + iRet + ", callIdx : " + callIdx + ", l_Digit : " + l_Digit);
            }
        } else {
            printlog.e(THIS_FILE, " CERES_SendDTMF, digit length error!!!");
        }
        return iRet;
    }

    public static synchronized int getAccountStatus(int acc_id, CMAccStatus info) {
        printlog.d(THIS_FILE, " getcallinfo call_id : " + acc_id);
        return CMInterface.get_account_status(acc_id, CMAccStatus.getCPtr(info), info);
    }

    public static String charReturnTest(int testId) {
        return CMInterface.char_return_TEST(testId, 1, " ");
    }

    public String CERES_Version_get(int moduleId) {
        return this.CMIF_GetVersion(moduleId);
    }

    private int CERES_HeadSetState_set(int state) {
        int iRet = 1;
        iRet = this.CMIF_SetHeadSetState(state);
        if (iRet != 0) {
            printlog.e(THIS_FILE, " CMIF_SetHeadSetState ERR : " + iRet + ", state : " + state);
        }
        return iRet;
    }

    private int CERES_BuildDevice_set(int device) {
        int iRet = 1;
        iRet = this.CMIF_SetBuildDevice(device);
        if (iRet != 0) {
            printlog.e(THIS_FILE, " CMIF_SetBuildDevice ERR : " + iRet + ", device : " + device);
        }
        return iRet;
    }

    private int CERES_BuildVersion_set(int version) {
        int iRet = 1;
        iRet = this.CMIF_SetBuildVersion(version);
        if (iRet != 0) {
            printlog.e(THIS_FILE, " CMIF_SetBuildVersion ERR : " + iRet + ", version : " + version);
        }
        return iRet;
    }

    public static int CERES_DigitalVolume_set(int type, int mute, int volume) {
        int iRet = 1;
        if (type == 0) {
            spk_volume_level = volume;
        } else if (type == 1) {
            mic_volume_level = volume;
        }
        printlog.i(THIS_FILE, "DigitalVolume CERES_DigitalVolume_set, type:" + type + ", mute:" + mute + ", volume:" + volume);
        iRet = CMInterface.CMIF_SetDigitalVolume(type, mute, volume);
        iRet = CMInterface.CMIF_SetDigitalVolume(type, mute, volume);
        if (iRet != 0) {
            printlog.e(THIS_FILE, " CMIF_SetDigitalVolume ERR : " + iRet + ", type : " + type + ", mute : " + mute + ", volume : " + volume);
        }
        return iRet;
    }

    public int CERES_DigitalVolume_get(int type) {
        int l_volume = -1;
        if (type == 0) {
            l_volume = spk_volume_level;
        } else if (type == 1) {
            l_volume = mic_volume_level;
        }
        return l_volume;
    }

    public int CERES_DefaultDigitalVolume_get(int type) {
        int defaultVolume = 0;
        defaultVolume = this.CMIF_GetDefaultDigitalVolume(type);
        printlog.i(THIS_FILE, "CERES_DefaultDigitalVolume_get , type : " + (type == 1 ? "MIC" : "SPK") + ", defaultVolume : " + defaultVolume);
        return defaultVolume;
    }

    private int CERES_DeviceIP_set(String deviceIP) {
        int iRet = 1;
        byte[] l_deviceIP = null;
        l_deviceIP = new byte[32];
        deviceIP.getBytes(0, deviceIP.length(), l_deviceIP, 0);
        if (deviceIP.length() <= 0 || (iRet = this.CMIF_SetLocalIPAddress(l_deviceIP)) != 0) {
            printlog.e(THIS_FILE, " CMIF_SetLocalIPAddress ERR : " + iRet + ", deviceIP : " + deviceIP);
        }
        return iRet;
    }

    public int CERES_Vidoe_Ready(int callIdx) {
        return this.CMIF_IsVideoCall(callIdx);
    }

    public int CERES_SYSDelay_chk(int start) {
        return mPCMIF.AECDelayCheck(start);
    }

    public int CERES_SYSDelay_set() {
        return mPCMIF.SystemDelay_set();
    }

    public int CERES_JBVariation_chk(int start) {
        return mPCMIF.JBVCheck(start);
    }

    public int CERES_NP_Metrics(int start) {
        return mPCMIF.NPMetrics(start);
    }

    public static void jCmGetDeviceIP(byte[] deviceIP) {
        m_DeviceIP.getBytes(0, m_DeviceIP.length(), deviceIP, 0);
    }

    public static void jCmGetTelEventPT(byte[] telEventPT) {
        m_TelEventPT = "101";
        m_TelEventPT.getBytes(0, m_TelEventPT.length(), telEventPT, 0);
    }

    public static void jCmGetVideoMAXSize(byte[] videoMAXSize) {
        m_VideoMAXSize = "2";
        m_VideoMAXSize.getBytes(0, m_VideoMAXSize.length(), videoMAXSize, 0);
    }

    public static void jCmGetVideoSize(byte[] videoSize) {
        m_VideoSize.getBytes(0, m_VideoSize.length(), videoSize, 0);
    }

    public static void jCmGetVCodecFrameRate(byte[] vCodecFrameRate) {
        m_VCodecFrameRate.getBytes(0, m_VCodecFrameRate.length(), vCodecFrameRate, 0);
    }

    public static void jCmGetVCodecBandWidth(byte[] vCodecBandWidth) {
        m_VCodecBandwidth.getBytes(0, m_VCodecBandwidth.length(), vCodecBandWidth, 0);
    }

    public static void jCmGetVCodecMAXBR(byte[] vCodecMAXBR) {
        m_VCodec_MAXBR.getBytes(0, m_VCodec_MAXBR.length(), vCodecMAXBR, 0);
    }

    public static void jCmGetH264_Pmode(byte[] h264_Pmode) {
        m_H264_Pmode.getBytes(0, m_H264_Pmode.length(), h264_Pmode, 0);
    }

    public static void jCmGetMPEG4VES_Pli(byte[] MPEG4VES_Pli) {
        m_MPEG4VES_Pli.getBytes(0, m_MPEG4VES_Pli.length(), MPEG4VES_Pli, 0);
    }

    public static void jCmGetMAXCall(byte[] maxCall) {
        m_MAXCall = "2";
        m_MAXCall.getBytes(0, m_MAXCall.length(), maxCall, 0);
    }

    public static void jCmGetURLRule(byte[] urlRule) {
        m_URLRule = "1";
        m_URLRule.getBytes(0, m_URLRule.length(), urlRule, 0);
    }

    public static void jCmGetSRTPSKey(byte[] sSecurityKey) {
        m_SRTP_SKey = "d2eec3717da76195bb878578790af71c4ee9f859e197a414a78d5abc7451";
        m_SRTP_SKey.getBytes(0, m_SRTP_SKey.length(), sSecurityKey, 0);
    }

    public static void jCmGetUserAddr(byte[] userAddr) {
        printlog.w(THIS_FILE, "m_Address : " + m_Address);
        m_Address.getBytes(0, m_Address.length(), userAddr, 0);
        printlog.w(THIS_FILE, "userAddr : " + userAddr);
    }

    public static void jGetDecryptByteData(byte[] from_enc_data, byte[] to_dec_data) {
        String tempStr = "";
        String tempStr2 = "";
        String encryptKey = "abcdefghijk0";
        printlog.d(THIS_FILE, "from_enc_data : " + from_enc_data);
        try {
            tempStr = new String(from_enc_data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        printlog.d(THIS_FILE, "new String(from_enc_data) : " + tempStr);
        tempStr2 = Base64Utils.decrypt(tempStr, encryptKey);
        printlog.d(THIS_FILE, "tempStr2 " + tempStr2);
        tempStr2.getBytes(0, tempStr2.length(), to_dec_data, 0);
    }

    public static void jCmGetServerName(byte[] registrarAddr) {
        m_SVRName = "Svr0";
        m_SVRName.getBytes(0, m_SVRName.length(), registrarAddr, 0);
    }

    public static void jCmGetServerName2(byte[] regPort) {
        m_SVRName2 = "Svr1";
        m_SVRName2.getBytes(0, m_SVRName2.length(), regPort, 0);
    }

    public static void jCmGetServerName3(byte[] regPort) {
        m_SVRName3 = "Svr2";
        m_SVRName3.getBytes(0, m_SVRName3.length(), regPort, 0);
    }

    public static void jCmGetServerName4(byte[] regPort) {
        m_SVRName4 = "Svr3";
        m_SVRName4.getBytes(0, m_SVRName4.length(), regPort, 0);
    }

    public static void jCmGetPRegistrarAddr(byte[] registrarAddr) {
        m_RegAddr.getBytes(0, m_RegAddr.length(), registrarAddr, 0);
    }

    public static void jCmGetPRegistrarPort(byte[] regPort) {
        m_RegPort.getBytes(0, m_RegPort.length(), regPort, 0);
    }

    public static void jCmGetPRegistrarAddr2(byte[] registrarAddr) {
        m_RegAddr2 = m_RegAddr;
        m_RegAddr2.getBytes(0, m_RegAddr2.length(), registrarAddr, 0);
    }

    public static void jCmGetPRegistrarPort2(byte[] regPort) {
        m_RegPort2 = m_RegPort;
        m_RegPort2.getBytes(0, m_RegPort2.length(), regPort, 0);
    }

    public static void jCmGetPRegistrarAddr3(byte[] registrarAddr) {
        m_RegAddr3 = m_RegAddr;
        m_RegAddr3.getBytes(0, m_RegAddr3.length(), registrarAddr, 0);
    }

    public static void jCmGetPRegistrarPort3(byte[] regPort) {
        m_RegPort3 = m_RegPort;
        m_RegPort3.getBytes(0, m_RegPort3.length(), regPort, 0);
    }

    public static void jCmGetPRegistrarAddr4(byte[] registrarAddr) {
        m_RegAddr4 = m_RegAddr;
        m_RegAddr4.getBytes(0, m_RegAddr4.length(), registrarAddr, 0);
    }

    public static void jCmGetPRegistrarPort4(byte[] regPort) {
        m_RegPort4 = m_RegPort;
        m_RegPort4.getBytes(0, m_RegPort4.length(), regPort, 0);
    }

    public static void jCmGetUserID(byte[] userID) {
        m_PhoneNumber.getBytes(0, m_PhoneNumber.length(), userID, 0);
    }

    public static void jCmGetAuthID(byte[] authID) {
        m_AuthId.getBytes(0, m_AuthId.length(), authID, 0);
    }

    public static void jCmGetUserPWD(byte[] userPWD) {
        m_Password.getBytes(0, m_Password.length(), userPWD, 0);
    }

    public static void jCmGetReRegTime(byte[] reregtime) {
        m_ReRegTime.getBytes(0, m_ReRegTime.length(), reregtime, 0);
    }

    public static void jCmGetSessionTime(byte[] sessiontime) {
        m_SessionTime.getBytes(0, m_SessionTime.length(), sessiontime, 0);
    }

    public static void jCmGetSessionExpireTime(byte[] sessionexpiretime) {
        m_SessionExpireTime.getBytes(0, m_SessionExpireTime.length(), sessionexpiretime, 0);
    }

    public static void jCmGetTransactionTime(byte[] transactiontime) {
        m_TransactionTime.getBytes(0, m_TransactionTime.length(), transactiontime, 0);
    }

    public static void jCmGetDTMFType(byte[] dtmftype) {
        m_DTMFType.getBytes(0, m_DTMFType.length(), dtmftype, 0);
    }

    public static void jCmGetURLType(byte[] urltype) {
        m_URLType.getBytes(0, m_URLType.length(), urltype, 0);
    }

    public static void jCmGetLocalPort(byte[] localPort) {
        m_LocalPort.getBytes(0, m_LocalPort.length(), localPort, 0);
    }

    public static void jCmGetLocalMediaPort(byte[] localMediaPort) {
        m_LocalMediaPort.getBytes(0, m_LocalMediaPort.length(), localMediaPort, 0);
    }

    public static void jCmGetRemoteMediaPort(byte[] remoteMediaPort) {
        m_RemoteMediaPort.getBytes(0, m_RemoteMediaPort.length(), remoteMediaPort, 0);
    }

    public static void jCmGetCodecPri(byte[] codecPri) {
        m_ACodecPri.getBytes(0, m_ACodecPri.length(), codecPri, 0);
    }

    public static void jCmGetVideoCodecPri(byte[] vcodecPri) {
        m_VCodecPri.getBytes(0, m_VCodecPri.length(), vcodecPri, 0);
    }

    public static void jCmGetProvider(byte[] provider) {
        m_Provider.getBytes(0, m_Provider.length(), provider, 0);
        Log.v((String)"yjyoon", (String)("jCmGetProvider provider=" + m_Provider));
    }

    public static void jCmGetAEConoff(byte[] aeconoff) {
        m_AECOnOff.getBytes(0, m_AECOnOff.length(), aeconoff, 0);
    }

    public static void jCmGetSDC(byte[] aeconoff) {
        m_SDCOnOff.getBytes(0, m_SDCOnOff.length(), aeconoff, 0);
    }

    public static void jCmGetJBMinMax(byte[] minmax) {
        m_JBMinMax.getBytes(0, m_JBMinMax.length(), minmax, 0);
    }

    public static void jCmGetHWSamplingRate(byte[] hw_sr) {
        printlog.d(THIS_FILE, "jCmGetHWSamplingRate is called...");
        m_HWSamplingRate.getBytes(0, m_HWSamplingRate.length(), hw_sr, 0);
    }

    public static void jGetLogLvSIP(byte[] level) {
        if (m_Log_LV_SIP.length() == 0) {
            m_Log_LV_SIP = "4";
        }
        m_Log_LV_SIP.getBytes(0, m_Log_LV_SIP.length(), level, 0);
    }

    public static void jGetLogLvRTP(byte[] level) {
        if (m_Log_LV_RTP.length() == 0) {
            m_Log_LV_RTP = "4";
        }
        printlog.d(THIS_FILE, "m_Log_LV_RTP : " + m_Log_LV_RTP);
        m_Log_LV_RTP.getBytes(0, m_Log_LV_RTP.length(), level, 0);
    }

    public static void jGetLogLvCM(byte[] level) {
        if (m_Log_LV_CM.length() == 0) {
            m_Log_LV_CM = "4";
        }
        m_Log_LV_CM.getBytes(0, m_Log_LV_CM.length(), level, 0);
    }

    public static void jGetLogLvMCM(byte[] level) {
        if (m_Log_LV_MCM.length() == 0) {
            m_Log_LV_MCM = "4";
        }
        m_Log_LV_MCM.getBytes(0, m_Log_LV_MCM.length(), level, 0);
    }

    public static void jGetLogLvMMM(byte[] level) {
        if (m_Log_LV_MMM.length() == 0) {
            m_Log_LV_MMM = "4";
        }
        m_Log_LV_MMM.getBytes(0, m_Log_LV_MMM.length(), level, 0);
    }

    public static void jGetVAD(byte[] onoff) {
        if (m_VADOnOff.length() == 0) {
            m_VADOnOff = "0";
        }
        printlog.d(THIS_FILE, "m_VADOnOff : " + m_VADOnOff);
        m_VADOnOff.getBytes(0, m_VADOnOff.length(), onoff, 0);
    }

    public static void jGetNS(byte[] onoff) {
        if (m_NSOnOff.length() == 0) {
            m_NSOnOff = "0";
        }
        m_NSOnOff.getBytes(0, m_NSOnOff.length(), onoff, 0);
    }

    public static void jGetCNG(byte[] onoff) {
        if (m_CNGOnOff.length() == 0) {
            m_CNGOnOff = "0";
        }
        m_CNGOnOff.getBytes(0, m_CNGOnOff.length(), onoff, 0);
    }

    public static void jGetAECMemo(byte[] aecmemo, int value) {
        m_AECMemo.getBytes(0, m_AECMemo.length(), aecmemo, 0);
    }

    public static void jGetAECDelay(byte[] delay) {
        m_AECDelay.getBytes(0, m_AECDelay.length(), delay, 0);
    }

    public static void jGetAECTimeSpan(byte[] timespan) {
        m_AECTimeSpan.getBytes(0, m_AECTimeSpan.length(), timespan, 0);
    }

    public static void jGetAECERL(byte[] erl) {
        m_AECERL.getBytes(0, m_AECERL.length(), erl, 0);
    }

    public static void jGetAECDynVol(byte[] dynvol) {
        m_AECDynVol.getBytes(0, m_AECDynVol.length(), dynvol, 0);
    }

    public static void jGetAECDynVolMin(byte[] dynvolmin) {
        m_AECDynVolMin.getBytes(0, m_AECDynVolMin.length(), dynvolmin, 0);
    }

    public static void jGetAECUpdateSpeed(byte[] updatespeed) {
        m_AECUpdateSpeed.getBytes(0, m_AECUpdateSpeed.length(), updatespeed, 0);
    }

    public static void jGetAECWMaxIndex(byte[] wmaxindex) {
        m_AECWMaxIndex.getBytes(0, m_AECWMaxIndex.length(), wmaxindex, 0);
    }

    public static void jGetAECWScale(byte[] wscale) {
        m_AECWScale.getBytes(0, m_AECWScale.length(), wscale, 0);
    }

    public static void jCmGetSRTPState(byte[] srtpstate) {
        m_SRTPOption.getBytes(0, m_SRTPOption.length(), srtpstate, 0);
    }

    public static void jCmGetSRegistrarAddr(byte[] registrarAddr) {
    }

    public static void jCmGetSBCPRegistrarAddr(byte[] registrarAddr) {
    }

    public static void jCmGetSBCSRegistrarAddr(byte[] registrarAddr) {
    }

    public static void jCmGetSRegistrarPort(byte[] regPort) {
    }

    public static void jCmGetSBCPRegistrarPort(byte[] regPort) {
    }

    public static void jCmGetSBCSRegistrarPort(byte[] regPort) {
    }

    public void setOnCallStateCBListener(OnCallbackListener listener) {
        onCallStateCBListener = listener;
    }

    public void setOnCheckCBListener(OnMonitorListener listener) {
        onCheckCBListener = listener;
    }

    public void setOnMediaUpdateListener(OnCallbackListener listener) {
        onMediaUpdateCBListener = listener;
    }

    public void setOnLoopbackCBListener(OnLoopbackListener listener) {
        onLoopbackCBListener = listener;
    }

    public void setOnTapsStatusCBListener(OnTapsStatusListener listener) {
        onTapsStatusEvent = listener;
    }

    private void dispatchMediaUpdateCBEvent(int mediaDir) {
        if (onMediaUpdateCBListener != null) {
            onMediaUpdateCBListener.OnMediaUpdated(mediaDir);
        }
    }

    private void dispatchCallStateCBEvent(CMCallInfo callinfo) {
        if (onCallStateCBListener != null) {
            onCallStateCBListener.OnCallStateChanged(callinfo);
        }
    }

    private void dispatchCallStateCBEvent(int state) {
        if (onCallStateCBListener != null) {
            onCallStateCBListener.OnAccRegChanged(state);
        }
    }

    public static void dispatchNPMetricsCBEvent(NPMetrics npMetrics) {
        if (onCheckCBListener != null) {
            onCheckCBListener.onNPMetricsEvent(npMetrics);
        }
    }

    public static void dispatchCheckCBEvent(int currMS, int var) {
        if (onCheckCBListener != null) {
            onCheckCBListener.onJBVCheckEvent(currMS, var);
        }
    }

    public static void dispatchSysDelayEvent(int delay, int echo_dB) {
        if (onCheckCBListener != null) {
            onCheckCBListener.onSYSDelayCheckEvent(delay, echo_dB);
        }
    }

    private void dispatchLoopbackCBEvent(int state, int callType) {
        if (onLoopbackCBListener != null) {
            onLoopbackCBListener.OnLoopbackStateChanged(state, callType);
        }
    }

    private static void dispatchTapsStatusCBEvent(int state, String str) {
        if (onTapsStatusEvent != null) {
            onTapsStatusEvent.onTapsStatusEvent(state, str);
        }
    }

    private static void currentCallInfo(boolean printfg, DupCallInfo callInfo) {
        if (printfg) {
            printlog.w(THIS_FILE, "callInfo.---------------------------------------------------------");
            printlog.i(THIS_FILE, "callInfo.getAccId() : " + callInfo.getAccId());
            printlog.i(THIS_FILE, "callInfo.getAudioCodec() : " + callInfo.getAudioCodec());
            printlog.i(THIS_FILE, "callInfo.getAudioCodecParamPtime() : " + callInfo.getAudioCodecParamPtime());
            printlog.d(THIS_FILE, "callInfo.getAudioDir() : " + callInfo.getAudioDir());
            printlog.d(THIS_FILE, "callInfo.getAudioLocalAddr() : " + callInfo.getAudioLocalAddr());
            printlog.d(THIS_FILE, "callInfo.getAudioLocalPort() : " + callInfo.getAudioLocalPort());
            printlog.d(THIS_FILE, "callInfo.getAudioPayloadType() : " + callInfo.getAudioPayloadType());
            printlog.d(THIS_FILE, "callInfo.getAudioRemoteAddr() : " + callInfo.getAudioRemoteAddr());
            printlog.d(THIS_FILE, "callInfo.getAudioRemotePort() : " + callInfo.getAudioRemotePort());
            printlog.d(THIS_FILE, "callInfo.getAudioTeltPt() : " + callInfo.getAudioTeltPt());
            printlog.d(THIS_FILE, "callInfo.getAudioType() : " + callInfo.getAudioType());
            printlog.d(THIS_FILE, "callInfo.getLocalMedia() : " + callInfo.getLocalMedia());
            printlog.d(THIS_FILE, "callInfo.getNumRemote() : " + callInfo.getNumRemote());
            printlog.w(THIS_FILE, "callInfo.getPrevState() : " + callInfo.getPrevState());
            printlog.d(THIS_FILE, "callInfo.getRemoteMedia() : " + callInfo.getRemoteMedia());
            printlog.d(THIS_FILE, "callInfo.getRemoteName() : " + callInfo.getRemoteName());
            printlog.d(THIS_FILE, "callInfo.getRemoteStatus() : " + callInfo.getRemoteStatus());
            printlog.i(THIS_FILE, "callInfo.getRemoteUri() : " + callInfo.getRemoteUri());
            printlog.d(THIS_FILE, "callInfo.getRingWithMedia() : " + callInfo.getRingWithMedia());
            printlog.i(THIS_FILE, "callInfo.getState() : " + callInfo.getState());
            printlog.d(THIS_FILE, "callInfo.getStatusCode() : " + callInfo.getStatusCode());
            printlog.d(THIS_FILE, "callInfo.getType() : " + callInfo.getType());
        }
    }

    public static void setCallIndex(int callId) {
        m_callIdx = callId;
    }

    public int CERES_CallIndex_get() {
        return m_callIdx;
    }

    public int getCallIndex() {
        return m_callIdx;
    }

    public static void jLoopbackConnect(int state, int mediaType) {
        printlog.d(THIS_FILE, "jLoopbackConnect, state : " + state + ", mediaType : " + mediaType);
        Log.v((String)"yjyoon", (String)"3333");
        Message msg = msgHandler.obtainMessage(state);
        Bundle b = new Bundle();
        b.putInt("mediaType", mediaType);
        msg.setData(b);
        msgHandler.sendMessage(msg);
    }

    public static void jLoopbackDisconnect(int state, int mediaType) {
        printlog.d(THIS_FILE, "jLoopbackDisconnect, state : " + state + ", mediaType : " + mediaType);
        Log.v((String)"yjyoon", (String)"4444");
        Message msg = msgHandler.obtainMessage(state);
        Bundle b = new Bundle();
        b.putInt("mediaType", mediaType);
        msg.setData(b);
        msgHandler.sendMessage(msg);
    }

    public void InCallMedia_isFirstRun_set(boolean value) {
        isFirstRun = value;
    }

    public boolean InCallMeida_isFirstRun_get() {
        return isFirstRun;
    }

    public void InCallMedia_SPK_Volume_set(int setVolume) {
        mDigital_SpkVolume = setVolume;
    }

    public int InCallMedia_SPK_Volume_get() {
        return mDigital_SpkVolume;
    }

    public static void InCallMedia_MIC_Volume_set(int setVolume) {
        mDigital_MicVolume = setVolume;
    }

    public int InCallMedia_MIC_Volume_get() {
        return mDigital_MicVolume;
    }

    public void InCallMedia_SPK_InitVolume_set(int setVolume) {
        mInitDigital_SpkVolume = setVolume;
    }

    public int InCallMedia_SPK_InitVolume_get() {
        return mInitDigital_SpkVolume;
    }

    public void InCallMedia_MIC_InitVolume_set(int setVolume) {
        mInitDigital_MicVolume = setVolume;
    }

    public int InCallMedia_MIC_InitVolume_get() {
        return mInitDigital_MicVolume;
    }

    public static void jCmChangeState(int state, int callId) {
        CMInterface.lockCpu();
        printlog.d(THIS_FILE, "jCmChangeState. callId : " + callId);
        CMInterface.setCallIndex(callId);
        DupCallInfo callInfo = new DupCallInfo(callId);
        CMInterface.currentCallInfo(true, callInfo);
        int callState = callInfo.getState();
        printlog.w(THIS_FILE, "jCmChangeState. -------------------------------------------------");
        printlog.d(THIS_FILE, "jCmChangeState. state        : " + state);
        printlog.d(THIS_FILE, "jCmChangeState. callState        : " + callState);
        if (state == 0) {
            if (callState == 3) {
                printlog.d(THIS_FILE, "-----------> DupCallInfo.CMCallState.INCOMING : ");
                if (SipManager.DEVICE_NAME.equalsIgnoreCase("E120")) {
                    printlog.d(THIS_FILE, "-----------> DupCallInfo.CMCallState.INCOMING : S2LTE, set MIC 44");
                    CMInterface.CERES_DigitalVolume_set(1, 0, 44);
                    CMInterface.InCallMedia_MIC_Volume_set(44);
                } else if (SipManager.DEVICE_NAME.equalsIgnoreCase("M250")) {
                    printlog.d(THIS_FILE, "-----------> DupCallInfo.CMCallState.INCOMING : S2, set MIC 53");
                    CMInterface.CERES_DigitalVolume_set(1, 0, 60);
                }
            } else if (callState == 2) {
                printlog.d(THIS_FILE, "-----------> DupCallInfo.CMCallState.CALLING : ");
                if (SipManager.DEVICE_NAME.equalsIgnoreCase("E120")) {
                    printlog.d(THIS_FILE, "-----------> DupCallInfo.CMCallState.CALLING : S2LTE, set MIC 60");
                    CMInterface.CERES_DigitalVolume_set(1, 0, 60);
                    CMInterface.InCallMedia_MIC_Volume_set(60);
                } else if (SipManager.DEVICE_NAME.equalsIgnoreCase("M250")) {
                    printlog.d(THIS_FILE, "-----------> DupCallInfo.CMCallState.CALLING : S2, set MIC 53");
                    CMInterface.CERES_DigitalVolume_set(1, 0, 60);
                }
            } else if (callState == 7) {
                if (m_AECOnOff.equals("0") || m_AECOnOff.equals("2")) {
                    printlog.d(THIS_FILE, "ALL_AEC_OFF end");
                    if (SipManager.DEVICE_NAME.equalsIgnoreCase("E120")) {
                        printlog.d(THIS_FILE, "ALL_AEC_OFF end : S2 LTE");
                        audioManager.setParameters("realcall=off");
                    } else if (SipManager.DEVICE_NAME.equalsIgnoreCase("M250")) {
                        printlog.d(THIS_FILE, "ALL_AEC_OFF end : S2");
                        audioManager.setMode(0);
                    }
                } else if (m_AECOnOff.equals("1")) {
                    printlog.d(THIS_FILE, "INNER_AEC end");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else if (state == 1) {
            printlog.d(THIS_FILE, " state 1 is onPreMediaStart!!!");
            if (incomingCallLock != null) {
                incomingCallLock.release();
            }
            if (m_AECOnOff.equals("0") || m_AECOnOff.equals("2")) {
                printlog.d(THIS_FILE, "ALL_AEC_OFF start");
                if (SipManager.DEVICE_NAME.equalsIgnoreCase("E120")) {
                    printlog.d(THIS_FILE, "ALL_AEC_OFF start : S2 LTE");
                    audioManager.setMode(0);
                    audioManager.setParameters("realcall=on");
                    printlog.e(THIS_FILE, "audioManager.getStreamMaxVolume : " + audioManager.getStreamMaxVolume(0));
                    printlog.e(THIS_FILE, "audioManager.getStreamVolume : " + audioManager.getStreamVolume(0));
                } else if (SipManager.DEVICE_NAME.equalsIgnoreCase("M250")) {
                    printlog.d(THIS_FILE, "ALL_AEC_OFF start : S2");
                    audioManager.setMode(2);
                }
            } else if (m_AECOnOff.equals("1")) {
                printlog.d(THIS_FILE, "INNER_AEC start");
                if (SipManager.DEVICE_NAME.equalsIgnoreCase("M250")) {
                    printlog.d(THIS_FILE, "INNER_AEC start : S2 LTE");
                    audioManager.setMode(0);
                }
            }
        } else if (state == 2) {
            PCMInterface.MMIF_IsVideoReady(callId);
        } else if (state == 3) {
            msgHandler.sendMessage(msgHandler.obtainMessage(3, callInfo));
            return;
        }
        msgHandler.sendMessage(msgHandler.obtainMessage(0, callInfo));
        CMInterface.unlockCpu();
    }

    public static void jCmRegisterState(int state, int accId) {
        CMInterface.lockCpu();
        CMAccStatus accInfo = new CMAccStatus();
        CMInterface.getAccountStatus(0, accInfo);
        printlog.w(THIS_FILE, "jCmRegisterState, state:" + state);
        printlog.w(THIS_FILE, "jCmRegisterState, accId:" + accId);
        msgHandler.sendMessage(msgHandler.obtainMessage(1, accInfo));
        CMInterface.unlockCpu();
    }

    public static void jTAPSReportState(int state, byte[] str) {
        CMInterface.lockCpu();
        String tempStr = "";
        printlog.w(THIS_FILE, "taps jTAPSReportState, state:" + state);
        printlog.e(THIS_FILE, "taps jTAPSReportState, str:" + str);
        try {
            tempStr = new String(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        printlog.e(THIS_FILE, "taps jTAPSReportState, tempStr:" + tempStr);
        Message msg = handler.obtainMessage(6);
        Bundle b = new Bundle();
        b.putInt("state", state);
        b.putString("str", tempStr);
        msg.setData(b);
        handler.sendMessage(msg);
        CMInterface.unlockCpu();
    }

    static {
        m_PhoneNumber = "";
        m_OneNumber = "";
        m_Address = "";
        m_Password = "";
        m_AuthId = "";
        m_ProxyAddr = "";
        m_ProxyPort = "";
        m_RegAddr = "";
        m_RegPort = "";
        m_LocalPort = "";
        m_LocalMediaPort = "";
        m_RemoteMediaPort = "";
        m_RegAddr2 = "";
        m_RegPort2 = "";
        m_RegAddr3 = "";
        m_RegPort3 = "";
        m_RegAddr4 = "";
        m_RegPort4 = "";
        m_SVRName = "";
        m_SVRName2 = "";
        m_SVRName3 = "";
        m_SVRName4 = "";
        m_Provider = "";
        m_ACodecPri = "";
        m_ReRegTime = "";
        m_SessionTime = "";
        m_SessionExpireTime = "";
        m_TransactionTime = "";
        m_DTMFType = "";
        m_URLType = "";
        m_PTime = "";
        m_VCodecPri = "";
        m_SRTPOption = "";
        m_SDCOnOff = "";
        m_VideoOnOff = "";
        m_VideoSize = "";
        m_VCodecFrameRate = "";
        m_VCodecBandwidth = "";
        m_VCodec_MAXBR = "";
        m_H264_Pmode = "";
        m_MPEG4VES_Pli = "";
        m_AECOnOff = "";
        m_OneNumberOnOff = "";
        m_SpamOnOff = "";
        m_RedirectOption = "";
        m_HWSamplingRate = "";
        m_AudioMode = "";
        m_JBMinMax = "";
        m_DeviceIP = "";
        m_TelEventPT = "";
        m_VideoMAXSize = "";
        m_MAXCall = "";
        m_URLRule = "";
        m_SRTP_SKey = "";
        m_Log_LV_SIP = "";
        m_Log_LV_RTP = "";
        m_Log_LV_CM = "";
        m_Log_LV_MCM = "";
        m_Log_LV_MMM = "";
        m_Log_LV_UI = "";
        m_VADOnOff = "";
        m_NSOnOff = "";
        m_CNGOnOff = "";
        m_AECMemo = "";
        m_AECDelay = "";
        m_AECTimeSpan = "";
        m_AECERL = "";
        m_AECDynVol = "";
        m_AECDynVolMin = "";
        m_AECUpdateSpeed = "";
        m_AECWMaxIndex = "";
        m_AECWScale = "";
        mPCMIF = null;
        mSRIF = null;
        ceres_init_state = 0;
        register_state = 0;
        regi_callback_cnt = 0;
        network_change_cnt = 0;
        handler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 6: {
                        int state = msg.getData().getInt("state");
                        String str = msg.getData().getString("str");
                        CMInterface.dispatchTapsStatusCBEvent(state, str);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
        mic_volume_level = 0;
        spk_volume_level = 0;
        m_callIdx = -1;
        isFirstRun = true;
        mDigital_SpkVolume = 0;
        mDigital_MicVolume = 0;
        mInitDigital_SpkVolume = 0;
        mInitDigital_MicVolume = 0;
    }

    private class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
            printlog.i(CMInterface.THIS_FILE, " service debugCreate async worker !!!");
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    DupCallInfo callInfo = (DupCallInfo)msg.obj;
                    printlog.w(CMInterface.THIS_FILE, "handleMessage. -------------------------------------------------");
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.state        : " + callInfo.getState());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.mediaType    : " + callInfo.getRemoteMedia());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.aCodecName    : " + callInfo.get_ACodecName(callInfo.getAudioCodec()));
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.aCodecInt     : " + callInfo.getAudioCodec());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.vCodecName    : " + callInfo.get_VCodecName(callInfo.getVideoCodec()));
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.vCodecInt     : " + callInfo.getVideoCodec());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.vSizeName    : " + callInfo.get_VSizeName(Integer.parseInt(m_VideoSize)));
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.vSizeInt     : " + m_VideoSize);
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.remoteNumber : " + callInfo.getRemoteUri());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.mediaDir\t : " + callInfo.getAudioDir());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.prevState\t: " + callInfo.getPrevState());
                    CMInterface.this.dupCallInfo.callState = callInfo.getState();
                    CMInterface.this.dupCallInfo.mediaType = callInfo.getRemoteMedia();
                    CMInterface.this.dupCallInfo.aCodecName = callInfo.get_ACodecName(callInfo.getAudioCodec());
                    CMInterface.this.dupCallInfo.vCodecName = callInfo.get_VCodecName(callInfo.getVideoCodec());
                    CMInterface.this.dupCallInfo.vSizeName = callInfo.get_VSizeName(Integer.parseInt(m_VideoSize));
                    CMInterface.this.dupCallInfo.remoteNumber = callInfo.getRemoteUri();
                    CMInterface.this.dupCallInfo.mediaDir = callInfo.getAudioDir();
                    CMInterface.this.dupCallInfo.prevCallState = callInfo.getPrevState();
                    CMInterface.this.dispatchCallStateCBEvent(CMInterface.this.dupCallInfo);
                    break;
                }
                case 1: {
                    CMAccStatus accInfo = (CMAccStatus)msg.obj;
                    short registered = accInfo.getRegistered();
                    CMInterface.this.dupCallInfo.callState = registered;
                    CMInterface.this.dispatchCallStateCBEvent(registered);
                    CMInterface.CERES_RegiState_set(registered);
                    printlog.i(CMInterface.THIS_FILE, "register_state : " + register_state);
                    break;
                }
                case 3: {
                    DupCallInfo callInfo = (DupCallInfo)msg.obj;
                    printlog.w(CMInterface.THIS_FILE, "handleMessage. -------------------------------------------------");
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.state        : " + callInfo.getState());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.mediaType    : " + callInfo.getRemoteMedia());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.aCodecName    : " + callInfo.get_ACodecName(callInfo.getAudioCodec()));
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.vCodecName    : " + callInfo.get_VCodecName(callInfo.getVideoCodec()));
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.remoteNumber : " + callInfo.getRemoteUri());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.mediaDir\t : " + callInfo.getAudioDir());
                    printlog.d(CMInterface.THIS_FILE, "handleMessage.prevState\t: " + callInfo.getPrevState());
                    CMInterface.this.dupCallInfo.mediaDir = callInfo.getAudioDir();
                    CMInterface.this.dispatchMediaUpdateCBEvent(CMInterface.this.dupCallInfo.mediaDir);
                    break;
                }
                case 4: {
                    int mediaType = msg.getData().getInt("mediaType");
                    CMInterface.this.dispatchLoopbackCBEvent(1, mediaType);
                    break;
                }
                case 5: {
                    int mediaType = msg.getData().getInt("mediaType");
                    CMInterface.this.dispatchLoopbackCBEvent(0, mediaType);
                }
                case 6: {
                    printlog.d(CMInterface.THIS_FILE, "taps ON_TAPS_REPORT_STATE : ");
                    CMInterface.this.CERES_Initialize(mContext);
                }
            }
        }
    }

    public static interface OnLoopbackListener {
        public void OnLoopbackStateChanged(int var1, int var2);
    }

    public static interface OnTapsStatusListener {
        public void onTapsStatusEvent(int var1, String var2);
    }

    public static interface OnMonitorListener {
        public void onSYSDelayCheckEvent(int var1, int var2);

        public void onJBVCheckEvent(int var1, int var2);

        public void onNPMetricsEvent(NPMetrics var1);
    }

    public static interface OnCallbackListener {
        public void OnCallStateChanged(CMCallInfo var1);

        public void OnAccRegChanged(int var1);

        public void OnMediaUpdated(int var1);
    }
}

