/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class EnergyMeterAPI
extends WallPadDevAPI {
    private final String TAG = "EnergyMeterAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"EnergyMeterAPI", (String)s);
    }

    public EnergyMeterAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("EnergyMeterAPI create " + devctrcmd);
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "ENERGYMETER";
        this.data = new Data();
        this.GetDeviceCount();
        Log.i((String)"EnergyMeterAPI", (String)("GetDeviceCount() - " + this.data.RoomCnt));
        DataClasses.EnergyMeter.Info info = this.GetVersion();
        if (info != null) {
            this.data.Em.info = info;
            Log.i((String)"EnergyMeterAPI", (String)"GetVersion() - OK!!!");
        } else {
            Log.i((String)"EnergyMeterAPI", (String)"GetVersion() - Fail... null");
        }
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.RoomCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[Refresh] data.RoomCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.RoomCnt)) {
            Log.w((String)"EnergyMeterAPI", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.RoomCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.RoomCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.EnergyMeter.EachRoom eachRoom = new DataClasses.EnergyMeter.EachRoom();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            eachRoom.Install = Boolean.parseBoolean(retData[index++]);
            eachRoom.CommStatus = Boolean.parseBoolean(retData[index++]);
            eachRoom.UnitError = Boolean.parseBoolean(retData[index++]);
            byte LightCnt = Byte.parseByte(retData[index++]);
            eachRoom.setLightCnt(LightCnt);
            if (LightCnt != 0) {
                for (byte i = 0; i < LightCnt; i = (byte)(i + 1)) {
                    eachRoom.LightOnOff[i] = Boolean.parseBoolean(retData[index++]);
                }
            }
            eachRoom.LightNowPw = Double.parseDouble(retData[index++]);
            eachRoom.LightAccPw = Double.parseDouble(retData[index++]);
            eachRoom.LightAccOverflow = Boolean.parseBoolean(retData[index++]);
            eachRoom.LightOverLoad = Boolean.parseBoolean(retData[index++]);
            byte ConCnt = Byte.parseByte(retData[index++]);
            eachRoom.setConCnt(ConCnt);
            eachRoom.ConMode = Boolean.parseBoolean(retData[index++]);
            if (ConCnt != 0) {
                byte i;
                for (i = 0; i < 2; i = (byte)(i + 1)) {
                    eachRoom.ConOnOff[i] = Boolean.parseBoolean(retData[index++]);
                    eachRoom.ConCutOffVal[i] = Double.parseDouble(retData[index++]);
                    eachRoom.ConCutOffStatus[i] = Boolean.parseBoolean(retData[index++]);
                    eachRoom.ConOverLoad[i] = Boolean.parseBoolean(retData[index++]);
                }
                for (i = 0; i < ConCnt; i = (byte)(i + 1)) {
                    eachRoom.ConNowPw[i] = Double.parseDouble(retData[index++]);
                    eachRoom.ConAccPw[i] = Double.parseDouble(retData[index++]);
                    eachRoom.ConAccOverflow[i] = Boolean.parseBoolean(retData[index++]);
                }
            }
            eachRoom.AllLightRelay_Use = Boolean.parseBoolean(retData[index++]);
            eachRoom.AllLightRelay_OnOff = Boolean.parseBoolean(retData[index++]);
            this.data.Em.eachRoom[Current] = eachRoom;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "EnergyMeterAPI", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"EnergyMeterAPI", (String)"[Exception Error] - ProcResult");
            LogUtil.errorLogInfo("", "EnergyMeterAPI", e);
            return -1;
        }
        return 0;
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.RoomCnt = DeviceCount;
                    this.data.Em.setRoomCnt(this.data.RoomCnt);
                    return 0;
                }
                return -1;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "EnergyMeterAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"EnergyMeterAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "EnergyMeterAPI", e);
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetPollingMode(byte ChangePollingMode, byte RoomIndex) {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetPollingMode] RoomCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (ChangePollingMode != 0 && ChangePollingMode != 1) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetPollingMode] ChangePollingMode Out Of Range !!!(ChangePollingMode:" + ChangePollingMode + ")"));
            return -300;
        }
        if (ChangePollingMode == 1 && !this.DeviceIndexRangeCheck(RoomIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetPollingMode] Param - RoomIndex  : Out Of Range (RoomIndex:" + RoomIndex + ")"));
            return -2;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetPollingMode", ChangePollingMode, RoomIndex, 0, 0, 0);
    }

    public int SetLightOnOff(byte RoomIndex, byte LightIndex, boolean OnOff) {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetLightOnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(RoomIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetLightOnOff] Param - RoomIndex  : Out Of Range (RoomIndex:" + RoomIndex + ")"));
            return -2;
        }
        if (!this.LightIndexRangeCheck(RoomIndex, LightIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetLightOnOff] Param - LightIndex  : Out Of Range (LightIndex:" + LightIndex + ")"));
            return -3;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightOnOff", RoomIndex, LightIndex, ByteOnOff, 0, 0);
    }

    public int SetConcentOnOff(byte RoomIndex, byte ConcentIndex, boolean OnOff) {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetConcentOnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(RoomIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetConcentOnOff] Param - RoomIndex  : Out Of Range (RoomIndex:" + RoomIndex + ")"));
            return -2;
        }
        if (!this.ConcentIndexRangeCheck(RoomIndex, ConcentIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetConcentOnOff] Param - ConcentIndex  : Out Of Range (ConcentIndex:" + ConcentIndex + ")"));
            return -3;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentOnOff", RoomIndex, ConcentIndex, ByteOnOff, 0, 0);
    }

    public int SetConcentAllOnOff(byte RoomIndex, byte ConcentIndex, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentOnOff", RoomIndex, ConcentIndex, ByteOnOff, 0, 0);
    }

    public int SetConcentCutoffVal(byte RoomIndex, byte ConcentIndex) {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetConcentOnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(RoomIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetConcentOnOff] Param - RoomIndex  : Out Of Range (RoomIndex:" + RoomIndex + ")"));
            return -2;
        }
        if (!this.ConcentIndexRangeCheck(RoomIndex, ConcentIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetConcentOnOff] Param - ConcentIndex  : Out Of Range (ConcentIndex:" + ConcentIndex + ")"));
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentCutoffVal", RoomIndex, ConcentIndex, 0, 0, 0);
    }

    public int SetConcentCutoffMode(byte RoomIndex, boolean Mode) {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetConcentCutoffMode] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(RoomIndex)) {
            Log.w((String)"EnergyMeterAPI", (String)("[SetConcentCutoffMode] Param - RoomIndex  : Out Of Range (RoomIndex:" + RoomIndex + ")"));
            return -2;
        }
        if (!this.ConcentIndexRangeCheck(RoomIndex, (byte)0)) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetConcentCutoffMode] Param - ConcentIndex  : Out Of Range (ConcentIndex:0)");
            return -3;
        }
        int ByteMode = 0;
        if (Mode) {
            ByteMode = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentCutoffMode", RoomIndex, ByteMode, 0, 0, 0);
    }

    public int SetAllLightOnOff(boolean OnOff) {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetAllLightOnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAllLightOnOff", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetAllConcentOnOff(boolean OnOff) {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetAllConcentOnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAllConcentOnOff", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetAccPwReset() {
        if (this.data.RoomCnt <= 0) {
            Log.w((String)"EnergyMeterAPI", (String)"[SetAccPwReset] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAccPwReset", 0, 0, 0, 0, 0);
    }

    private DataClasses.EnergyMeter.Info GetVersion() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetVersion", 0, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist.length != 10) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                DataClasses.EnergyMeter.Info info = new DataClasses.EnergyMeter.Info();
                info.RoomCnt = Byte.parseByte(retlist[index++]);
                info.Vender = Byte.parseByte(retlist[index++]);
                info.FwVer_Year = Byte.parseByte(retlist[index++]);
                info.FwVer_Month = Byte.parseByte(retlist[index++]);
                info.FwVer_Day = Byte.parseByte(retlist[index++]);
                info.FwVer_Number = Byte.parseByte(retlist[index++]);
                info.ProtocolVer_Main = Byte.parseByte(retlist[index++]);
                info.ProtocolVer_Sub = Byte.parseByte(retlist[index++]);
                info.AccPw_Unit = Boolean.parseBoolean(retlist[index++]);
                return info;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "EnergyMeterAPI", re);
                return null;
            }
            catch (Exception e) {
                Log.e((String)"EnergyMeterAPI", (String)("[GetDeviceCount] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "EnergyMeterAPI", e);
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    private boolean DeviceIndexRangeCheck(byte Index) {
        try {
            return Index >= 0 && Index < this.data.RoomCnt;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "EnergyMeterAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"EnergyMeterAPI", (String)"[Exception Error] DeviceIndexRangeCheck");
            LogUtil.errorLogInfo("", "EnergyMeterAPI", e);
            return false;
        }
    }

    private boolean LightIndexRangeCheck(byte Index, byte LightIdx) {
        try {
            return !(this.data.Em.eachRoom[Index].LightCnt == 0 ? LightIdx != -1 && (LightIdx >= 8 || LightIdx < 0) : LightIdx != -1 && (LightIdx >= this.data.Em.eachRoom[Index].LightCnt || LightIdx < 0));
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "EnergyMeterAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"EnergyMeterAPI", (String)"[Exception Error] LightIndexRangeCheck");
            LogUtil.errorLogInfo("", "EnergyMeterAPI", e);
            return false;
        }
    }

    private boolean ConcentIndexRangeCheck(byte Index, byte ConcentIdx) {
        try {
            return !(this.data.Em.eachRoom[Index].ConCnt == 0 ? ConcentIdx != -1 && (ConcentIdx >= 8 || ConcentIdx < 0) : ConcentIdx != -1 && (ConcentIdx >= this.data.Em.eachRoom[Index].ConCnt || ConcentIdx < 0));
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "EnergyMeterAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"EnergyMeterAPI", (String)"[Exception Error] ConcentIndexRangeCheck");
            LogUtil.errorLogInfo("", "EnergyMeterAPI", e);
            return false;
        }
    }

    public static class Data {
        public byte RoomCnt = 0;
        public DataClasses.EnergyMeter Em = new DataClasses.EnergyMeter();
    }

    public static final class POLLING_MODE {
        public static final byte NORMAL = 0;
        public static final byte FIXROOM = 1;
    }
}

