/*
 * Decompiled with CFR 0.152.
 */
package ceres.utils;

import android.content.Context;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Vibrator;
import ceres.utils.printlog;

public class Ringer {
    private static final String THIS_FILE = "Ringer";
    private static final int VIBRATE_LENGTH = 1000;
    private static final int PAUSE_LENGTH = 1000;
    Uri customRingtoneUri;
    Ringtone ringtone = null;
    Vibrator vibrator;
    VibratorThread vibratorThread;
    RingerThread ringerThread;
    Context context;
    public int audioMode;

    public Ringer(Context aContext) {
        this.context = aContext;
        this.vibrator = (Vibrator)this.context.getSystemService("vibrator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ring(String remoteContact, String defaultRingtone) {
        printlog.d(THIS_FILE, "  ==> ring() called...");
        Ringer ringer = this;
        synchronized (ringer) {
            AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
            this.ringtone = this.getRingtone(remoteContact, defaultRingtone);
            printlog.w(THIS_FILE, "remoteContact:" + remoteContact + " defaultRingtone:" + defaultRingtone + "ringtone:" + this.ringtone);
            int ringerMode = audioManager.getRingerMode();
            if (ringerMode == 0) {
                return;
            }
            if (ringerMode == 1 || audioManager.getStreamVolume(2) == 0) {
                printlog.d(THIS_FILE, "  skipping ring because profile is Vibrate OR because volume is zero");
                return;
            }
            if (this.ringtone == null) {
                printlog.d(THIS_FILE, "  No ringtone available - do not ring");
                return;
            }
            printlog.d(THIS_FILE, "  Starting ring with " + this.ringtone.getTitle(this.context));
            if (this.ringerThread == null) {
                this.ringerThread = new RingerThread();
                printlog.d(THIS_FILE, "  Starting ringer...");
                this.ringerThread.start();
            }
        }
    }

    public boolean isRinging() {
        return this.ringerThread != null || this.vibratorThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRing() {
        Ringer ringer = this;
        synchronized (ringer) {
            printlog.d(THIS_FILE, "  ==> stopRing() called...");
            this.stopVibrator();
            this.stopRinger();
        }
    }

    private void stopRinger() {
        if (this.ringerThread != null) {
            this.ringerThread.interrupt();
            try {
                this.ringerThread.join(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.ringerThread = null;
        }
    }

    private void stopVibrator() {
        if (this.vibratorThread != null) {
            this.vibratorThread.interrupt();
            try {
                this.vibratorThread.join(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.vibratorThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRingerMode() {
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        Ringer ringer = this;
        synchronized (ringer) {
            int ringerMode = audioManager.getRingerMode();
            if (ringerMode == 0) {
                this.stopRing();
                return;
            }
            int vibrateSetting = audioManager.getVibrateSetting(0);
            if (this.vibratorThread == null && (vibrateSetting == 1 || ringerMode == 1)) {
                this.vibratorThread = new VibratorThread();
                this.vibratorThread.start();
            }
            if (ringerMode == 1 || audioManager.getStreamVolume(2) == 0) {
                this.stopRinger();
                return;
            }
            if (this.ringerThread == null) {
                this.ringerThread = new RingerThread();
                printlog.d(THIS_FILE, "  Starting ringer...");
                this.ringerThread.start();
            }
        }
    }

    private Ringtone getRingtone(String remoteContact, String defaultRingtone) {
        Uri ringtoneUri = Uri.parse((String)defaultRingtone);
        printlog.w(THIS_FILE, "--------------->>> ringtoneUri : " + ringtoneUri);
        return RingtoneManager.getRingtone((Context)this.context, (Uri)ringtoneUri);
    }

    private class RingerThread
    extends Thread {
        private RingerThread() {
        }

        @Override
        public void run() {
            AudioManager audioManager = (AudioManager)Ringer.this.context.getSystemService("audio");
            try {
                try {
                    Ringer.this.audioMode = audioManager.getMode();
                    printlog.d(Ringer.THIS_FILE, "  try Ringer run()111" + Ringer.this.audioMode);
                    block4: while (true) {
                        Ringer.this.ringtone.play();
                        while (true) {
                            if (!Ringer.this.ringtone.isPlaying()) continue block4;
                            Thread.sleep(100L);
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    printlog.d(Ringer.THIS_FILE, "  Ringer thread interrupt");
                    printlog.d(Ringer.THIS_FILE, "  ringtone.stop()");
                    Ringer.this.ringtone.stop();
                    printlog.d(Ringer.THIS_FILE, "  finally Ringer run()" + Ringer.this.audioMode);
                }
            }
            catch (Throwable throwable) {
                printlog.d(Ringer.THIS_FILE, "  ringtone.stop()");
                Ringer.this.ringtone.stop();
                printlog.d(Ringer.THIS_FILE, "  finally Ringer run()" + Ringer.this.audioMode);
                throw throwable;
            }
            printlog.d(Ringer.THIS_FILE, "  Ringer thread exiting");
        }
    }

    private class VibratorThread
    extends Thread {
        private VibratorThread() {
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Ringer.this.vibrator.vibrate(1000L);
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException ex) {
                    printlog.d(Ringer.THIS_FILE, "  Vibrator thread interrupt");
                    Ringer.this.vibrator.cancel();
                }
            }
            catch (Throwable throwable) {
                Ringer.this.vibrator.cancel();
                throw throwable;
            }
            printlog.d(Ringer.THIS_FILE, "  Vibrator thread exiting");
        }
    }
}

