/*
 * Decompiled with CFR 0.152.
 */
package ceres.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.provider.CallLog;
import ceres.cminterface.DupCallInfo;

public class CallLogHelper {
    public static void addCallLog(Context context, ContentValues values) {
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.insert(CallLog.Calls.CONTENT_URI, values);
    }

    public static ContentValues logValuesForCall(Context context, DupCallInfo call, long callStart) {
        ContentValues cv = new ContentValues();
        String remoteUri = call.getRemoteUri();
        cv.put("number", remoteUri);
        cv.put("new", Integer.valueOf(callStart > 0L ? 1 : 0));
        cv.put("date", Long.valueOf(callStart > 0L ? callStart : System.currentTimeMillis()));
        int type = 2;
        int nonAcknowledge = 0;
        if (call.isIncoming()) {
            type = 3;
            nonAcknowledge = 1;
            if (callStart > 0L) {
                type = 1;
                nonAcknowledge = 0;
            }
        }
        cv.put("type", Integer.valueOf(type));
        cv.put("new", Integer.valueOf(nonAcknowledge));
        cv.put("duration", Long.valueOf(callStart > 0L ? (System.currentTimeMillis() - callStart) / 1000L : 0L));
        return cv;
    }

    public static ContentValues logValuesForCall2(Context context, String remoteContact, int calltype, long callStart) {
        ContentValues cv = new ContentValues();
        cv.put("number", remoteContact);
        cv.put("new", Integer.valueOf(1));
        cv.put("date", Long.valueOf(System.currentTimeMillis()));
        int type = 2;
        int nonAcknowledge = 0;
        if (calltype == 1) {
            type = 3;
            nonAcknowledge = 1;
        } else if (calltype == 2) {
            type = 1;
            nonAcknowledge = 0;
        }
        cv.put("type", Integer.valueOf(type));
        cv.put("new", Integer.valueOf(nonAcknowledge));
        return cv;
    }
}

