/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class CurtainAPI
extends WallPadDevAPI {
    private final String TAG = "CurtainAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;
    int MAX_DEVICE_CNT = 8;
    int MAX_CURTAIN_CNT = 15;

    private void DebugLogOutput(String s) {
        Log.d((String)"CurtainAPI", (String)s);
    }

    public CurtainAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("CurtainAPI create " + devctrcmd);
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "CURTAINLIVINGROOMCTRL";
        this.data = new Data();
    }

    public int Refresh(boolean isLivingRoom, byte Index, boolean real) {
        if (Index != -1 && (Index < 0 || Index >= this.MAX_CURTAIN_CNT)) {
            Log.w((String)"CurtainAPI", (String)("[Refresh] Param - Index Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        this.TitleStr = isLivingRoom ? "CURTAINLIVINGROOMCTRL" : "CURTAINROOMCTRL";
        if (Index == -1) {
            String ret;
            for (int i = 0; i < this.MAX_CURTAIN_CNT && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            int index = 1;
            byte hRequestIndex = Byte.parseByte(retData[index++]);
            boolean bInstall = Boolean.parseBoolean(retData[index++]);
            DataClasses.CurtainCtrl Device2 = new DataClasses.CurtainCtrl();
            if (bInstall) {
                Device2.info.bInstall = bInstall;
                Device2.curtain.setCurtainGroupID(Byte.parseByte(retData[index++]));
                Device2.curtain.setCurtainID(Byte.parseByte(retData[index++]));
                Device2.curtain.setCurtainStatus(Byte.parseByte(retData[index++]));
                Device2.curtain.setErrorStatus(Byte.parseByte(retData[index++]));
            } else {
                Device2.info.bInstall = false;
            }
            this.data.Device[hRequestIndex] = Device2;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CurtainAPI", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"CurtainAPI", (String)"[Exception Error] ProcResult");
            LogUtil.errorLogInfo("", "CurtainAPI", e);
            return -1;
        }
        return 0;
    }

    public int setUnitCurtainStatus(boolean isLivingRoom, byte Index, byte Status2) {
        if (!this.checkDeviceIndexRange(Index)) {
            Log.w((String)"CurtainAPI", (String)("[setEntireCircuitStatus] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        this.TitleStr = isLivingRoom ? "CURTAINLIVINGROOMCTRL" : "CURTAINROOMCTRL";
        return this.SendNReadCMD_int("SINKCTRL", "setUnitCurtainStatus", Index, Status2, 0, 0, 0);
    }

    private boolean checkDeviceIndexRange(byte Index) {
        try {
            return Index >= 0 && Index < this.MAX_CURTAIN_CNT && this.data.Device[Index] != null;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CurtainAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"CurtainAPI", (String)"[Exception Error] checkDeviceIndexRange");
            LogUtil.errorLogInfo("", "CurtainAPI", e);
            return false;
        }
    }

    public static class Data {
        public DataClasses.CurtainCtrl[] Device = null;
    }
}

