/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.Sdb_DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class Sdb_LivingRoomLightAPI
extends WallPadDevAPI {
    private final String TAG = "Sdb_LivingRoomLightAPI";
    private final boolean DEBUG_LOG_ON = true;
    public static byte MAX_LIGHT_COUNT = (byte)3;
    public Sdb_DataClasses.LivingEnergyMeterClass data;

    private void DebugLogOutput(String s) {
        Log.d((String)"Sdb_LivingRoomLightAPI", (String)s);
    }

    public Sdb_LivingRoomLightAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("Sdb_LivingRoomLightAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "SDB_LIVINGROOM_LIGHT";
        int ret = this.Refresh();
        if (ret < 0) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[create] Refresh Error (ret:" + ret + ")"));
            this.data = new Sdb_DataClasses.LivingEnergyMeterClass();
        }
    }

    public int Refresh() {
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "Refresh";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                Sdb_DataClasses.LivingEnergyMeterClass LivingEnergyMeter = new Sdb_DataClasses.LivingEnergyMeterClass();
                index = 1;
                LivingEnergyMeter.Info.Install = Boolean.parseBoolean(retlist[index++]);
                if (!LivingEnergyMeter.Info.Version.setData(retlist, index)) {
                    return -2;
                }
                index += 7;
                LivingEnergyMeter.Info.LightCount = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Exist_Indirect = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Exist_Hallway = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Group_Indirect = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Group_Hallway = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Data.OutingStatus = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Data.LightLimitControl = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Data.LightElecNow = Double.parseDouble(retlist[index++]);
                LivingEnergyMeter.Data.LightElecAcc = Integer.parseInt(retlist[index++]);
                LivingEnergyMeter.Data.LightMode = Byte.parseByte(retlist[index++]);
                if (LivingEnergyMeter.Info.LightCount > 0) {
                    LivingEnergyMeter.Data.setLedLight(LivingEnergyMeter.Info.LightCount);
                    for (byte i = 0; i < LivingEnergyMeter.Info.LightCount; i = (byte)(i + 1)) {
                        LivingEnergyMeter.Data.LedLight[i].Info.Install = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Info.Support.OnOff = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Info.Support.Dimming = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Info.Support.Color = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Info.Code.Usage = Byte.parseByte(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Data.CommFault = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Data.OnOff = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Data.Dimming = Byte.parseByte(retlist[index++]);
                        LivingEnergyMeter.Data.LedLight[i].Data.Color = Byte.parseByte(retlist[index++]);
                    }
                }
                this.data = LivingEnergyMeter;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"Sdb_LivingRoomLightAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", e);
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetLight(byte LightIndex, boolean OnOff, byte Dimming, byte Color) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)"[SetLight] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLight] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLight] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLight", LightIndex, OnOff ? 1 : 0, Dimming, Color, 0);
    }

    public int SetLight2(byte LightIndex, byte OnOff, byte Dimming, byte Color) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)"[SetLight2] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.LightPowerRangeCheck(OnOff)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLight2] Param : Power Out Of Range !!! (OnOff:" + OnOff + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLight2] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLight2] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLight2", LightIndex, OnOff, Dimming, Color, 0);
    }

    public int SetLightOnOff(byte LightIndex, boolean OnOff) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)"[SetLightOnOff] LightIndexRangeCheck Error");
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightOnOff", LightIndex, OnOff ? 1 : 0, 0, 0, 0);
    }

    public int SetLightDimming(byte LightIndex, byte Dimming) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)"[SetLightDimming] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLightDimming] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightDimming", LightIndex, Dimming, 0, 0, 0);
    }

    public int SetLightColor(byte LightIndex, byte Color) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)"[SetLightDimming] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLightColor] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightColor", LightIndex, Color, 0, 0, 0);
    }

    public int SetLightMode(byte Mode) {
        if (!LIGHT_MODE.CheckRange(Mode)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLightMode] LIGHT_MODE.CheckRange Error (Mode:" + Mode + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightMode", Mode, 0, 0, 0, 0);
    }

    public int SetLightGroup(boolean Indirect, boolean Hallway) {
        int ret;
        if (this.data == null && (ret = this.Refresh()) < 0) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLightGroup] Refresh Error (ret:" + ret + ")"));
            return -111;
        }
        if (Indirect && !this.data.Info.LightGroup.Exist_Indirect) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)"[SetLightGroup] Indirect Not Exist !!!");
            return -300;
        }
        if (Hallway && !this.data.Info.LightGroup.Exist_Hallway) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)"[SetLightGroup] Hallway Not Exist !!!");
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightGroup", Indirect ? 1 : 0, Hallway ? 1 : 0, 0, 0, 0);
    }

    public int SetControlMode(boolean ControlType) {
        return this.SendNReadCMD_int("SINKCTRL", "SetControlMode", ControlType ? 1 : 0, 0, 0, 0, 0);
    }

    public int SetWifiModuleOnOff(boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetWifiModuleOnOff", OnOff ? 1 : 0, 0, 0, 0, 0);
    }

    public boolean GetWifiModuleOnOff() {
        boolean FailValue = true;
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "GetWifiModuleOnOff";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return FailValue;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return FailValue;
        }
        if (retlist.length != 2) {
            return FailValue;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                boolean WifiOnOff = Boolean.parseBoolean(retlist[index++]);
                return WifiOnOff;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", re);
                return FailValue;
            }
            catch (Exception e) {
                Log.e((String)"Sdb_LivingRoomLightAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", e);
                return FailValue;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return FailValue;
    }

    public int SetLightRegisterMode(byte Mode) {
        if (!LIGHT_REG_MODE.CheckRange(Mode)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetLightRegisterMode] CheckRange Error (Mode:" + Mode + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightRegisterMode", Mode, 0, 0, 0, 0);
    }

    public Sdb_DataClasses.LivingEnergyMeterClass.LightRegisterClass GetLightRegisterStatus() {
        String MainCMD = "SINKCTRL";
        String SubCMD = "GetLightRegisterStatus";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                Sdb_DataClasses.LivingEnergyMeterClass.LightRegisterClass LightRegister = new Sdb_DataClasses.LivingEnergyMeterClass.LightRegisterClass();
                index = 1;
                LightRegister.Registering = Boolean.parseBoolean(retlist[index++]);
                LightRegister.RemainingTime = Integer.parseInt(retlist[index++]);
                LightRegister.Regi_Count = Byte.parseByte(retlist[index++]);
                return LightRegister;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", re);
                return null;
            }
            catch (Exception e) {
                Log.e((String)"Sdb_LivingRoomLightAPI", (String)("[GetLightRegisterStatus] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", e);
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    public int SetConcentRegisterMode(byte Mode) {
        if (!CONCENT_REG_MODE.CheckRange(Mode)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[SetConcentRegisterMode] CheckRange Error (Mode:" + Mode + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentRegisterMode", Mode, 0, 0, 0, 0);
    }

    public Sdb_DataClasses.LivingEnergyMeterClass.ConcentRegisterClass GetConcentRegisterStatus() {
        String MainCMD = "SINKCTRL";
        String SubCMD = "GetConcentRegisterStatus";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                Sdb_DataClasses.LivingEnergyMeterClass.ConcentRegisterClass ConcentRegister = new Sdb_DataClasses.LivingEnergyMeterClass.ConcentRegisterClass();
                index = 1;
                ConcentRegister.Registering = Boolean.parseBoolean(retlist[index++]);
                ConcentRegister.RemainingTime = Integer.parseInt(retlist[index++]);
                ConcentRegister.Regi_Count = Byte.parseByte(retlist[index++]);
                return ConcentRegister;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", re);
                return null;
            }
            catch (Exception e) {
                Log.e((String)"Sdb_LivingRoomLightAPI", (String)("[GetConcentRegisterStatus] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "Sdb_LivingRoomLightAPI", e);
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    private boolean DimmingNColorRangeCheck(byte DimmingNColor) {
        return DimmingNColor >= 1 && 10 >= DimmingNColor || DimmingNColor == -1;
    }

    private boolean LightIndexRangeCheck(byte LightIndex) {
        int ret;
        if (this.data == null && (ret = this.Refresh()) < 0) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[LightIndexRangeCheck] Refresh Error (ret:" + ret + ")"));
            return false;
        }
        byte LightCount = this.data.Info.LightCount;
        if (LightIndex != -1 && (LightIndex < 0 || LightIndex >= LightCount)) {
            Log.w((String)"Sdb_LivingRoomLightAPI", (String)("[LightIndexRangeCheck] - Param : LightIndex - Out Of Range !!!(LightIndex:" + LightIndex + ", LightCount:" + LightCount + ")"));
            return false;
        }
        return true;
    }

    private boolean LightPowerRangeCheck(byte OnOff) {
        return OnOff >= LIGHT_ONOFF.ON && LIGHT_ONOFF.OFF >= OnOff || OnOff == -1;
    }

    public static class CONCENT_REG_MODE {
        public static byte TIME_EXTENSION = 0;
        public static byte START = 1;
        public static byte END = (byte)2;

        public static boolean CheckRange(byte nMode) {
            if (nMode == TIME_EXTENSION) {
                return true;
            }
            if (nMode == START) {
                return true;
            }
            return nMode == END;
        }

        public static String ToString(byte nMode) {
            if (nMode == TIME_EXTENSION) {
                return "TIME_EXTENSION";
            }
            if (nMode == START) {
                return "START";
            }
            if (nMode == END) {
                return "END";
            }
            return "UnDefined";
        }
    }

    public static class LIGHT_REG_MODE {
        public static byte TIME_EXTENSION = 0;
        public static byte START = 1;
        public static byte END = (byte)2;

        public static boolean CheckRange(byte nMode) {
            if (nMode == TIME_EXTENSION) {
                return true;
            }
            if (nMode == START) {
                return true;
            }
            return nMode == END;
        }

        public static String ToString(byte nMode) {
            if (nMode == TIME_EXTENSION) {
                return "TIME_EXTENSION";
            }
            if (nMode == START) {
                return "START";
            }
            if (nMode == END) {
                return "END";
            }
            return "UnDefined";
        }
    }

    public static class LIGHT_MODE {
        public static byte NONE = 0;
        public static byte READING = 1;
        public static byte REST = (byte)2;
        public static byte MOVIE = (byte)3;
        public static byte USER = (byte)4;

        public static boolean CheckRange(byte nMode) {
            if (nMode == READING) {
                return true;
            }
            if (nMode == REST) {
                return true;
            }
            if (nMode == MOVIE) {
                return true;
            }
            return nMode == USER;
        }

        public static String ToString(byte nMode) {
            if (nMode == READING) {
                return "READING";
            }
            if (nMode == REST) {
                return "REST";
            }
            if (nMode == MOVIE) {
                return "MOVIE";
            }
            if (nMode == USER) {
                return "USER";
            }
            return "UnDefined";
        }
    }

    public static class LIGHT_ONOFF {
        public static byte ON = 1;
        public static byte OFF = (byte)2;
        public static byte DONTCARE = (byte)-1;
    }
}

