/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class KnxVentiAPI
extends WallPadDevAPI {
    private final String TAG = "KnxVentiAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"KnxVentiAPI", (String)s);
    }

    public KnxVentiAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("KnxVentiAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "KNXVENTILATION";
        this.data = new Data();
        this.GetDeviceCount();
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.DeviceCnt = DeviceCount;
                    this.data.Device = new DataClasses.Venti[DeviceCount];
                    return 0;
                }
                return -1;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "KnxVentiAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"KnxVentiAPI", (String)("[GetDeviceCount] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "KnxVentiAPI", e);
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"KnxVentiAPI", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"KnxVentiAPI", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.DeviceCnt && this.ProcResult(i, ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.DeviceCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(Index, ret);
    }

    private int ProcResult(int CurrentIndex, String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            String[] retlist = ret.split(";");
            if (retlist == null) {
                return -101;
            }
            if (retlist[0].equals("FAIL")) {
                return Integer.parseInt(retlist[1]);
            }
            if (!retlist[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.Venti device = new DataClasses.Venti();
            int index = 1;
            device.OnOff = Boolean.parseBoolean(retlist[index++]);
            device.Reservation = Boolean.parseBoolean(retlist[index++]);
            device.Wind = Byte.parseByte(retlist[index++]);
            device.Timer = Integer.parseInt(retlist[index++]);
            device.Fault = new DataClasses.Venti.FAULT(Byte.parseByte(retlist[index++]));
            device.Support = new DataClasses.Venti.SUPPORT(Byte.parseByte(retlist[index++]));
            device.Support2 = new DataClasses.Venti.SUPPORT2(Byte.parseByte(retlist[index++]));
            device.HeaterStatus = Byte.parseByte(retlist[index++]);
            device.HeaterTimeRemaining = Byte.parseByte(retlist[index++]);
            device.ByPass = Boolean.parseBoolean(retlist[index++]);
            device.AutoDriving = Boolean.parseBoolean(retlist[index++]);
            device.BathRoom = Boolean.parseBoolean(retlist[index++]);
            device.InnerCycle = Boolean.parseBoolean(retlist[index++]);
            device.OutAirClean = Boolean.parseBoolean(retlist[index++]);
            device.AirCleanAuto = Boolean.parseBoolean(retlist[index++]);
            device.Sleep = Byte.parseByte(retlist[index++]);
            this.data.Device[CurrentIndex] = device;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "KnxVentiAPI", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"KnxVentiAPI", (String)"[Exception Error] ProcResult");
            LogUtil.errorLogInfo("", "KnxVentiAPI", e);
            return -1;
        }
        return 0;
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 17) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.Device[0].OnOff = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].Reservation = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].Wind = Byte.parseByte(retlist[index++]);
                this.data.Device[0].Timer = Integer.parseInt(retlist[index++]);
                this.data.Device[0].Fault = new DataClasses.Venti.FAULT(Byte.parseByte(retlist[index++]));
                this.data.Device[0].Support = new DataClasses.Venti.SUPPORT(Byte.parseByte(retlist[index++]));
                this.data.Device[0].Support2 = new DataClasses.Venti.SUPPORT2(Byte.parseByte(retlist[index++]));
                this.data.Device[0].HeaterStatus = Byte.parseByte(retlist[index++]);
                this.data.Device[0].HeaterTimeRemaining = Byte.parseByte(retlist[index++]);
                this.data.Device[0].ByPass = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].AutoDriving = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].BathRoom = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].InnerCycle = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].OutAirClean = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].AirCleanAuto = Boolean.parseBoolean(retlist[index++]);
                this.data.Device[0].Sleep = Byte.parseByte(retlist[index++]);
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "KnxVentiAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"KnxVentiAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "KnxVentiAPI", e);
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetOnOff(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetOnOff", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetOnOff(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetOnOff", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetWind(byte ChangeWind) {
        if (!DataClasses.Venti.WIND.CheckRange(ChangeWind)) {
            Log.w((String)"KnxVentiAPI", (String)("[SetWind] Param : ChangeWind  Out Of Range !!!" + String.format("0x%02X", ChangeWind)));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetWind", ChangeWind, 0, 0, 0, 0);
    }

    public int SetWind(byte Index, byte ChangeWind) {
        if (!DataClasses.Venti.WIND.CheckRange(ChangeWind)) {
            Log.w((String)"KnxVentiAPI", (String)("[SetWind] Param : ChangeWind  Out Of Range !!!" + String.format("0x%02X", ChangeWind)));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetWind", ChangeWind, Index, 0, 0, 0);
    }

    public int SetTimer(int ChangeTimer) {
        return this.SendNReadCMD_int("SINKCTRL", "SetTimer", (byte)ChangeTimer, 0, 0, 0, 0);
    }

    public int SetTimer(byte Index, int ChangeTimer) {
        return this.SendNReadCMD_int("SINKCTRL", "SetTimer", (byte)ChangeTimer, Index, 0, 0, 0);
    }

    public int SetReservationOnOff(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetReservationOnOff", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetReservationOnOff(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetReservationOnOff", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetReservationSchedule(byte[] ScheduleData2) {
        if (ScheduleData2 == null) {
            return -1;
        }
        if (ScheduleData2.length != 24) {
            return -2;
        }
        byte range = WIND.HI;
        if (this.data.Device[0].Support2.WindowVenti) {
            range = WIND.BYPASS;
        }
        for (int i = 0; i < ScheduleData2.length; ++i) {
            if (ScheduleData2[i] <= range) continue;
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetReservationSchedule", ScheduleData2);
    }

    public byte[] GetReservationSchedule() {
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "GetReservationSchedule";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        Log.d((String)"WALLPADAPI", (String)("GetReservationSchedule cmd ret : " + ret));
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist.length != 25) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte[] Schedule = new byte[24];
                for (int i = 0; i < 24; ++i) {
                    Schedule[i] = Byte.parseByte(retlist[index++]);
                }
                return Schedule;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "KnxVentiAPI", re);
                return null;
            }
            catch (Exception e) {
                Log.e((String)"KnxVentiAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "KnxVentiAPI", e);
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    public byte[] GetReservationSchedule(byte Index) {
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "GetReservationSchedule";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        Log.d((String)"WALLPADAPI", (String)("GetReservationSchedule cmd ret : " + ret));
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist.length != 25) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte[] Schedule = new byte[24];
                for (int i = 0; i < 24; ++i) {
                    Schedule[i] = Byte.parseByte(retlist[index++]);
                }
                return Schedule;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "KnxVentiAPI", re);
                return null;
            }
            catch (Exception e) {
                Log.e((String)"KnxVentiAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "KnxVentiAPI", e);
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    public int SetHeater(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetHeater", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetHeater(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetHeater", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetByPass(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetByPass", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetByPass(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetByPass", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetFilterReset() {
        return this.SendNReadCMD_int("SINKCTRL", "SetFilterReset", 0, 0, 0, 0, 0);
    }

    public int SetFilterReset(byte Index) {
        return this.SendNReadCMD_int("SINKCTRL", "SetFilterReset", Index, 0, 0, 0, 0);
    }

    public int SetAutoDriving(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAutoDriving", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetAutoDriving(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAutoDriving", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetInnerCycle(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetInnerCycle", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetInnerCycle(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetInnerCycle", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetOutAirClean(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetOutAirClean", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetOutAirClean(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetOutAirClean", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetAirCleanAuto(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAirCleanAuto", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetAirCleanAuto(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAirCleanAuto", ByteOnOff, Index, 0, 0, 0);
    }

    public int SetSleepMode(boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetSleepMode", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetSleepMode(byte Index, boolean OnOff) {
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetSleepMode", ByteOnOff, Index, 0, 0, 0);
    }

    public static class WIND {
        public static byte LOW = DataClasses.Venti.WIND.LOW;
        public static byte MID = DataClasses.Venti.WIND.MID;
        public static byte HI = DataClasses.Venti.WIND.HI;
        public static byte AUTO = DataClasses.Venti.WIND.AUTO;
        public static byte BYPASS = DataClasses.Venti.WIND.BYPASS;
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public DataClasses.Venti[] Device = null;
    }
}

